/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode.ha;

import java.io.IOException;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.XAttrSetFlag;
import org.apache.hadoop.hdfs.HAUtil;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.MiniDFSNNTopology;
import org.apache.hadoop.hdfs.server.namenode.NameNode;
import org.apache.hadoop.hdfs.server.namenode.ha.HATestUtil;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;

public class TestXAttrsWithHA {
    private static final Path path = new Path("/file");
    protected static final String name1 = "user.a1";
    protected static final byte[] value1 = new byte[]{49, 50, 51};
    protected static final byte[] newValue1 = new byte[]{49, 49, 49};
    protected static final String name2 = "user.a2";
    protected static final byte[] value2 = new byte[]{55, 56, 57};
    protected static final String name3 = "user.a3";
    private MiniDFSCluster cluster;
    private NameNode nn0;
    private NameNode nn1;
    private FileSystem fs;

    @BeforeEach
    public void setupCluster() throws Exception {
        Configuration conf = new Configuration();
        conf.setInt("dfs.ha.tail-edits.period", 1);
        HAUtil.setAllowStandbyReads((Configuration)conf, (boolean)true);
        this.cluster = new MiniDFSCluster.Builder(conf).nnTopology(MiniDFSNNTopology.simpleHATopology()).numDataNodes(1).waitSafeMode(false).build();
        this.cluster.waitActive();
        this.nn0 = this.cluster.getNameNode(0);
        this.nn1 = this.cluster.getNameNode(1);
        this.fs = HATestUtil.configureFailoverFs(this.cluster, conf);
        this.cluster.transitionToActive(0);
    }

    @AfterEach
    public void shutdownCluster() throws IOException {
        if (this.cluster != null) {
            this.cluster.shutdown();
            this.cluster = null;
        }
    }

    @Test
    @Timeout(value=60L)
    public void testXAttrsTrackedOnStandby() throws Exception {
        this.fs.create(path).close();
        this.fs.setXAttr(path, name1, value1, EnumSet.of(XAttrSetFlag.CREATE));
        this.fs.setXAttr(path, name2, value2, EnumSet.of(XAttrSetFlag.CREATE));
        HATestUtil.waitForStandbyToCatchUp(this.nn0, this.nn1);
        List xAttrs = this.nn1.getRpcServer().getXAttrs("/file", null);
        Assertions.assertEquals((int)2, (int)xAttrs.size());
        this.cluster.shutdownNameNode(0);
        this.cluster.shutdownNameNode(0);
        this.cluster.transitionToActive(1);
        Map xattrs = this.fs.getXAttrs(path);
        Assertions.assertEquals((int)xattrs.size(), (int)2);
        Assertions.assertArrayEquals((byte[])value1, (byte[])((byte[])xattrs.get(name1)));
        Assertions.assertArrayEquals((byte[])value2, (byte[])((byte[])xattrs.get(name2)));
        this.fs.delete(path, true);
    }
}

