/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode.ha;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.util.Arrays;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.DFSUtil;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.MiniDFSNNTopology;
import org.apache.hadoop.hdfs.server.namenode.ha.ConfiguredFailoverProxyProvider;
import org.apache.hadoop.hdfs.server.namenode.ha.HATestUtil;
import org.apache.hadoop.hdfs.server.namenode.ha.RequestHedgingProxyProvider;
import org.apache.hadoop.hdfs.tools.DFSck;
import org.apache.hadoop.test.GenericTestUtils;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.Parameter;
import org.junit.jupiter.params.ParameterizedClass;
import org.junit.jupiter.params.provider.MethodSource;
import org.slf4j.Logger;
import org.slf4j.event.Level;

@ParameterizedClass(name="ProxyProvider: {0}")
@MethodSource(value={"data"})
public class TestHAFsck {
    @Parameter(value=0)
    private String proxyProvider;

    public String getProxyProvider() {
        return this.proxyProvider;
    }

    public static Iterable<Object[]> data() {
        return Arrays.asList({ConfiguredFailoverProxyProvider.class.getName()}, {RequestHedgingProxyProvider.class.getName()});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testHaFsck() throws Exception {
        Configuration conf = new Configuration();
        MiniDFSNNTopology topology = new MiniDFSNNTopology().addNameservice(new MiniDFSNNTopology.NSConf("ha-nn-uri-0").addNN(new MiniDFSNNTopology.NNConf("nn1").setHttpPort(10051)).addNN(new MiniDFSNNTopology.NNConf("nn2").setHttpPort(10052)));
        MiniDFSCluster cluster = new MiniDFSCluster.Builder(conf).nnTopology(topology).numDataNodes(0).build();
        FileSystem fs = null;
        try {
            cluster.waitActive();
            cluster.transitionToActive(0);
            HATestUtil.setFailoverConfigurations(cluster, conf, "ha-nn-uri-0", this.getProxyProvider(), 0);
            fs = FileSystem.get((Configuration)conf);
            fs.mkdirs(new Path("/test1"));
            fs.mkdirs(new Path("/test2"));
            TestHAFsck.runFsck(conf);
            cluster.transitionToStandby(0);
            cluster.transitionToActive(1);
            TestHAFsck.runFsck(conf);
            cluster.getNameNode(0).stop();
            TestHAFsck.runFsck(conf);
        }
        finally {
            if (fs != null) {
                fs.close();
            }
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }

    static void runFsck(Configuration conf) throws Exception {
        ByteArrayOutputStream bStream = new ByteArrayOutputStream();
        PrintStream out = new PrintStream(bStream, true);
        int errCode = ToolRunner.run((Tool)new DFSck(conf, out), (String[])new String[]{"/", "-files"});
        String result = bStream.toString();
        System.out.println("output from fsck:\n" + result);
        Assertions.assertEquals((int)0, (int)errCode);
        Assertions.assertTrue((boolean)result.contains("/test1"));
        Assertions.assertTrue((boolean)result.contains("/test2"));
    }

    static {
        GenericTestUtils.setLogLevel((Logger)DFSUtil.LOG, (Level)Level.TRACE);
    }
}

