/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode.ha;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.List;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Supplier;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileUtil;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.DFSUtilClient;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.MiniDFSNNTopology;
import org.apache.hadoop.hdfs.protocol.HdfsConstants;
import org.apache.hadoop.hdfs.server.common.HttpGetFailedException;
import org.apache.hadoop.hdfs.server.namenode.CheckpointSignature;
import org.apache.hadoop.hdfs.server.namenode.FSImage;
import org.apache.hadoop.hdfs.server.namenode.FSImageTestUtil;
import org.apache.hadoop.hdfs.server.namenode.NNStorage;
import org.apache.hadoop.hdfs.server.namenode.NameNode;
import org.apache.hadoop.hdfs.server.namenode.NameNodeAdapter;
import org.apache.hadoop.hdfs.server.namenode.NameNodeLayoutVersion;
import org.apache.hadoop.hdfs.server.namenode.ha.BootstrapStandby;
import org.apache.hadoop.hdfs.server.protocol.NamenodeProtocol;
import org.apache.hadoop.hdfs.server.protocol.NamespaceInfo;
import org.apache.hadoop.test.GenericTestUtils;
import org.apache.hadoop.test.LambdaTestUtils;
import org.apache.hadoop.thirdparty.com.google.common.collect.ImmutableList;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestBootstrapStandby {
    private static final Logger LOG = LoggerFactory.getLogger(TestBootstrapStandby.class);
    private static final int maxNNCount = 3;
    private static final int STARTING_PORT = 20000;
    private MiniDFSCluster cluster;
    private NameNode nn0;

    @BeforeEach
    public void setupCluster() throws IOException {
        Configuration conf = new Configuration();
        MiniDFSNNTopology.NSConf nameservice = new MiniDFSNNTopology.NSConf("ns1");
        for (int i = 0; i < 3; ++i) {
            nameservice.addNN(new MiniDFSNNTopology.NNConf("nn" + i).setHttpPort(20000 + i + 1));
        }
        MiniDFSNNTopology topology = new MiniDFSNNTopology().addNameservice(nameservice);
        this.cluster = new MiniDFSCluster.Builder(conf).nnTopology(topology).numDataNodes(0).build();
        this.cluster.waitActive();
        this.nn0 = this.cluster.getNameNode(0);
        this.cluster.transitionToActive(0);
        for (int i = 1; i < 3; ++i) {
            this.cluster.shutdownNameNode(i);
        }
    }

    @AfterEach
    public void shutdownCluster() {
        if (this.cluster != null) {
            this.cluster.shutdown();
            this.cluster = null;
        }
    }

    @Test
    public void testSuccessfulBaseCase() throws Exception {
        this.removeStandbyNameDirs();
        for (int index = 1; index < 3; ++index) {
            try {
                this.cluster.restartNameNode(index);
                Assertions.fail((String)"Did not throw");
            }
            catch (IOException ioe) {
                GenericTestUtils.assertExceptionContains((String)"storage directory does not exist or is not accessible", (Throwable)ioe);
            }
            int expectedCheckpointTxId = (int)NameNodeAdapter.getNamesystem(this.nn0).getFSImage().getMostRecentCheckpointTxId();
            int rc = BootstrapStandby.run((String[])new String[]{"-nonInteractive"}, (Configuration)this.cluster.getConfiguration(index));
            Assertions.assertEquals((int)0, (int)rc);
            FSImageTestUtil.assertNNHasCheckpoints(this.cluster, index, (List<Integer>)ImmutableList.of((Object)expectedCheckpointTxId));
        }
        this.restartNameNodesFromIndex(1, new String[0]);
    }

    @Test
    public void testDownloadingLaterCheckpoint() throws Exception {
        this.nn0.getRpcServer().rollEditLog();
        this.nn0.getRpcServer().rollEditLog();
        NameNodeAdapter.enterSafeMode(this.nn0, false);
        NameNodeAdapter.saveNamespace(this.nn0);
        NameNodeAdapter.leaveSafeMode(this.nn0);
        long expectedCheckpointTxId = NameNodeAdapter.getNamesystem(this.nn0).getFSImage().getMostRecentCheckpointTxId();
        Assertions.assertEquals((long)6L, (long)expectedCheckpointTxId);
        this.cluster.getFileSystem(0).create(new Path("/test_txid"), (short)1).close();
        URI editsUri = this.cluster.getSharedEditsDir(0, 2);
        long seen_txid_shared = FSImageTestUtil.getStorageTxId(this.nn0, editsUri);
        for (int i = 1; i < 3; ++i) {
            Assertions.assertEquals((int)0, (int)this.forceBootstrap(i));
            LOG.info("Checking namenode: " + i);
            FSImageTestUtil.assertNNHasCheckpoints(this.cluster, i, (List<Integer>)ImmutableList.of((Object)((int)expectedCheckpointTxId)));
        }
        FSImageTestUtil.assertNNFilesMatch(this.cluster);
        Assertions.assertEquals((long)seen_txid_shared, (long)FSImageTestUtil.getStorageTxId(this.nn0, editsUri));
        this.restartNameNodesFromIndex(1, new String[0]);
    }

    @Test
    public void testRollingUpgradeBootstrapStandby() throws Exception {
        int i;
        this.cluster.restartNameNode(1);
        int futureVersion = NameNodeLayoutVersion.CURRENT_LAYOUT_VERSION - 1;
        DistributedFileSystem fs = this.cluster.getFileSystem(0);
        NameNodeAdapter.enterSafeMode(this.nn0, false);
        NameNodeAdapter.saveNamespace(this.nn0);
        NameNodeAdapter.leaveSafeMode(this.nn0);
        BootstrapStandby bs = (BootstrapStandby)Mockito.spy((Object)new BootstrapStandby());
        ((BootstrapStandby)Mockito.doAnswer(nsInfo -> {
            NamespaceInfo nsInfoSpy = (NamespaceInfo)Mockito.spy((Object)nsInfo.callRealMethod());
            ((NamespaceInfo)Mockito.doReturn((Object)futureVersion).when((Object)nsInfoSpy)).getServiceLayoutVersion();
            return nsInfoSpy;
        }).when((Object)bs)).getProxyNamespaceInfo((NamenodeProtocol)ArgumentMatchers.any());
        bs.setConf(this.cluster.getConfiguration(2));
        Assertions.assertEquals((int)3, (int)bs.run(new String[]{"-force"}), (String)"BootstrapStandby should return ERR_CODE_INVALID_VERSION");
        fs.rollingUpgrade(HdfsConstants.RollingUpgradeAction.PREPARE);
        LambdaTestUtils.await((int)60000, (int)1000, () -> fs.rollingUpgrade(HdfsConstants.RollingUpgradeAction.QUERY).createdRollbackImages());
        this.cluster.shutdownNameNode(1);
        this.removeStandbyNameDirs();
        this.nn0 = (NameNode)Mockito.spy((Object)this.nn0);
        ((NameNode)Mockito.doAnswer(fsImage -> {
            FSImage fsImageSpy = (FSImage)Mockito.spy((Object)fsImage.callRealMethod());
            ((FSImage)Mockito.doAnswer(storage -> {
                NNStorage storageSpy = (NNStorage)Mockito.spy((Object)storage.callRealMethod());
                ((NNStorage)Mockito.doReturn((Object)futureVersion).when((Object)storageSpy)).getServiceLayoutVersion();
                return storageSpy;
            }).when((Object)fsImageSpy)).getStorage();
            return fsImageSpy;
        }).when((Object)this.nn0)).getFSImage();
        this.nn0.getRpcServer().rollEditLog();
        this.nn0.getRpcServer().rollEditLog();
        NameNodeAdapter.enterSafeMode(this.nn0, false);
        NameNodeAdapter.saveNamespace(this.nn0);
        NameNodeAdapter.leaveSafeMode(this.nn0);
        long expectedCheckpointTxId = NameNodeAdapter.getNamesystem(this.nn0).getFSImage().getMostRecentCheckpointTxId();
        long expectedRollbackTxId = NameNodeAdapter.getNamesystem(this.nn0).getFSImage().getMostRecentNameNodeFileTxId(NNStorage.NameNodeFile.IMAGE_ROLLBACK);
        Assertions.assertEquals((long)11L, (long)expectedCheckpointTxId);
        for (i = 1; i < 3; ++i) {
            bs.setConf(this.cluster.getConfiguration(i));
            bs.run(new String[]{"-force"});
            FSImageTestUtil.assertNNHasCheckpoints(this.cluster, i, (List<Integer>)ImmutableList.of((Object)((int)expectedCheckpointTxId)));
            FSImageTestUtil.assertNNHasRollbackCheckpoints(this.cluster, i, (List<Integer>)ImmutableList.of((Object)((int)expectedRollbackTxId)));
        }
        FSImageTestUtil.assertNNFilesMatch(this.cluster);
        this.restartNameNodesFromIndex(1, "-rollingUpgrade", "started");
        for (i = 1; i < 3; ++i) {
            NameNode nn = this.cluster.getNameNode(i);
            Assertions.assertTrue((boolean)nn.getFSImage().hasRollbackFSImage(), (String)"NameNodes should all have the rollback FSImage");
            Assertions.assertTrue((boolean)nn.getNamesystem().isRollingUpgrade(), (String)"NameNodes should all be inRollingUpgrade");
        }
        for (i = 1; i < 3; ++i) {
            this.cluster.shutdownNameNode(i);
        }
        this.removeStandbyNameDirs();
        ((BootstrapStandby)Mockito.doAnswer(nsInfo -> {
            NamespaceInfo nsInfoSpy = (NamespaceInfo)Mockito.spy((Object)nsInfo.callRealMethod());
            nsInfoSpy.layoutVersion = futureVersion;
            ((NamespaceInfo)Mockito.doReturn((Object)futureVersion).when((Object)nsInfoSpy)).getServiceLayoutVersion();
            return nsInfoSpy;
        }).when((Object)bs)).getProxyNamespaceInfo((NamenodeProtocol)ArgumentMatchers.any());
        for (i = 1; i < 3; ++i) {
            bs.setConf(this.cluster.getConfiguration(i));
            Assertions.assertThrows(HttpGetFailedException.class, () -> {
                try {
                    bs.run(new String[]{"-force"});
                }
                catch (RuntimeException e) {
                    Throwable cause = e.getCause();
                    if (cause != null) {
                        throw cause;
                    }
                    throw e;
                }
            }, (String)"BootstrapStandby should fail the image transfer request");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSharedEditsMissingLogs() throws Exception {
        this.removeStandbyNameDirs();
        CheckpointSignature sig = this.nn0.getRpcServer().rollEditLog();
        Assertions.assertEquals((long)3L, (long)sig.getCurSegmentTxId());
        URI editsUri = this.cluster.getSharedEditsDir(0, 2);
        File editsDir = new File(editsUri);
        File currentDir = new File(editsDir, "current");
        File editsSegment = new File(currentDir, NNStorage.getFinalizedEditsFileName((long)1L, (long)2L));
        GenericTestUtils.assertExists((File)editsSegment);
        GenericTestUtils.assertExists((File)currentDir);
        Assertions.assertTrue((boolean)editsSegment.delete());
        GenericTestUtils.LogCapturer logs = GenericTestUtils.LogCapturer.captureLogs((Logger)LoggerFactory.getLogger(BootstrapStandby.class));
        try {
            Assertions.assertEquals((int)6, (int)this.forceBootstrap(1));
        }
        finally {
            logs.stopCapturing();
        }
        Assertions.assertTrue((boolean)logs.getOutput().contains("Unable to read transaction ids 1-3 from the configured shared"));
    }

    @Test
    public void testStandbyDirsAlreadyExist() throws Exception {
        int rc = BootstrapStandby.run((String[])new String[]{"-nonInteractive"}, (Configuration)this.cluster.getConfiguration(1));
        Assertions.assertEquals((int)5, (int)rc);
        Assertions.assertEquals((int)0, (int)this.forceBootstrap(1));
    }

    @Test
    @Timeout(value=30L)
    public void testOtherNodeNotActive() throws Exception {
        this.cluster.transitionToStandby(0);
        this.assertSuccessfulBootstrapFromIndex(1);
    }

    @Test
    @Timeout(value=180L)
    public void testRateThrottling() throws Exception {
        this.cluster.getConfiguration(0).setLong("dfs.image.transfer.bandwidthPerSec", 1L);
        this.cluster.restartNameNode(0);
        this.cluster.waitActive();
        this.nn0 = this.cluster.getNameNode(0);
        this.cluster.transitionToActive(0);
        boolean minXferRatePerMS = true;
        int imageXferBufferSize = DFSUtilClient.getIoFileBufferSize((Configuration)new Configuration());
        File imageFile = null;
        int dirIdx = 0;
        while (imageFile == null || imageFile.length() < (long)imageXferBufferSize) {
            for (int i = 0; i < 5; ++i) {
                this.cluster.getFileSystem(0).mkdirs(new Path("/foo" + dirIdx++));
            }
            this.nn0.getRpcServer().rollEditLog();
            NameNodeAdapter.enterSafeMode(this.nn0, false);
            NameNodeAdapter.saveNamespace(this.nn0);
            NameNodeAdapter.leaveSafeMode(this.nn0);
            imageFile = FSImageTestUtil.findLatestImageFile(FSImageTestUtil.getFSImage(this.nn0).getStorage().getStorageDir(0));
        }
        int timeOut = (int)(imageFile.length() / 1L) + 1;
        final AtomicBoolean bootStrapped = new AtomicBoolean(false);
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    TestBootstrapStandby.this.testSuccessfulBaseCase();
                    bootStrapped.set(true);
                }
                catch (Exception e) {
                    Assertions.fail((String)e.getMessage());
                }
            }
        }).start();
        GenericTestUtils.waitFor((Supplier)new Supplier<Boolean>(){

            @Override
            public Boolean get() {
                return bootStrapped.get();
            }
        }, (long)50L, (long)timeOut);
        this.shutdownCluster();
        this.setupCluster();
        this.cluster.getConfiguration(0).setLong("dfs.image.transfer-bootstrap-standby.bandwidthPerSec", 1L);
        this.cluster.restartNameNode(0);
        this.cluster.waitActive();
        this.nn0 = this.cluster.getNameNode(0);
        this.cluster.transitionToActive(0);
        bootStrapped.set(false);
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    TestBootstrapStandby.this.testSuccessfulBaseCase();
                    bootStrapped.set(true);
                }
                catch (Exception e) {
                    LOG.info(e.getMessage());
                }
            }
        }).start();
        try {
            GenericTestUtils.waitFor((Supplier)new Supplier<Boolean>(){

                @Override
                public Boolean get() {
                    return bootStrapped.get();
                }
            }, (long)50L, (long)timeOut);
            Assertions.fail((String)"Did not timeout");
        }
        catch (TimeoutException e) {
            LOG.info("Encountered expected timeout.");
        }
    }

    private void removeStandbyNameDirs() {
        for (int i = 1; i < 3; ++i) {
            for (URI u : this.cluster.getNameDirs(i)) {
                Assertions.assertTrue((boolean)u.getScheme().equals("file"));
                File dir = new File(u.getPath());
                LOG.info("Removing standby dir " + dir);
                Assertions.assertTrue((boolean)FileUtil.fullyDelete((File)dir));
            }
        }
    }

    private void restartNameNodesFromIndex(int start, String ... args) throws IOException {
        for (int i = start; i < 3; ++i) {
            this.cluster.restartNameNode(i, false, args);
        }
        this.cluster.waitClusterUp();
        this.cluster.waitActive();
    }

    private int forceBootstrap(int i) throws Exception {
        return BootstrapStandby.run((String[])new String[]{"-force"}, (Configuration)this.cluster.getConfiguration(i));
    }

    private void assertSuccessfulBootstrapFromIndex(int start) throws Exception {
        for (int i = start; i < 3; ++i) {
            Assertions.assertEquals((int)0, (int)this.forceBootstrap(i));
        }
    }
}

