/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode.fgl;

import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.qjournal.MiniQJMHACluster;
import org.apache.hadoop.hdfs.server.namenode.fgl.FSNLockBenchmarkThroughput;
import org.apache.hadoop.hdfs.server.namenode.fgl.FSNLockManager;
import org.apache.hadoop.hdfs.server.namenode.fgl.FineGrainedFSNamesystemLock;
import org.apache.hadoop.hdfs.server.namenode.fgl.GlobalFSNamesystemLock;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestFSNLockBenchmarkThroughput {
    @Test
    public void testFineGrainedLockingBenchmarkThroughput1() throws Exception {
        this.testBenchmarkThroughput(true, 20, 100, 1000);
    }

    @Test
    public void testFineGrainedLockingBenchmarkThroughput2() throws Exception {
        this.testBenchmarkThroughput(true, 20, 1000, 1000);
    }

    @Test
    public void testFineGrainedLockingBenchmarkThroughput3() throws Exception {
        this.testBenchmarkThroughput(true, 10, 100, 100);
    }

    @Test
    public void testGlobalLockingBenchmarkThroughput1() throws Exception {
        this.testBenchmarkThroughput(false, 20, 100, 1000);
    }

    @Test
    public void testGlobalLockingBenchmarkThroughput2() throws Exception {
        this.testBenchmarkThroughput(false, 20, 1000, 1000);
    }

    @Test
    public void testGlobalLockingBenchmarkThroughput3() throws Exception {
        this.testBenchmarkThroughput(false, 10, 100, 100);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testBenchmarkThroughput(boolean enableFGL, int readWriteRatio, int testingCount, int numClients) throws Exception {
        MiniQJMHACluster qjmhaCluster = null;
        try {
            HdfsConfiguration conf = new HdfsConfiguration();
            conf.setBoolean("dfs.ha.tail-edits.in-progress", true);
            conf.setInt("dfs.qjournal.select-input-streams.timeout.ms", 500);
            if (enableFGL) {
                conf.setClass("dfs.namenode.lock.model.provider.class", FineGrainedFSNamesystemLock.class, FSNLockManager.class);
            } else {
                conf.setClass("dfs.namenode.lock.model.provider.class", GlobalFSNamesystemLock.class, FSNLockManager.class);
            }
            MiniQJMHACluster.Builder builder = new MiniQJMHACluster.Builder((Configuration)conf);
            builder.getDfsBuilder().numDataNodes(10);
            qjmhaCluster = builder.build();
            MiniDFSCluster cluster = qjmhaCluster.getDfsCluster();
            cluster.transitionToActive(0);
            cluster.waitActive(0);
            DistributedFileSystem fileSystem = cluster.getFileSystem(0);
            String[] args = new String[]{"/tmp/fsnlock/benchmark/throughput", String.valueOf(readWriteRatio), String.valueOf(testingCount), String.valueOf(numClients)};
            Assertions.assertEquals((int)0, (int)ToolRunner.run((Configuration)conf, (Tool)new FSNLockBenchmarkThroughput((FileSystem)fileSystem), (String[])args));
        }
        finally {
            if (qjmhaCluster != null) {
                qjmhaCluster.shutdown();
            }
        }
    }
}

