/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.conf.ReconfigurationException;
import org.apache.hadoop.fs.StorageType;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.MiniDFSNNTopology;
import org.apache.hadoop.hdfs.protocol.HdfsConstants;
import org.apache.hadoop.test.GenericTestUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;

public class TestStoragePolicySatisfierWithHA {
    private MiniDFSCluster cluster = null;
    private final Configuration config = new HdfsConfiguration();
    private static final int DEFAULT_BLOCK_SIZE = 1024;
    private DistributedFileSystem dfs = null;
    private StorageType[][] allDiskTypes = new StorageType[][]{{StorageType.DISK, StorageType.DISK}, {StorageType.DISK, StorageType.DISK}, {StorageType.DISK, StorageType.DISK}};
    private int numOfDatanodes = 3;
    private int storagesPerDatanode = 2;
    private long capacity = 0x20000000L;
    private int nnIndex = 0;

    private void createCluster() throws IOException {
        this.config.setLong("dfs.block.size", 1024L);
        this.config.set("dfs.storage.policy.satisfier.mode", HdfsConstants.StoragePolicySatisfierMode.EXTERNAL.toString());
        this.config.setLong("dfs.storage.policy.satisfier.datanode.cache.refresh.interval.ms", 1000L);
        this.startCluster(this.config, this.allDiskTypes, this.numOfDatanodes, this.storagesPerDatanode, this.capacity);
        this.dfs = this.cluster.getFileSystem(this.nnIndex);
    }

    private void startCluster(Configuration conf, StorageType[][] storageTypes, int numberOfDatanodes, int storagesPerDn, long nodeCapacity) throws IOException {
        long[][] capacities = new long[numberOfDatanodes][storagesPerDn];
        for (int i = 0; i < numberOfDatanodes; ++i) {
            for (int j = 0; j < storagesPerDn; ++j) {
                capacities[i][j] = nodeCapacity;
            }
        }
        this.cluster = new MiniDFSCluster.Builder(conf).nnTopology(MiniDFSNNTopology.simpleHATopology()).numDataNodes(numberOfDatanodes).storagesPerDatanode(storagesPerDn).storageTypes(storageTypes).storageCapacities(capacities).build();
        this.cluster.waitActive();
        this.cluster.transitionToActive(0);
    }

    @Test
    @Timeout(value=90L)
    public void testWhenNNHAStateChanges() throws IOException {
        try {
            this.createCluster();
            this.cluster.transitionToStandby(0);
            this.cluster.waitActive();
            try {
                this.cluster.getNameNode(0).reconfigurePropertyImpl("dfs.storage.policy.satisfier.mode", HdfsConstants.StoragePolicySatisfierMode.NONE.toString());
                Assertions.fail((String)"It's not allowed to enable or disable StoragePolicySatisfier on Standby NameNode");
            }
            catch (ReconfigurationException e) {
                GenericTestUtils.assertExceptionContains((String)"Could not change property dfs.storage.policy.satisfier.mode from 'EXTERNAL' to 'NONE'", (Throwable)e);
                GenericTestUtils.assertExceptionContains((String)"Enabling or disabling storage policy satisfier service on standby NameNode is not allowed", (Throwable)e.getCause());
            }
        }
        finally {
            this.cluster.shutdown();
        }
    }
}

