/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.protocol.LayoutVersion;
import org.apache.hadoop.hdfs.server.common.HdfsServerConstants;
import org.apache.hadoop.hdfs.server.namenode.NNStorage;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedClass;
import org.junit.jupiter.params.provider.MethodSource;

@MethodSource(value={"startOption"})
@ParameterizedClass
public class TestStartupOptionUpgrade {
    private Configuration conf;
    private HdfsServerConstants.StartupOption startOpt;
    private int layoutVersion;
    NNStorage storage;

    public static Collection<Object[]> startOption() {
        Object[][] params = new Object[][]{{HdfsServerConstants.StartupOption.UPGRADE}, {HdfsServerConstants.StartupOption.UPGRADEONLY}};
        return Arrays.asList(params);
    }

    public TestStartupOptionUpgrade(HdfsServerConstants.StartupOption startOption) throws Exception {
        this.startOpt = startOption;
        this.setUp();
    }

    public void setUp() throws Exception {
        this.conf = new HdfsConfiguration();
        this.startOpt.setClusterId(null);
        this.storage = new NNStorage(this.conf, Collections.emptyList(), Collections.emptyList());
    }

    @AfterEach
    public void tearDown() throws Exception {
        this.conf = null;
        this.startOpt = null;
    }

    @Test
    public void testStartupOptUpgradeFrom204() throws Exception {
        this.layoutVersion = LayoutVersion.Feature.RESERVED_REL20_204.getInfo().getLayoutVersion();
        this.storage.processStartupOptionsForUpgrade(this.startOpt, this.layoutVersion);
        Assertions.assertTrue((boolean)this.storage.getClusterID().startsWith("CID"), (String)"Clusterid should start with CID");
    }

    @Test
    public void testStartupOptUpgradeFrom22WithCID() throws Exception {
        this.startOpt.setClusterId("cid");
        this.layoutVersion = LayoutVersion.Feature.RESERVED_REL22.getInfo().getLayoutVersion();
        this.storage.processStartupOptionsForUpgrade(this.startOpt, this.layoutVersion);
        Assertions.assertEquals((Object)"cid", (Object)this.storage.getClusterID(), (String)"Clusterid should match with the given clusterid");
    }

    @Test
    public void testStartupOptUpgradeFromFederation() throws Exception {
        this.storage.setClusterID("currentcid");
        this.layoutVersion = LayoutVersion.Feature.FEDERATION.getInfo().getLayoutVersion();
        this.storage.processStartupOptionsForUpgrade(this.startOpt, this.layoutVersion);
        Assertions.assertEquals((Object)"currentcid", (Object)this.storage.getClusterID(), (String)"Clusterid should match with the existing one");
    }

    @Test
    public void testStartupOptUpgradeFromFederationWithWrongCID() throws Exception {
        this.startOpt.setClusterId("wrong-cid");
        this.storage.setClusterID("currentcid");
        this.layoutVersion = LayoutVersion.Feature.FEDERATION.getInfo().getLayoutVersion();
        this.storage.processStartupOptionsForUpgrade(this.startOpt, this.layoutVersion);
        Assertions.assertEquals((Object)"currentcid", (Object)this.storage.getClusterID(), (String)"Clusterid should match with the existing one");
    }

    @Test
    public void testStartupOptUpgradeFromFederationWithCID() throws Exception {
        this.startOpt.setClusterId("currentcid");
        this.storage.setClusterID("currentcid");
        this.layoutVersion = LayoutVersion.Feature.FEDERATION.getInfo().getLayoutVersion();
        this.storage.processStartupOptionsForUpgrade(this.startOpt, this.layoutVersion);
        Assertions.assertEquals((Object)"currentcid", (Object)this.storage.getClusterID(), (String)"Clusterid should match with the existing one");
    }
}

