/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode;

import java.io.File;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.net.InetAddress;
import java.net.URI;
import java.nio.file.Paths;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FileUtil;
import org.apache.hadoop.fs.LocalFileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.fs.permission.PermissionStatus;
import org.apache.hadoop.hdfs.DFSTestUtil;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.LogVerificationAppender;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.StripedFileTestUtil;
import org.apache.hadoop.hdfs.protocol.DatanodeInfo;
import org.apache.hadoop.hdfs.protocol.ErasureCodingPolicy;
import org.apache.hadoop.hdfs.protocol.HdfsConstants;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockManagerTestUtil;
import org.apache.hadoop.hdfs.server.common.HdfsServerConstants;
import org.apache.hadoop.hdfs.server.common.InconsistentFSStateException;
import org.apache.hadoop.hdfs.server.common.Storage;
import org.apache.hadoop.hdfs.server.common.Util;
import org.apache.hadoop.hdfs.server.namenode.FSImage;
import org.apache.hadoop.hdfs.server.namenode.FSNamesystem;
import org.apache.hadoop.hdfs.server.namenode.NNStorage;
import org.apache.hadoop.hdfs.server.namenode.NameNode;
import org.apache.hadoop.hdfs.server.namenode.SecondaryNameNode;
import org.apache.hadoop.hdfs.server.protocol.NamenodeProtocols;
import org.apache.hadoop.hdfs.util.HostsFileWriter;
import org.apache.hadoop.hdfs.util.MD5FileUtils;
import org.apache.hadoop.io.MD5Hash;
import org.apache.hadoop.test.GenericTestUtils;
import org.apache.hadoop.test.PathUtils;
import org.apache.hadoop.util.ExitUtil;
import org.apache.hadoop.util.StringUtils;
import org.apache.log4j.Appender;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestStartup {
    public static final String NAME_NODE_HOST = "localhost:";
    public static final String WILDCARD_HTTP_HOST = "0.0.0.0:";
    private static final Logger LOG = LoggerFactory.getLogger((String)TestStartup.class.getName());
    private Configuration config;
    private File hdfsDir = null;
    static final long seed = 0xAAAAEEFL;
    static final int blockSize = 4096;
    static final int fileSize = 8192;
    private long editsLength = 0L;
    private long fsimageLength = 0L;

    @BeforeEach
    public void setUp() throws Exception {
        ExitUtil.disableSystemExit();
        ExitUtil.resetFirstExitException();
        this.config = new HdfsConfiguration();
        this.hdfsDir = new File(MiniDFSCluster.getBaseDirectory());
        if (this.hdfsDir.exists() && !FileUtil.fullyDelete((File)this.hdfsDir)) {
            throw new IOException("Could not delete hdfs directory '" + this.hdfsDir + "'");
        }
        LOG.info("--hdfsdir is " + this.hdfsDir.getAbsolutePath());
        this.config.set("dfs.namenode.name.dir", Util.fileAsURI((File)new File(this.hdfsDir, "name")).toString());
        this.config.set("dfs.datanode.data.dir", new File(this.hdfsDir, "data").getPath());
        this.config.set("dfs.datanode.address", "0.0.0.0:0");
        this.config.set("dfs.datanode.http.address", "0.0.0.0:0");
        this.config.set("dfs.datanode.ipc.address", "0.0.0.0:0");
        this.config.set("dfs.namenode.checkpoint.dir", Util.fileAsURI((File)new File(this.hdfsDir, "secondary")).toString());
        this.config.set("dfs.namenode.secondary.http-address", "0.0.0.0:0");
        FileSystem.setDefaultUri((Configuration)this.config, (String)"hdfs://localhost:0");
    }

    @AfterEach
    public void tearDown() throws Exception {
        if (this.hdfsDir.exists() && !FileUtil.fullyDelete((File)this.hdfsDir)) {
            throw new IOException("Could not delete hdfs directory in tearDown '" + this.hdfsDir + "'");
        }
    }

    public void createCheckPoint(int count) throws IOException {
        LOG.info("--starting mini cluster");
        MiniDFSCluster cluster = null;
        SecondaryNameNode sn = null;
        try {
            cluster = new MiniDFSCluster.Builder(this.config).manageDataDfsDirs(false).manageNameDfsDirs(false).build();
            cluster.waitActive();
            LOG.info("--starting Secondary Node");
            sn = new SecondaryNameNode(this.config);
            org.junit.jupiter.api.Assertions.assertNotNull((Object)sn);
            for (int i = 0; i < count; ++i) {
                DistributedFileSystem fileSys = cluster.getFileSystem();
                Path p = new Path("t" + i);
                DFSTestUtil.createFile((FileSystem)fileSys, p, 8192, 8192L, 4096L, (short)1, 0xAAAAEEFL);
                LOG.info("--file " + p.toString() + " created");
                LOG.info("--doing checkpoint");
                sn.doCheckpoint();
                LOG.info("--done checkpoint");
            }
        }
        catch (IOException e) {
            org.junit.jupiter.api.Assertions.fail((String)StringUtils.stringifyException((Throwable)e));
            System.err.println("checkpoint failed");
            throw e;
        }
        finally {
            if (sn != null) {
                sn.shutdown();
            }
            if (cluster != null) {
                cluster.shutdown();
            }
            LOG.info("--cluster shutdown");
        }
    }

    private void corruptFSImageMD5(boolean corruptAll) throws IOException {
        List nameDirs = (List)FSNamesystem.getNamespaceDirs((Configuration)this.config);
        for (URI uri : nameDirs) {
            File nameDir = new File(uri.getPath());
            File dfsDir = nameDir.getParentFile();
            org.junit.jupiter.api.Assertions.assertEquals((Object)dfsDir.getName(), (Object)"dfs");
            File imageFile = new File(nameDir, "current/" + NNStorage.getImageFileName((long)0L));
            MD5FileUtils.saveMD5File((File)imageFile, (MD5Hash)new MD5Hash(new byte[16]));
            if (corruptAll) continue;
            break;
        }
    }

    private void corruptNameNodeFiles() throws IOException {
        List nameDirs = (List)FSNamesystem.getNamespaceDirs((Configuration)this.config);
        List nameEditsDirs = FSNamesystem.getNamespaceEditsDirs((Configuration)this.config);
        File dir = new File(((URI)nameDirs.get(0)).getPath());
        this.fsimageLength = new File(new File(dir, "current"), NNStorage.NameNodeFile.IMAGE.getName()).length();
        if (dir.exists() && !FileUtil.fullyDelete((File)dir)) {
            throw new IOException("Cannot remove directory: " + dir);
        }
        LOG.info("--removed dir " + dir + ";len was =" + this.fsimageLength);
        if (!dir.mkdirs()) {
            throw new IOException("Cannot create directory " + dir);
        }
        dir = new File(((URI)nameEditsDirs.get(0)).getPath());
        this.editsLength = new File(new File(dir, "current"), NNStorage.NameNodeFile.EDITS.getName()).length();
        if (dir.exists() && !FileUtil.fullyDelete((File)dir)) {
            throw new IOException("Cannot remove directory: " + dir);
        }
        if (!dir.mkdirs()) {
            throw new IOException("Cannot create directory " + dir);
        }
        LOG.info("--removed dir and recreated " + dir + ";len was =" + this.editsLength);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkNameNodeFiles() throws IOException {
        LOG.info("-- about to start DFS cluster");
        MiniDFSCluster cluster = null;
        try {
            cluster = new MiniDFSCluster.Builder(this.config).format(false).manageDataDfsDirs(false).manageNameDfsDirs(false).startupOption(HdfsServerConstants.StartupOption.IMPORT).build();
            cluster.waitActive();
            LOG.info("--NN started with checkpoint option");
            NameNode nn = cluster.getNameNode();
            org.junit.jupiter.api.Assertions.assertNotNull((Object)nn);
            FSImage image = nn.getFSImage();
            this.verifyDifferentDirs(image, this.fsimageLength, this.editsLength);
        }
        finally {
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }

    private void verifyDifferentDirs(FSImage img, long expectedImgSize, long expectedEditsSize) {
        Storage.StorageDirectory sd = null;
        Iterator it = img.getStorage().dirIterator();
        while (it.hasNext()) {
            sd = (Storage.StorageDirectory)it.next();
            if (sd.getStorageDirType().isOfType((Storage.StorageDirType)NNStorage.NameNodeDirType.IMAGE)) {
                img.getStorage();
                File imf = NNStorage.getStorageFile((Storage.StorageDirectory)sd, (NNStorage.NameNodeFile)NNStorage.NameNodeFile.IMAGE, (long)0L);
                LOG.info("--image file " + imf.getAbsolutePath() + "; len = " + imf.length() + "; expected = " + expectedImgSize);
                org.junit.jupiter.api.Assertions.assertEquals((long)expectedImgSize, (long)imf.length());
                continue;
            }
            if (sd.getStorageDirType().isOfType((Storage.StorageDirType)NNStorage.NameNodeDirType.EDITS)) {
                img.getStorage();
                File edf = NNStorage.getStorageFile((Storage.StorageDirectory)sd, (NNStorage.NameNodeFile)NNStorage.NameNodeFile.EDITS, (long)0L);
                LOG.info("-- edits file " + edf.getAbsolutePath() + "; len = " + edf.length() + "; expected = " + expectedEditsSize);
                org.junit.jupiter.api.Assertions.assertEquals((long)expectedEditsSize, (long)edf.length());
                continue;
            }
            org.junit.jupiter.api.Assertions.fail((String)"Image/Edits directories are not different");
        }
    }

    @Test
    public void testChkpointStartup2() throws IOException {
        LOG.info("--starting checkpointStartup2 - same directory for checkpoint");
        this.config.set("dfs.namenode.name.dir", Util.fileAsURI((File)new File(this.hdfsDir, "name")).toString());
        this.config.set("dfs.namenode.edits.dir", Util.fileAsURI((File)new File(this.hdfsDir, "edits")).toString());
        this.config.set("dfs.namenode.checkpoint.edits.dir", Util.fileAsURI((File)new File(this.hdfsDir, "chkpt")).toString());
        this.config.set("dfs.namenode.checkpoint.dir", Util.fileAsURI((File)new File(this.hdfsDir, "chkpt")).toString());
        this.createCheckPoint(1);
        this.corruptNameNodeFiles();
        this.checkNameNodeFiles();
    }

    @Test
    public void testChkpointStartup1() throws IOException {
        LOG.info("--starting testStartup Recovery");
        this.config.set("dfs.namenode.name.dir", Util.fileAsURI((File)new File(this.hdfsDir, "name")).toString());
        this.config.set("dfs.namenode.edits.dir", Util.fileAsURI((File)new File(this.hdfsDir, "edits")).toString());
        this.config.set("dfs.namenode.checkpoint.edits.dir", Util.fileAsURI((File)new File(this.hdfsDir, "chkpt_edits")).toString());
        this.config.set("dfs.namenode.checkpoint.dir", Util.fileAsURI((File)new File(this.hdfsDir, "chkpt")).toString());
        this.createCheckPoint(1);
        this.corruptNameNodeFiles();
        this.checkNameNodeFiles();
    }

    @Test
    public void testSNNStartup() throws IOException {
        LOG.info("--starting SecondNN startup test");
        this.config.set("dfs.namenode.name.dir", Util.fileAsURI((File)new File(this.hdfsDir, "name")).toString());
        this.config.set("dfs.namenode.edits.dir", Util.fileAsURI((File)new File(this.hdfsDir, "name")).toString());
        this.config.set("dfs.namenode.checkpoint.edits.dir", Util.fileAsURI((File)new File(this.hdfsDir, "chkpt_edits")).toString());
        this.config.set("dfs.namenode.checkpoint.dir", Util.fileAsURI((File)new File(this.hdfsDir, "chkpt")).toString());
        LOG.info("--starting NN ");
        MiniDFSCluster cluster = null;
        SecondaryNameNode sn = null;
        NameNode nn = null;
        try {
            cluster = new MiniDFSCluster.Builder(this.config).manageDataDfsDirs(false).manageNameDfsDirs(false).build();
            cluster.waitActive();
            nn = cluster.getNameNode();
            org.junit.jupiter.api.Assertions.assertNotNull((Object)nn);
            LOG.info("--starting SecondNN");
            sn = new SecondaryNameNode(this.config);
            org.junit.jupiter.api.Assertions.assertNotNull((Object)sn);
            LOG.info("--doing checkpoint");
            sn.doCheckpoint();
            LOG.info("--done checkpoint");
            FSImage image = nn.getFSImage();
            Storage.StorageDirectory sd = image.getStorage().getStorageDir(0);
            org.junit.jupiter.api.Assertions.assertEquals((Object)sd.getStorageDirType(), (Object)NNStorage.NameNodeDirType.IMAGE_AND_EDITS);
            image.getStorage();
            File imf = NNStorage.getStorageFile((Storage.StorageDirectory)sd, (NNStorage.NameNodeFile)NNStorage.NameNodeFile.IMAGE, (long)0L);
            image.getStorage();
            File edf = NNStorage.getStorageFile((Storage.StorageDirectory)sd, (NNStorage.NameNodeFile)NNStorage.NameNodeFile.EDITS, (long)0L);
            LOG.info("--image file " + imf.getAbsolutePath() + "; len = " + imf.length());
            LOG.info("--edits file " + edf.getAbsolutePath() + "; len = " + edf.length());
            FSImage chkpImage = sn.getFSImage();
            this.verifyDifferentDirs(chkpImage, imf.length(), edf.length());
        }
        catch (IOException e) {
            org.junit.jupiter.api.Assertions.fail((String)StringUtils.stringifyException((Throwable)e));
            System.err.println("checkpoint failed");
            throw e;
        }
        finally {
            if (sn != null) {
                sn.shutdown();
            }
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }

    @Test
    @Timeout(value=30L)
    public void testSNNStartupWithRuntimeException() throws Exception {
        String[] argv = new String[]{"-checkpoint"};
        try {
            SecondaryNameNode.main((String[])argv);
            org.junit.jupiter.api.Assertions.fail((String)"Failed to handle runtime exceptions during SNN startup!");
        }
        catch (ExitUtil.ExitException ee) {
            GenericTestUtils.assertExceptionContains((String)"ExitException", (Throwable)ee);
            org.junit.jupiter.api.Assertions.assertTrue((boolean)ExitUtil.terminateCalled(), (String)"Didn't terminate properly ");
        }
    }

    @Test
    public void testCompression() throws IOException {
        LOG.info("Test compressing image.");
        Configuration conf = new Configuration();
        FileSystem.setDefaultUri((Configuration)conf, (String)"hdfs://localhost:0");
        conf.set("dfs.namenode.http-address", "127.0.0.1:0");
        File base_dir = new File(PathUtils.getTestDir(this.getClass()), "dfs/");
        conf.set("dfs.namenode.name.dir", new File(base_dir, "name").getPath());
        conf.setBoolean("dfs.permissions.enabled", false);
        DFSTestUtil.formatNameNode(conf);
        LOG.info("Create an uncompressed fsimage");
        NameNode namenode = new NameNode(conf);
        namenode.getNamesystem().mkdirs("/test", new PermissionStatus("hairong", null, FsPermission.getDefault()), true);
        NamenodeProtocols nnRpc = namenode.getRpcServer();
        org.junit.jupiter.api.Assertions.assertTrue((boolean)nnRpc.getFileInfo("/test").isDirectory());
        nnRpc.setSafeMode(HdfsConstants.SafeModeAction.SAFEMODE_ENTER, false);
        nnRpc.saveNamespace(0L, 0L);
        namenode.stop();
        namenode.join();
        namenode.joinHttpServer();
        LOG.info("Read an uncomressed image and store it compressed using default codec.");
        conf.setBoolean("dfs.image.compress", true);
        this.checkNameSpace(conf);
        LOG.info("Read a compressed image and store it using a different codec.");
        conf.set("dfs.image.compression.codec", "org.apache.hadoop.io.compress.GzipCodec");
        this.checkNameSpace(conf);
        LOG.info("Read a compressed image and store it as uncompressed.");
        conf.setBoolean("dfs.image.compress", false);
        this.checkNameSpace(conf);
        LOG.info("Read an uncompressed image and store it as uncompressed.");
        this.checkNameSpace(conf);
    }

    private void checkNameSpace(Configuration conf) throws IOException {
        NameNode namenode = new NameNode(conf);
        NamenodeProtocols nnRpc = namenode.getRpcServer();
        org.junit.jupiter.api.Assertions.assertTrue((boolean)nnRpc.getFileInfo("/test").isDirectory());
        nnRpc.setSafeMode(HdfsConstants.SafeModeAction.SAFEMODE_ENTER, false);
        nnRpc.saveNamespace(0L, 0L);
        namenode.stop();
        namenode.join();
        namenode.joinHttpServer();
    }

    @Test
    public void testImageChecksum() throws Exception {
        LOG.info("Test uncompressed image checksum");
        this.testImageChecksum(false);
        LOG.info("Test compressed image checksum");
        this.testImageChecksum(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testImageChecksum(boolean compress) throws Exception {
        MiniDFSCluster cluster = null;
        if (compress) {
            this.config.setBoolean("dfs.image.compression.codec", true);
        }
        try {
            LOG.info("\n===========================================\nStarting empty cluster");
            cluster = new MiniDFSCluster.Builder(this.config).numDataNodes(0).format(true).build();
            cluster.waitActive();
            DistributedFileSystem fs = cluster.getFileSystem();
            fs.mkdirs(new Path("/test"));
            LOG.info("Shutting down cluster #1");
            cluster.shutdown();
            cluster = null;
            this.corruptFSImageMD5(true);
            LogVerificationAppender appender = new LogVerificationAppender();
            org.apache.log4j.Logger logger = org.apache.log4j.Logger.getRootLogger();
            logger.addAppender((Appender)appender);
            LOG.info("\n===========================================\nStarting same cluster after simulated crash");
            try {
                cluster = new MiniDFSCluster.Builder(this.config).numDataNodes(0).format(false).build();
                org.junit.jupiter.api.Assertions.fail((String)"Should not have successfully started with corrupt image");
            }
            catch (IOException ioe) {
                GenericTestUtils.assertExceptionContains((String)"Failed to load FSImage file", (Throwable)ioe);
                int md5failures = appender.countExceptionsWithMessage(" is corrupt with MD5 checksum of ");
                org.junit.jupiter.api.Assertions.assertEquals((int)2, (int)md5failures);
            }
        }
        finally {
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }

    @Test
    @Timeout(value=30L)
    public void testCorruptImageFallback() throws IOException {
        this.createCheckPoint(2);
        this.corruptFSImageMD5(false);
        MiniDFSCluster cluster = new MiniDFSCluster.Builder(this.config).format(false).manageDataDfsDirs(false).manageNameDfsDirs(false).build();
        try {
            cluster.waitActive();
        }
        finally {
            cluster.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @Timeout(value=30L)
    public void testCorruptImageFallbackLostECPolicy() throws IOException {
        ErasureCodingPolicy defaultPolicy = StripedFileTestUtil.getDefaultECPolicy();
        String policy = defaultPolicy.getName();
        Path f1 = new Path("/f1");
        try (MiniDFSCluster cluster = new MiniDFSCluster.Builder(this.config).numDataNodes(0).format(true).build();){
            cluster.waitActive();
            DistributedFileSystem fs = cluster.getFileSystem();
            fs.enableErasureCodingPolicy(policy);
            Path srcECDir = new Path("/");
            fs.setErasureCodingPolicy(srcECDir, defaultPolicy.getName());
            fs.create(f1);
            FileStatus fs1 = fs.getFileStatus(f1);
            org.junit.jupiter.api.Assertions.assertTrue((boolean)fs1.isErasureCoded());
            ErasureCodingPolicy fs1Policy = fs.getErasureCodingPolicy(f1);
            org.junit.jupiter.api.Assertions.assertEquals((Object)fs1Policy, (Object)defaultPolicy);
        }
        this.corruptFSImageMD5(false);
        cluster = new MiniDFSCluster.Builder(this.config).numDataNodes(0).format(false).build();
        try {
            cluster.waitActive();
            ErasureCodingPolicy[] ecPolicies = cluster.getNameNode().getNamesystem().getErasureCodingPolicyManager().getEnabledPolicies();
            DistributedFileSystem fs = cluster.getFileSystem();
            org.junit.jupiter.api.Assertions.assertEquals((Object)fs.getErasureCodingPolicy(f1), (Object)defaultPolicy);
            org.junit.jupiter.api.Assertions.assertTrue((ecPolicies.length == 1 ? 1 : 0) != 0);
        }
        finally {
            cluster.shutdown();
        }
    }

    @Test
    public void testNNRestart() throws IOException, InterruptedException {
        MiniDFSCluster cluster = null;
        int HEARTBEAT_INTERVAL = 1;
        HostsFileWriter hostsFileWriter = new HostsFileWriter();
        hostsFileWriter.initialize(this.config, "work-dir/restartnn");
        byte[] b = new byte[]{127, 0, 0, 1};
        InetAddress inetAddress = InetAddress.getByAddress(b);
        hostsFileWriter.initIncludeHosts(new String[]{inetAddress.getHostName()});
        int numDatanodes = 1;
        try {
            cluster = new MiniDFSCluster.Builder(this.config).numDataNodes(numDatanodes).setupHostsFile(true).build();
            cluster.waitActive();
            cluster.restartNameNode(new String[0]);
            NamenodeProtocols nn = cluster.getNameNodeRpc();
            org.junit.jupiter.api.Assertions.assertNotNull((Object)nn);
            org.junit.jupiter.api.Assertions.assertTrue((boolean)cluster.isDataNodeUp());
            DatanodeInfo[] info = nn.getDatanodeReport(HdfsConstants.DatanodeReportType.LIVE);
            for (int i = 0; i < 5 && info.length != numDatanodes; ++i) {
                Thread.sleep(HEARTBEAT_INTERVAL * 1000);
                info = nn.getDatanodeReport(HdfsConstants.DatanodeReportType.LIVE);
            }
            org.junit.jupiter.api.Assertions.assertEquals((int)numDatanodes, (int)info.length, (String)("Number of live nodes should be " + numDatanodes));
        }
        catch (IOException e) {
            org.junit.jupiter.api.Assertions.fail((String)StringUtils.stringifyException((Throwable)e));
            throw e;
        }
        finally {
            if (cluster != null) {
                cluster.shutdown();
            }
            hostsFileWriter.cleanup();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @Timeout(value=120L)
    public void testXattrConfiguration() throws Exception {
        HdfsConfiguration conf = new HdfsConfiguration();
        MiniDFSCluster cluster = null;
        try {
            conf.setInt("dfs.namenode.fs-limits.max-xattr-size", -1);
            cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(0).format(true).build();
            org.junit.jupiter.api.Assertions.fail((String)"Expected exception with negative xattr size");
        }
        catch (IllegalArgumentException e) {
            GenericTestUtils.assertExceptionContains((String)"The maximum size of an xattr should be > 0", (Throwable)e);
        }
        finally {
            conf.setInt("dfs.namenode.fs-limits.max-xattr-size", 16384);
            if (cluster != null) {
                cluster.shutdown();
            }
        }
        try {
            conf.setInt("dfs.namenode.fs-limits.max-xattrs-per-inode", -1);
            cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(0).format(true).build();
            org.junit.jupiter.api.Assertions.fail((String)"Expected exception with negative # xattrs per inode");
        }
        catch (IllegalArgumentException e) {
            GenericTestUtils.assertExceptionContains((String)"Cannot set a negative limit on the number of xattrs per inode", (Throwable)e);
        }
        finally {
            conf.setInt("dfs.namenode.fs-limits.max-xattrs-per-inode", 32);
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @Timeout(value=30L)
    public void testNNFailToStartOnReadOnlyNNDir() throws Exception {
        String nnDirStr = Paths.get(this.hdfsDir.toString(), GenericTestUtils.getMethodName(), "name").toString();
        this.config.set("dfs.namenode.name.dir", nnDirStr);
        try (MiniDFSCluster cluster = new MiniDFSCluster.Builder(this.config).numDataNodes(1).manageNameDfsDirs(false).build();){
            cluster.waitActive();
            Collection nnDirs = FSNamesystem.getNamespaceDirs((Configuration)this.config);
            org.junit.jupiter.api.Assertions.assertNotNull((Object)nnDirs);
            org.junit.jupiter.api.Assertions.assertTrue((boolean)nnDirs.iterator().hasNext());
            org.junit.jupiter.api.Assertions.assertEquals((Object)new File(nnDirStr), (Object)new File(((URI)nnDirs.iterator().next()).getPath()), (String)"NN dir should be created after NN startup.");
            File nnDir = new File(nnDirStr);
            org.junit.jupiter.api.Assertions.assertTrue((boolean)nnDir.exists());
            org.junit.jupiter.api.Assertions.assertTrue((boolean)nnDir.isDirectory());
            try {
                org.junit.jupiter.api.Assertions.assertTrue((boolean)FileUtil.setWritable((File)nnDir, (boolean)false), (String)"Setting NN dir read only should succeed.");
                cluster.restartNameNodes();
                org.junit.jupiter.api.Assertions.fail((String)"Restarting NN should fail on read only NN dir.");
            }
            catch (InconsistentFSStateException e) {
                Assertions.assertThat((String)e.toString()).contains(new CharSequence[]{"InconsistentFSStateException", nnDirStr, "in an inconsistent state", "storage directory does not exist or is not accessible."});
            }
            finally {
                org.junit.jupiter.api.Assertions.assertTrue((boolean)FileUtil.setWritable((File)nnDir, (boolean)true), (String)"Setting NN dir should succeed.");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @Timeout(value=60L)
    public void testStorageBlockContentsStaleAfterNNRestart() throws Exception {
        MiniDFSCluster dfsCluster = null;
        try {
            Configuration config = new Configuration();
            dfsCluster = new MiniDFSCluster.Builder(config).numDataNodes(1).build();
            dfsCluster.waitActive();
            dfsCluster.restartNameNode(true);
            BlockManagerTestUtil.checkHeartbeat(dfsCluster.getNamesystem().getBlockManager());
            MBeanServer mbs = ManagementFactory.getPlatformMBeanServer();
            ObjectName mxbeanNameFsns = new ObjectName("Hadoop:service=NameNode,name=FSNamesystemState");
            Integer numStaleStorages = (Integer)mbs.getAttribute(mxbeanNameFsns, "NumStaleStorages");
            org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)numStaleStorages);
        }
        finally {
            if (dfsCluster != null) {
                dfsCluster.shutdown();
            }
        }
    }

    @Test
    @Timeout(value=60L)
    public void testDirectoryPermissions() throws Exception {
        Configuration conf = new Configuration();
        try (MiniDFSCluster dfsCluster = new MiniDFSCluster.Builder(conf).build();){
            dfsCluster.waitActive();
            List nameDirs = dfsCluster.getNameNode().getFSImage().getStorage().getStorageDirs();
            Collection nameDirUris = nameDirs.stream().map(d -> d.getCurrentDir().toURI()).collect(Collectors.toList());
            org.junit.jupiter.api.Assertions.assertNotNull((Object)nameDirUris);
            LocalFileSystem fs = LocalFileSystem.getLocal((Configuration)this.config);
            FsPermission permission = new FsPermission(conf.get("dfs.namenode.storage.dir.perm", "700"));
            for (URI uri : nameDirUris) {
                FileStatus fileStatus = fs.getFileLinkStatus(new Path(uri));
                org.junit.jupiter.api.Assertions.assertEquals((short)permission.toOctal(), (short)fileStatus.getPermission().toOctal());
            }
        }
    }
}

