/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode;

import java.io.FileNotFoundException;
import java.util.ArrayList;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.DFSTestUtil;
import org.apache.hadoop.hdfs.DFSUtil;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.protocol.SnapshotException;
import org.apache.hadoop.hdfs.server.namenode.FSDirSnapshotOp;
import org.apache.hadoop.hdfs.server.namenode.FSDirectory;
import org.apache.hadoop.hdfs.server.namenode.FSNamesystem;
import org.apache.hadoop.hdfs.server.namenode.INode;
import org.apache.hadoop.hdfs.server.namenode.INodeDirectory;
import org.apache.hadoop.hdfs.server.namenode.INodeFile;
import org.apache.hadoop.hdfs.server.namenode.INodesInPath;
import org.apache.hadoop.hdfs.server.namenode.snapshot.Snapshot;
import org.apache.hadoop.hdfs.server.namenode.snapshot.SnapshotManager;
import org.apache.hadoop.test.MockitoUtil;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;
import org.mockito.Mockito;

public class TestSnapshotPathINodes {
    private static final long seed = 0L;
    private static final short REPLICATION = 3;
    private static final Path dir = new Path("/TestSnapshot");
    private static final Path sub1 = new Path(dir, "sub1");
    private static final Path file1 = new Path(sub1, "file1");
    private static final Path file2 = new Path(sub1, "file2");
    private static MiniDFSCluster cluster;
    private static FSDirectory fsdir;
    private static DistributedFileSystem hdfs;

    @BeforeAll
    public static void setUp() throws Exception {
        Configuration conf = new Configuration();
        cluster = new MiniDFSCluster.Builder(conf).numDataNodes(3).build();
        cluster.waitActive();
        FSNamesystem fsn = cluster.getNamesystem();
        fsdir = fsn.getFSDirectory();
        hdfs = cluster.getFileSystem();
    }

    @BeforeEach
    public void reset() throws Exception {
        DFSTestUtil.createFile((FileSystem)hdfs, file1, 1024L, (short)3, 0L);
        DFSTestUtil.createFile((FileSystem)hdfs, file2, 1024L, (short)3, 0L);
    }

    @AfterAll
    public static void tearDown() throws Exception {
        if (cluster != null) {
            cluster.shutdown();
        }
    }

    @Test
    @Timeout(value=15L)
    public void testAllowSnapshot() throws Exception {
        String pathStr = sub1.toString();
        INode before = fsdir.getINode(pathStr);
        Assertions.assertFalse((boolean)before.asDirectory().isSnapshottable());
        Path path = new Path(pathStr);
        hdfs.allowSnapshot(path);
        INode after = fsdir.getINode(pathStr);
        Assertions.assertTrue((boolean)after.asDirectory().isSnapshottable());
        hdfs.disallowSnapshot(path);
        after = fsdir.getINode(pathStr);
        Assertions.assertFalse((boolean)after.asDirectory().isSnapshottable());
    }

    static Snapshot getSnapshot(INodesInPath inodesInPath, String name, int index) {
        if (name == null) {
            return null;
        }
        INode inode = inodesInPath.getINode(index - 1);
        return inode.asDirectory().getSnapshot(DFSUtil.string2Bytes((String)name));
    }

    static void assertSnapshot(INodesInPath inodesInPath, boolean isSnapshot, Snapshot snapshot, int index) {
        Assertions.assertEquals((Object)isSnapshot, (Object)inodesInPath.isSnapshot());
        Assertions.assertEquals((int)Snapshot.getSnapshotId((Snapshot)(isSnapshot ? snapshot : null)), (int)inodesInPath.getPathSnapshotId());
        if (!isSnapshot) {
            Assertions.assertEquals((int)Snapshot.getSnapshotId((Snapshot)snapshot), (int)inodesInPath.getLatestSnapshotId());
        }
        if (isSnapshot && index >= 0) {
            Assertions.assertEquals(Snapshot.Root.class, inodesInPath.getINode(index).getClass());
        }
    }

    static void assertINodeFile(INode inode, Path path) {
        Assertions.assertEquals((Object)path.getName(), (Object)inode.getLocalName());
        Assertions.assertEquals(INodeFile.class, inode.getClass());
    }

    @Test
    @Timeout(value=15L)
    public void testNonSnapshotPathINodes() throws Exception {
        byte[][] components = INode.getPathComponents((String)file1.toString());
        INodesInPath nodesInPath = INodesInPath.resolve((INodeDirectory)TestSnapshotPathINodes.fsdir.rootDir, (byte[][])components, (boolean)false);
        Assertions.assertEquals((int)nodesInPath.length(), (int)components.length);
        TestSnapshotPathINodes.assertSnapshot(nodesInPath, false, null, -1);
        for (int i = 0; i < components.length; ++i) {
            Assertions.assertEquals((Object)components[i], (Object)nodesInPath.getPathComponent(i));
        }
        Assertions.assertTrue((nodesInPath.getINode(components.length - 1) != null ? 1 : 0) != 0, (String)("file1=" + file1 + ", nodesInPath=" + nodesInPath));
        Assertions.assertEquals((Object)nodesInPath.getINode(components.length - 1).getFullPathName(), (Object)file1.toString());
        Assertions.assertEquals((Object)nodesInPath.getINode(components.length - 2).getFullPathName(), (Object)sub1.toString());
        Assertions.assertEquals((Object)nodesInPath.getINode(components.length - 3).getFullPathName(), (Object)dir.toString());
        Assertions.assertEquals((Object)"/", (Object)nodesInPath.getPath(0));
        Assertions.assertEquals((Object)dir.toString(), (Object)nodesInPath.getPath(1));
        Assertions.assertEquals((Object)sub1.toString(), (Object)nodesInPath.getPath(2));
        Assertions.assertEquals((Object)file1.toString(), (Object)nodesInPath.getPath(3));
        Assertions.assertEquals((Object)file1.getParent().toString(), (Object)nodesInPath.getParentINodesInPath().getPath());
        nodesInPath = INodesInPath.resolve((INodeDirectory)TestSnapshotPathINodes.fsdir.rootDir, (byte[][])components, (boolean)false);
        Assertions.assertEquals((int)nodesInPath.length(), (int)components.length);
        TestSnapshotPathINodes.assertSnapshot(nodesInPath, false, null, -1);
        Assertions.assertEquals((Object)nodesInPath.getLastINode().getFullPathName(), (Object)file1.toString());
    }

    @Test
    @Timeout(value=15L)
    public void testSnapshotPathINodes() throws Exception {
        hdfs.allowSnapshot(sub1);
        hdfs.createSnapshot(sub1, "s1");
        String snapshotPath = sub1.toString() + "/.snapshot/s1/file1";
        byte[][] components = INode.getPathComponents((String)snapshotPath);
        INodesInPath nodesInPath = INodesInPath.resolve((INodeDirectory)TestSnapshotPathINodes.fsdir.rootDir, (byte[][])components, (boolean)false);
        Assertions.assertEquals((int)nodesInPath.length(), (int)(components.length - 1));
        Snapshot snapshot = TestSnapshotPathINodes.getSnapshot(nodesInPath, "s1", 3);
        TestSnapshotPathINodes.assertSnapshot(nodesInPath, true, snapshot, 3);
        Assertions.assertEquals((Object)".snapshot/s1", (Object)DFSUtil.bytes2String((byte[])nodesInPath.getPathComponent(3)));
        Assertions.assertTrue((boolean)(nodesInPath.getINode(3) instanceof Snapshot.Root));
        Assertions.assertEquals((Object)"s1", (Object)nodesInPath.getINode(3).getLocalName());
        INode snapshotFileNode = nodesInPath.getLastINode();
        TestSnapshotPathINodes.assertINodeFile(snapshotFileNode, file1);
        Assertions.assertTrue((boolean)snapshotFileNode.getParent().isWithSnapshot());
        nodesInPath = INodesInPath.resolve((INodeDirectory)TestSnapshotPathINodes.fsdir.rootDir, (byte[][])components, (boolean)false);
        Assertions.assertEquals((int)nodesInPath.length(), (int)(components.length - 1));
        TestSnapshotPathINodes.assertSnapshot(nodesInPath, true, snapshot, 3);
        TestSnapshotPathINodes.assertINodeFile(nodesInPath.getLastINode(), file1);
        String dotSnapshotPath = sub1.toString() + "/.snapshot";
        components = INode.getPathComponents((String)dotSnapshotPath);
        nodesInPath = INodesInPath.resolve((INodeDirectory)TestSnapshotPathINodes.fsdir.rootDir, (byte[][])components, (boolean)false);
        Assertions.assertEquals((int)nodesInPath.length(), (int)components.length);
        Assertions.assertEquals((Object)".snapshot", (Object)DFSUtil.bytes2String((byte[])nodesInPath.getLastLocalName()));
        Assertions.assertNull((Object)nodesInPath.getLastINode());
        Assertions.assertEquals((Object)sub1.toString(), (Object)nodesInPath.getParentINodesInPath().getPath());
        TestSnapshotPathINodes.assertSnapshot(nodesInPath, true, snapshot, -1);
        Assertions.assertNull((Object)nodesInPath.getLastINode());
        Assertions.assertEquals((Object)nodesInPath.getINode(-2).getFullPathName(), (Object)sub1.toString());
        Assertions.assertTrue((boolean)nodesInPath.getINode(-2).isDirectory());
        String[] invalidPathComponent = new String[]{"invalidDir", "foo", ".snapshot", "bar"};
        Path invalidPath = new Path(invalidPathComponent[0]);
        for (int i = 1; i < invalidPathComponent.length; ++i) {
            invalidPath = new Path(invalidPath, invalidPathComponent[i]);
            try {
                hdfs.getFileStatus(invalidPath);
                Assertions.fail();
                continue;
            }
            catch (FileNotFoundException fnfe) {
                System.out.println("The exception is expected: " + fnfe);
            }
        }
        hdfs.deleteSnapshot(sub1, "s1");
        hdfs.disallowSnapshot(sub1);
    }

    @Test
    @Timeout(value=15L)
    public void testSnapshotPathINodesAfterDeletion() throws Exception {
        hdfs.allowSnapshot(sub1);
        hdfs.createSnapshot(sub1, "s2");
        hdfs.delete(file1, false);
        String snapshotPath = sub1.toString() + "/.snapshot/s2/file1";
        byte[][] components = INode.getPathComponents((String)snapshotPath);
        INodesInPath nodesInPath = INodesInPath.resolve((INodeDirectory)TestSnapshotPathINodes.fsdir.rootDir, (byte[][])components, (boolean)false);
        Assertions.assertEquals((int)nodesInPath.length(), (int)(components.length - 1));
        Snapshot snapshot = TestSnapshotPathINodes.getSnapshot(nodesInPath, "s2", 3);
        TestSnapshotPathINodes.assertSnapshot(nodesInPath, true, snapshot, 3);
        INode inode = nodesInPath.getLastINode();
        Assertions.assertEquals((Object)file1.getName(), (Object)inode.getLocalName());
        Assertions.assertTrue((boolean)inode.asFile().isWithSnapshot());
        byte[][] components2 = INode.getPathComponents((String)file1.toString());
        INodesInPath nodesInPath2 = INodesInPath.resolve((INodeDirectory)TestSnapshotPathINodes.fsdir.rootDir, (byte[][])components2, (boolean)false);
        Assertions.assertEquals((int)nodesInPath2.length(), (int)components2.length);
        Assertions.assertEquals((int)this.getNumNonNull(nodesInPath2), (int)(components2.length - 1));
        TestSnapshotPathINodes.assertSnapshot(nodesInPath2, false, snapshot, -1);
        Assertions.assertNull((Object)nodesInPath2.getINode(components2.length - 1));
        Assertions.assertEquals((Object)nodesInPath2.getINode(components2.length - 2).getFullPathName(), (Object)sub1.toString());
        Assertions.assertEquals((Object)nodesInPath2.getINode(components2.length - 3).getFullPathName(), (Object)dir.toString());
        hdfs.deleteSnapshot(sub1, "s2");
        hdfs.disallowSnapshot(sub1);
    }

    private int getNumNonNull(INodesInPath iip) {
        for (int i = iip.length() - 1; i >= 0; --i) {
            if (iip.getINode(i) == null) continue;
            return i + 1;
        }
        return 0;
    }

    @Test
    @Timeout(value=15L)
    public void testSnapshotPathINodesWithAddedFile() throws Exception {
        hdfs.allowSnapshot(sub1);
        hdfs.createSnapshot(sub1, "s4");
        Path file3 = new Path(sub1, "file3");
        DFSTestUtil.createFile((FileSystem)hdfs, file3, 1024L, (short)3, 0L);
        String snapshotPath = sub1.toString() + "/.snapshot/s4/file3";
        byte[][] components = INode.getPathComponents((String)snapshotPath);
        INodesInPath nodesInPath = INodesInPath.resolve((INodeDirectory)TestSnapshotPathINodes.fsdir.rootDir, (byte[][])components, (boolean)false);
        Assertions.assertEquals((int)nodesInPath.length(), (int)(components.length - 1));
        Assertions.assertEquals((int)this.getNumNonNull(nodesInPath), (int)(components.length - 2));
        Snapshot s4 = TestSnapshotPathINodes.getSnapshot(nodesInPath, "s4", 3);
        TestSnapshotPathINodes.assertSnapshot(nodesInPath, true, s4, 3);
        Assertions.assertNull((Object)nodesInPath.getINode(nodesInPath.length() - 1));
        byte[][] components2 = INode.getPathComponents((String)file3.toString());
        INodesInPath nodesInPath2 = INodesInPath.resolve((INodeDirectory)TestSnapshotPathINodes.fsdir.rootDir, (byte[][])components2, (boolean)false);
        Assertions.assertEquals((int)nodesInPath2.length(), (int)components2.length);
        TestSnapshotPathINodes.assertSnapshot(nodesInPath2, false, s4, -1);
        Assertions.assertEquals((Object)nodesInPath2.getINode(components2.length - 1).getFullPathName(), (Object)file3.toString());
        Assertions.assertEquals((Object)nodesInPath2.getINode(components2.length - 2).getFullPathName(), (Object)sub1.toString());
        Assertions.assertEquals((Object)nodesInPath2.getINode(components2.length - 3).getFullPathName(), (Object)dir.toString());
        hdfs.deleteSnapshot(sub1, "s4");
        hdfs.disallowSnapshot(sub1);
    }

    @Test
    @Timeout(value=15L)
    public void testSnapshotPathINodesAfterModification() throws Exception {
        byte[][] components = INode.getPathComponents((String)file1.toString());
        INodesInPath nodesInPath = INodesInPath.resolve((INodeDirectory)TestSnapshotPathINodes.fsdir.rootDir, (byte[][])components, (boolean)false);
        Assertions.assertEquals((int)nodesInPath.length(), (int)components.length);
        Assertions.assertEquals((Object)nodesInPath.getINode(components.length - 1).getFullPathName(), (Object)file1.toString());
        long modTime = nodesInPath.getINode(nodesInPath.length() - 1).getModificationTime();
        hdfs.allowSnapshot(sub1);
        hdfs.createSnapshot(sub1, "s3");
        DFSTestUtil.appendFile((FileSystem)hdfs, file1, "the content for appending");
        String snapshotPath = sub1.toString() + "/.snapshot/s3/file1";
        components = INode.getPathComponents((String)snapshotPath);
        INodesInPath ssNodesInPath = INodesInPath.resolve((INodeDirectory)TestSnapshotPathINodes.fsdir.rootDir, (byte[][])components, (boolean)false);
        Assertions.assertEquals((int)ssNodesInPath.length(), (int)(components.length - 1));
        Snapshot s3 = TestSnapshotPathINodes.getSnapshot(ssNodesInPath, "s3", 3);
        TestSnapshotPathINodes.assertSnapshot(ssNodesInPath, true, s3, 3);
        INode snapshotFileNode = ssNodesInPath.getLastINode();
        Assertions.assertEquals((Object)snapshotFileNode.getLocalName(), (Object)file1.getName());
        Assertions.assertTrue((boolean)snapshotFileNode.asFile().isWithSnapshot());
        Assertions.assertEquals((long)modTime, (long)snapshotFileNode.getModificationTime(ssNodesInPath.getPathSnapshotId()));
        components = INode.getPathComponents((String)file1.toString());
        INodesInPath newNodesInPath = INodesInPath.resolve((INodeDirectory)TestSnapshotPathINodes.fsdir.rootDir, (byte[][])components, (boolean)false);
        TestSnapshotPathINodes.assertSnapshot(newNodesInPath, false, s3, -1);
        Assertions.assertEquals((int)newNodesInPath.length(), (int)components.length);
        int last = components.length - 1;
        Assertions.assertEquals((Object)newNodesInPath.getINode(last).getFullPathName(), (Object)file1.toString());
        Assertions.assertFalse((modTime == newNodesInPath.getINode(last).getModificationTime() ? 1 : 0) != 0);
        hdfs.deleteSnapshot(sub1, "s3");
        hdfs.disallowSnapshot(sub1);
    }

    @Test
    public void testShortCircuitSnapshotSearch() throws SnapshotException {
        FSNamesystem fsn = cluster.getNamesystem();
        SnapshotManager sm = fsn.getSnapshotManager();
        Assertions.assertEquals((int)0, (int)sm.getNumSnapshottableDirs());
        INodesInPath iip = (INodesInPath)Mockito.mock(INodesInPath.class);
        ArrayList snapDirs = new ArrayList();
        FSDirSnapshotOp.checkSnapshot((FSDirectory)fsn.getFSDirectory(), (INodesInPath)iip, snapDirs);
        MockitoUtil.verifyZeroInteractions((Object[])new Object[]{iip});
    }
}

