/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.conf.ReconfigurationException;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.MiniDFSNNTopology;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockManager;
import org.apache.hadoop.test.LambdaTestUtils;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;

public class TestRefreshNamenodeReplicationConfig {
    private MiniDFSCluster cluster = null;
    private BlockManager bm;

    @BeforeEach
    public void setup() throws IOException {
        Configuration config = new Configuration();
        config.setInt("dfs.namenode.replication.max-streams", 8);
        config.setInt("dfs.namenode.replication.max-streams-hard-limit", 10);
        config.setInt("dfs.namenode.replication.work.multiplier.per.iteration", 12);
        config.setInt("dfs.namenode.reconstruction.pending.timeout-sec", 300);
        this.cluster = new MiniDFSCluster.Builder(config).nnTopology(MiniDFSNNTopology.simpleSingleNN(0, 0)).numDataNodes(0).build();
        this.cluster.waitActive();
        this.bm = this.cluster.getNameNode().getNamesystem().getBlockManager();
    }

    @AfterEach
    public void teardown() throws IOException {
        this.cluster.shutdown();
    }

    @Test
    @Timeout(value=90L)
    public void testParamsCanBeReconfigured() throws ReconfigurationException {
        Assertions.assertEquals((int)8, (int)this.bm.getMaxReplicationStreams());
        Assertions.assertEquals((int)10, (int)this.bm.getReplicationStreamsHardLimit());
        Assertions.assertEquals((int)12, (int)this.bm.getBlocksReplWorkMultiplier());
        Assertions.assertEquals((int)300, (int)this.bm.getReconstructionPendingTimeout());
        this.cluster.getNameNode().reconfigurePropertyImpl("dfs.namenode.replication.max-streams", "20");
        this.cluster.getNameNode().reconfigurePropertyImpl("dfs.namenode.replication.max-streams-hard-limit", "22");
        this.cluster.getNameNode().reconfigurePropertyImpl("dfs.namenode.replication.work.multiplier.per.iteration", "24");
        this.cluster.getNameNode().reconfigurePropertyImpl("dfs.namenode.reconstruction.pending.timeout-sec", "180");
        Assertions.assertEquals((int)20, (int)this.bm.getMaxReplicationStreams());
        Assertions.assertEquals((int)22, (int)this.bm.getReplicationStreamsHardLimit());
        Assertions.assertEquals((int)24, (int)this.bm.getBlocksReplWorkMultiplier());
        Assertions.assertEquals((int)180, (int)this.bm.getReconstructionPendingTimeout());
    }

    @Test
    @Timeout(value=90L)
    public void testReconfigureFailsWithInvalidValues() throws Exception {
        ReconfigurationException e;
        String[] keys;
        for (String key : keys = new String[]{"dfs.namenode.replication.max-streams", "dfs.namenode.replication.max-streams-hard-limit", "dfs.namenode.replication.work.multiplier.per.iteration", "dfs.namenode.reconstruction.pending.timeout-sec"}) {
            e = (ReconfigurationException)LambdaTestUtils.intercept(ReconfigurationException.class, () -> this.cluster.getNameNode().reconfigurePropertyImpl(key, "-20"));
            Assertions.assertTrue((boolean)(e.getCause() instanceof IllegalArgumentException));
            Assertions.assertEquals((Object)(key + " = '-20' is invalid. It should be a positive, non-zero integer value."), (Object)e.getCause().getMessage());
        }
        Assertions.assertEquals((int)8, (int)this.bm.getMaxReplicationStreams());
        Assertions.assertEquals((int)10, (int)this.bm.getReplicationStreamsHardLimit());
        Assertions.assertEquals((int)12, (int)this.bm.getBlocksReplWorkMultiplier());
        Assertions.assertEquals((int)300, (int)this.bm.getReconstructionPendingTimeout());
        for (String key : keys) {
            e = (ReconfigurationException)LambdaTestUtils.intercept(ReconfigurationException.class, () -> this.cluster.getNameNode().reconfigurePropertyImpl(key, "0"));
            Assertions.assertTrue((boolean)(e.getCause() instanceof IllegalArgumentException));
            Assertions.assertEquals((Object)(key + " = '0' is invalid. It should be a positive, non-zero integer value."), (Object)e.getCause().getMessage());
        }
        Assertions.assertEquals((int)8, (int)this.bm.getMaxReplicationStreams());
        Assertions.assertEquals((int)10, (int)this.bm.getReplicationStreamsHardLimit());
        Assertions.assertEquals((int)12, (int)this.bm.getBlocksReplWorkMultiplier());
        Assertions.assertEquals((int)300, (int)this.bm.getReconstructionPendingTimeout());
        for (String key : keys) {
            e = (ReconfigurationException)LambdaTestUtils.intercept(ReconfigurationException.class, () -> this.cluster.getNameNode().reconfigurePropertyImpl(key, "str"));
            Assertions.assertTrue((boolean)(e.getCause() instanceof NumberFormatException));
        }
        Assertions.assertEquals((int)8, (int)this.bm.getMaxReplicationStreams());
        Assertions.assertEquals((int)10, (int)this.bm.getReplicationStreamsHardLimit());
        Assertions.assertEquals((int)12, (int)this.bm.getBlocksReplWorkMultiplier());
        Assertions.assertEquals((int)300, (int)this.bm.getReconstructionPendingTimeout());
    }
}

