/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode;

import java.io.File;
import java.io.FileWriter;
import java.io.Writer;
import java.util.UUID;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.crypto.key.kms.server.KMSACLs;
import org.apache.hadoop.crypto.key.kms.server.KMSWebApp;
import org.apache.hadoop.crypto.key.kms.server.MiniKMS;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.server.namenode.TestReencryption;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class TestReencryptionWithKMS
extends TestReencryption {
    private MiniKMS miniKMS;
    private String kmsDir;

    @Override
    protected String getKeyProviderURI() {
        return "kms://" + this.miniKMS.getKMSUrl().toExternalForm().replace("://", "@");
    }

    @Override
    @BeforeEach
    public void setup() throws Exception {
        this.kmsDir = "target/test-classes/" + UUID.randomUUID().toString();
        File dir = new File(this.kmsDir);
        Assertions.assertTrue((boolean)dir.mkdirs());
        MiniKMS.Builder miniKMSBuilder = new MiniKMS.Builder();
        this.miniKMS = miniKMSBuilder.setKmsConfDir(dir).build();
        this.miniKMS.start();
        super.setup();
    }

    @Override
    @AfterEach
    public void teardown() {
        super.teardown();
        if (this.miniKMS != null) {
            this.miniKMS.stop();
        }
    }

    @Override
    protected void setProvider() {
    }

    @Test
    public void testReencryptionKMSACLs() throws Exception {
        Path aclPath = new Path(this.kmsDir, "kms-acls.xml");
        Configuration acl = new Configuration(false);
        acl.addResource(aclPath);
        acl.set(KMSACLs.Type.GET.getBlacklistConfigKey(), "*");
        acl.set(KMSACLs.Type.GET_KEYS.getBlacklistConfigKey(), "*");
        File kmsAcl = new File(aclPath.toString());
        Assertions.assertTrue((boolean)kmsAcl.exists());
        try (FileWriter writer = new FileWriter(kmsAcl);){
            acl.writeXml((Writer)writer);
        }
        KMSWebApp.getACLs().run();
        this.testReencryptionBasic();
    }

    @Override
    protected void rollKey(String keyName) throws Exception {
        this.dfsAdmin.getKeyProvider().rollNewVersion(keyName);
    }
}

