/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode;

import java.util.Arrays;
import java.util.BitSet;
import java.util.Iterator;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.StorageType;
import org.apache.hadoop.hdfs.DFSTestUtil;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.StripedFileTestUtil;
import org.apache.hadoop.hdfs.client.HdfsDataInputStream;
import org.apache.hadoop.hdfs.protocol.Block;
import org.apache.hadoop.hdfs.protocol.DatanodeID;
import org.apache.hadoop.hdfs.protocol.DatanodeInfoWithStorage;
import org.apache.hadoop.hdfs.protocol.ErasureCodingPolicy;
import org.apache.hadoop.hdfs.protocol.LocatedBlock;
import org.apache.hadoop.hdfs.protocol.LocatedBlocks;
import org.apache.hadoop.hdfs.protocol.LocatedStripedBlock;
import org.apache.hadoop.hdfs.protocol.SystemErasureCodingPolicies;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockInfo;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockInfoStriped;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockManager;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockManagerTestUtil;
import org.apache.hadoop.hdfs.server.blockmanagement.DatanodeDescriptor;
import org.apache.hadoop.hdfs.server.blockmanagement.DatanodeManager;
import org.apache.hadoop.hdfs.server.blockmanagement.DatanodeStorageInfo;
import org.apache.hadoop.hdfs.server.blockmanagement.NumberReplicas;
import org.apache.hadoop.hdfs.server.datanode.DataNode;
import org.apache.hadoop.hdfs.server.datanode.DataNodeTestUtils;
import org.apache.hadoop.hdfs.server.namenode.FSNamesystem;
import org.apache.hadoop.hdfs.server.namenode.INodeFile;
import org.apache.hadoop.hdfs.server.protocol.BlockECReconstructionCommand;
import org.apache.hadoop.hdfs.util.RwLockMode;
import org.apache.hadoop.hdfs.util.StripedBlockUtil;
import org.apache.hadoop.test.GenericTestUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestReconstructStripedBlocks {
    public static final Logger LOG = LoggerFactory.getLogger(TestReconstructStripedBlocks.class);
    private final ErasureCodingPolicy ecPolicy = StripedFileTestUtil.getDefaultECPolicy();
    private final int cellSize = this.ecPolicy.getCellSize();
    private final short dataBlocks = (short)this.ecPolicy.getNumDataUnits();
    private final short parityBlocks = (short)this.ecPolicy.getNumParityUnits();
    private final short groupSize = (short)(this.dataBlocks + this.parityBlocks);
    private final int blockSize = 4 * this.cellSize;
    private MiniDFSCluster cluster;
    private final Path dirPath = new Path("/dir");
    private Path filePath = new Path(this.dirPath, "file");
    private int maxReplicationStreams = 2;

    private void initConf(Configuration conf) {
        conf.setInt("dfs.heartbeat.interval", 100);
        conf.setInt("dfs.namenode.replication.work.multiplier.per.iteration", 5);
    }

    @Test
    public void testMissingStripedBlock() throws Exception {
        this.doTestMissingStripedBlock(1, 0);
    }

    @Test
    public void testMissingStripedBlockWithBusyNode() throws Exception {
        for (int i = 1; i <= this.parityBlocks; ++i) {
            this.doTestMissingStripedBlock(i, 1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doTestMissingStripedBlock(int numOfMissed, int numOfBusy) throws Exception {
        HdfsConfiguration conf = new HdfsConfiguration();
        this.initConf((Configuration)conf);
        this.cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(this.groupSize + 1).build();
        try {
            int i;
            this.cluster.waitActive();
            this.cluster.getFileSystem().enableErasureCodingPolicy(StripedFileTestUtil.getDefaultECPolicy().getName());
            int numBlocks = 4;
            DFSTestUtil.createStripedFile(this.cluster, this.filePath, this.dirPath, 4, 1, true);
            INodeFile fileNode = this.cluster.getNamesystem().getFSDirectory().getINode4Write(this.filePath.toString()).asFile();
            Assertions.assertFalse((boolean)fileNode.isUnderConstruction());
            Assertions.assertTrue((boolean)fileNode.isStriped());
            BlockInfo[] blocks = fileNode.getBlocks();
            Assertions.assertEquals((int)4, (int)blocks.length);
            for (BlockInfo blk : blocks) {
                Assertions.assertTrue((boolean)blk.isStriped());
                Assertions.assertTrue((boolean)blk.isComplete());
                Assertions.assertEquals((long)(this.cellSize * this.dataBlocks), (long)blk.getNumBytes());
                BlockInfoStriped sb = (BlockInfoStriped)blk;
                Assertions.assertEquals((int)this.groupSize, (int)sb.numNodes());
            }
            BlockManager bm = this.cluster.getNamesystem().getBlockManager();
            BlockInfo firstBlock = fileNode.getBlocks()[0];
            DatanodeStorageInfo[] storageInfos = bm.getStorages(firstBlock);
            for (i = 0; i < numOfBusy; ++i) {
                DatanodeDescriptor busyNode = storageInfos[i].getDatanodeDescriptor();
                for (int j = 0; j < this.maxReplicationStreams + 1; ++j) {
                    BlockManagerTestUtil.addBlockToBeReplicated(busyNode, new Block((long)j), new DatanodeStorageInfo[]{storageInfos[0]});
                }
            }
            while (i < numOfBusy + numOfMissed) {
                DatanodeDescriptor missedNode = storageInfos[i].getDatanodeDescriptor();
                Assertions.assertEquals((int)4, (int)missedNode.numBlocks());
                bm.getDatanodeManager().removeDatanode((DatanodeID)missedNode);
                ++i;
            }
            BlockManagerTestUtil.updateState(bm);
            DFSTestUtil.verifyClientStats((Configuration)conf, this.cluster);
            BlockManagerTestUtil.getComputedDatanodeWork(bm);
            DataNode lastDn = this.cluster.getDataNodes().get(this.groupSize);
            DatanodeDescriptor last = bm.getDatanodeManager().getDatanode(lastDn.getDatanodeId());
            Assertions.assertEquals((int)4, (int)last.getNumberOfBlocksToBeErasureCoded(), (String)"Counting the number of outstanding EC tasks");
            List reconstruction = last.getErasureCodeCommand(4);
            for (BlockECReconstructionCommand.BlockECReconstructionInfo info : reconstruction) {
                Assertions.assertEquals((int)1, (int)info.getTargetDnInfos().length);
                Assertions.assertEquals((Object)last, (Object)info.getTargetDnInfos()[0]);
                Assertions.assertEquals((int)info.getSourceDnInfos().length, (int)info.getLiveBlockIndices().length);
                if (this.groupSize - numOfMissed == this.dataBlocks) {
                    Assertions.assertEquals((int)this.dataBlocks, (int)info.getSourceDnInfos().length);
                    continue;
                }
                Assertions.assertEquals((int)(this.groupSize - numOfMissed - numOfBusy), (int)info.getSourceDnInfos().length);
            }
            BlockManagerTestUtil.updateState(bm);
            DFSTestUtil.verifyClientStats((Configuration)conf, this.cluster);
        }
        finally {
            this.cluster.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void test2RecoveryTasksForSameBlockGroup() throws Exception {
        HdfsConfiguration conf = new HdfsConfiguration();
        conf.setInt("dfs.heartbeat.interval", 1000);
        conf.setInt("dfs.namenode.redundancy.interval.seconds", 1000);
        conf.setLong("dfs.blocksize", (long)this.blockSize);
        this.cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(this.groupSize + 2).build();
        try {
            this.cluster.waitActive();
            DistributedFileSystem fs = this.cluster.getFileSystem();
            BlockManager bm = this.cluster.getNamesystem().getBlockManager();
            fs.enableErasureCodingPolicy(StripedFileTestUtil.getDefaultECPolicy().getName());
            fs.getClient().setErasureCodingPolicy("/", StripedFileTestUtil.getDefaultECPolicy().getName());
            int fileLen = this.dataBlocks * this.blockSize;
            Path p = new Path("/test2RecoveryTasksForSameBlockGroup");
            byte[] data = new byte[fileLen];
            DFSTestUtil.writeFile((FileSystem)fs, p, data);
            DFSTestUtil.waitForReplication(fs, p, this.groupSize, 5000);
            BlockManagerTestUtil.updateState(bm);
            DFSTestUtil.verifyClientStats((Configuration)conf, this.cluster);
            LocatedStripedBlock lb = (LocatedStripedBlock)fs.getClient().getLocatedBlocks(p.toString(), 0L).get(0);
            LocatedBlock[] lbs = StripedBlockUtil.parseStripedBlockGroup((LocatedStripedBlock)lb, (int)this.cellSize, (int)this.dataBlocks, (int)this.parityBlocks);
            BlockManagerTestUtil.getComputedDatanodeWork(bm);
            BlockManagerTestUtil.updateState(bm);
            Assertions.assertEquals((int)0, (int)TestReconstructStripedBlocks.getNumberOfBlocksToBeErasureCoded(this.cluster));
            Assertions.assertEquals((long)0L, (long)bm.getPendingReconstructionBlocksCount());
            DFSTestUtil.verifyClientStats((Configuration)conf, this.cluster);
            DatanodeInfoWithStorage dn0 = lbs[0].getLocations()[0];
            this.cluster.stopDataNode(dn0.getName());
            this.cluster.setDataNodeDead((DatanodeID)dn0);
            BlockManagerTestUtil.getComputedDatanodeWork(bm);
            BlockManagerTestUtil.updateState(bm);
            Assertions.assertEquals((int)1, (int)TestReconstructStripedBlocks.getNumberOfBlocksToBeErasureCoded(this.cluster));
            Assertions.assertEquals((long)1L, (long)bm.getPendingReconstructionBlocksCount());
            DFSTestUtil.verifyClientStats((Configuration)conf, this.cluster);
            DatanodeInfoWithStorage dn1 = lbs[1].getLocations()[0];
            this.cluster.stopDataNode(dn1.getName());
            this.cluster.setDataNodeDead((DatanodeID)dn1);
            BlockManagerTestUtil.getComputedDatanodeWork(bm);
            BlockManagerTestUtil.updateState(bm);
            Assertions.assertEquals((int)1, (int)TestReconstructStripedBlocks.getNumberOfBlocksToBeErasureCoded(this.cluster));
            Assertions.assertEquals((long)1L, (long)bm.getPendingReconstructionBlocksCount());
            DFSTestUtil.verifyClientStats((Configuration)conf, this.cluster);
        }
        finally {
            this.cluster.shutdown();
        }
    }

    private static int getNumberOfBlocksToBeErasureCoded(MiniDFSCluster cluster) throws Exception {
        DatanodeManager dm = cluster.getNamesystem().getBlockManager().getDatanodeManager();
        int count = 0;
        for (DataNode dn : cluster.getDataNodes()) {
            DatanodeDescriptor dd = dm.getDatanode(dn.getDatanodeId());
            count += dd.getNumberOfBlocksToBeErasureCoded();
        }
        return count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Test
    public void testCountLiveReplicas() throws Exception {
        HdfsConfiguration conf = new HdfsConfiguration();
        conf.setInt("dfs.namenode.redundancy.interval.seconds", 1);
        this.cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(this.groupSize + 2).build();
        this.cluster.waitActive();
        DistributedFileSystem fs = this.cluster.getFileSystem();
        fs.enableErasureCodingPolicy(StripedFileTestUtil.getDefaultECPolicy().getName());
        try {
            void var11_18;
            fs.mkdirs(this.dirPath);
            fs.setErasureCodingPolicy(this.dirPath, StripedFileTestUtil.getDefaultECPolicy().getName());
            DFSTestUtil.createFile((FileSystem)fs, this.filePath, this.cellSize * this.dataBlocks * 2, (short)1, 0L);
            LocatedBlocks blks = fs.getClient().getLocatedBlocks(this.filePath.toString(), 0L);
            LocatedStripedBlock block = (LocatedStripedBlock)blks.getLastLocatedBlock();
            DatanodeInfoWithStorage dnToStop = block.getLocations()[0];
            MiniDFSCluster.DataNodeProperties dnProp = this.cluster.stopDataNode(dnToStop.getXferAddr());
            this.cluster.setDataNodeDead((DatanodeID)dnToStop);
            DFSTestUtil.waitForReplication(fs, this.filePath, this.groupSize, 15000);
            this.cluster.restartDataNode(dnProp);
            this.cluster.waitActive();
            DFSTestUtil.verifyClientStats((Configuration)conf, this.cluster);
            dnToStop = block.getLocations()[1];
            this.cluster.stopDataNode(dnToStop.getXferAddr());
            this.cluster.setDataNodeDead((DatanodeID)dnToStop);
            this.cluster.restartNameNode(true);
            for (DataNode dn : this.cluster.getDataNodes()) {
                DataNodeTestUtils.triggerBlockReport(dn);
            }
            FSNamesystem fsn = this.cluster.getNamesystem();
            BlockManager bm = fsn.getBlockManager();
            Thread.sleep(3000L);
            for (DataNode dn : this.cluster.getDataNodes()) {
                DataNodeTestUtils.triggerHeartbeat(dn);
            }
            StripedFileTestUtil.waitForReconstructionFinished(this.filePath, fs, this.groupSize);
            boolean reconstructed = false;
            for (int i = 0; i < 5; ++i) {
                NumberReplicas numberReplicas;
                Object var11_15 = null;
                fsn.readLock(RwLockMode.GLOBAL);
                try {
                    BlockInfo blockInfo = this.cluster.getNamesystem().getFSDirectory().getINode4Write(this.filePath.toString()).asFile().getLastBlock();
                    numberReplicas = bm.countNodes(blockInfo);
                }
                finally {
                    fsn.readUnlock(RwLockMode.GLOBAL, "testCountLiveReplicas");
                }
                if (numberReplicas.liveReplicas() >= this.groupSize) {
                    reconstructed = true;
                    break;
                }
                Thread.sleep(1000L);
            }
            Assertions.assertTrue((boolean)reconstructed);
            blks = fs.getClient().getLocatedBlocks(this.filePath.toString(), 0L);
            block = (LocatedStripedBlock)blks.getLastLocatedBlock();
            BitSet bitSet = new BitSet(this.groupSize);
            for (byte index : block.getBlockIndices()) {
                bitSet.set(index);
            }
            boolean bl = false;
            while (var11_18 < this.groupSize) {
                Assertions.assertTrue((boolean)bitSet.get((int)var11_18));
                ++var11_18;
            }
        }
        finally {
            this.cluster.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @Timeout(value=120L)
    public void testReconstructionWork() throws Exception {
        HdfsConfiguration conf = new HdfsConfiguration();
        conf.setLong("dfs.namenode.fs-limits.min-block-size", 0L);
        conf.setLong("dfs.blocksize", 1L);
        conf.setInt("dfs.bytes-per-checksum", 1);
        conf.setInt("dfs.heartbeat.interval", 1000);
        conf.setInt("dfs.namenode.redundancy.interval.seconds", 1000);
        conf.setInt("dfs.namenode.replication.work.multiplier.per.iteration", 5);
        ErasureCodingPolicy policy = SystemErasureCodingPolicies.getByID((byte)4);
        Path ecDir = new Path("/ec");
        Path ecFilePath = new Path(ecDir, "ec-file");
        int blockGroups = 2;
        int totalDataNodes = policy.getNumDataUnits() + policy.getNumParityUnits() + 1;
        MiniDFSCluster dfsCluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(totalDataNodes).build();
        try {
            DistributedFileSystem fs = dfsCluster.getFileSystem();
            fs.enableErasureCodingPolicy(policy.getName());
            fs.mkdirs(ecDir);
            fs.setErasureCodingPolicy(ecDir, policy.getName());
            DFSTestUtil.createStripedFile(dfsCluster, ecFilePath, ecDir, blockGroups, 2, false, policy);
            BlockManager bm = dfsCluster.getNamesystem().getBlockManager();
            LocatedBlocks lbs = fs.getClient().getNamenode().getBlockLocations(ecFilePath.toString(), 0L, (long)blockGroups);
            assert (lbs.get(0) instanceof LocatedStripedBlock);
            LocatedStripedBlock bg = (LocatedStripedBlock)lbs.get(0);
            Iterator storageInfos = bm.getStorages(bg.getBlock().getLocalBlock()).iterator();
            DatanodeDescriptor firstDn = ((DatanodeStorageInfo)storageInfos.next()).getDatanodeDescriptor();
            BlockManagerTestUtil.updateState(bm);
            DFSTestUtil.verifyClientStats((Configuration)conf, dfsCluster);
            bm.getDatanodeManager().removeDatanode((DatanodeID)firstDn);
            BlockManagerTestUtil.updateState(bm);
            Assertions.assertEquals((long)blockGroups, (long)bm.getLowRedundancyECBlockGroups());
            DFSTestUtil.verifyClientStats((Configuration)conf, dfsCluster);
            BlockManagerTestUtil.getComputedDatanodeWork(bm);
            BlockManagerTestUtil.updateState(bm);
            Assertions.assertEquals((int)blockGroups, (int)TestReconstructStripedBlocks.getNumberOfBlocksToBeErasureCoded(dfsCluster));
            Assertions.assertEquals((long)0L, (long)bm.getLowRedundancyECBlockGroups());
            DFSTestUtil.verifyClientStats((Configuration)conf, dfsCluster);
        }
        finally {
            dfsCluster.shutdown();
        }
    }

    private byte[] writeStripedFile(DistributedFileSystem fs, Path ecFile, int writeBytes) throws Exception {
        byte[] bytes = StripedFileTestUtil.generateBytes(writeBytes);
        DFSTestUtil.writeFile((FileSystem)fs, ecFile, new String(bytes));
        StripedFileTestUtil.waitBlockGroupsReported(fs, ecFile.toString());
        return bytes;
    }

    @Test
    public void testReconstrutionWithBusyBlock1() throws Exception {
        int busyNodeIndex1 = 0;
        int busyNodeIndex2 = 1;
        int deadNodeIndex = 2;
        Path ecDir = new Path(GenericTestUtils.getRandomizedTempPath());
        Path ecFile = new Path(ecDir, "testReconstrutionWithBusyBlock1");
        int writeBytes = this.cellSize * this.dataBlocks;
        HdfsConfiguration conf = new HdfsConfiguration();
        this.initConf((Configuration)conf);
        conf.setBoolean("dfs.disk.balancer.enabled", false);
        conf.setInt("dfs.namenode.heartbeat.recheck-interval", 2000);
        conf.setInt("dfs.heartbeat.interval", 1);
        conf.setInt("dfs.namenode.redundancy.interval.seconds", 1);
        conf.setInt("dfs.blockreport.intervalMsec", 1000);
        conf.setInt("dfs.namenode.reconstruction.pending.timeout-sec", 4);
        conf.setInt("dfs.namenode.redundancy.interval.seconds", 1);
        this.cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(this.groupSize + 5).build();
        this.cluster.waitActive();
        DistributedFileSystem dfs = this.cluster.getFileSystem(0);
        dfs.enableErasureCodingPolicy(StripedFileTestUtil.getDefaultECPolicy().getName());
        dfs.mkdirs(ecDir);
        dfs.setErasureCodingPolicy(ecDir, StripedFileTestUtil.getDefaultECPolicy().getName());
        byte[] originBytesArray = this.writeStripedFile(dfs, ecFile, writeBytes);
        List lbs = ((HdfsDataInputStream)dfs.open(ecFile)).getAllBlocks();
        LocatedStripedBlock lsb = (LocatedStripedBlock)lbs.get(0);
        DatanodeInfoWithStorage[] dnList = lsb.getLocations();
        BlockManager bm = this.cluster.getNamesystem().getBlockManager();
        BlockInfoStriped blockInfo = (BlockInfoStriped)bm.getStoredBlock(new Block(lsb.getBlock().getBlockId()));
        DatanodeDescriptor busyNode = bm.getDatanodeManager().getDatanode(dnList[busyNodeIndex1].getDatanodeUuid());
        for (int j = 0; j < this.maxReplicationStreams; ++j) {
            busyNode.incrementPendingReplicationWithoutTargets();
        }
        DatanodeDescriptor busyNode2 = bm.getDatanodeManager().getDatanode(dnList[busyNodeIndex2].getDatanodeUuid());
        for (int j = 0; j < this.maxReplicationStreams; ++j) {
            busyNode2.incrementPendingReplicationWithoutTargets();
        }
        DataNode dn = this.cluster.getDataNode(dnList[deadNodeIndex].getIpcPort());
        this.cluster.stopDataNode(dnList[deadNodeIndex].getXferAddr());
        this.cluster.setDataNodeDead(dn.getDatanodeId());
        Assertions.assertEquals((int)8, (int)bm.countNodes((BlockInfo)blockInfo).liveReplicas());
        GenericTestUtils.waitFor(() -> bm.countNodes((BlockInfo)blockInfo).liveReplicas() == 9 || bm.countNodes((BlockInfo)blockInfo).excessReplicas() >= 1 || bm.countNodes((BlockInfo)blockInfo).redundantInternalBlocks() >= 1, (long)10L, (long)100000L);
        Assertions.assertEquals((int)0, (int)bm.countNodes((BlockInfo)blockInfo).excessReplicas());
        Assertions.assertEquals((int)9, (int)bm.countNodes((BlockInfo)blockInfo).liveReplicas());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testReconstructionWithStorageTypeNotEnough() throws Exception {
        HdfsConfiguration conf = new HdfsConfiguration();
        conf.setInt("dfs.namenode.redundancy.interval.seconds", 1);
        int numDn = this.groupSize * 2 + 2;
        StorageType[][] storageTypes = new StorageType[numDn][];
        Arrays.fill((Object[])storageTypes, 0, (int)this.groupSize, new StorageType[]{StorageType.DISK, StorageType.DISK});
        Arrays.fill((Object[])storageTypes, (int)this.groupSize, numDn, new StorageType[]{StorageType.ARCHIVE, StorageType.ARCHIVE});
        String[] racks = new String[]{"/rack1", "/rack2", "/rack3", "/rack4", "/rack5", "/rack6", "/rack7", "/rack8", "/rack9", "/rack0", "/rack0", "/rack0", "/rack0", "/rack0", "/rack0", "/rack0", "/rack0", "/rack0", "/rack0", "/rack0"};
        this.cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(numDn).storageTypes(storageTypes).racks(racks).build();
        this.cluster.waitActive();
        DistributedFileSystem fs = this.cluster.getFileSystem();
        fs.enableErasureCodingPolicy(StripedFileTestUtil.getDefaultECPolicy().getName());
        try {
            fs.mkdirs(this.dirPath);
            fs.setStoragePolicy(this.dirPath, "COLD");
            fs.setErasureCodingPolicy(this.dirPath, StripedFileTestUtil.getDefaultECPolicy().getName());
            DFSTestUtil.createFile((FileSystem)fs, this.filePath, this.cellSize * this.dataBlocks * 2, (short)1, 0L);
            LocatedBlocks blks = fs.getClient().getLocatedBlocks(this.filePath.toString(), 0L);
            LocatedStripedBlock block = (LocatedStripedBlock)blks.getLastLocatedBlock();
            DatanodeInfoWithStorage dnToStop = block.getLocations()[0];
            this.cluster.stopDataNode(dnToStop.getXferAddr());
            this.cluster.setDataNodeDead((DatanodeID)dnToStop);
            StripedFileTestUtil.waitForReconstructionFinished(this.filePath, fs, this.groupSize);
            blks = fs.getClient().getLocatedBlocks(this.filePath.toString(), 0L);
            block = (LocatedStripedBlock)blks.getLastLocatedBlock();
            BitSet bitSet = new BitSet(this.groupSize);
            for (byte index : block.getBlockIndices()) {
                bitSet.set(index);
            }
            for (int i = 0; i < this.groupSize; ++i) {
                Assertions.assertTrue((boolean)bitSet.get(i));
            }
        }
        finally {
            this.cluster.shutdown();
        }
    }
}

