/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode;

import java.io.File;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.crypto.key.KeyProvider;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FileSystemTestHelper;
import org.apache.hadoop.fs.FsShell;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.SafeModeAction;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.hdfs.DFSTestUtil;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.server.namenode.EncryptionZoneManager;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.test.GenericTestUtils;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.event.Level;

public class TestNestedEncryptionZones {
    private File testRootDir;
    private final String TOP_EZ_KEY = "topezkey";
    private final String NESTED_EZ_KEY = "nestedezkey";
    private MiniDFSCluster cluster;
    protected DistributedFileSystem fs;
    private final Path rootDir = new Path("/");
    private final Path rawDir = new Path("/.reserved/raw/");
    private Path nestedEZBaseFile = new Path(this.rootDir, "nestedEZBaseFile");
    private Path topEZBaseFile = new Path(this.rootDir, "topEZBaseFile");
    private Path topEZDir;
    private Path nestedEZDir;
    private Path topEZFile;
    private Path nestedEZFile;
    private Path topEZRawFile;
    private Path nestedEZRawFile;
    private final int len = 8196;

    private String getKeyProviderURI() {
        return "jceks://file" + new Path(this.testRootDir.toString(), "test.jks").toUri();
    }

    private void setProvider() {
        this.fs.getClient().setKeyProvider((KeyProvider)this.cluster.getNameNode().getNamesystem().getProvider());
    }

    @BeforeEach
    public void setup() throws Exception {
        HdfsConfiguration conf = new HdfsConfiguration();
        FileSystemTestHelper fsHelper = new FileSystemTestHelper();
        String testRoot = fsHelper.getTestRootDir();
        this.testRootDir = new File(testRoot).getAbsoluteFile();
        conf.set("hadoop.security.key.provider.path", this.getKeyProviderURI());
        conf.setBoolean("dfs.namenode.delegation.token.always-use", true);
        conf.setInt("dfs.namenode.list.encryption.zones.num.responses", 2);
        conf.setLong("fs.trash.interval", 1L);
        this.cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(1).build();
        GenericTestUtils.setLogLevel((Logger)LoggerFactory.getLogger(EncryptionZoneManager.class), (Level)Level.TRACE);
        this.fs = this.cluster.getFileSystem();
        this.setProvider();
        DFSTestUtil.createKey("topezkey", this.cluster, (Configuration)conf);
        DFSTestUtil.createKey("nestedezkey", this.cluster, (Configuration)conf);
    }

    @AfterEach
    public void tearDown() throws Exception {
        if (this.cluster != null) {
            this.cluster.shutdown();
            this.cluster = null;
        }
    }

    @Test
    @Timeout(value=60L)
    public void testNestedEncryptionZones() throws Exception {
        this.initTopEZDirAndNestedEZDir(new Path(this.rootDir, "topEZ"));
        this.verifyEncryption();
        this.cluster.restartNameNodes();
        this.cluster.waitActive();
        this.fs = this.cluster.getFileSystem();
        this.verifyEncryption();
        this.fs.setSafeMode(SafeModeAction.ENTER);
        this.fs.saveNamespace();
        this.fs.setSafeMode(SafeModeAction.LEAVE);
        this.cluster.restartNameNodes();
        this.cluster.waitActive();
        this.fs = this.cluster.getFileSystem();
        this.verifyEncryption();
        this.renameChildrenOfEZ();
        Path topEZ2Dir = new Path(this.rootDir, "topEZ2");
        this.fs.mkdir(topEZ2Dir, FsPermission.getDirDefault());
        this.fs.createEncryptionZone(topEZ2Dir, "topezkey");
        try {
            this.fs.rename(topEZ2Dir, new Path(this.topEZDir, "topEZ2"));
            Assertions.fail((String)"Shouldn't be able to move a non-nested EZ into another existing EZ.");
        }
        catch (Exception e) {
            Assertions.assertTrue((boolean)e.getMessage().contains("can't be moved into an encryption zone"));
        }
        this.fs.rename(this.topEZDir, new Path(this.rootDir, "newTopEZ"));
        this.fs.rename(new Path(this.rootDir, "newTopEZ/nestedEZ"), new Path(this.rootDir, "newTopEZ/newNestedEZ"));
    }

    @Test
    @Timeout(value=60L)
    public void testNestedEZWithRoot() throws Exception {
        this.initTopEZDirAndNestedEZDir(this.rootDir);
        this.verifyEncryption();
        this.renameChildrenOfEZ();
        String currentUser = UserGroupInformation.getCurrentUser().getShortUserName();
        Path suffixTrashPath = new Path(".Trash", currentUser);
        Path rootTrash = this.fs.getTrashRoot(this.rootDir);
        Path topEZTrash = this.fs.getTrashRoot(this.topEZFile);
        Path nestedEZTrash = this.fs.getTrashRoot(this.nestedEZFile);
        Path expectedTopEZTrash = this.fs.makeQualified(new Path(this.topEZDir, suffixTrashPath));
        Path expectedNestedEZTrash = this.fs.makeQualified(new Path(this.nestedEZDir, suffixTrashPath));
        Assertions.assertEquals((Object)expectedTopEZTrash, (Object)topEZTrash, (String)("Top ez trash should be " + expectedTopEZTrash));
        Assertions.assertEquals((Object)topEZTrash, (Object)rootTrash, (String)"Root trash should be equal with TopEZFile trash");
        Assertions.assertEquals((Object)expectedNestedEZTrash, (Object)nestedEZTrash, (String)("Nested ez Trash should be " + expectedNestedEZTrash));
        FsShell shell = new FsShell(this.fs.getConf());
        Path topTrashFile = new Path(shell.getCurrentTrashDir(this.topEZFile) + "/" + this.topEZFile);
        Path nestedTrashFile = new Path(shell.getCurrentTrashDir(this.nestedEZFile) + "/" + this.nestedEZFile);
        ToolRunner.run((Tool)shell, (String[])new String[]{"-rm", this.topEZFile.toString()});
        ToolRunner.run((Tool)shell, (String[])new String[]{"-rm", this.nestedEZFile.toString()});
        Assertions.assertTrue((boolean)this.fs.exists(topTrashFile), (String)("File not in trash : " + topTrashFile));
        Assertions.assertTrue((boolean)this.fs.exists(nestedTrashFile), (String)("File not in trash : " + nestedTrashFile));
    }

    private void renameChildrenOfEZ() throws Exception {
        Path renamedTopEZFile = new Path(this.topEZDir, "renamedFile");
        Path renamedNestedEZFile = new Path(this.nestedEZDir, "renamedFile");
        this.fs.rename(this.topEZFile, renamedTopEZFile);
        this.fs.rename(this.nestedEZFile, renamedNestedEZFile);
        this.topEZFile = renamedTopEZFile;
        this.nestedEZFile = renamedNestedEZFile;
        this.topEZRawFile = new Path(this.rawDir + this.topEZFile.toUri().getPath());
        this.nestedEZRawFile = new Path(this.rawDir + this.nestedEZFile.toUri().getPath());
        this.verifyEncryption();
        try {
            this.fs.rename(this.topEZFile, new Path(this.nestedEZDir, "movedTopEZFile"));
            Assertions.fail((String)"Shouldn't be able to rename between top EZ and nested EZ.");
        }
        catch (Exception e) {
            Assertions.assertTrue((boolean)e.getMessage().contains("can't be moved from encryption zone " + this.topEZDir.toString() + " to encryption zone " + this.nestedEZDir.toString()));
        }
        try {
            this.fs.rename(this.nestedEZFile, new Path(this.topEZDir, "movedNestedEZFile"));
            Assertions.fail((String)"Shouldn't be able to rename between top EZ and nested EZ.");
        }
        catch (Exception e) {
            Assertions.assertTrue((boolean)e.getMessage().contains("can't be moved from encryption zone " + this.nestedEZDir.toString() + " to encryption zone " + this.topEZDir.toString()));
        }
        try {
            this.fs.rename(this.nestedEZFile, new Path(this.rootDir, "movedNestedEZFile"));
            Assertions.fail((String)"Shouldn't be able to move the nested EZ out of the top EZ.");
        }
        catch (Exception e) {
            String exceptionMsg = e.getMessage();
            Assertions.assertTrue((exceptionMsg.contains("can't be moved from") && exceptionMsg.contains("encryption zone") ? 1 : 0) != 0);
        }
    }

    private void initTopEZDirAndNestedEZDir(Path topPath) throws Exception {
        this.fs.delete(this.rootDir, true);
        this.topEZDir = topPath;
        this.nestedEZDir = new Path(this.topEZDir, "nestedEZ");
        this.topEZFile = new Path(this.topEZDir, "file");
        this.nestedEZFile = new Path(this.nestedEZDir, "file");
        this.topEZRawFile = new Path(this.rawDir + this.topEZFile.toUri().getPath());
        this.nestedEZRawFile = new Path(this.rawDir + this.nestedEZFile.toUri().getPath());
        this.fs.mkdir(this.topEZDir, FsPermission.getDirDefault());
        this.fs.createEncryptionZone(this.topEZDir, "topezkey");
        this.fs.mkdir(this.nestedEZDir, FsPermission.getDirDefault());
        this.fs.createEncryptionZone(this.nestedEZDir, "nestedezkey");
        DFSTestUtil.createFile((FileSystem)this.fs, this.topEZBaseFile, 8196L, (short)1, 65261L);
        DFSTestUtil.createFile((FileSystem)this.fs, this.topEZFile, 8196L, (short)1, 65261L);
        DFSTestUtil.createFile((FileSystem)this.fs, this.nestedEZBaseFile, 8196L, (short)1, 65261L);
        DFSTestUtil.createFile((FileSystem)this.fs, this.nestedEZFile, 8196L, (short)1, 65261L);
    }

    private void verifyEncryption() throws Exception {
        Assertions.assertEquals((Object)true, (Object)this.fs.getFileStatus(this.topEZDir).isEncrypted(), (String)"Top EZ dir is encrypted");
        Assertions.assertEquals((Object)true, (Object)this.fs.getFileStatus(this.nestedEZDir).isEncrypted(), (String)"Nested EZ dir is encrypted");
        Assertions.assertEquals((Object)true, (Object)this.fs.getFileStatus(this.topEZFile).isEncrypted(), (String)"Top zone file is encrypted");
        Assertions.assertEquals((Object)true, (Object)this.fs.getFileStatus(this.nestedEZFile).isEncrypted(), (String)"Nested zone file is encrypted");
        DFSTestUtil.verifyFilesEqual((FileSystem)this.fs, this.topEZBaseFile, this.topEZFile, 8196);
        DFSTestUtil.verifyFilesEqual((FileSystem)this.fs, this.nestedEZBaseFile, this.nestedEZFile, 8196);
        DFSTestUtil.verifyFilesNotEqual((FileSystem)this.fs, this.topEZRawFile, this.nestedEZRawFile, 8196);
    }
}

