/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.StorageType;
import org.apache.hadoop.hdfs.DFSOutputStream;
import org.apache.hadoop.hdfs.DFSTestUtil;
import org.apache.hadoop.hdfs.DFSUtilClient;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.protocol.DatanodeID;
import org.apache.hadoop.hdfs.protocol.DatanodeInfo;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockManagerTestUtil;
import org.apache.hadoop.hdfs.server.blockmanagement.DatanodeDescriptor;
import org.apache.hadoop.hdfs.server.blockmanagement.DatanodeManager;
import org.apache.hadoop.hdfs.server.datanode.DataNode;
import org.apache.hadoop.hdfs.server.datanode.DataNodeTestUtils;
import org.apache.hadoop.hdfs.server.datanode.FsDatasetTestUtils;
import org.apache.hadoop.hdfs.server.namenode.FSNamesystem;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestNamenodeCapacityReport {
    private static final Logger LOG = LoggerFactory.getLogger(TestNamenodeCapacityReport.class);
    private static final float EPSILON = 1.0E-4f;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testVolumeSize() throws Exception {
        HdfsConfiguration conf = new HdfsConfiguration();
        MiniDFSCluster cluster = null;
        long reserved = 10000L;
        conf.setLong("dfs.datanode.du.reserved", reserved);
        try {
            float percentBpUsed;
            long bpUsed;
            float percentRemaining;
            float percentUsed;
            long configCapacity;
            long nonDFSUsed;
            long remaining;
            long used;
            cluster = new MiniDFSCluster.Builder((Configuration)conf).build();
            cluster.waitActive();
            FSNamesystem namesystem = cluster.getNamesystem();
            DatanodeManager dm = cluster.getNamesystem().getBlockManager().getDatanodeManager();
            ArrayList live = new ArrayList();
            ArrayList dead = new ArrayList();
            dm.fetchDatanodes(live, dead, false);
            Assertions.assertTrue((live.size() == 1 ? 1 : 0) != 0);
            for (DatanodeDescriptor datanode : live) {
                used = datanode.getDfsUsed();
                remaining = datanode.getRemaining();
                nonDFSUsed = datanode.getNonDfsUsed();
                configCapacity = datanode.getCapacity();
                percentUsed = datanode.getDfsUsedPercent();
                percentRemaining = datanode.getRemainingPercent();
                bpUsed = datanode.getBlockPoolUsed();
                percentBpUsed = datanode.getBlockPoolUsedPercent();
                LOG.info("Datanode configCapacity " + configCapacity + " used " + used + " non DFS used " + nonDFSUsed + " remaining " + remaining + " perentUsed " + percentUsed + " percentRemaining " + percentRemaining);
                Assertions.assertTrue((configCapacity >= used + remaining + nonDFSUsed ? 1 : 0) != 0);
                Assertions.assertTrue((percentUsed == DFSUtilClient.getPercentUsed((long)used, (long)configCapacity) ? 1 : 0) != 0);
                Assertions.assertTrue((percentRemaining == DFSUtilClient.getPercentRemaining((long)remaining, (long)configCapacity) ? 1 : 0) != 0);
                Assertions.assertTrue((percentBpUsed == DFSUtilClient.getPercentUsed((long)bpUsed, (long)configCapacity) ? 1 : 0) != 0);
            }
            FsDatasetTestUtils utils = cluster.getFsDatasetTestUtils(0);
            int numOfDataDirs = utils.getDefaultNumOfDataDirs();
            long diskCapacity = (long)numOfDataDirs * utils.getRawCapacity();
            reserved *= (long)numOfDataDirs;
            configCapacity = namesystem.getCapacityTotal();
            used = namesystem.getCapacityUsed();
            nonDFSUsed = namesystem.getNonDfsUsedSpace();
            remaining = namesystem.getCapacityRemaining();
            percentUsed = namesystem.getPercentUsed();
            percentRemaining = namesystem.getPercentRemaining();
            bpUsed = namesystem.getBlockPoolUsedSpace();
            percentBpUsed = namesystem.getPercentBlockPoolUsed();
            LOG.info("Data node directory " + cluster.getDataDirectory());
            LOG.info("Name node diskCapacity " + diskCapacity + " configCapacity " + configCapacity + " reserved " + reserved + " used " + used + " remaining " + remaining + " nonDFSUsed " + nonDFSUsed + " remaining " + remaining + " percentUsed " + percentUsed + " percentRemaining " + percentRemaining + " bpUsed " + bpUsed + " percentBpUsed " + percentBpUsed);
            Assertions.assertTrue((configCapacity == diskCapacity - reserved ? 1 : 0) != 0);
            Assertions.assertTrue((configCapacity >= used + remaining + nonDFSUsed ? 1 : 0) != 0);
            Assertions.assertTrue((percentUsed == DFSUtilClient.getPercentUsed((long)used, (long)configCapacity) ? 1 : 0) != 0);
            Assertions.assertTrue((percentBpUsed == DFSUtilClient.getPercentUsed((long)bpUsed, (long)configCapacity) ? 1 : 0) != 0);
            Assertions.assertTrue((percentRemaining == (float)remaining * 100.0f / (float)configCapacity ? 1 : 0) != 0);
            int fileCount = 5;
            DistributedFileSystem fs = cluster.getFileSystem();
            DFSOutputStream[] streams = new DFSOutputStream[5];
            for (int i = 0; i < 5; ++i) {
                streams[i] = (DFSOutputStream)fs.create(new Path("/f" + i)).getWrappedStream();
                streams[i].write("1".getBytes());
                streams[i].hsync();
            }
            this.triggerHeartbeats(cluster.getDataNodes());
            Assertions.assertTrue((configCapacity > namesystem.getCapacityUsed() + namesystem.getCapacityRemaining() + namesystem.getNonDfsUsedSpace() ? 1 : 0) != 0);
            Assertions.assertTrue((namesystem.getCapacityUsed() + namesystem.getCapacityRemaining() + namesystem.getNonDfsUsedSpace() + 5L * fs.getDefaultBlockSize() - configCapacity < 1024L ? 1 : 0) != 0);
        }
        finally {
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testVolumeSizeWithSameDiskTiering() throws Exception {
        HdfsConfiguration conf = new HdfsConfiguration();
        MiniDFSCluster cluster = null;
        long reserved = 10000L;
        conf.setLong("dfs.datanode.du.reserved", reserved);
        try {
            double reserveForAchive = 0.3;
            conf.setBoolean("dfs.datanode.same-disk-tiering.enabled", true);
            conf.setDouble("dfs.datanode.reserve-for-archive.default.percentage", reserveForAchive);
            cluster = new MiniDFSCluster.Builder((Configuration)conf).storageTypes(new StorageType[]{StorageType.DISK, StorageType.ARCHIVE}).build();
            cluster.waitActive();
            FsDatasetTestUtils utils = cluster.getFsDatasetTestUtils(0);
            long configCapacity = cluster.getNamesystem().getCapacityTotal();
            long rawCapacity = utils.getRawCapacity();
            long diskCapacity = (long)((double)(rawCapacity - reserved) * reserveForAchive) + (long)((double)(rawCapacity - reserved) * (1.0 - reserveForAchive)) + reserved;
            Assertions.assertEquals((long)configCapacity, (long)(diskCapacity - reserved));
            DataNode dn = cluster.getDataNodes().get(0);
            long singleVolumeUsed = dn.getFSDataset().getStorageReports(cluster.getNamesystem().getBlockPoolId())[0].getNonDfsUsed();
            cluster.triggerHeartbeats();
            Assertions.assertTrue((cluster.getNamesystem().getCapacityUsed() < singleVolumeUsed * 2L ? 1 : 0) != 0);
        }
        finally {
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }

    @Test
    public void testXceiverCount() throws Exception {
        this.testXceiverCountInternal(0);
        this.testXceiverCountInternal(1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testXceiverCountInternal(int minMaintenanceR) throws Exception {
        HdfsConfiguration conf = new HdfsConfiguration();
        conf.setInt("dfs.client.block.write.locateFollowingBlock.retries", 1);
        conf.setInt("dfs.namenode.maintenance.replication.min", minMaintenanceR);
        MiniDFSCluster cluster = null;
        int nodes = 8;
        int fileCount = 5;
        int fileRepl = 3;
        try {
            int i;
            DatanodeDescriptor dnd;
            cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(8).build();
            cluster.waitActive();
            FSNamesystem namesystem = cluster.getNamesystem();
            DatanodeManager dnm = namesystem.getBlockManager().getDatanodeManager();
            ArrayList<DataNode> datanodes = cluster.getDataNodes();
            DistributedFileSystem fs = cluster.getFileSystem();
            this.triggerHeartbeats(datanodes);
            int expectedTotalLoad = 0;
            int expectedInServiceNodes = 8;
            int expectedInServiceLoad = 0;
            TestNamenodeCapacityReport.checkClusterHealth(8, namesystem, expectedTotalLoad, expectedInServiceNodes, expectedInServiceLoad);
            for (int i2 = 0; i2 < 4; ++i2) {
                DataNode dn = (DataNode)datanodes.get(i2);
                dnd = dnm.getDatanode(dn.getDatanodeId());
                dn.shutdown();
                DFSTestUtil.setDatanodeDead((DatanodeInfo)dnd);
                BlockManagerTestUtil.checkHeartbeat(namesystem.getBlockManager());
                this.startDecommissionOrMaintenance(dnm, dnd, i2 % 2 == 0);
                Assertions.assertEquals((int)(--expectedInServiceNodes), (int)namesystem.getNumLiveDataNodes());
                Assertions.assertEquals((int)expectedInServiceNodes, (int)TestNamenodeCapacityReport.getNumDNInService(namesystem));
                this.stopDecommissionOrMaintenance(dnm, dnd, i2 % 2 == 0);
                Assertions.assertEquals((int)expectedInServiceNodes, (int)TestNamenodeCapacityReport.getNumDNInService(namesystem));
            }
            cluster.restartDataNodes();
            cluster.waitActive();
            datanodes = cluster.getDataNodes();
            expectedInServiceNodes = 8;
            Assertions.assertEquals((int)8, (int)datanodes.size());
            TestNamenodeCapacityReport.checkClusterHealth(8, namesystem, expectedTotalLoad, expectedInServiceNodes, expectedInServiceLoad);
            DFSOutputStream[] streams = new DFSOutputStream[5];
            for (i = 0; i < 5; ++i) {
                streams[i] = (DFSOutputStream)fs.create(new Path("/f" + i), (short)3).getWrappedStream();
                streams[i].write("1".getBytes());
                streams[i].hsync();
                expectedTotalLoad += 6;
                expectedInServiceLoad += 6;
            }
            this.triggerHeartbeats(datanodes);
            TestNamenodeCapacityReport.checkClusterHealth(8, namesystem, expectedTotalLoad, expectedInServiceNodes, expectedInServiceLoad);
            for (i = 0; i < 3; ++i) {
                dnd = dnm.getDatanode(((DataNode)datanodes.get(i)).getDatanodeId());
                this.startDecommissionOrMaintenance(dnm, dnd, i % 2 == 0);
                DataNodeTestUtils.triggerHeartbeat((DataNode)datanodes.get(i));
                Thread.sleep(100L);
                TestNamenodeCapacityReport.checkClusterHealth(8, namesystem, expectedTotalLoad, --expectedInServiceNodes, expectedInServiceLoad -= dnd.getXceiverCount());
            }
            for (i = 0; i < 5; ++i) {
                block14: {
                    int adminOps = 0;
                    for (DatanodeInfo dni : streams[i].getPipeline()) {
                        DatanodeDescriptor dnd2 = dnm.getDatanode((DatanodeID)dni);
                        expectedTotalLoad -= 2;
                        if (!dnd2.isInService()) {
                            ++adminOps;
                            continue;
                        }
                        expectedInServiceLoad -= 2;
                    }
                    try {
                        streams[i].close();
                    }
                    catch (IOException ioe) {
                        if (adminOps >= 3) break block14;
                        throw ioe;
                    }
                }
                this.triggerHeartbeats(datanodes);
                TestNamenodeCapacityReport.checkClusterHealth(8, namesystem, expectedTotalLoad, expectedInServiceNodes, expectedInServiceLoad);
            }
            for (i = 0; i < 8; ++i) {
                DataNode dn = (DataNode)datanodes.get(i);
                dn.shutdown();
                DatanodeDescriptor dnDesc = dnm.getDatanode(dn.getDatanodeId());
                DFSTestUtil.setDatanodeDead((DatanodeInfo)dnDesc);
                BlockManagerTestUtil.checkHeartbeat(namesystem.getBlockManager());
                Assertions.assertEquals((int)(7 - i), (int)namesystem.getNumLiveDataNodes());
                if (i >= 3) {
                    --expectedInServiceNodes;
                }
                Assertions.assertEquals((int)expectedInServiceNodes, (int)TestNamenodeCapacityReport.getNumDNInService(namesystem));
                Assertions.assertEquals((double)0.0, (double)TestNamenodeCapacityReport.getInServiceXceiverAverage(namesystem), (double)1.0E-4f);
            }
            TestNamenodeCapacityReport.checkClusterHealth(0, namesystem, 0.0, 0, 0.0);
        }
        finally {
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }

    private void startDecommissionOrMaintenance(DatanodeManager dnm, DatanodeDescriptor dnd, boolean decomm) {
        if (decomm) {
            dnm.getDatanodeAdminManager().startDecommission(dnd);
        } else {
            dnm.getDatanodeAdminManager().startMaintenance(dnd, Long.MAX_VALUE);
        }
    }

    private void stopDecommissionOrMaintenance(DatanodeManager dnm, DatanodeDescriptor dnd, boolean decomm) {
        if (decomm) {
            dnm.getDatanodeAdminManager().stopDecommission(dnd);
        } else {
            dnm.getDatanodeAdminManager().stopMaintenance(dnd);
        }
    }

    private static void checkClusterHealth(int numOfLiveNodes, FSNamesystem namesystem, double expectedTotalLoad, int expectedInServiceNodes, double expectedInServiceLoad) {
        Assertions.assertEquals((int)numOfLiveNodes, (int)namesystem.getNumLiveDataNodes());
        Assertions.assertEquals((int)expectedInServiceNodes, (int)TestNamenodeCapacityReport.getNumDNInService(namesystem));
        Assertions.assertEquals((double)expectedTotalLoad, (double)namesystem.getTotalLoad(), (double)1.0E-4f);
        if (expectedInServiceNodes != 0) {
            Assertions.assertEquals((double)(expectedInServiceLoad / (double)expectedInServiceNodes), (double)TestNamenodeCapacityReport.getInServiceXceiverAverage(namesystem), (double)1.0E-4f);
        } else {
            Assertions.assertEquals((double)0.0, (double)TestNamenodeCapacityReport.getInServiceXceiverAverage(namesystem), (double)1.0E-4f);
        }
    }

    private static int getNumDNInService(FSNamesystem fsn) {
        return fsn.getBlockManager().getDatanodeManager().getFSClusterStats().getNumDatanodesInService();
    }

    private static double getInServiceXceiverAverage(FSNamesystem fsn) {
        return fsn.getBlockManager().getDatanodeManager().getFSClusterStats().getInServiceXceiverAverage();
    }

    private void triggerHeartbeats(List<DataNode> datanodes) throws IOException, InterruptedException {
        for (DataNode dn : datanodes) {
            DataNodeTestUtils.triggerHeartbeat(dn);
        }
        Thread.sleep(100L);
    }
}

