/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.conf.ReconfigurationException;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.DFSConfigKeys;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.protocol.BlockType;
import org.apache.hadoop.hdfs.protocol.HdfsConstants;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockManager;
import org.apache.hadoop.hdfs.server.blockmanagement.DatanodeAdminBackoffMonitor;
import org.apache.hadoop.hdfs.server.blockmanagement.DatanodeAdminMonitorInterface;
import org.apache.hadoop.hdfs.server.blockmanagement.DatanodeManager;
import org.apache.hadoop.hdfs.server.blockmanagement.SlowPeerTracker;
import org.apache.hadoop.hdfs.server.namenode.FSImageFormatProtobuf;
import org.apache.hadoop.hdfs.server.namenode.FSNamesystem;
import org.apache.hadoop.hdfs.server.namenode.NameNode;
import org.apache.hadoop.hdfs.server.namenode.NameNodeRpcServer;
import org.apache.hadoop.hdfs.server.namenode.sps.StoragePolicySatisfyManager;
import org.apache.hadoop.hdfs.server.protocol.OutlierMetrics;
import org.apache.hadoop.ipc.RemoteException;
import org.apache.hadoop.test.GenericTestUtils;
import org.apache.hadoop.test.LambdaTestUtils;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestNameNodeReconfigure {
    public static final Logger LOG = LoggerFactory.getLogger(TestNameNodeReconfigure.class);
    private MiniDFSCluster cluster;
    private final int customizedBlockInvalidateLimit = 500;

    @BeforeEach
    public void setUp() throws IOException {
        HdfsConfiguration conf = new HdfsConfiguration();
        conf.setInt("dfs.block.invalidate.limit", 500);
        this.cluster = new MiniDFSCluster.Builder((Configuration)conf).build();
        this.cluster.waitActive();
    }

    @Test
    public void testReconfigureCallerContextEnabled() throws ReconfigurationException {
        NameNode nameNode = this.cluster.getNameNode();
        FSNamesystem nameSystem = nameNode.getNamesystem();
        nameNode.reconfigureProperty("hadoop.caller.context.enabled", "text");
        this.verifyReconfigureCallerContextEnabled(nameNode, nameSystem, false);
        nameNode.reconfigureProperty("hadoop.caller.context.enabled", "true");
        this.verifyReconfigureCallerContextEnabled(nameNode, nameSystem, true);
        nameNode.reconfigureProperty("hadoop.caller.context.enabled", "false");
        this.verifyReconfigureCallerContextEnabled(nameNode, nameSystem, false);
        nameNode.reconfigureProperty("hadoop.caller.context.enabled", null);
        Assertions.assertEquals((Object)false, (Object)nameSystem.getCallerContextEnabled(), (String)"hadoop.caller.context.enabled has wrong value");
        Assertions.assertEquals(null, (Object)nameNode.getConf().get("hadoop.caller.context.enabled"), (String)"hadoop.caller.context.enabled has wrong value");
    }

    void verifyReconfigureCallerContextEnabled(NameNode nameNode, FSNamesystem nameSystem, boolean expected) {
        Assertions.assertEquals((Object)expected, (Object)nameNode.getNamesystem().getCallerContextEnabled(), (String)"hadoop.caller.context.enabled has wrong value");
        Assertions.assertEquals((Object)expected, (Object)nameNode.getConf().getBoolean("hadoop.caller.context.enabled", false), (String)"hadoop.caller.context.enabled has wrong value");
    }

    @Test
    public void testReconfigureIPCBackoff() throws ReconfigurationException {
        NameNode nameNode = this.cluster.getNameNode();
        NameNodeRpcServer nnrs = (NameNodeRpcServer)nameNode.getRpcServer();
        String ipcClientRPCBackoffEnable = NameNode.buildBackoffEnableKey((int)nnrs.getClientRpcServer().getPort());
        this.verifyReconfigureIPCBackoff(nameNode, nnrs, ipcClientRPCBackoffEnable, false);
        nameNode.reconfigureProperty(ipcClientRPCBackoffEnable, "true");
        this.verifyReconfigureIPCBackoff(nameNode, nnrs, ipcClientRPCBackoffEnable, true);
        nameNode.reconfigureProperty(ipcClientRPCBackoffEnable, "false");
        this.verifyReconfigureIPCBackoff(nameNode, nnrs, ipcClientRPCBackoffEnable, false);
        nameNode.reconfigureProperty(ipcClientRPCBackoffEnable, null);
        Assertions.assertEquals((Object)false, (Object)nnrs.getClientRpcServer().isClientBackoffEnabled(), (String)(ipcClientRPCBackoffEnable + " has wrong value"));
        Assertions.assertEquals(null, (Object)nameNode.getConf().get(ipcClientRPCBackoffEnable), (String)(ipcClientRPCBackoffEnable + " has wrong value"));
    }

    void verifyReconfigureIPCBackoff(NameNode nameNode, NameNodeRpcServer nnrs, String property, boolean expected) {
        Assertions.assertEquals((Object)expected, (Object)nnrs.getClientRpcServer().isClientBackoffEnabled(), (String)(property + " has wrong value"));
        Assertions.assertEquals((Object)expected, (Object)nameNode.getConf().getBoolean(property, false), (String)(property + " has wrong value"));
    }

    @Test
    public void testReconfigureHearbeatCheck() throws ReconfigurationException {
        NameNode nameNode = this.cluster.getNameNode();
        DatanodeManager datanodeManager = nameNode.namesystem.getBlockManager().getDatanodeManager();
        nameNode.reconfigureProperty("dfs.heartbeat.interval", "6");
        nameNode.reconfigureProperty("dfs.namenode.heartbeat.recheck-interval", "600000");
        try {
            nameNode.reconfigureProperty("dfs.heartbeat.interval", "text");
            Assertions.fail((String)"ReconfigurationException expected");
        }
        catch (ReconfigurationException expected) {
            Assertions.assertTrue((boolean)(expected.getCause() instanceof NumberFormatException));
        }
        try {
            nameNode.reconfigureProperty("dfs.namenode.heartbeat.recheck-interval", "text");
            Assertions.fail((String)"ReconfigurationException expected");
        }
        catch (ReconfigurationException expected) {
            Assertions.assertTrue((boolean)(expected.getCause() instanceof NumberFormatException));
        }
        Assertions.assertEquals((long)6L, (long)nameNode.getConf().getLong("dfs.heartbeat.interval", 3L), (String)"dfs.heartbeat.interval has wrong value");
        Assertions.assertEquals((long)6L, (long)datanodeManager.getHeartbeatInterval(), (String)"dfs.heartbeat.interval has wrong value");
        Assertions.assertEquals((int)600000, (int)nameNode.getConf().getInt("dfs.namenode.heartbeat.recheck-interval", 300000), (String)"dfs.namenode.heartbeat.recheck-interval has wrong value");
        Assertions.assertEquals((long)600000L, (long)datanodeManager.getHeartbeatRecheckInterval(), (String)"dfs.namenode.heartbeat.recheck-interval has wrong value");
        nameNode.reconfigureProperty("dfs.heartbeat.interval", "1m");
        Assertions.assertEquals((long)60L, (long)nameNode.getConf().getLong("dfs.heartbeat.interval", 3L), (String)"dfs.heartbeat.interval has wrong value");
        Assertions.assertEquals((long)60L, (long)datanodeManager.getHeartbeatInterval(), (String)"dfs.heartbeat.interval has wrong value");
        nameNode.reconfigureProperty("dfs.heartbeat.interval", null);
        nameNode.reconfigureProperty("dfs.namenode.heartbeat.recheck-interval", null);
        Assertions.assertEquals(null, (Object)nameNode.getConf().get("dfs.heartbeat.interval"), (String)"dfs.heartbeat.interval has wrong value");
        Assertions.assertEquals((long)3L, (long)datanodeManager.getHeartbeatInterval(), (String)"dfs.heartbeat.interval has wrong value");
        Assertions.assertEquals(null, (Object)nameNode.getConf().get("dfs.namenode.heartbeat.recheck-interval"), (String)"dfs.namenode.heartbeat.recheck-interval has wrong value");
        Assertions.assertEquals((long)300000L, (long)datanodeManager.getHeartbeatRecheckInterval(), (String)"dfs.namenode.heartbeat.recheck-interval has wrong value");
    }

    @Test
    @Timeout(value=30L)
    public void testReconfigureSPSWithStoragePolicyDisabled() throws ReconfigurationException, IOException {
        this.cluster.shutdown();
        HdfsConfiguration conf = new HdfsConfiguration();
        conf.setBoolean("dfs.storage.policy.enabled", false);
        this.cluster = new MiniDFSCluster.Builder((Configuration)conf).build();
        this.cluster.waitActive();
        NameNode nameNode = this.cluster.getNameNode();
        this.verifySPSEnabled(nameNode, "dfs.storage.policy.satisfier.mode", HdfsConstants.StoragePolicySatisfierMode.NONE, false);
        nameNode.reconfigureProperty("dfs.storage.policy.satisfier.mode", HdfsConstants.StoragePolicySatisfierMode.EXTERNAL.toString());
        Assertions.assertNull((Object)nameNode.getNamesystem().getBlockManager().getSPSManager(), (String)"SPS shouldn't start as dfs.storage.policy.enabled is disabled");
        this.verifySPSEnabled(nameNode, "dfs.storage.policy.satisfier.mode", HdfsConstants.StoragePolicySatisfierMode.EXTERNAL, false);
        Assertions.assertEquals((Object)HdfsConstants.StoragePolicySatisfierMode.EXTERNAL.toString(), (Object)nameNode.getConf().get("dfs.storage.policy.satisfier.mode", DFSConfigKeys.DFS_STORAGE_POLICY_SATISFIER_MODE_DEFAULT), (String)"dfs.storage.policy.satisfier.mode has wrong value");
    }

    @Test
    @Timeout(value=30L)
    public void testReconfigureStoragePolicySatisfierEnabled() throws ReconfigurationException {
        NameNode nameNode = this.cluster.getNameNode();
        this.verifySPSEnabled(nameNode, "dfs.storage.policy.satisfier.mode", HdfsConstants.StoragePolicySatisfierMode.NONE, false);
        try {
            nameNode.reconfigureProperty("dfs.storage.policy.satisfier.mode", "text");
            Assertions.fail((String)"ReconfigurationException expected");
        }
        catch (ReconfigurationException e) {
            GenericTestUtils.assertExceptionContains((String)"For enabling or disabling storage policy satisfier, must pass either internal/external/none string value only", (Throwable)e.getCause());
        }
        nameNode.reconfigureProperty("dfs.storage.policy.satisfier.mode", HdfsConstants.StoragePolicySatisfierMode.NONE.toString());
        this.verifySPSEnabled(nameNode, "dfs.storage.policy.satisfier.mode", HdfsConstants.StoragePolicySatisfierMode.NONE, false);
        nameNode.reconfigureProperty("dfs.storage.policy.satisfier.mode", HdfsConstants.StoragePolicySatisfierMode.EXTERNAL.toString());
        Assertions.assertEquals((Object)false, (Object)nameNode.getNamesystem().getBlockManager().getSPSManager().isSatisfierRunning(), (String)"dfs.storage.policy.satisfier.mode has wrong value");
        Assertions.assertEquals((Object)HdfsConstants.StoragePolicySatisfierMode.EXTERNAL.toString(), (Object)nameNode.getConf().get("dfs.storage.policy.satisfier.mode", DFSConfigKeys.DFS_STORAGE_POLICY_SATISFIER_MODE_DEFAULT), (String)"dfs.storage.policy.satisfier.mode has wrong value");
        Assertions.assertNotNull((Object)nameNode.getNamesystem().getBlockManager().getSPSManager(), (String)"SPS Manager should be created");
    }

    @Test
    @Timeout(value=30L)
    public void testSatisfyStoragePolicyAfterSatisfierDisabled() throws ReconfigurationException, IOException {
        NameNode nameNode = this.cluster.getNameNode();
        nameNode.reconfigureProperty("dfs.storage.policy.satisfier.mode", HdfsConstants.StoragePolicySatisfierMode.NONE.toString());
        this.verifySPSEnabled(nameNode, "dfs.storage.policy.satisfier.mode", HdfsConstants.StoragePolicySatisfierMode.NONE, false);
        Assertions.assertNull((Object)nameNode.getNamesystem().getBlockManager().getSPSManager(), (String)"SPS Manager should be null");
        Path filePath = new Path("/testSPS");
        DistributedFileSystem fileSystem = this.cluster.getFileSystem();
        fileSystem.create(filePath);
        fileSystem.setStoragePolicy(filePath, "COLD");
        try {
            fileSystem.satisfyStoragePolicy(filePath);
            Assertions.fail((String)"Expected to fail, as storage policy feature has disabled.");
        }
        catch (RemoteException e) {
            GenericTestUtils.assertExceptionContains((String)"Cannot request to satisfy storage policy when storage policy satisfier feature has been disabled by admin. Seek for an admin help to enable it or use Mover tool.", (Throwable)e);
        }
    }

    void verifySPSEnabled(NameNode nameNode, String property, HdfsConstants.StoragePolicySatisfierMode expected, boolean isSatisfierRunning) {
        StoragePolicySatisfyManager spsMgr = nameNode.getNamesystem().getBlockManager().getSPSManager();
        boolean isSPSRunning = spsMgr != null ? spsMgr.isSatisfierRunning() : false;
        Assertions.assertEquals((Object)isSatisfierRunning, (Object)isSPSRunning, (String)(property + " has wrong value"));
        String actual = nameNode.getConf().get(property, DFSConfigKeys.DFS_STORAGE_POLICY_SATISFIER_MODE_DEFAULT);
        Assertions.assertEquals((Object)expected, (Object)HdfsConstants.StoragePolicySatisfierMode.fromString((String)actual), (String)(property + " has wrong value"));
    }

    @Test
    public void testBlockInvalidateLimitAfterReconfigured() throws ReconfigurationException {
        NameNode nameNode = this.cluster.getNameNode();
        DatanodeManager datanodeManager = nameNode.namesystem.getBlockManager().getDatanodeManager();
        Assertions.assertEquals((int)500, (int)datanodeManager.getBlockInvalidateLimit(), (String)"dfs.block.invalidate.limit is not correctly set");
        nameNode.reconfigureProperty("dfs.heartbeat.interval", Integer.toString(6));
        Assertions.assertEquals((int)500, (int)datanodeManager.getBlockInvalidateLimit(), (String)"dfs.block.invalidate.limit is not honored after reconfiguration");
        nameNode.reconfigureProperty("dfs.heartbeat.interval", Integer.toString(50));
        Assertions.assertEquals((int)1000, (int)datanodeManager.getBlockInvalidateLimit(), (String)"dfs.block.invalidate.limit is not reconfigured correctly");
    }

    @Test
    public void testEnableParallelLoadAfterReconfigured() throws ReconfigurationException {
        NameNode nameNode = this.cluster.getNameNode();
        Assertions.assertEquals((Object)false, (Object)FSImageFormatProtobuf.getEnableParallelLoad());
        nameNode.reconfigureProperty("dfs.image.parallel.load", Boolean.toString(true));
        Assertions.assertEquals((Object)true, (Object)FSImageFormatProtobuf.getEnableParallelLoad());
    }

    @Test
    public void testEnableSlowNodesParametersAfterReconfigured() throws ReconfigurationException {
        NameNode nameNode = this.cluster.getNameNode();
        BlockManager blockManager = nameNode.namesystem.getBlockManager();
        DatanodeManager datanodeManager = blockManager.getDatanodeManager();
        Assertions.assertEquals((Object)false, (Object)datanodeManager.getEnableAvoidSlowDataNodesForRead());
        nameNode.reconfigureProperty("dfs.namenode.avoid.read.slow.datanode", Boolean.toString(true));
        Assertions.assertEquals((Object)true, (Object)datanodeManager.getEnableAvoidSlowDataNodesForRead());
        Assertions.assertEquals((Object)false, (Object)blockManager.getExcludeSlowNodesEnabled(BlockType.CONTIGUOUS));
        Assertions.assertEquals((Object)false, (Object)blockManager.getExcludeSlowNodesEnabled(BlockType.STRIPED));
        nameNode.reconfigureProperty("dfs.namenode.block-placement-policy.exclude-slow-nodes.enabled", Boolean.toString(true));
        Assertions.assertEquals((Object)true, (Object)blockManager.getExcludeSlowNodesEnabled(BlockType.CONTIGUOUS));
        Assertions.assertEquals((Object)true, (Object)blockManager.getExcludeSlowNodesEnabled(BlockType.STRIPED));
    }

    @Test
    public void testReconfigureMaxSlowpeerCollectNodes() throws ReconfigurationException {
        NameNode nameNode = this.cluster.getNameNode();
        DatanodeManager datanodeManager = nameNode.namesystem.getBlockManager().getDatanodeManager();
        Assertions.assertEquals((int)5, (int)datanodeManager.getMaxSlowpeerCollectNodes());
        nameNode.reconfigureProperty("dfs.namenode.max.slowpeer.collect.nodes", Integer.toString(10));
        Assertions.assertEquals((int)10, (int)datanodeManager.getMaxSlowpeerCollectNodes());
    }

    @Test
    public void testBlockInvalidateLimit() throws ReconfigurationException {
        NameNode nameNode = this.cluster.getNameNode();
        DatanodeManager datanodeManager = nameNode.namesystem.getBlockManager().getDatanodeManager();
        Assertions.assertEquals((int)500, (int)datanodeManager.getBlockInvalidateLimit(), (String)"dfs.block.invalidate.limit is not correctly set");
        try {
            nameNode.reconfigureProperty("dfs.block.invalidate.limit", "non-numeric");
            Assertions.fail((String)"Should not reach here");
        }
        catch (ReconfigurationException e) {
            Assertions.assertEquals((Object)"Could not change property dfs.block.invalidate.limit from '500' to 'non-numeric'", (Object)e.getMessage());
        }
        nameNode.reconfigureProperty("dfs.block.invalidate.limit", "2500");
        Assertions.assertEquals((int)2500, (int)datanodeManager.getBlockInvalidateLimit(), (String)"dfs.block.invalidate.limit is not honored after reconfiguration");
        nameNode.reconfigureProperty("dfs.heartbeat.interval", "500");
        Assertions.assertEquals((int)10000, (int)datanodeManager.getBlockInvalidateLimit(), (String)"dfs.block.invalidate.limit is not reconfigured correctly");
    }

    @Test
    public void testSlowPeerTrackerEnabled() throws Exception {
        NameNode nameNode = this.cluster.getNameNode();
        DatanodeManager datanodeManager = nameNode.namesystem.getBlockManager().getDatanodeManager();
        Assertions.assertFalse((boolean)datanodeManager.getSlowPeerTracker().isSlowPeerTrackerEnabled(), (String)"SlowNode tracker is already enabled. It should be disabled by default");
        Assertions.assertTrue((boolean)datanodeManager.isSlowPeerCollectorInitialized());
        try {
            nameNode.reconfigurePropertyImpl("dfs.datanode.peer.stats.enabled", "non-boolean");
            Assertions.fail((String)"should not reach here");
        }
        catch (ReconfigurationException e) {
            Assertions.assertEquals((Object)"Could not change property dfs.datanode.peer.stats.enabled from 'false' to 'non-boolean'", (Object)e.getMessage());
        }
        nameNode.reconfigurePropertyImpl("dfs.datanode.peer.stats.enabled", "True");
        Assertions.assertTrue((boolean)datanodeManager.getSlowPeerTracker().isSlowPeerTrackerEnabled(), (String)"SlowNode tracker is still disabled. Reconfiguration could not be successful");
        Assertions.assertFalse((boolean)datanodeManager.isSlowPeerCollectorInitialized());
        nameNode.reconfigurePropertyImpl("dfs.datanode.peer.stats.enabled", null);
        Assertions.assertFalse((boolean)datanodeManager.getSlowPeerTracker().isSlowPeerTrackerEnabled(), (String)"SlowNode tracker is still enabled. Reconfiguration could not be successful");
    }

    @Test
    public void testSlowPeerMaxNodesToReportReconf() throws Exception {
        NameNode nameNode = this.cluster.getNameNode();
        DatanodeManager datanodeManager = nameNode.namesystem.getBlockManager().getDatanodeManager();
        nameNode.reconfigurePropertyImpl("dfs.datanode.peer.stats.enabled", "true");
        Assertions.assertTrue((boolean)datanodeManager.getSlowPeerTracker().isSlowPeerTrackerEnabled(), (String)"SlowNode tracker is still disabled. Reconfiguration could not be successful");
        SlowPeerTracker tracker = datanodeManager.getSlowPeerTracker();
        OutlierMetrics outlierMetrics1 = new OutlierMetrics(Double.valueOf(0.0), Double.valueOf(0.0), Double.valueOf(0.0), Double.valueOf(1.1));
        tracker.addReport("node1", "node70", outlierMetrics1);
        OutlierMetrics outlierMetrics2 = new OutlierMetrics(Double.valueOf(0.0), Double.valueOf(0.0), Double.valueOf(0.0), Double.valueOf(1.23));
        tracker.addReport("node2", "node71", outlierMetrics2);
        OutlierMetrics outlierMetrics3 = new OutlierMetrics(Double.valueOf(0.0), Double.valueOf(0.0), Double.valueOf(0.0), Double.valueOf(2.13));
        tracker.addReport("node3", "node72", outlierMetrics3);
        OutlierMetrics outlierMetrics4 = new OutlierMetrics(Double.valueOf(0.0), Double.valueOf(0.0), Double.valueOf(0.0), Double.valueOf(1.244));
        tracker.addReport("node4", "node73", outlierMetrics4);
        OutlierMetrics outlierMetrics5 = new OutlierMetrics(Double.valueOf(0.0), Double.valueOf(0.0), Double.valueOf(0.0), Double.valueOf(0.2));
        tracker.addReport("node5", "node74", outlierMetrics4);
        OutlierMetrics outlierMetrics6 = new OutlierMetrics(Double.valueOf(0.0), Double.valueOf(0.0), Double.valueOf(0.0), Double.valueOf(1.244));
        tracker.addReport("node6", "node75", outlierMetrics4);
        String jsonReport = tracker.getJson();
        LOG.info("Retrieved slow peer json report: {}", (Object)jsonReport);
        List<Boolean> containReport = this.validatePeerReport(jsonReport);
        Assertions.assertEquals((long)1L, (long)containReport.stream().filter(reportVal -> reportVal == false).count());
        nameNode.reconfigurePropertyImpl("dfs.datanode.max.nodes.to.report", "2");
        jsonReport = tracker.getJson();
        LOG.info("Retrieved slow peer json report: {}", (Object)jsonReport);
        containReport = this.validatePeerReport(jsonReport);
        Assertions.assertEquals((long)4L, (long)containReport.stream().filter(reportVal -> reportVal == false).count());
    }

    private List<Boolean> validatePeerReport(String jsonReport) {
        ArrayList<Boolean> containReport = new ArrayList<Boolean>();
        containReport.add(jsonReport.contains("node1"));
        containReport.add(jsonReport.contains("node2"));
        containReport.add(jsonReport.contains("node3"));
        containReport.add(jsonReport.contains("node4"));
        containReport.add(jsonReport.contains("node5"));
        containReport.add(jsonReport.contains("node6"));
        return containReport;
    }

    @Test
    public void testReconfigureDecommissionBackoffMonitorParameters() throws ReconfigurationException, IOException {
        HdfsConfiguration conf = new HdfsConfiguration();
        conf.setClass("dfs.namenode.decommission.monitor.class", DatanodeAdminBackoffMonitor.class, DatanodeAdminMonitorInterface.class);
        int defaultPendingRepLimit = 1000;
        conf.setInt("dfs.namenode.decommission.backoff.monitor.pending.limit", defaultPendingRepLimit);
        int defaultBlocksPerLock = 1000;
        conf.setInt("dfs.namenode.decommission.backoff.monitor.pending.blocks.per.lock", defaultBlocksPerLock);
        try (MiniDFSCluster newCluster = new MiniDFSCluster.Builder((Configuration)conf).build();){
            newCluster.waitActive();
            NameNode nameNode = newCluster.getNameNode();
            DatanodeManager datanodeManager = nameNode.namesystem.getBlockManager().getDatanodeManager();
            Assertions.assertEquals((int)datanodeManager.getDatanodeAdminManager().getPendingRepLimit(), (int)defaultPendingRepLimit);
            try {
                nameNode.reconfigureProperty("dfs.namenode.decommission.backoff.monitor.pending.limit", "non-numeric");
                Assertions.fail((String)"Should not reach here");
            }
            catch (ReconfigurationException e) {
                Assertions.assertEquals((Object)("Could not change property dfs.namenode.decommission.backoff.monitor.pending.limit from '" + defaultPendingRepLimit + "' to 'non-numeric'"), (Object)e.getMessage());
            }
            try {
                nameNode.reconfigureProperty("dfs.namenode.decommission.backoff.monitor.pending.limit", "-1");
                Assertions.fail((String)"Should not reach here");
            }
            catch (ReconfigurationException e) {
                Assertions.assertEquals((Object)("Could not change property dfs.namenode.decommission.backoff.monitor.pending.limit from '" + defaultPendingRepLimit + "' to '-1'"), (Object)e.getMessage());
            }
            nameNode.reconfigureProperty("dfs.namenode.decommission.backoff.monitor.pending.limit", "20000");
            Assertions.assertEquals((int)datanodeManager.getDatanodeAdminManager().getPendingRepLimit(), (int)20000);
            Assertions.assertEquals((int)datanodeManager.getDatanodeAdminManager().getBlocksPerLock(), (int)defaultBlocksPerLock);
            try {
                nameNode.reconfigureProperty("dfs.namenode.decommission.backoff.monitor.pending.blocks.per.lock", "non-numeric");
                Assertions.fail((String)"Should not reach here");
            }
            catch (ReconfigurationException e) {
                Assertions.assertEquals((Object)("Could not change property dfs.namenode.decommission.backoff.monitor.pending.blocks.per.lock from '" + defaultBlocksPerLock + "' to 'non-numeric'"), (Object)e.getMessage());
            }
            try {
                nameNode.reconfigureProperty("dfs.namenode.decommission.backoff.monitor.pending.blocks.per.lock", "-1");
                Assertions.fail((String)"Should not reach here");
            }
            catch (ReconfigurationException e) {
                Assertions.assertEquals((Object)("Could not change property dfs.namenode.decommission.backoff.monitor.pending.blocks.per.lock from '" + defaultBlocksPerLock + "' to '-1'"), (Object)e.getMessage());
            }
            nameNode.reconfigureProperty("dfs.namenode.decommission.backoff.monitor.pending.blocks.per.lock", "10000");
            Assertions.assertEquals((int)datanodeManager.getDatanodeAdminManager().getBlocksPerLock(), (int)10000);
        }
    }

    @Test
    public void testReconfigureMinBlocksForWrite() throws Exception {
        NameNode nameNode = this.cluster.getNameNode(0);
        BlockManager bm = nameNode.getNamesystem().getBlockManager();
        String key = "dfs.namenode.block-placement.min-blocks-for.write";
        int defaultVal = 1;
        ReconfigurationException reconfigurationException = (ReconfigurationException)LambdaTestUtils.intercept(ReconfigurationException.class, () -> nameNode.reconfigurePropertyImpl(key, "-20"));
        Assertions.assertTrue((boolean)(reconfigurationException.getCause() instanceof IllegalArgumentException));
        Assertions.assertEquals((Object)(key + " = '-20' is invalid. It should be a positive, non-zero integer value."), (Object)reconfigurationException.getCause().getMessage());
        Assertions.assertEquals((int)defaultVal, (int)bm.getMinBlocksForWrite(BlockType.CONTIGUOUS));
        Assertions.assertEquals((int)defaultVal, (int)bm.getMinBlocksForWrite(BlockType.STRIPED));
        reconfigurationException = (ReconfigurationException)LambdaTestUtils.intercept(ReconfigurationException.class, () -> nameNode.reconfigurePropertyImpl(key, "0"));
        Assertions.assertTrue((boolean)(reconfigurationException.getCause() instanceof IllegalArgumentException));
        Assertions.assertEquals((Object)(key + " = '0' is invalid. It should be a positive, non-zero integer value."), (Object)reconfigurationException.getCause().getMessage());
        Assertions.assertEquals((int)defaultVal, (int)bm.getMinBlocksForWrite(BlockType.CONTIGUOUS));
        Assertions.assertEquals((int)defaultVal, (int)bm.getMinBlocksForWrite(BlockType.STRIPED));
        reconfigurationException = (ReconfigurationException)LambdaTestUtils.intercept(ReconfigurationException.class, () -> nameNode.reconfigurePropertyImpl(key, "str"));
        Assertions.assertTrue((boolean)(reconfigurationException.getCause() instanceof NumberFormatException));
        Assertions.assertEquals((int)defaultVal, (int)bm.getMinBlocksForWrite(BlockType.CONTIGUOUS));
        Assertions.assertEquals((int)defaultVal, (int)bm.getMinBlocksForWrite(BlockType.STRIPED));
        nameNode.reconfigurePropertyImpl(key, "3");
        Assertions.assertEquals((int)3, (int)bm.getMinBlocksForWrite(BlockType.CONTIGUOUS));
        Assertions.assertEquals((int)3, (int)bm.getMinBlocksForWrite(BlockType.STRIPED));
    }

    @Test
    public void testReconfigureLogSlowRPC() throws ReconfigurationException {
        NameNode nameNode = this.cluster.getNameNode();
        NameNodeRpcServer nnrs = (NameNodeRpcServer)nameNode.getRpcServer();
        Assertions.assertFalse((boolean)nnrs.getClientRpcServer().isLogSlowRPC());
        Assertions.assertEquals((long)0L, (long)nnrs.getClientRpcServer().getLogSlowRPCThresholdTime());
        try {
            nameNode.reconfigurePropertyImpl("ipc.server.log.slow.rpc", "non-boolean");
            Assertions.fail((String)"should not reach here");
        }
        catch (ReconfigurationException e) {
            Assertions.assertEquals((Object)"Could not change property ipc.server.log.slow.rpc from 'false' to 'non-boolean'", (Object)e.getMessage());
        }
        nameNode.reconfigurePropertyImpl("ipc.server.log.slow.rpc", "True");
        Assertions.assertTrue((boolean)nnrs.getClientRpcServer().isLogSlowRPC());
        nameNode.reconfigurePropertyImpl("ipc.server.log.slow.rpc", null);
        Assertions.assertFalse((boolean)nnrs.getClientRpcServer().isLogSlowRPC());
        try {
            nameNode.reconfigureProperty("ipc.server.log.slow.rpc.threshold.ms", "non-numeric");
            Assertions.fail((String)"Should not reach here");
        }
        catch (ReconfigurationException e) {
            Assertions.assertEquals((Object)"Could not change property ipc.server.log.slow.rpc.threshold.ms from '0' to 'non-numeric'", (Object)e.getMessage());
        }
        nameNode.reconfigureProperty("ipc.server.log.slow.rpc.threshold.ms", "20000");
        Assertions.assertEquals((long)nnrs.getClientRpcServer().getLogSlowRPCThresholdTime(), (long)20000L);
    }

    @Test
    public void testReconfigureFSNamesystemLockMetricsParameters() throws ReconfigurationException, IOException {
        HdfsConfiguration conf = new HdfsConfiguration();
        conf.setBoolean("dfs.namenode.lock.detailed-metrics.enabled", false);
        long defaultReadLockMS = 1000L;
        conf.setLong("dfs.namenode.read-lock-reporting-threshold-ms", defaultReadLockMS);
        long defaultWriteLockMS = 1000L;
        conf.setLong("dfs.namenode.write-lock-reporting-threshold-ms", defaultWriteLockMS);
        try (MiniDFSCluster newCluster = new MiniDFSCluster.Builder((Configuration)conf).build();){
            newCluster.waitActive();
            NameNode nameNode = newCluster.getNameNode();
            FSNamesystem fsNamesystem = nameNode.getNamesystem();
            Assertions.assertFalse((boolean)fsNamesystem.isMetricsEnabled());
            Assertions.assertEquals((long)defaultReadLockMS, (long)fsNamesystem.getReadLockReportingThresholdMs());
            Assertions.assertEquals((long)defaultWriteLockMS, (long)fsNamesystem.getWriteLockReportingThresholdMs());
            try {
                nameNode.reconfigurePropertyImpl("dfs.namenode.lock.detailed-metrics.enabled", "non-boolean");
                Assertions.fail((String)"should not reach here");
            }
            catch (ReconfigurationException e) {
                Assertions.assertEquals((Object)"Could not change property dfs.namenode.lock.detailed-metrics.enabled from 'false' to 'non-boolean'", (Object)e.getMessage());
            }
            nameNode.reconfigurePropertyImpl("dfs.namenode.lock.detailed-metrics.enabled", "true");
            Assertions.assertTrue((boolean)fsNamesystem.isMetricsEnabled());
            nameNode.reconfigurePropertyImpl("dfs.namenode.lock.detailed-metrics.enabled", null);
            Assertions.assertFalse((boolean)fsNamesystem.isMetricsEnabled());
            try {
                nameNode.reconfigureProperty("dfs.namenode.read-lock-reporting-threshold-ms", "non-numeric");
                Assertions.fail((String)"Should not reach here");
            }
            catch (ReconfigurationException e) {
                Assertions.assertEquals((Object)("Could not change property dfs.namenode.read-lock-reporting-threshold-ms from '" + defaultReadLockMS + "' to 'non-numeric'"), (Object)e.getMessage());
            }
            nameNode.reconfigureProperty("dfs.namenode.read-lock-reporting-threshold-ms", "20000");
            Assertions.assertEquals((long)fsNamesystem.getReadLockReportingThresholdMs(), (long)20000L);
            try {
                nameNode.reconfigureProperty("dfs.namenode.write-lock-reporting-threshold-ms", "non-numeric");
                Assertions.fail((String)"Should not reach here");
            }
            catch (ReconfigurationException e) {
                Assertions.assertEquals((Object)("Could not change property dfs.namenode.write-lock-reporting-threshold-ms from '" + defaultWriteLockMS + "' to 'non-numeric'"), (Object)e.getMessage());
            }
            nameNode.reconfigureProperty("dfs.namenode.write-lock-reporting-threshold-ms", "100000");
            Assertions.assertEquals((long)fsNamesystem.getWriteLockReportingThresholdMs(), (long)100000L);
        }
    }

    @Test
    public void testReconfigureSlowPeerCollectInterval() throws Exception {
        NameNode nameNode = this.cluster.getNameNode();
        DatanodeManager datanodeManager = nameNode.namesystem.getBlockManager().getDatanodeManager();
        Assertions.assertFalse((boolean)datanodeManager.getSlowPeerTracker().isSlowPeerTrackerEnabled(), (String)"SlowNode tracker is already enabled. It should be disabled by default");
        Assertions.assertTrue((boolean)datanodeManager.isSlowPeerCollectorInitialized());
        try {
            nameNode.reconfigureProperty("dfs.namenode.slowpeer.collect.interval", "10m");
        }
        catch (NullPointerException e) {
            Assertions.assertEquals((Object)"slowPeerCollectorDaemon thread is null, not support restart", (Object)e.getMessage());
        }
        nameNode.reconfigureProperty("dfs.datanode.peer.stats.enabled", "True");
        Assertions.assertTrue((boolean)datanodeManager.getSlowPeerTracker().isSlowPeerTrackerEnabled(), (String)"SlowNode tracker is still disabled. Reconfiguration could not be successful");
        Assertions.assertFalse((boolean)datanodeManager.isSlowPeerCollectorInitialized());
        Assertions.assertEquals((long)1800000L, (long)datanodeManager.getSlowPeerCollectionInterval());
        try {
            nameNode.reconfigureProperty("dfs.namenode.slowpeer.collect.interval", "non-numeric");
        }
        catch (ReconfigurationException e) {
            Assertions.assertEquals((Object)"Could not change property dfs.namenode.slowpeer.collect.interval from '30m' to 'non-numeric'", (Object)e.getMessage());
        }
        nameNode.reconfigureProperty("dfs.namenode.slowpeer.collect.interval", "10m");
        Assertions.assertFalse((boolean)datanodeManager.isSlowPeerCollectorInitialized());
        Assertions.assertEquals((long)600000L, (long)datanodeManager.getSlowPeerCollectionInterval());
        nameNode.reconfigureProperty("dfs.namenode.slowpeer.collect.interval", null);
        Assertions.assertFalse((boolean)datanodeManager.isSlowPeerCollectorInitialized());
        Assertions.assertEquals((long)600000L, (long)datanodeManager.getSlowPeerCollectionInterval());
    }

    @AfterEach
    public void shutDown() throws IOException {
        if (this.cluster != null) {
            this.cluster.shutdown();
        }
    }
}

