/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.concurrent.TimeoutException;
import java.util.function.Supplier;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.server.namenode.FSNamesystem;
import org.apache.hadoop.hdfs.server.namenode.NameNode;
import org.apache.hadoop.hdfs.server.namenode.PatternMatchingAppender;
import org.apache.hadoop.metrics2.annotation.Metrics;
import org.apache.hadoop.metrics2.util.MBeans;
import org.apache.hadoop.test.GenericTestUtils;
import org.apache.log4j.AsyncAppender;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;
import org.mockito.Mockito;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Timeout(value=300L)
public class TestNameNodeMetricsLogger {
    static final Logger LOG = LoggerFactory.getLogger(TestNameNodeMetricsLogger.class);

    @Test
    public void testMetricsLoggerOnByDefault() throws IOException {
        NameNode nn = this.makeNameNode(true);
        Assertions.assertNotNull((Object)nn.metricsLoggerTimer);
    }

    @Test
    public void testDisableMetricsLogger() throws IOException {
        NameNode nn = this.makeNameNode(false);
        Assertions.assertNull((Object)nn.metricsLoggerTimer);
    }

    @Test
    public void testMetricsLoggerIsAsync() throws IOException {
        this.makeNameNode(true);
        org.apache.log4j.Logger logger = org.apache.log4j.Logger.getLogger((String)"NameNodeMetricsLog");
        ArrayList appenders = Collections.list(logger.getAllAppenders());
        Assertions.assertTrue((boolean)(appenders.get(0) instanceof AsyncAppender));
    }

    @Test
    public void testMetricsLogOutput() throws IOException, InterruptedException, TimeoutException {
        TestFakeMetric metricsProvider = new TestFakeMetric();
        MBeans.register((String)this.getClass().getSimpleName(), (String)"DummyMetrics", (Object)metricsProvider);
        this.makeNameNode(true);
        final PatternMatchingAppender appender = (PatternMatchingAppender)org.apache.log4j.Logger.getLogger((String)"NameNodeMetricsLog").getAppender("PATTERNMATCHERAPPENDER");
        GenericTestUtils.waitFor((Supplier)new Supplier<Boolean>(){

            @Override
            public Boolean get() {
                return appender.isMatched();
            }
        }, (long)1000L, (long)60000L);
    }

    private NameNode makeNameNode(boolean enableMetricsLogging) throws IOException {
        HdfsConfiguration conf = new HdfsConfiguration();
        conf.set("fs.defaultFS", "hdfs://localhost:0");
        conf.set("dfs.namenode.http-address", "0.0.0.0:0");
        conf.setInt("dfs.namenode.metrics.logger.period.seconds", enableMetricsLogging ? 1 : 0);
        return new TestNameNode((Configuration)conf);
    }

    public static class TestFakeMetric
    implements TestFakeMetricMXBean {
        @Override
        public int getFakeMetric42() {
            return 0;
        }
    }

    public static interface TestFakeMetricMXBean {
        public int getFakeMetric42();
    }

    @Metrics(context="dfs")
    private static class TestNameNode
    extends NameNode {
        protected void loadNamesystem(Configuration conf) throws IOException {
            this.namesystem = (FSNamesystem)Mockito.mock(FSNamesystem.class);
        }

        public TestNameNode(Configuration conf) throws IOException {
            super(conf);
        }
    }
}

