/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode;

import java.io.IOException;
import java.util.function.Supplier;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.DFSTestUtil;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.protocol.ExtendedBlock;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockInfo;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockManagerTestUtil;
import org.apache.hadoop.hdfs.server.datanode.DataNodeTestUtils;
import org.apache.hadoop.hdfs.util.RwLockMode;
import org.apache.hadoop.test.GenericTestUtils;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class TestNameNodeMetadataConsistency {
    private static final Path filePath1 = new Path("/testdata1.txt");
    private static final Path filePath2 = new Path("/testdata2.txt");
    private static final String TEST_DATA_IN_FUTURE = "This is test data";
    private static final int SCAN_INTERVAL = 1;
    private static final int SCAN_WAIT = 3;
    MiniDFSCluster cluster;
    HdfsConfiguration conf;

    @BeforeEach
    public void InitTest() throws IOException {
        this.conf = new HdfsConfiguration();
        this.conf.setLong("dfs.datanode.directoryscan.interval", 1L);
        this.cluster = new MiniDFSCluster.Builder((Configuration)this.conf).numDataNodes(1).build();
    }

    @AfterEach
    public void cleanup() {
        if (this.cluster != null) {
            this.cluster.shutdown();
            this.cluster = null;
        }
    }

    @Test
    public void testGenerationStampInFuture() throws Exception {
        this.cluster.waitActive();
        DistributedFileSystem fs = this.cluster.getFileSystem();
        FSDataOutputStream ostream = fs.create(filePath1);
        ostream.write(TEST_DATA_IN_FUTURE.getBytes());
        ostream.close();
        ExtendedBlock block = DFSTestUtil.getFirstBlock((FileSystem)fs, filePath1);
        long genStamp = block.getGenerationStamp();
        boolean datanodeIndex = false;
        this.cluster.changeGenStampOfBlock(0, block, genStamp + 1L);
        DataNodeTestUtils.runDirectoryScanner(this.cluster.getDataNodes().get(0));
        MiniDFSCluster.DataNodeProperties dnProps = this.cluster.stopDataNode(0);
        this.cluster.restartNameNode(true);
        this.cluster.getNameNode().getNamesystem().writeLock(RwLockMode.BM);
        BlockInfo bInfo = this.cluster.getNameNode().getNamesystem().getBlockManager().getStoredBlock(block.getLocalBlock());
        bInfo.delete();
        this.cluster.getNameNode().getNamesystem().getBlockManager().removeBlock(bInfo);
        this.cluster.getNameNode().getNamesystem().writeUnlock(RwLockMode.BM, "testGenerationStampInFuture");
        BlockManagerTestUtil.setStartupSafeModeForTest(this.cluster.getNameNode().getNamesystem().getBlockManager());
        this.cluster.restartDataNode(dnProps);
        this.waitForNumBytes(TEST_DATA_IN_FUTURE.length());
        Assertions.assertEquals((long)TEST_DATA_IN_FUTURE.length(), (long)this.cluster.getNameNode().getBytesWithFutureGenerationStamps());
        Assertions.assertTrue((boolean)this.cluster.getNameNode().getNamesystem().getSafeModeTip().contains("Name node detected blocks with generation stamps in future"));
    }

    @Test
    public void testEnsureGenStampsIsStartupOnly() throws Exception {
        String testData = " This is test data";
        this.cluster.restartDataNodes();
        this.cluster.restartNameNodes();
        this.cluster.waitActive();
        DistributedFileSystem fs = this.cluster.getFileSystem();
        FSDataOutputStream ostream = fs.create(filePath2);
        ostream.write(testData.getBytes());
        ostream.close();
        ExtendedBlock block = DFSTestUtil.getFirstBlock((FileSystem)fs, filePath2);
        long genStamp = block.getGenerationStamp();
        this.cluster.changeGenStampOfBlock(0, block, genStamp + 1L);
        MiniDFSCluster.DataNodeProperties dnProps = this.cluster.stopDataNode(0);
        this.cluster.restartNameNode(true);
        BlockInfo bInfo = this.cluster.getNameNode().getNamesystem().getBlockManager().getStoredBlock(block.getLocalBlock());
        this.cluster.getNameNode().getNamesystem().writeLock(RwLockMode.BM);
        bInfo.delete();
        this.cluster.getNameNode().getNamesystem().getBlockManager().removeBlock(bInfo);
        this.cluster.getNameNode().getNamesystem().writeUnlock(RwLockMode.BM, "testEnsureGenStampsIsStartupOnly");
        this.cluster.restartDataNode(dnProps);
        this.waitForNumBytes(0);
        Assertions.assertEquals((long)0L, (long)this.cluster.getNameNode().getBytesWithFutureGenerationStamps());
    }

    private void waitForNumBytes(final int numBytes) throws Exception {
        GenericTestUtils.waitFor((Supplier)new Supplier<Boolean>(){

            @Override
            public Boolean get() {
                try {
                    TestNameNodeMetadataConsistency.this.cluster.triggerBlockReports();
                    if (TestNameNodeMetadataConsistency.this.cluster.getNameNode().getBytesWithFutureGenerationStamps() == (long)numBytes) {
                        return true;
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                return false;
            }
        }, (long)3000L, (long)60000L);
    }
}

