/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode;

import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Set;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FileUtil;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.DFSTestUtil;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.server.namenode.FSEditLog;
import org.apache.hadoop.hdfs.server.namenode.FSImageTestUtil;
import org.apache.hadoop.hdfs.server.namenode.FSImageTransactionalStorageInspector;
import org.apache.hadoop.hdfs.server.namenode.FileJournalManager;
import org.apache.hadoop.hdfs.server.namenode.NNStorage;
import org.apache.hadoop.hdfs.server.namenode.SecondaryNameNode;
import org.apache.hadoop.test.PathUtils;
import org.apache.hadoop.thirdparty.com.google.common.collect.ImmutableList;
import org.apache.hadoop.thirdparty.com.google.common.collect.ImmutableSet;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestNameEditsConfigs {
    private static final Logger LOG = LoggerFactory.getLogger(FSEditLog.class);
    static final long SEED = 3735928559L;
    static final int BLOCK_SIZE = 4096;
    static final int FILE_SIZE = 8192;
    static final int NUM_DATA_NODES = 3;
    static final String FILE_IMAGE = "current/fsimage";
    static final String FILE_EDITS = "current/edits";
    short replication = (short)3;
    private final File base_dir = new File(PathUtils.getTestDir(TestNameEditsConfigs.class), "dfs");

    @BeforeEach
    public void setUp() throws IOException {
        if (this.base_dir.exists() && !FileUtil.fullyDelete((File)this.base_dir)) {
            throw new IOException("Cannot remove directory " + this.base_dir);
        }
    }

    void checkImageAndEditsFilesExistence(File dir, boolean shouldHaveImages, boolean shouldHaveEdits) throws IOException {
        FSImageTransactionalStorageInspector ins = this.inspect(dir);
        if (shouldHaveImages) {
            Assertions.assertTrue((ins.foundImages.size() > 0 ? 1 : 0) != 0, (String)("Expect images in " + dir));
        } else {
            Assertions.assertTrue((boolean)ins.foundImages.isEmpty(), (String)("Expect no images in " + dir));
        }
        List editlogs = FileJournalManager.matchEditLogs((File[])new File(dir, "current").listFiles());
        if (shouldHaveEdits) {
            Assertions.assertTrue((editlogs.size() > 0 ? 1 : 0) != 0, (String)("Expect edits in " + dir));
        } else {
            Assertions.assertTrue((boolean)editlogs.isEmpty(), (String)("Expect no edits in " + dir));
        }
    }

    private void checkFile(FileSystem fileSys, Path name, int repl) throws IOException {
        Assertions.assertTrue((boolean)fileSys.exists(name));
        short replication = fileSys.getFileStatus(name).getReplication();
        Assertions.assertEquals((int)repl, (int)replication, (String)("replication for " + name));
        long size = fileSys.getContentSummary(name).getLength();
        Assertions.assertEquals((long)size, (long)8192L, (String)("file size for " + name));
    }

    private void cleanupFile(FileSystem fileSys, Path name) throws IOException {
        Assertions.assertTrue((boolean)fileSys.exists(name));
        fileSys.delete(name, true);
        Assertions.assertTrue((!fileSys.exists(name) ? 1 : 0) != 0);
    }

    SecondaryNameNode startSecondaryNameNode(Configuration conf) throws IOException {
        conf.set("dfs.namenode.secondary.http-address", "0.0.0.0:0");
        return new SecondaryNameNode(conf);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testNameEditsConfigs() throws Exception {
        Path file1 = new Path("TestNameEditsConfigs1");
        Path file2 = new Path("TestNameEditsConfigs2");
        Path file3 = new Path("TestNameEditsConfigs3");
        MiniDFSCluster cluster = null;
        SecondaryNameNode secondary = null;
        HdfsConfiguration conf = null;
        DistributedFileSystem fileSys = null;
        File newNameDir = new File(this.base_dir, "name");
        File newEditsDir = new File(this.base_dir, "edits");
        File nameAndEdits = new File(this.base_dir, "name_and_edits");
        File checkpointNameDir = new File(this.base_dir, "secondname");
        File checkpointEditsDir = new File(this.base_dir, "secondedits");
        File checkpointNameAndEdits = new File(this.base_dir, "second_name_and_edits");
        ImmutableList allCurrentDirs = ImmutableList.of((Object)new File(nameAndEdits, "current"), (Object)new File(newNameDir, "current"), (Object)new File(newEditsDir, "current"), (Object)new File(checkpointNameAndEdits, "current"), (Object)new File(checkpointNameDir, "current"), (Object)new File(checkpointEditsDir, "current"));
        ImmutableList imageCurrentDirs = ImmutableList.of((Object)new File(nameAndEdits, "current"), (Object)new File(newNameDir, "current"), (Object)new File(checkpointNameAndEdits, "current"), (Object)new File(checkpointNameDir, "current"));
        conf = new HdfsConfiguration();
        conf.set("dfs.namenode.name.dir", nameAndEdits.getPath());
        conf.set("dfs.namenode.edits.dir", nameAndEdits.getPath());
        conf.set("dfs.namenode.checkpoint.dir", checkpointNameAndEdits.getPath());
        conf.set("dfs.namenode.checkpoint.edits.dir", checkpointNameAndEdits.getPath());
        this.replication = (short)conf.getInt("dfs.replication", 3);
        cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(3).manageNameDfsDirs(false).build();
        cluster.waitActive();
        secondary = this.startSecondaryNameNode((Configuration)conf);
        fileSys = cluster.getFileSystem();
        try {
            Assertions.assertTrue((!fileSys.exists(file1) ? 1 : 0) != 0);
            DFSTestUtil.createFile((FileSystem)fileSys, file1, 8192, 8192L, 4096L, this.replication, 3735928559L);
            this.checkFile((FileSystem)fileSys, file1, this.replication);
            secondary.doCheckpoint();
        }
        finally {
            fileSys.close();
            cluster.shutdown();
            secondary.shutdown();
        }
        conf = new HdfsConfiguration();
        Assertions.assertTrue((boolean)newNameDir.mkdir());
        Assertions.assertTrue((boolean)newEditsDir.mkdir());
        conf.set("dfs.namenode.name.dir", nameAndEdits.getPath() + "," + newNameDir.getPath());
        conf.set("dfs.namenode.edits.dir", nameAndEdits.getPath() + "," + newEditsDir.getPath());
        conf.set("dfs.namenode.checkpoint.dir", checkpointNameDir.getPath() + "," + checkpointNameAndEdits.getPath());
        conf.set("dfs.namenode.checkpoint.edits.dir", checkpointEditsDir.getPath() + "," + checkpointNameAndEdits.getPath());
        this.replication = (short)conf.getInt("dfs.replication", 3);
        cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(3).format(false).manageNameDfsDirs(false).build();
        cluster.waitActive();
        secondary = this.startSecondaryNameNode((Configuration)conf);
        fileSys = cluster.getFileSystem();
        try {
            Assertions.assertTrue((boolean)fileSys.exists(file1));
            this.checkFile((FileSystem)fileSys, file1, this.replication);
            this.cleanupFile((FileSystem)fileSys, file1);
            DFSTestUtil.createFile((FileSystem)fileSys, file2, 8192, 8192L, 4096L, this.replication, 3735928559L);
            this.checkFile((FileSystem)fileSys, file2, this.replication);
            secondary.doCheckpoint();
        }
        finally {
            fileSys.close();
            cluster.shutdown();
            secondary.shutdown();
        }
        FSImageTestUtil.assertParallelFilesAreIdentical((List<File>)allCurrentDirs, (Set<String>)ImmutableSet.of((Object)"VERSION"));
        FSImageTestUtil.assertSameNewestImage((List<File>)imageCurrentDirs);
        conf = new HdfsConfiguration();
        conf.set("dfs.namenode.name.dir", newNameDir.getPath());
        conf.set("dfs.namenode.edits.dir", newEditsDir.getPath());
        conf.set("dfs.namenode.checkpoint.dir", checkpointNameDir.getPath());
        conf.set("dfs.namenode.checkpoint.edits.dir", checkpointEditsDir.getPath());
        this.replication = (short)conf.getInt("dfs.replication", 3);
        cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(3).format(false).manageNameDfsDirs(false).build();
        cluster.waitActive();
        secondary = this.startSecondaryNameNode((Configuration)conf);
        fileSys = cluster.getFileSystem();
        try {
            Assertions.assertTrue((!fileSys.exists(file1) ? 1 : 0) != 0);
            Assertions.assertTrue((boolean)fileSys.exists(file2));
            this.checkFile((FileSystem)fileSys, file2, this.replication);
            this.cleanupFile((FileSystem)fileSys, file2);
            DFSTestUtil.createFile((FileSystem)fileSys, file3, 8192, 8192L, 4096L, this.replication, 3735928559L);
            this.checkFile((FileSystem)fileSys, file3, this.replication);
            secondary.doCheckpoint();
        }
        finally {
            fileSys.close();
            cluster.shutdown();
            secondary.shutdown();
        }
        this.checkImageAndEditsFilesExistence(newNameDir, true, false);
        this.checkImageAndEditsFilesExistence(newEditsDir, false, true);
        this.checkImageAndEditsFilesExistence(checkpointNameDir, true, false);
        this.checkImageAndEditsFilesExistence(checkpointEditsDir, false, true);
        Assertions.assertTrue((boolean)FileUtil.fullyDelete((File)new File(nameAndEdits, "current")));
        Assertions.assertTrue((boolean)FileUtil.fullyDelete((File)new File(checkpointNameAndEdits, "current")));
        conf = new HdfsConfiguration();
        conf.set("dfs.namenode.name.dir", nameAndEdits.getPath() + "," + newNameDir.getPath());
        conf.set("dfs.namenode.edits.dir", nameAndEdits + "," + newEditsDir.getPath());
        conf.set("dfs.namenode.checkpoint.dir", checkpointNameDir.getPath() + "," + checkpointNameAndEdits.getPath());
        conf.set("dfs.namenode.checkpoint.edits.dir", checkpointEditsDir.getPath() + "," + checkpointNameAndEdits.getPath());
        this.replication = (short)conf.getInt("dfs.replication", 3);
        cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(3).format(false).manageNameDfsDirs(false).build();
        cluster.waitActive();
        secondary = this.startSecondaryNameNode((Configuration)conf);
        fileSys = cluster.getFileSystem();
        try {
            Assertions.assertTrue((!fileSys.exists(file1) ? 1 : 0) != 0);
            Assertions.assertTrue((!fileSys.exists(file2) ? 1 : 0) != 0);
            Assertions.assertTrue((boolean)fileSys.exists(file3));
            this.checkFile((FileSystem)fileSys, file3, this.replication);
            secondary.doCheckpoint();
        }
        finally {
            fileSys.close();
            cluster.shutdown();
            secondary.shutdown();
        }
        this.checkImageAndEditsFilesExistence(nameAndEdits, true, true);
        this.checkImageAndEditsFilesExistence(checkpointNameAndEdits, true, true);
    }

    private FSImageTransactionalStorageInspector inspect(File storageDir) throws IOException {
        return FSImageTestUtil.inspectStorageDirectory(new File(storageDir, "current"), NNStorage.NameNodeDirType.IMAGE_AND_EDITS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testNameEditsRequiredConfigs() throws IOException {
        HdfsConfiguration conf;
        MiniDFSCluster cluster = null;
        File nameAndEditsDir = new File(this.base_dir, "name_and_edits");
        File nameAndEditsDir2 = new File(this.base_dir, "name_and_edits2");
        File nameDir = new File(this.base_dir, "name");
        try {
            conf = new HdfsConfiguration();
            conf.set("dfs.namenode.name.dir", nameDir.getAbsolutePath());
            conf.set("dfs.namenode.edits.dir.required", nameAndEditsDir2.toURI().toString());
            conf.set("dfs.namenode.edits.dir", nameAndEditsDir.toURI().toString());
            cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(3).manageNameDfsDirs(false).build();
            Assertions.fail((String)"Successfully started cluster but should not have been able to.");
        }
        catch (IllegalArgumentException iae) {
            LOG.info("EXPECTED: cluster start failed due to bad configuration" + iae);
        }
        finally {
            if (cluster != null) {
                cluster.shutdown();
            }
            cluster = null;
        }
        try {
            conf = new HdfsConfiguration();
            conf.set("dfs.namenode.name.dir", nameDir.getAbsolutePath());
            conf.setStrings("dfs.namenode.edits.dir", new String[]{nameAndEditsDir.toURI().toString(), nameAndEditsDir2.toURI().toString()});
            conf.set("dfs.namenode.edits.dir.required", nameAndEditsDir2.toURI().toString());
            cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(3).manageNameDfsDirs(false).build();
        }
        finally {
            if (cluster != null) {
                cluster.shutdown();
            }
        }
        try {
            conf = new HdfsConfiguration();
            conf.set("dfs.namenode.name.dir", nameDir.getAbsolutePath());
            conf.setStrings("dfs.namenode.edits.dir", new String[]{nameAndEditsDir.toURI().toString(), nameAndEditsDir2.toURI().toString()});
            cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(3).manageNameDfsDirs(false).build();
        }
        finally {
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testNameEditsConfigsFailure() throws IOException {
        Path file1 = new Path("TestNameEditsConfigs1");
        Path file2 = new Path("TestNameEditsConfigs2");
        Path file3 = new Path("TestNameEditsConfigs3");
        MiniDFSCluster cluster = null;
        HdfsConfiguration conf = null;
        DistributedFileSystem fileSys = null;
        File nameOnlyDir = new File(this.base_dir, "name");
        File editsOnlyDir = new File(this.base_dir, "edits");
        File nameAndEditsDir = new File(this.base_dir, "name_and_edits");
        conf = new HdfsConfiguration();
        conf.set("dfs.namenode.name.dir", nameAndEditsDir.getPath());
        conf.set("dfs.namenode.edits.dir", nameAndEditsDir.getPath());
        this.replication = (short)conf.getInt("dfs.replication", 3);
        try {
            cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(3).manageNameDfsDirs(false).build();
            cluster.waitActive();
            Assertions.assertTrue((boolean)new File(nameAndEditsDir, "current/VERSION").exists());
            fileSys = cluster.getFileSystem();
            Assertions.assertTrue((!fileSys.exists(file1) ? 1 : 0) != 0);
            DFSTestUtil.createFile((FileSystem)fileSys, file1, 8192, 8192L, 4096L, this.replication, 3735928559L);
            this.checkFile((FileSystem)fileSys, file1, this.replication);
        }
        finally {
            if (fileSys != null) {
                fileSys.close();
            }
            if (cluster != null) {
                cluster.shutdown();
            }
        }
        conf = new HdfsConfiguration();
        Assertions.assertTrue((boolean)nameOnlyDir.mkdir());
        Assertions.assertTrue((boolean)editsOnlyDir.mkdir());
        conf.set("dfs.namenode.name.dir", nameAndEditsDir.getPath() + "," + nameOnlyDir.getPath());
        conf.set("dfs.namenode.edits.dir", nameAndEditsDir.getPath() + "," + editsOnlyDir.getPath());
        this.replication = (short)conf.getInt("dfs.replication", 3);
        try {
            cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(3).format(false).manageNameDfsDirs(false).build();
            cluster.waitActive();
            Assertions.assertTrue((boolean)new File(nameAndEditsDir, "current/VERSION").exists());
            Assertions.assertTrue((boolean)new File(nameOnlyDir, "current/VERSION").exists());
            Assertions.assertTrue((boolean)new File(editsOnlyDir, "current/VERSION").exists());
            fileSys = cluster.getFileSystem();
            Assertions.assertTrue((boolean)fileSys.exists(file1));
            this.checkFile((FileSystem)fileSys, file1, this.replication);
            this.cleanupFile((FileSystem)fileSys, file1);
            DFSTestUtil.createFile((FileSystem)fileSys, file2, 8192, 8192L, 4096L, this.replication, 3735928559L);
            this.checkFile((FileSystem)fileSys, file2, this.replication);
        }
        finally {
            fileSys.close();
            cluster.shutdown();
        }
        try {
            conf = new HdfsConfiguration();
            conf.set("dfs.namenode.name.dir", nameOnlyDir.getPath());
            conf.set("dfs.namenode.edits.dir", editsOnlyDir.getPath());
            this.replication = (short)conf.getInt("dfs.replication", 3);
            cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(3).format(false).manageNameDfsDirs(false).build();
            cluster.waitActive();
            fileSys = cluster.getFileSystem();
            Assertions.assertFalse((boolean)fileSys.exists(file1));
            Assertions.assertTrue((boolean)fileSys.exists(file2));
            this.checkFile((FileSystem)fileSys, file2, this.replication);
            this.cleanupFile((FileSystem)fileSys, file2);
            DFSTestUtil.createFile((FileSystem)fileSys, file3, 8192, 8192L, 4096L, this.replication, 3735928559L);
            this.checkFile((FileSystem)fileSys, file3, this.replication);
        }
        finally {
            fileSys.close();
            cluster.shutdown();
        }
        conf = new HdfsConfiguration();
        conf.set("dfs.namenode.name.dir", nameOnlyDir.getPath() + "," + nameAndEditsDir.getPath());
        conf.set("dfs.namenode.edits.dir", nameAndEditsDir.getPath());
        this.replication = (short)conf.getInt("dfs.replication", 3);
        try {
            cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(3).format(false).manageNameDfsDirs(false).build();
            Assertions.fail((String)"Successfully started cluster but should not have been able to.");
        }
        catch (IOException e) {
            LOG.info("EXPECTED: cluster start failed due to missing latest edits dir", (Throwable)e);
        }
        finally {
            if (cluster != null) {
                cluster.shutdown();
            }
            cluster = null;
        }
        conf = new HdfsConfiguration();
        conf.set("dfs.namenode.name.dir", nameAndEditsDir.getPath());
        conf.set("dfs.namenode.edits.dir", editsOnlyDir.getPath() + "," + nameAndEditsDir.getPath());
        this.replication = (short)conf.getInt("dfs.replication", 3);
        try {
            cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(3).format(false).manageNameDfsDirs(false).build();
            fileSys = cluster.getFileSystem();
            Assertions.assertFalse((boolean)fileSys.exists(file1));
            Assertions.assertFalse((boolean)fileSys.exists(file2));
            Assertions.assertTrue((boolean)fileSys.exists(file3));
            this.checkFile((FileSystem)fileSys, file3, this.replication);
            this.cleanupFile((FileSystem)fileSys, file3);
            DFSTestUtil.createFile((FileSystem)fileSys, file3, 8192, 8192L, 4096L, this.replication, 3735928559L);
            this.checkFile((FileSystem)fileSys, file3, this.replication);
        }
        finally {
            fileSys.close();
            cluster.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCheckPointDirsAreTrimmed() throws Exception {
        MiniDFSCluster cluster = null;
        SecondaryNameNode secondary = null;
        File checkpointNameDir1 = new File(this.base_dir, "chkptName1");
        File checkpointEditsDir1 = new File(this.base_dir, "chkptEdits1");
        File checkpointNameDir2 = new File(this.base_dir, "chkptName2");
        File checkpointEditsDir2 = new File(this.base_dir, "chkptEdits2");
        File nameDir = new File(this.base_dir, "name1");
        String whiteSpace = "  \n   \n  ";
        HdfsConfiguration conf = new HdfsConfiguration();
        conf.set("dfs.namenode.name.dir", nameDir.getPath());
        conf.setStrings("dfs.namenode.checkpoint.dir", new String[]{whiteSpace + checkpointNameDir1.getPath() + whiteSpace, whiteSpace + checkpointNameDir2.getPath() + whiteSpace});
        conf.setStrings("dfs.namenode.checkpoint.edits.dir", new String[]{whiteSpace + checkpointEditsDir1.getPath() + whiteSpace, whiteSpace + checkpointEditsDir2.getPath() + whiteSpace});
        cluster = new MiniDFSCluster.Builder((Configuration)conf).manageNameDfsDirs(false).numDataNodes(3).build();
        try {
            cluster.waitActive();
            secondary = this.startSecondaryNameNode((Configuration)conf);
            secondary.doCheckpoint();
            Assertions.assertTrue((boolean)checkpointNameDir1.exists(), (String)"dfs.namenode.name.dir must be trimmed ");
            Assertions.assertTrue((boolean)checkpointNameDir2.exists(), (String)"dfs.namenode.name.dir must be trimmed ");
            Assertions.assertTrue((boolean)checkpointEditsDir1.exists(), (String)"dfs.namenode.checkpoint.edits.dir must be trimmed ");
            Assertions.assertTrue((boolean)checkpointEditsDir2.exists(), (String)"dfs.namenode.checkpoint.edits.dir must be trimmed ");
        }
        finally {
            secondary.shutdown();
            cluster.shutdown();
        }
    }
}

