/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode;

import org.apache.hadoop.hdfs.server.namenode.NameCache;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestNameCache {
    @Test
    public void testDictionary() throws Exception {
        NameCache cache = new NameCache(2);
        String[] matching = new String[]{"part1", "part10000000", "fileabc", "abc", "filepart"};
        String[] notMatching = new String[]{"spart1", "apart", "abcd", "def"};
        for (String s : matching) {
            cache.put((Object)s);
            Assertions.assertTrue((s == cache.put((Object)s) ? 1 : 0) != 0);
        }
        for (String s : notMatching) {
            cache.put((Object)s);
        }
        cache.initialized();
        for (String s : matching) {
            this.verifyNameReuse((NameCache<String>)cache, s, true);
        }
        Assertions.assertEquals((int)matching.length, (int)cache.size());
        for (String s : notMatching) {
            this.verifyNameReuse((NameCache<String>)cache, s, false);
        }
        cache.reset();
        cache.initialized();
        for (String s : matching) {
            this.verifyNameReuse((NameCache<String>)cache, s, false);
        }
        for (String s : notMatching) {
            this.verifyNameReuse((NameCache<String>)cache, s, false);
        }
    }

    private void verifyNameReuse(NameCache<String> cache, String s, boolean reused) {
        cache.put((Object)s);
        int lookupCount = cache.getLookupCount();
        if (reused) {
            Assertions.assertNotNull((Object)cache.put((Object)s));
            Assertions.assertEquals((int)(lookupCount + 1), (int)cache.getLookupCount());
        } else {
            Assertions.assertNull((Object)cache.put((Object)s));
            Assertions.assertEquals((int)lookupCount, (int)cache.getLookupCount());
        }
    }
}

