/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.hdfs.DFSTestUtil;
import org.apache.hadoop.hdfs.HAUtil;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.qjournal.MiniJournalCluster;
import org.apache.hadoop.hdfs.qjournal.MiniQJMHACluster;
import org.apache.hadoop.hdfs.qjournal.client.QuorumJournalManager;
import org.apache.hadoop.hdfs.qjournal.client.SpyQJournalUtil;
import org.apache.hadoop.hdfs.server.namenode.FSEditLog;
import org.apache.hadoop.hdfs.server.namenode.JournalManager;
import org.apache.hadoop.hdfs.server.namenode.JournalSet;
import org.apache.hadoop.hdfs.server.namenode.NameNode;
import org.apache.hadoop.hdfs.server.namenode.NameNodeAdapter;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;

public class TestHAWithInProgressTail {
    private MiniQJMHACluster qjmhaCluster;
    private MiniDFSCluster cluster;
    private MiniJournalCluster jnCluster;
    private NameNode nn0;
    private NameNode nn1;

    @BeforeEach
    public void startUp() throws IOException {
        Configuration conf = new Configuration();
        conf.setBoolean("dfs.ha.tail-edits.in-progress", true);
        conf.setInt("dfs.qjournal.select-input-streams.timeout.ms", 500);
        HAUtil.setAllowStandbyReads((Configuration)conf, (boolean)true);
        this.qjmhaCluster = new MiniQJMHACluster.Builder(conf).build();
        this.cluster = this.qjmhaCluster.getDfsCluster();
        this.jnCluster = this.qjmhaCluster.getJournalCluster();
        this.nn0 = this.cluster.getNameNode(0);
        this.nn1 = this.cluster.getNameNode(1);
    }

    @AfterEach
    public void tearDown() throws IOException {
        if (this.qjmhaCluster != null) {
            this.qjmhaCluster.shutdown();
        }
    }

    @Test
    public void testFailoverWithAbnormalJN() throws Exception {
        this.cluster.transitionToActive(0);
        this.cluster.waitActive(0);
        this.cluster.getNameNode(1).getNamesystem().getEditLogTailer().stop();
        String p = "/testFailoverWhileTailingWithoutCache/";
        this.nn0.getRpcServer().mkdirs(p + 0, FsPermission.getCachePoolDefault(), true);
        this.cluster.transitionToStandby(0);
        this.spyFSEditLog();
        this.cluster.transitionToActive(1);
        Assertions.assertNotNull((Object)NameNodeAdapter.getFileInfo(this.nn1, p + 0, true, false, false));
    }

    private void spyFSEditLog() throws IOException {
        FSEditLog spyEditLog = (FSEditLog)Mockito.spy((Object)this.nn1.getNamesystem().getFSImage().getEditLog());
        ((FSEditLog)Mockito.doAnswer(invocation -> {
            invocation.callRealMethod();
            this.spyOnJASjournal(spyEditLog.getJournalSet());
            return null;
        }).when((Object)spyEditLog)).recoverUnclosedStreams(ArgumentMatchers.anyBoolean());
        DFSTestUtil.setEditLogForTesting(this.nn1.getNamesystem(), spyEditLog);
        this.nn1.getNamesystem().getEditLogTailer().setEditLog(spyEditLog);
    }

    private void spyOnJASjournal(JournalSet journalSet) throws IOException {
        JournalSet.JournalAndStream jas = (JournalSet.JournalAndStream)journalSet.getAllJournalStreams().get(0);
        JournalManager oldManager = jas.getManager();
        oldManager.close();
        QuorumJournalManager manager = SpyQJournalUtil.createSpyingQJM(this.nn1.getConf(), this.jnCluster.getQuorumJournalURI("ns1"), this.nn1.getNamesystem().getNamespaceInfo(), "ns1");
        manager.recoverUnfinalizedSegments();
        jas.setJournalForTests((JournalManager)manager);
        SpyQJournalUtil.mockJNWithEmptyOrSlowResponse(manager, 1L);
    }
}

