/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode;

import java.lang.management.ManagementFactory;
import java.util.HashSet;
import java.util.Map;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanInfo;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.DFSTestUtil;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.server.namenode.FSEditLog;
import org.apache.hadoop.hdfs.server.namenode.FSNamesystem;
import org.apache.hadoop.hdfs.util.RwLockMode;
import org.apache.hadoop.metrics2.impl.ConfigBuilder;
import org.apache.hadoop.metrics2.impl.TestMetricsConfig;
import org.apache.hadoop.test.GenericTestUtils;
import org.eclipse.jetty.util.ajax.JSON;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;

public class TestFSNamesystemMBean {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void test() throws Exception {
        Configuration conf = new Configuration();
        MiniDFSCluster cluster = null;
        try {
            cluster = new MiniDFSCluster.Builder(conf).build();
            cluster.waitActive();
            FSNamesystem fsn = cluster.getNameNode().namesystem;
            MBeanServer mbs = ManagementFactory.getPlatformMBeanServer();
            ObjectName mxbeanName = new ObjectName("Hadoop:service=NameNode,name=FSNamesystemState");
            String snapshotStats = (String)mbs.getAttribute(mxbeanName, "SnapshotStats");
            Map stat = (Map)JSON.parse((String)snapshotStats);
            Assertions.assertTrue((stat.containsKey("SnapshottableDirectories") && (Long)stat.get("SnapshottableDirectories") == (long)fsn.getNumSnapshottableDirs() ? 1 : 0) != 0);
            Assertions.assertTrue((stat.containsKey("Snapshots") && (Long)stat.get("Snapshots") == (long)fsn.getNumSnapshots() ? 1 : 0) != 0);
            Object pendingDeletionBlocks = mbs.getAttribute(mxbeanName, "PendingDeletionBlocks");
            Assertions.assertNotNull((Object)pendingDeletionBlocks);
            Assertions.assertTrue((boolean)(pendingDeletionBlocks instanceof Long));
            Object encryptionZones = mbs.getAttribute(mxbeanName, "NumEncryptionZones");
            Assertions.assertNotNull((Object)encryptionZones);
            Assertions.assertTrue((boolean)(encryptionZones instanceof Integer));
        }
        finally {
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testWithFSNamesystemWriteLock() throws Exception {
        Configuration conf = new Configuration();
        MiniDFSCluster cluster = null;
        FSNamesystem fsn = null;
        int jmxCachePeriod = 1;
        new ConfigBuilder().add("namenode.period", (Object)jmxCachePeriod).save(TestMetricsConfig.getTestFilename((String)"hadoop-metrics2-namenode"));
        try {
            cluster = new MiniDFSCluster.Builder(conf).build();
            cluster.waitActive();
            fsn = cluster.getNameNode().namesystem;
            fsn.writeLock(RwLockMode.GLOBAL);
            Thread.sleep(jmxCachePeriod * 1000);
            MBeanClient client = new MBeanClient();
            client.start();
            client.join(20000L);
            Assertions.assertTrue((boolean)client.succeeded, (String)"JMX calls are blocked when FSNamesystem's writerlockis owned by another thread");
            client.interrupt();
        }
        finally {
            if (fsn != null && fsn.hasWriteLock(RwLockMode.GLOBAL)) {
                fsn.writeUnlock(RwLockMode.GLOBAL, "testWithFSNamesystemWriteLock");
            }
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testWithFSEditLogLock() throws Exception {
        Configuration conf = new Configuration();
        int jmxCachePeriod = 1;
        new ConfigBuilder().add("namenode.period", (Object)jmxCachePeriod).save(TestMetricsConfig.getTestFilename((String)"hadoop-metrics2-namenode"));
        MiniDFSCluster cluster = null;
        try {
            cluster = new MiniDFSCluster.Builder(conf).build();
            cluster.waitActive();
            FSEditLog fSEditLog = cluster.getNameNode().getFSImage().getEditLog();
            synchronized (fSEditLog) {
                Thread.sleep(jmxCachePeriod * 1000);
                MBeanClient client = new MBeanClient();
                client.start();
                client.join(20000L);
                Assertions.assertTrue((boolean)client.succeeded, (String)"JMX calls are blocked when FSEditLog is synchronized by another thread");
                client.interrupt();
            }
        }
        finally {
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @Timeout(value=120L)
    public void testFsEditLogMetrics() throws Exception {
        Configuration conf = new Configuration();
        MiniDFSCluster cluster = null;
        try {
            cluster = new MiniDFSCluster.Builder(conf).numDataNodes(0).build();
            cluster.waitActive();
            MBeanServer mbs = ManagementFactory.getPlatformMBeanServer();
            ObjectName mxbeanNameFs = new ObjectName("Hadoop:service=NameNode,name=FSNamesystemState");
            DistributedFileSystem fs = cluster.getFileSystem();
            int NUM_OPS = 10;
            for (int i = 0; i < 10; ++i) {
                Path path = new Path(String.format("/user%d", i));
                fs.mkdirs(path);
            }
            long syncCount = (Long)mbs.getAttribute(mxbeanNameFs, "TotalSyncCount");
            String syncTimes = (String)mbs.getAttribute(mxbeanNameFs, "TotalSyncTimes");
            Assertions.assertTrue((syncCount > 0L ? 1 : 0) != 0);
            Assertions.assertNotNull((Object)syncTimes);
        }
        finally {
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }

    @Test
    public void testReconstructionQueuesInitProgressMetrics() throws Exception {
        Configuration conf = new Configuration();
        try (MiniDFSCluster cluster = new MiniDFSCluster.Builder(conf).build();){
            cluster.waitActive();
            FSNamesystem fsNamesystem = cluster.getNamesystem();
            DistributedFileSystem fs = cluster.getFileSystem();
            Assertions.assertEquals((double)0.0, (double)fsNamesystem.getReconstructionQueuesInitProgress(), (double)0.0);
            MBeanServer mbs = ManagementFactory.getPlatformMBeanServer();
            ObjectName mxbeanName = new ObjectName("Hadoop:service=NameNode,name=FSNamesystemState");
            float reconstructionQueuesInitProgress = ((Float)mbs.getAttribute(mxbeanName, "ReconstructionQueuesInitProgress")).floatValue();
            Assertions.assertEquals((double)0.0, (double)reconstructionQueuesInitProgress, (double)0.0);
            Path file = new Path("/test");
            long fileLength = 0x300000L;
            DFSTestUtil.createFile((FileSystem)fs, file, fileLength, (short)1, 0L);
            DFSTestUtil.waitReplication((FileSystem)fs, file, (short)1);
            cluster.restartNameNode(true);
            GenericTestUtils.waitFor(() -> (double)cluster.getNamesystem().getReconstructionQueuesInitProgress() == 1.0, (long)100L, (long)5000L);
            reconstructionQueuesInitProgress = ((Float)mbs.getAttribute(mxbeanName, "ReconstructionQueuesInitProgress")).floatValue();
            Assertions.assertEquals((double)1.0, (double)reconstructionQueuesInitProgress, (double)0.0);
        }
    }

    private static class MBeanClient
    extends Thread {
        private boolean succeeded = false;

        private MBeanClient() {
        }

        @Override
        public void run() {
            try {
                MBeanServer mbs = ManagementFactory.getPlatformMBeanServer();
                ObjectName mxbeanNamefsn = new ObjectName("Hadoop:service=NameNode,name=FSNamesystem");
                ObjectName mxbeanNameFsns = new ObjectName("Hadoop:service=NameNode,name=FSNamesystemState");
                ObjectName mxbeanNameNni = new ObjectName("Hadoop:service=NameNode,name=NameNodeInfo");
                HashSet<ObjectName> mbeans = new HashSet<ObjectName>();
                mbeans.add(mxbeanNamefsn);
                mbeans.add(mxbeanNameFsns);
                mbeans.add(mxbeanNameNni);
                for (ObjectName mbean : mbeans) {
                    MBeanInfo attributes = mbs.getMBeanInfo(mbean);
                    for (MBeanAttributeInfo attributeInfo : attributes.getAttributes()) {
                        mbs.getAttribute(mbean, attributeInfo.getName());
                    }
                }
                this.succeeded = true;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

