/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode;

import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileUtil;
import org.apache.hadoop.ha.HAServiceProtocol;
import org.apache.hadoop.hdfs.DFSTestUtil;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockManager;
import org.apache.hadoop.hdfs.server.common.HdfsServerConstants;
import org.apache.hadoop.hdfs.server.namenode.AuditLogger;
import org.apache.hadoop.hdfs.server.namenode.FSEditLog;
import org.apache.hadoop.hdfs.server.namenode.FSImage;
import org.apache.hadoop.hdfs.server.namenode.FSNamesystem;
import org.apache.hadoop.hdfs.server.namenode.INodeDirectory;
import org.apache.hadoop.hdfs.server.namenode.LeaseManager;
import org.apache.hadoop.hdfs.server.namenode.NNStorage;
import org.apache.hadoop.hdfs.server.namenode.NameNode;
import org.apache.hadoop.hdfs.server.namenode.ha.HAContext;
import org.apache.hadoop.hdfs.server.namenode.ha.HAState;
import org.apache.hadoop.hdfs.server.namenode.top.TopAuditLogger;
import org.apache.hadoop.hdfs.server.protocol.NamespaceInfo;
import org.apache.hadoop.hdfs.util.RwLockMode;
import org.apache.hadoop.test.Whitebox;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;
import org.mockito.Mockito;

public class TestFSNamesystem {
    @AfterEach
    public void cleanUp() {
        FileUtil.fullyDeleteContents((File)new File(MiniDFSCluster.getBaseDirectory()));
    }

    @Test
    public void testUniqueEditDirs() throws IOException {
        Configuration config = new Configuration();
        config.set("dfs.namenode.edits.dir", "file://edits/dir, file://edits/dir1,file://edits/dir1");
        List editsDirs = FSNamesystem.getNamespaceEditsDirs((Configuration)config);
        org.junit.jupiter.api.Assertions.assertEquals((int)2, (int)editsDirs.size());
    }

    @Test
    public void testFSNamespaceClearLeases() throws Exception {
        HdfsConfiguration conf = new HdfsConfiguration();
        File nameDir = new File(MiniDFSCluster.getBaseDirectory(), "name");
        conf.set("dfs.namenode.name.dir", nameDir.getAbsolutePath());
        NameNode.initMetrics((Configuration)conf, (HdfsServerConstants.NamenodeRole)HdfsServerConstants.NamenodeRole.NAMENODE);
        DFSTestUtil.formatNameNode((Configuration)conf);
        FSNamesystem fsn = FSNamesystem.loadFromDisk((Configuration)conf);
        LeaseManager leaseMan = fsn.getLeaseManager();
        leaseMan.addLease("client1", fsn.getFSDirectory().allocateNewInodeId());
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)leaseMan.countLease());
        this.clearNamesystem(fsn);
        leaseMan = fsn.getLeaseManager();
        org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)leaseMan.countLease());
    }

    @Test
    public void testStartupSafemode() throws IOException {
        Configuration conf = new Configuration();
        FSImage fsImage = (FSImage)Mockito.mock(FSImage.class);
        FSEditLog fsEditLog = (FSEditLog)Mockito.mock(FSEditLog.class);
        Mockito.when((Object)fsImage.getEditLog()).thenReturn((Object)fsEditLog);
        FSNamesystem fsn = new FSNamesystem(conf, fsImage);
        fsn.leaveSafeMode(false);
        org.junit.jupiter.api.Assertions.assertTrue((!fsn.isInStartupSafeMode() ? 1 : 0) != 0, (String)"After leaving safemode FSNamesystem.isInStartupSafeMode still returned true");
        org.junit.jupiter.api.Assertions.assertTrue((!fsn.isInSafeMode() ? 1 : 0) != 0, (String)"After leaving safemode FSNamesystem.isInSafeMode still returned true");
        fsn.enterSafeMode(true);
        org.junit.jupiter.api.Assertions.assertTrue((!fsn.isInStartupSafeMode() ? 1 : 0) != 0, (String)"After entering safemode due to low resources FSNamesystem.isInStartupSafeMode still returned true");
        org.junit.jupiter.api.Assertions.assertTrue((boolean)fsn.isInSafeMode(), (String)"After entering safemode due to low resources FSNamesystem.isInSafeMode still returned false");
    }

    @Test
    public void testReplQueuesActiveAfterStartupSafemode() throws IOException, InterruptedException {
        Configuration conf = new Configuration();
        FSEditLog fsEditLog = (FSEditLog)Mockito.mock(FSEditLog.class);
        FSImage fsImage = (FSImage)Mockito.mock(FSImage.class);
        Mockito.when((Object)fsImage.getEditLog()).thenReturn((Object)fsEditLog);
        FSNamesystem fsNamesystem = new FSNamesystem(conf, fsImage);
        FSNamesystem fsn = (FSNamesystem)Mockito.spy((Object)fsNamesystem);
        BlockManager bm = fsn.getBlockManager();
        Whitebox.setInternalState((Object)bm, (String)"namesystem", (Object)fsn);
        HAContext haContext = (HAContext)Mockito.mock(HAContext.class);
        HAState haState = (HAState)Mockito.mock(HAState.class);
        Mockito.when((Object)haContext.getState()).thenReturn((Object)haState);
        Mockito.when((Object)haState.shouldPopulateReplQueues()).thenReturn((Object)true);
        Mockito.when((Object)fsn.getHAContext()).thenReturn((Object)haContext);
        NameNode.initMetrics((Configuration)conf, (HdfsServerConstants.NamenodeRole)HdfsServerConstants.NamenodeRole.NAMENODE);
        fsn.enterSafeMode(false);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)fsn.isInSafeMode(), (String)"FSNamesystem didn't enter safemode");
        org.junit.jupiter.api.Assertions.assertTrue((!bm.isPopulatingReplQueues() ? 1 : 0) != 0, (String)"Replication queues were being populated during very first safemode");
        fsn.leaveSafeMode(false);
        org.junit.jupiter.api.Assertions.assertTrue((!fsn.isInSafeMode() ? 1 : 0) != 0, (String)"FSNamesystem didn't leave safemode");
        org.junit.jupiter.api.Assertions.assertTrue((boolean)bm.isPopulatingReplQueues(), (String)"Replication queues weren't being populated even after leaving safemode");
        fsn.enterSafeMode(false);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)fsn.isInSafeMode(), (String)"FSNamesystem didn't enter safemode");
        org.junit.jupiter.api.Assertions.assertTrue((boolean)bm.isPopulatingReplQueues(), (String)"Replication queues weren't being populated after entering safemode 2nd time");
    }

    @Test
    public void testHAStateInNamespaceInfo() throws IOException {
        Configuration conf = new Configuration();
        FSEditLog fsEditLog = (FSEditLog)Mockito.mock(FSEditLog.class);
        FSImage fsImage = (FSImage)Mockito.mock(FSImage.class);
        Mockito.when((Object)fsImage.getEditLog()).thenReturn((Object)fsEditLog);
        NNStorage nnStorage = (NNStorage)Mockito.mock(NNStorage.class);
        Mockito.when((Object)fsImage.getStorage()).thenReturn((Object)nnStorage);
        FSNamesystem fsNamesystem = new FSNamesystem(conf, fsImage);
        FSNamesystem fsn = (FSNamesystem)Mockito.spy((Object)fsNamesystem);
        Mockito.when((Object)fsn.getState()).thenReturn((Object)HAServiceProtocol.HAServiceState.ACTIVE);
        NamespaceInfo nsInfo = fsn.unprotectedGetNamespaceInfo();
        org.junit.jupiter.api.Assertions.assertNotNull((Object)nsInfo.getState());
    }

    @Test
    public void testReset() throws Exception {
        Configuration conf = new Configuration();
        FSEditLog fsEditLog = (FSEditLog)Mockito.mock(FSEditLog.class);
        FSImage fsImage = (FSImage)Mockito.mock(FSImage.class);
        Mockito.when((Object)fsImage.getEditLog()).thenReturn((Object)fsEditLog);
        FSNamesystem fsn = new FSNamesystem(conf, fsImage);
        fsn.imageLoadComplete();
        org.junit.jupiter.api.Assertions.assertTrue((boolean)fsn.isImageLoaded());
        this.clearNamesystem(fsn);
        INodeDirectory root = (INodeDirectory)fsn.getFSDirectory().getINode("/");
        org.junit.jupiter.api.Assertions.assertTrue((boolean)root.getChildrenList(0x7FFFFFFE).isEmpty());
        fsn.imageLoadComplete();
        org.junit.jupiter.api.Assertions.assertTrue((boolean)fsn.isImageLoaded());
    }

    private void clearNamesystem(FSNamesystem fsn) {
        fsn.writeLock(RwLockMode.GLOBAL);
        try {
            fsn.clear();
            org.junit.jupiter.api.Assertions.assertFalse((boolean)fsn.isImageLoaded());
        }
        finally {
            fsn.writeUnlock(RwLockMode.GLOBAL, "clearNamesystem");
        }
    }

    @Test
    public void testGetEffectiveLayoutVersion() {
        org.junit.jupiter.api.Assertions.assertEquals((int)-63, (int)FSNamesystem.getEffectiveLayoutVersion((boolean)true, (int)-60, (int)-61, (int)-63));
        org.junit.jupiter.api.Assertions.assertEquals((int)-61, (int)FSNamesystem.getEffectiveLayoutVersion((boolean)true, (int)-61, (int)-61, (int)-63));
        org.junit.jupiter.api.Assertions.assertEquals((int)-62, (int)FSNamesystem.getEffectiveLayoutVersion((boolean)true, (int)-62, (int)-61, (int)-63));
        org.junit.jupiter.api.Assertions.assertEquals((int)-63, (int)FSNamesystem.getEffectiveLayoutVersion((boolean)true, (int)-63, (int)-61, (int)-63));
        org.junit.jupiter.api.Assertions.assertEquals((int)-63, (int)FSNamesystem.getEffectiveLayoutVersion((boolean)false, (int)-60, (int)-61, (int)-63));
        org.junit.jupiter.api.Assertions.assertEquals((int)-63, (int)FSNamesystem.getEffectiveLayoutVersion((boolean)false, (int)-61, (int)-61, (int)-63));
        org.junit.jupiter.api.Assertions.assertEquals((int)-63, (int)FSNamesystem.getEffectiveLayoutVersion((boolean)false, (int)-62, (int)-61, (int)-63));
        org.junit.jupiter.api.Assertions.assertEquals((int)-63, (int)FSNamesystem.getEffectiveLayoutVersion((boolean)false, (int)-63, (int)-61, (int)-63));
    }

    @Test
    public void testSafemodeReplicationConf() throws IOException {
        Configuration conf = new Configuration();
        FSImage fsImage = (FSImage)Mockito.mock(FSImage.class);
        FSEditLog fsEditLog = (FSEditLog)Mockito.mock(FSEditLog.class);
        Mockito.when((Object)fsImage.getEditLog()).thenReturn((Object)fsEditLog);
        conf.setInt("dfs.namenode.replication.min", 2);
        FSNamesystem fsn = new FSNamesystem(conf, fsImage);
        Object bmSafeMode = Whitebox.getInternalState((Object)fsn.getBlockManager(), (String)"bmSafeMode");
        int safeReplication = (Integer)Whitebox.getInternalState((Object)bmSafeMode, (String)"safeReplication");
        org.junit.jupiter.api.Assertions.assertEquals((int)2, (int)safeReplication);
    }

    @Test
    @Timeout(value=30L)
    public void testInitAuditLoggers() throws IOException {
        Configuration conf = new Configuration();
        FSImage fsImage = (FSImage)Mockito.mock(FSImage.class);
        FSEditLog fsEditLog = (FSEditLog)Mockito.mock(FSEditLog.class);
        Mockito.when((Object)fsImage.getEditLog()).thenReturn((Object)fsEditLog);
        conf.set("dfs.namenode.audit.loggers", "");
        conf.setBoolean("dfs.namenode.top.enabled", false);
        conf.setBoolean("hadoop.caller.context.enabled", true);
        FSNamesystem fsn = new FSNamesystem(conf, fsImage);
        List auditLoggers = fsn.getAuditLoggers();
        org.junit.jupiter.api.Assertions.assertTrue((auditLoggers.size() == 1 ? 1 : 0) != 0);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)(auditLoggers.get(0) instanceof FSNamesystem.FSNamesystemAuditLogger));
        FSNamesystem.FSNamesystemAuditLogger defaultAuditLogger = (FSNamesystem.FSNamesystemAuditLogger)auditLoggers.get(0);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)defaultAuditLogger.getCallerContextEnabled());
        conf.set("dfs.namenode.audit.loggers", "");
        conf.setBoolean("dfs.namenode.top.enabled", true);
        fsn = new FSNamesystem(conf, fsImage);
        auditLoggers = fsn.getAuditLoggers();
        org.junit.jupiter.api.Assertions.assertTrue((auditLoggers.size() == 2 ? 1 : 0) != 0);
        for (AuditLogger auditLogger : auditLoggers) {
            Assertions.assertThat((Object)auditLogger).isInstanceOfAny(new Class[]{FSNamesystem.FSNamesystemAuditLogger.class, TopAuditLogger.class});
        }
        conf.set("dfs.namenode.audit.loggers", "default");
        conf.setBoolean("dfs.namenode.top.enabled", true);
        fsn = new FSNamesystem(conf, fsImage);
        auditLoggers = fsn.getAuditLoggers();
        org.junit.jupiter.api.Assertions.assertTrue((auditLoggers.size() == 2 ? 1 : 0) != 0);
        for (AuditLogger auditLogger : auditLoggers) {
            Assertions.assertThat((Object)auditLogger).isInstanceOfAny(new Class[]{FSNamesystem.FSNamesystemAuditLogger.class, TopAuditLogger.class});
        }
        conf.set("dfs.namenode.audit.loggers", " default, org.apache.hadoop.hdfs.server.namenode.TestFSNamesystem$DummyAuditLogger  ");
        conf.setBoolean("dfs.namenode.top.enabled", true);
        fsn = new FSNamesystem(conf, fsImage);
        auditLoggers = fsn.getAuditLoggers();
        org.junit.jupiter.api.Assertions.assertTrue((auditLoggers.size() == 3 ? 1 : 0) != 0);
        for (AuditLogger auditLogger : auditLoggers) {
            Assertions.assertThat((Object)auditLogger).isInstanceOfAny(new Class[]{FSNamesystem.FSNamesystemAuditLogger.class, TopAuditLogger.class, DummyAuditLogger.class});
        }
        conf.set("dfs.namenode.audit.loggers", "org.apache.hadoop.hdfs.server.namenode.top.TopAuditLogger");
        fsn = new FSNamesystem(conf, fsImage);
        auditLoggers = fsn.getAuditLoggers();
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)auditLoggers.size());
        Assertions.assertThat(auditLoggers.get(0)).isInstanceOf(TopAuditLogger.class);
    }

    static class DummyAuditLogger
    implements AuditLogger {
        DummyAuditLogger() {
        }

        public void initialize(Configuration conf) {
        }

        public void logAuditEvent(boolean succeeded, String userName, InetAddress addr, String cmd, String src, String dst, FileStatus stat) {
        }
    }
}

