/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.server.namenode.INode;
import org.apache.hadoop.hdfs.server.namenode.TestFSImageWithSnapshot;
import org.apache.hadoop.hdfs.server.namenode.snapshot.SnapshotTestHelper;
import org.apache.hadoop.io.compress.GzipCodec;
import org.apache.hadoop.test.GenericTestUtils;
import org.slf4j.Logger;
import org.slf4j.event.Level;

public class TestFSImageWithSnapshotParallelAndCompress
extends TestFSImageWithSnapshot {
    public TestFSImageWithSnapshotParallelAndCompress() {
        SnapshotTestHelper.disableLogs();
        GenericTestUtils.setLogLevel((Logger)INode.LOG, (Level)Level.TRACE);
    }

    @Override
    public void createCluster() throws IOException {
        this.conf.setBoolean("dfs.image.compress", true);
        this.conf.set("dfs.image.compression.codec", GzipCodec.class.getCanonicalName());
        this.conf.setBoolean("dfs.image.parallel.load", true);
        this.conf.setInt("dfs.image.parallel.inode.threshold", 2);
        this.conf.setInt("dfs.image.parallel.target.sections", 2);
        this.conf.setInt("dfs.image.parallel.threads", 2);
        this.conf = new Configuration();
        this.cluster = new MiniDFSCluster.Builder(this.conf).numDataNodes(1).build();
        this.cluster.waitActive();
        this.fsn = this.cluster.getNamesystem();
        this.hdfs = this.cluster.getFileSystem();
    }
}

