/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode;

import java.io.File;
import java.io.IOException;
import org.apache.hadoop.hdfs.server.common.Storage;
import org.apache.hadoop.hdfs.server.namenode.FSImageStorageInspector;
import org.apache.hadoop.hdfs.server.namenode.FSImageTestUtil;
import org.apache.hadoop.hdfs.server.namenode.FSImageTransactionalStorageInspector;
import org.apache.hadoop.hdfs.server.namenode.NNStorage;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestFSImageStorageInspector {
    @Test
    public void testCurrentStorageInspector() throws IOException {
        FSImageTransactionalStorageInspector inspector = new FSImageTransactionalStorageInspector();
        Storage.StorageDirectory mockDir = FSImageTestUtil.mockStorageDirectory((Storage.StorageDirType)NNStorage.NameNodeDirType.IMAGE_AND_EDITS, false, "/foo/current/" + NNStorage.getImageFileName((long)123L), "/foo/current/" + NNStorage.getFinalizedEditsFileName((long)123L, (long)456L), "/foo/current/" + NNStorage.getImageFileName((long)456L), "/foo/current/" + NNStorage.getInProgressEditsFileName((long)457L));
        inspector.inspectDirectory(mockDir);
        Assertions.assertEquals((int)2, (int)inspector.foundImages.size());
        FSImageStorageInspector.FSImageFile latestImage = (FSImageStorageInspector.FSImageFile)inspector.getLatestImages().get(0);
        Assertions.assertEquals((long)456L, (long)latestImage.txId);
        Assertions.assertSame((Object)mockDir, (Object)latestImage.sd);
        Assertions.assertTrue((boolean)inspector.isUpgradeFinalized());
        Assertions.assertEquals((Object)new File("/foo/current/" + NNStorage.getImageFileName((long)456L)), (Object)latestImage.getFile());
    }
}

