/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode;

import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.crypto.CipherSuite;
import org.apache.hadoop.crypto.CryptoProtocolVersion;
import org.apache.hadoop.fs.BatchedRemoteIterator;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.fs.permission.PermissionStatus;
import org.apache.hadoop.hdfs.protocol.EncryptionZone;
import org.apache.hadoop.hdfs.server.namenode.EncryptionZoneManager;
import org.apache.hadoop.hdfs.server.namenode.FSDirectory;
import org.apache.hadoop.hdfs.server.namenode.INodeDirectory;
import org.apache.hadoop.hdfs.server.namenode.INodesInPath;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;

public class TestEncryptionZoneManager {
    private FSDirectory mockedDir;
    private INodesInPath mockedINodesInPath;
    private INodeDirectory firstINode;
    private INodeDirectory secondINode;
    private INodeDirectory rootINode;
    private PermissionStatus defaultPermission;
    private EncryptionZoneManager ezManager;

    @BeforeEach
    public void setup() {
        this.mockedDir = (FSDirectory)Mockito.mock(FSDirectory.class);
        this.mockedINodesInPath = (INodesInPath)Mockito.mock(INodesInPath.class);
        this.defaultPermission = new PermissionStatus("test", "test", new FsPermission(755));
        this.rootINode = new INodeDirectory(0L, "".getBytes(), this.defaultPermission, System.currentTimeMillis());
        this.firstINode = new INodeDirectory(1L, "first".getBytes(), this.defaultPermission, System.currentTimeMillis());
        this.secondINode = new INodeDirectory(2L, "second".getBytes(), this.defaultPermission, System.currentTimeMillis());
        Mockito.when((Object)this.mockedDir.hasReadLock()).thenReturn((Object)true);
        Mockito.when((Object)this.mockedDir.hasWriteLock()).thenReturn((Object)true);
        Mockito.when((Object)this.mockedDir.getInode(0L)).thenReturn((Object)this.rootINode);
        Mockito.when((Object)this.mockedDir.getInode(1L)).thenReturn((Object)this.firstINode);
        Mockito.when((Object)this.mockedDir.getInode(2L)).thenReturn((Object)this.secondINode);
    }

    @Test
    public void testListEncryptionZonesOneValidOnly() throws Exception {
        this.ezManager = new EncryptionZoneManager(this.mockedDir, new Configuration());
        this.ezManager.addEncryptionZone(Long.valueOf(1L), CipherSuite.AES_CTR_NOPADDING, CryptoProtocolVersion.ENCRYPTION_ZONES, "test_key");
        this.ezManager.addEncryptionZone(Long.valueOf(2L), CipherSuite.AES_CTR_NOPADDING, CryptoProtocolVersion.ENCRYPTION_ZONES, "test_key");
        this.firstINode.setParent(this.rootINode);
        Mockito.when((Object)this.mockedDir.getINodesInPath("/first", FSDirectory.DirOp.READ_LINK)).thenReturn((Object)this.mockedINodesInPath);
        Mockito.when((Object)this.mockedINodesInPath.getLastINode()).thenReturn((Object)this.firstINode);
        BatchedRemoteIterator.BatchedListEntries result = this.ezManager.listEncryptionZones(0L);
        Assertions.assertEquals((int)1, (int)result.size());
        Assertions.assertEquals((long)1L, (long)((EncryptionZone)result.get(0)).getId());
        Assertions.assertEquals((Object)"/first", (Object)((EncryptionZone)result.get(0)).getPath());
    }

    @Test
    public void testListEncryptionZonesTwoValids() throws Exception {
        this.ezManager = new EncryptionZoneManager(this.mockedDir, new Configuration());
        this.ezManager.addEncryptionZone(Long.valueOf(1L), CipherSuite.AES_CTR_NOPADDING, CryptoProtocolVersion.ENCRYPTION_ZONES, "test_key");
        this.ezManager.addEncryptionZone(Long.valueOf(2L), CipherSuite.AES_CTR_NOPADDING, CryptoProtocolVersion.ENCRYPTION_ZONES, "test_key");
        this.firstINode.setParent(this.rootINode);
        this.secondINode.setParent(this.rootINode);
        Mockito.when((Object)this.mockedDir.getINodesInPath("/first", FSDirectory.DirOp.READ_LINK)).thenReturn((Object)this.mockedINodesInPath);
        Mockito.when((Object)this.mockedINodesInPath.getLastINode()).thenReturn((Object)this.firstINode);
        INodesInPath mockedINodesInPathForSecond = (INodesInPath)Mockito.mock(INodesInPath.class);
        Mockito.when((Object)this.mockedDir.getINodesInPath("/second", FSDirectory.DirOp.READ_LINK)).thenReturn((Object)mockedINodesInPathForSecond);
        Mockito.when((Object)mockedINodesInPathForSecond.getLastINode()).thenReturn((Object)this.secondINode);
        BatchedRemoteIterator.BatchedListEntries result = this.ezManager.listEncryptionZones(0L);
        Assertions.assertEquals((int)2, (int)result.size());
        Assertions.assertEquals((long)1L, (long)((EncryptionZone)result.get(0)).getId());
        Assertions.assertEquals((Object)"/first", (Object)((EncryptionZone)result.get(0)).getPath());
        Assertions.assertEquals((long)2L, (long)((EncryptionZone)result.get(1)).getId());
        Assertions.assertEquals((Object)"/second", (Object)((EncryptionZone)result.get(1)).getPath());
    }

    @Test
    public void testListEncryptionZonesForRoot() throws Exception {
        this.ezManager = new EncryptionZoneManager(this.mockedDir, new Configuration());
        this.ezManager.addEncryptionZone(Long.valueOf(0L), CipherSuite.AES_CTR_NOPADDING, CryptoProtocolVersion.ENCRYPTION_ZONES, "test_key");
        Mockito.when((Object)this.mockedDir.getINodesInPath("/", FSDirectory.DirOp.READ_LINK)).thenReturn((Object)this.mockedINodesInPath);
        Mockito.when((Object)this.mockedINodesInPath.getLastINode()).thenReturn((Object)this.rootINode);
        BatchedRemoteIterator.BatchedListEntries result = this.ezManager.listEncryptionZones(-1L);
        Assertions.assertEquals((int)1, (int)result.size());
        Assertions.assertEquals((long)0L, (long)((EncryptionZone)result.get(0)).getId());
        Assertions.assertEquals((Object)"/", (Object)((EncryptionZone)result.get(0)).getPath());
    }

    @Test
    public void testListEncryptionZonesSubDirInvalid() throws Exception {
        INodeDirectory thirdINode = new INodeDirectory(3L, "third".getBytes(), this.defaultPermission, System.currentTimeMillis());
        Mockito.when((Object)this.mockedDir.getInode(3L)).thenReturn((Object)thirdINode);
        thirdINode.setParent(this.secondINode);
        this.ezManager = new EncryptionZoneManager(this.mockedDir, new Configuration());
        this.ezManager.addEncryptionZone(Long.valueOf(1L), CipherSuite.AES_CTR_NOPADDING, CryptoProtocolVersion.ENCRYPTION_ZONES, "test_key");
        this.ezManager.addEncryptionZone(Long.valueOf(3L), CipherSuite.AES_CTR_NOPADDING, CryptoProtocolVersion.ENCRYPTION_ZONES, "test_key");
        this.firstINode.setParent(this.rootINode);
        Mockito.when((Object)this.mockedDir.getINodesInPath("/first", FSDirectory.DirOp.READ_LINK)).thenReturn((Object)this.mockedINodesInPath);
        Mockito.when((Object)this.mockedINodesInPath.getLastINode()).thenReturn((Object)this.firstINode);
        BatchedRemoteIterator.BatchedListEntries result = this.ezManager.listEncryptionZones(0L);
        Assertions.assertEquals((int)1, (int)result.size());
        Assertions.assertEquals((long)1L, (long)((EncryptionZone)result.get(0)).getId());
        Assertions.assertEquals((Object)"/first", (Object)((EncryptionZone)result.get(0)).getPath());
    }
}

