/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode;

import java.io.Closeable;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Semaphore;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Options;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.AddBlockFlag;
import org.apache.hadoop.hdfs.AppendTestUtil;
import org.apache.hadoop.hdfs.DFSTestUtil;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.protocol.BlockStoragePolicy;
import org.apache.hadoop.hdfs.protocol.DatanodeID;
import org.apache.hadoop.hdfs.protocol.ExtendedBlock;
import org.apache.hadoop.hdfs.protocolPB.DatanodeProtocolClientSideTranslatorPB;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockPlacementPolicy;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockPlacementPolicyDefault;
import org.apache.hadoop.hdfs.server.blockmanagement.DatanodeDescriptor;
import org.apache.hadoop.hdfs.server.blockmanagement.DatanodeStorageInfo;
import org.apache.hadoop.hdfs.server.datanode.DataNode;
import org.apache.hadoop.hdfs.server.datanode.InternalDataNodeTestUtils;
import org.apache.hadoop.hdfs.server.namenode.FSDirectory;
import org.apache.hadoop.hdfs.server.namenode.FSNamesystem;
import org.apache.hadoop.hdfs.server.namenode.INode;
import org.apache.hadoop.hdfs.server.namenode.INodeMap;
import org.apache.hadoop.hdfs.server.namenode.INodesInPath;
import org.apache.hadoop.hdfs.server.namenode.NameNode;
import org.apache.hadoop.hdfs.server.namenode.snapshot.SnapshotTestHelper;
import org.apache.hadoop.hdfs.util.RwLockMode;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.net.Node;
import org.apache.hadoop.test.GenericTestUtils;
import org.apache.hadoop.test.Whitebox;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.stubbing.Answer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Timeout(value=180L)
public class TestDeleteRace {
    private static final int BLOCK_SIZE = 4096;
    private static final Logger LOG = LoggerFactory.getLogger(TestDeleteRace.class);
    private static final Configuration conf = new HdfsConfiguration();
    private MiniDFSCluster cluster;

    @Test
    public void testDeleteAddBlockRace() throws Exception {
        this.testDeleteAddBlockRace(false);
    }

    @Test
    public void testDeleteAddBlockRaceWithSnapshot() throws Exception {
        this.testDeleteAddBlockRace(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testDeleteAddBlockRace(boolean hasSnapshot) throws Exception {
        try {
            conf.setClass("dfs.block.replicator.classname", SlowBlockPlacementPolicy.class, BlockPlacementPolicy.class);
            this.cluster = new MiniDFSCluster.Builder(conf).build();
            DistributedFileSystem fs = this.cluster.getFileSystem();
            String fileName = "/testDeleteAddBlockRace";
            Path filePath = new Path("/testDeleteAddBlockRace");
            FSDataOutputStream out = null;
            out = fs.create(filePath);
            if (hasSnapshot) {
                SnapshotTestHelper.createSnapshot(fs, new Path("/"), "s1");
            }
            DeleteThread deleteThread = new DeleteThread((FileSystem)fs, filePath);
            deleteThread.start();
            try {
                out.write(new byte[32], 0, 32);
                out.hsync();
                Assertions.fail((String)"Should have failed.");
            }
            catch (FileNotFoundException e) {
                GenericTestUtils.assertExceptionContains((String)filePath.getName(), (Throwable)e);
            }
        }
        finally {
            if (this.cluster != null) {
                this.cluster.shutdown();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRenameRace() throws Exception {
        try {
            conf.setClass("dfs.block.replicator.classname", SlowBlockPlacementPolicy.class, BlockPlacementPolicy.class);
            this.cluster = new MiniDFSCluster.Builder(conf).build();
            DistributedFileSystem fs = this.cluster.getFileSystem();
            Path dirPath1 = new Path("/testRenameRace1");
            Path dirPath2 = new Path("/testRenameRace2");
            Path filePath = new Path("/testRenameRace1/file1");
            fs.mkdirs(dirPath1);
            FSDataOutputStream out = fs.create(filePath);
            RenameThread renameThread = new RenameThread((FileSystem)fs, dirPath1, dirPath2);
            renameThread.start();
            out.write(new byte[32], 0, 32);
            out.close();
            this.cluster.restartNameNode(0);
        }
        finally {
            if (this.cluster != null) {
                this.cluster.shutdown();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testDeleteAndCommitBlockSynchronizationRace(boolean hasSnapshot) throws Exception {
        LOG.info("Start testing, hasSnapshot: " + hasSnapshot);
        ArrayList<AbstractMap.SimpleImmutableEntry<String, Boolean>> testList = new ArrayList<AbstractMap.SimpleImmutableEntry<String, Boolean>>();
        testList.add(new AbstractMap.SimpleImmutableEntry<String, Boolean>("/test-file", false));
        testList.add(new AbstractMap.SimpleImmutableEntry<String, Boolean>("/test-file1", true));
        testList.add(new AbstractMap.SimpleImmutableEntry<String, Boolean>("/testdir/testdir1/test-file", false));
        testList.add(new AbstractMap.SimpleImmutableEntry<String, Boolean>("/testdir/testdir1/test-file1", true));
        Path rootPath = new Path("/");
        Configuration conf = new Configuration();
        conf.setBoolean("dfs.permissions.enabled", false);
        conf.setInt("dfs.blocksize", 4096);
        FSDataOutputStream stm = null;
        HashMap<DataNode, DatanodeProtocolClientSideTranslatorPB> dnMap = new HashMap<DataNode, DatanodeProtocolClientSideTranslatorPB>();
        try {
            this.cluster = new MiniDFSCluster.Builder(conf).numDataNodes(3).build();
            this.cluster.waitActive();
            DistributedFileSystem fs = this.cluster.getFileSystem();
            int stId = 0;
            for (AbstractMap.SimpleImmutableEntry simpleImmutableEntry : testList) {
                Path fPath;
                String testPath = (String)simpleImmutableEntry.getKey();
                Boolean mkSameDir = (Boolean)simpleImmutableEntry.getValue();
                LOG.info("test on " + testPath + " mkSameDir: " + mkSameDir + " snapshot: " + hasSnapshot);
                Path grandestNonRootParent = fPath = new Path(testPath);
                while (!grandestNonRootParent.getParent().equals((Object)rootPath)) {
                    grandestNonRootParent = grandestNonRootParent.getParent();
                }
                stm = fs.create(fPath);
                LOG.info("test on " + testPath + " created " + fPath);
                AppendTestUtil.write((OutputStream)stm, 0, 2048);
                stm.hflush();
                if (hasSnapshot) {
                    SnapshotTestHelper.createSnapshot(fs, rootPath, "st" + String.valueOf(stId));
                    ++stId;
                }
                NameNode nn = this.cluster.getNameNode();
                ExtendedBlock blk = DFSTestUtil.getFirstBlock((FileSystem)fs, fPath);
                DatanodeDescriptor expectedPrimary = DFSTestUtil.getExpectedPrimaryNode(nn, blk);
                LOG.info("Expecting block recovery to be triggered on DN " + expectedPrimary);
                DataNode primaryDN = this.cluster.getDataNode(expectedPrimary.getIpcPort());
                DatanodeProtocolClientSideTranslatorPB nnSpy = (DatanodeProtocolClientSideTranslatorPB)dnMap.get(primaryDN);
                if (nnSpy == null) {
                    nnSpy = InternalDataNodeTestUtils.spyOnBposToNN(primaryDN, nn);
                    dnMap.put(primaryDN, nnSpy);
                }
                GenericTestUtils.DelayAnswer delayer = new GenericTestUtils.DelayAnswer(LOG);
                ((DatanodeProtocolClientSideTranslatorPB)Mockito.doAnswer((Answer)delayer).when((Object)nnSpy)).commitBlockSynchronization((ExtendedBlock)Mockito.eq((Object)blk), Mockito.anyLong(), Mockito.anyLong(), Mockito.eq((boolean)true), Mockito.eq((boolean)false), (DatanodeID[])Mockito.any(), (String[])Mockito.any());
                fs.recoverLease(fPath);
                LOG.info("Waiting for commitBlockSynchronization call from primary");
                delayer.waitForCall();
                LOG.info("Deleting recursively " + grandestNonRootParent);
                fs.delete(grandestNonRootParent, true);
                if (mkSameDir.booleanValue() && !grandestNonRootParent.toString().equals(testPath)) {
                    LOG.info("Recreate dir " + grandestNonRootParent + " testpath: " + testPath);
                    fs.mkdirs(grandestNonRootParent);
                }
                delayer.proceed();
                LOG.info("Now wait for result");
                delayer.waitForResult();
                Throwable t = delayer.getThrown();
                if (t == null) continue;
                LOG.info("Result exception (snapshot: " + hasSnapshot + "): " + t);
            }
            LOG.info("Now check we can restart");
            this.cluster.restartNameNodes();
            LOG.info("Restart finished");
        }
        finally {
            if (stm != null) {
                IOUtils.closeStream(stm);
            }
            if (this.cluster != null) {
                this.cluster.shutdown();
            }
        }
    }

    @Test
    @Timeout(value=600L)
    public void testDeleteAndCommitBlockSynchonizationRaceNoSnapshot() throws Exception {
        this.testDeleteAndCommitBlockSynchronizationRace(false);
    }

    @Test
    @Timeout(value=600L)
    public void testDeleteAndCommitBlockSynchronizationRaceHasSnapshot() throws Exception {
        this.testDeleteAndCommitBlockSynchronizationRace(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDeleteAndLeaseRecoveryHardLimitSnapshot() throws Exception {
        block5: {
            Path rootPath = new Path("/");
            Configuration config = new Configuration();
            config.setBoolean("dfs.permissions.enabled", false);
            config.setInt("dfs.blocksize", 4096);
            long leaseRecheck = 1000L;
            conf.setLong("dfs.namenode.lease-recheck-interval-ms", leaseRecheck);
            conf.setLong("dfs.namenode.lease-hard-limit-sec", leaseRecheck / 1000L);
            FSDataOutputStream stm = null;
            try {
                this.cluster = new MiniDFSCluster.Builder(config).numDataNodes(3).build();
                this.cluster.waitActive();
                DistributedFileSystem fs = this.cluster.getFileSystem();
                Path testPath = new Path("/testfile");
                stm = fs.create(testPath);
                LOG.info("test on " + testPath);
                AppendTestUtil.write((OutputStream)stm, 0, 2048);
                stm.hflush();
                SnapshotTestHelper.createSnapshot(fs, rootPath, "snap");
                fs.delete(testPath, false);
                AppendTestUtil.write((OutputStream)stm, 0, 4096);
                Thread.sleep(2L * leaseRecheck);
                LOG.info("Now check we can restart");
                this.cluster.restartNameNodes();
                LOG.info("Restart finished");
                if (stm == null) break block5;
            }
            catch (Throwable throwable) {
                if (stm != null) {
                    IOUtils.closeStream(stm);
                }
                if (this.cluster != null) {
                    this.cluster.shutdown();
                }
                throw throwable;
            }
            IOUtils.closeStream((Closeable)stm);
        }
        if (this.cluster != null) {
            this.cluster.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @Timeout(value=20L)
    public void testOpenRenameRace() throws Exception {
        Configuration config = new Configuration();
        config.setLong("dfs.namenode.accesstime.precision", 1L);
        MiniDFSCluster dfsCluster = null;
        String src = "/dir/src-file";
        String dst = "/dir/dst-file";
        try {
            dfsCluster = new MiniDFSCluster.Builder(config).build();
            dfsCluster.waitActive();
            FSNamesystem fsn = dfsCluster.getNamesystem();
            DistributedFileSystem hdfs = dfsCluster.getFileSystem();
            DFSTestUtil.createFile((FileSystem)hdfs, new Path("/dir/src-file"), 5L, (short)1, 65261L);
            FileStatus status = hdfs.getFileStatus(new Path("/dir/src-file"));
            long accessTime = status.getAccessTime();
            Semaphore openSem = new Semaphore(0);
            Semaphore renameSem = new Semaphore(0);
            Thread open = new Thread(() -> {
                try {
                    openSem.release();
                    fsn.getBlockLocations("foo", "/dir/src-file", 0L, 5L);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            });
            Thread rename = new Thread(() -> {
                try {
                    openSem.acquire();
                    renameSem.release();
                    fsn.renameTo("/dir/src-file", "/dir/dst-file", false, new Options.Rename[]{Options.Rename.NONE});
                }
                catch (IOException iOException) {
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            });
            fsn.writeLock(RwLockMode.GLOBAL);
            open.start();
            openSem.acquire();
            Thread.yield();
            openSem.release();
            rename.start();
            renameSem.acquire();
            Thread.yield();
            fsn.writeUnlock(RwLockMode.GLOBAL, "testOpenRenameRace");
            open.join();
            rename.join();
            status = hdfs.getFileStatus(new Path("/dir/dst-file"));
            Assertions.assertNotEquals((long)accessTime, (long)status.getAccessTime());
            dfsCluster.restartNameNode(0);
        }
        finally {
            if (dfsCluster != null) {
                dfsCluster.shutdown();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDeleteOnSnapshottableDir() throws Exception {
        conf.setBoolean("dfs.namenode.snapshotdiff.allow.snap-root-descendant", true);
        try {
            this.cluster = new MiniDFSCluster.Builder(conf).numDataNodes(1).build();
            this.cluster.waitActive();
            DistributedFileSystem hdfs = this.cluster.getFileSystem();
            FSNamesystem fsn = this.cluster.getNamesystem();
            FSDirectory fsdir = fsn.getFSDirectory();
            Path dir = new Path("/dir");
            hdfs.mkdirs(dir);
            hdfs.allowSnapshot(dir);
            Path file1 = new Path(dir, "file1");
            Path file2 = new Path(dir, "file2");
            FSDirectory fsdir2 = (FSDirectory)Mockito.spy((Object)fsdir);
            this.cluster.getNamesystem().setFSDirectory(fsdir2);
            ((FSDirectory)Mockito.doReturn((Object)-1L).when((Object)fsdir2)).removeLastINode((INodesInPath)ArgumentMatchers.any());
            hdfs.delete(dir, true);
            DFSTestUtil.createFile((FileSystem)hdfs, file1, 4096L, (short)1, 0L);
            hdfs.createSnapshot(dir, "s1");
            DFSTestUtil.createFile((FileSystem)hdfs, file2, 4096L, (short)1, 0L);
            hdfs.createSnapshot(dir, "s2");
            Path dirDir1 = new Path(dir, "dir1");
            hdfs.mkdirs(dirDir1);
            hdfs.getSnapshotDiffReport(dirDir1, "s2", "s1");
            Assertions.assertEquals((int)1, (int)fsn.getSnapshotManager().getNumSnapshottableDirs());
        }
        finally {
            if (this.cluster != null) {
                this.cluster.shutdown();
            }
        }
    }

    private class RenameThread
    extends Thread {
        private FileSystem fs;
        private Path from;
        private Path to;

        RenameThread(FileSystem fs, Path from, Path to) {
            this.fs = fs;
            this.from = from;
            this.to = to;
        }

        @Override
        public void run() {
            try {
                Thread.sleep(1000L);
                LOG.info("Renaming " + this.from + " to " + this.to);
                this.fs.rename(this.from, this.to);
                LOG.info("Renamed " + this.from + " to " + this.to);
            }
            catch (Exception e) {
                LOG.info(e.toString());
            }
        }
    }

    private class DeleteThread
    extends Thread {
        private FileSystem fs;
        private Path path;

        DeleteThread(FileSystem fs, Path path) {
            this.fs = fs;
            this.path = path;
        }

        @Override
        public void run() {
            try {
                Thread.sleep(1000L);
                LOG.info("Deleting" + this.path);
                FSDirectory fsdir = ((TestDeleteRace)TestDeleteRace.this).cluster.getNamesystem().dir;
                INode fileINode = fsdir.getINode4Write(this.path.toString());
                INodeMap inodeMap = (INodeMap)Whitebox.getInternalState((Object)fsdir, (String)"inodeMap");
                this.fs.delete(this.path, false);
                inodeMap.put(fileINode);
                LOG.info("Deleted" + this.path);
            }
            catch (Exception e) {
                LOG.info(e.toString());
            }
        }
    }

    private static class SlowBlockPlacementPolicy
    extends BlockPlacementPolicyDefault {
        private SlowBlockPlacementPolicy() {
        }

        public DatanodeStorageInfo[] chooseTarget(String srcPath, int numOfReplicas, Node writer, List<DatanodeStorageInfo> chosenNodes, boolean returnChosenNodes, Set<Node> excludedNodes, long blocksize, BlockStoragePolicy storagePolicy, EnumSet<AddBlockFlag> flags) {
            DatanodeStorageInfo[] results = super.chooseTarget(srcPath, numOfReplicas, writer, chosenNodes, returnChosenNodes, excludedNodes, blocksize, storagePolicy, flags);
            try {
                Thread.sleep(3000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            return results;
        }
    }
}

