/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode;

import java.io.File;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileContext;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileUtil;
import org.apache.hadoop.fs.Options;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.DFSTestUtil;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.server.common.Util;
import org.apache.hadoop.hdfs.server.namenode.CreateEditsLog;
import org.apache.hadoop.test.GenericTestUtils;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;

public class TestCreateEditsLog {
    private static final File HDFS_DIR = new File(MiniDFSCluster.getBaseDirectory()).getAbsoluteFile();
    private static final File TEST_DIR = GenericTestUtils.getTestDir((String)"TestCreateEditsLog");
    private MiniDFSCluster cluster;

    @BeforeEach
    public void setUp() throws Exception {
        TestCreateEditsLog.deleteIfExists(HDFS_DIR);
        TestCreateEditsLog.deleteIfExists(TEST_DIR);
    }

    @AfterEach
    public void tearDown() {
        if (this.cluster != null) {
            this.cluster.shutdown();
            this.cluster = null;
        }
        TestCreateEditsLog.deleteIfExists(HDFS_DIR);
        TestCreateEditsLog.deleteIfExists(TEST_DIR);
    }

    @Test
    @Timeout(value=60L)
    public void testCanLoadCreatedEditsLog() throws Exception {
        HdfsConfiguration conf = new HdfsConfiguration();
        File nameDir = new File(HDFS_DIR, "name");
        conf.set("dfs.namenode.name.dir", Util.fileAsURI((File)nameDir).toString());
        DFSTestUtil.formatNameNode((Configuration)conf);
        CreateEditsLog.main(new String[]{"-f", "1000", "0", "1", "-d", TEST_DIR.getAbsolutePath()});
        Path editsWildcard = new Path(TEST_DIR.getAbsolutePath(), "*");
        FileContext localFc = FileContext.getLocalFSFileContext();
        for (FileStatus edits : localFc.util().globStatus(editsWildcard)) {
            Path src = edits.getPath();
            Path dst = new Path(new File(nameDir, "current").getAbsolutePath(), src.getName());
            localFc.rename(src, dst, new Options.Rename[0]);
        }
        this.cluster = new MiniDFSCluster.Builder((Configuration)conf).format(false).manageNameDfsDirs(false).waitSafeMode(false).build();
        this.cluster.waitClusterUp();
    }

    private static void deleteIfExists(File file) {
        if (file.exists() && !FileUtil.fullyDelete((File)file)) {
            Assertions.fail((String)("Could not delete  '" + file + "'"));
        }
    }
}

