/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode;

import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.server.namenode.NameNodeUtils;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Timeout(value=300L)
public class TestClientNameNodeAddress {
    public static final Logger LOG = LoggerFactory.getLogger(TestClientNameNodeAddress.class);

    @Test
    public void testSimpleConfig() {
        HdfsConfiguration conf = new HdfsConfiguration();
        conf.set("fs.defaultFS", "hdfs://host1:100");
        Assertions.assertThat((String)NameNodeUtils.getClientNamenodeAddress((Configuration)conf, null)).isEqualTo((Object)"host1:100");
    }

    @Test
    public void testSimpleWithoutPort() {
        HdfsConfiguration conf = new HdfsConfiguration();
        conf.set("fs.defaultFS", "hdfs://host1");
        org.junit.jupiter.api.Assertions.assertNull((Object)NameNodeUtils.getClientNamenodeAddress((Configuration)conf, null));
    }

    @Test
    public void testWithNoDefaultFs() {
        HdfsConfiguration conf = new HdfsConfiguration();
        org.junit.jupiter.api.Assertions.assertNull((Object)NameNodeUtils.getClientNamenodeAddress((Configuration)conf, null));
    }

    @Test
    public void testWithNoHost() {
        HdfsConfiguration conf = new HdfsConfiguration();
        conf.set("fs.defaultFS", "hdfs:///");
        org.junit.jupiter.api.Assertions.assertNull((Object)NameNodeUtils.getClientNamenodeAddress((Configuration)conf, null));
    }

    @Test
    public void testFederationWithHa() {
        HdfsConfiguration conf = new HdfsConfiguration();
        conf.set("fs.defaultFS", "hdfs://ns1");
        conf.set("dfs.nameservices", "ns1,ns2");
        conf.set("dfs.ha.namenodes.ns1", "nn1,nn2");
        conf.set("dfs.ha.namenodes.ns2", "nn1,nn2");
        Assertions.assertThat((String)NameNodeUtils.getClientNamenodeAddress((Configuration)conf, (String)"ns1")).isEqualTo((Object)"ns1");
        Assertions.assertThat((String)NameNodeUtils.getClientNamenodeAddress((Configuration)conf, (String)"ns2")).isEqualTo((Object)"ns2");
    }

    @Test
    public void testFederationWithoutHa() {
        HdfsConfiguration conf = new HdfsConfiguration();
        conf.set("fs.defaultFS", "hdfs://host1:100");
        conf.set("dfs.nameservices", "ns1,ns2");
        conf.set("dfs.namenode.rpc-address.ns1", "host1:100");
        conf.set("dfs.namenode.rpc-address.ns2", "host2:200");
        Assertions.assertThat((String)NameNodeUtils.getClientNamenodeAddress((Configuration)conf, (String)"ns1")).isEqualTo((Object)"host1:100");
        Assertions.assertThat((String)NameNodeUtils.getClientNamenodeAddress((Configuration)conf, (String)"ns2")).isEqualTo((Object)"host2:200");
    }
}

