/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.function.Supplier;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.CreateFlag;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.fs.permission.PermissionStatus;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.net.DFSNetworkTopology;
import org.apache.hadoop.hdfs.protocol.DatanodeInfo;
import org.apache.hadoop.hdfs.protocol.DatanodeInfoWithStorage;
import org.apache.hadoop.hdfs.protocol.HdfsFileStatus;
import org.apache.hadoop.hdfs.protocol.LocatedBlock;
import org.apache.hadoop.hdfs.protocol.LocatedBlocks;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockManager;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockPlacementPolicy;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockPlacementPolicyRackFaultTolerant;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockPlacementStatus;
import org.apache.hadoop.hdfs.server.blockmanagement.DatanodeDescriptor;
import org.apache.hadoop.hdfs.server.blockmanagement.DatanodeManager;
import org.apache.hadoop.hdfs.server.namenode.FSNamesystem;
import org.apache.hadoop.hdfs.server.protocol.NamenodeProtocols;
import org.apache.hadoop.hdfs.util.RwLockMode;
import org.apache.hadoop.net.StaticMapping;
import org.apache.hadoop.test.GenericTestUtils;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class TestBlockPlacementPolicyRackFaultTolerant {
    private static final int DEFAULT_BLOCK_SIZE = 1024;
    private MiniDFSCluster cluster = null;
    private NamenodeProtocols nameNodeRpc = null;
    private FSNamesystem namesystem = null;
    private PermissionStatus perm = null;

    @BeforeEach
    public void setup() throws IOException {
        StaticMapping.resetMap();
        HdfsConfiguration conf = new HdfsConfiguration();
        ArrayList<String> rackList = new ArrayList<String>();
        ArrayList<String> hostList = new ArrayList<String>();
        for (int i = 0; i < 10; ++i) {
            for (int j = 0; j < 2; ++j) {
                rackList.add("/rack" + i);
                hostList.add("/host" + i + j);
            }
        }
        conf.setClass("dfs.block.replicator.classname", BlockPlacementPolicyRackFaultTolerant.class, BlockPlacementPolicy.class);
        conf.setLong("dfs.blocksize", 1024L);
        conf.setInt("dfs.bytes-per-checksum", 512);
        this.cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(hostList.size()).racks(rackList.toArray(new String[rackList.size()])).hosts(hostList.toArray(new String[hostList.size()])).build();
        this.cluster.waitActive();
        this.nameNodeRpc = this.cluster.getNameNodeRpc();
        this.namesystem = this.cluster.getNamesystem();
        this.perm = new PermissionStatus("TestBlockPlacementPolicyEC", null, FsPermission.getDefault());
    }

    @AfterEach
    public void teardown() {
        if (this.cluster != null) {
            this.cluster.shutdown();
            this.cluster = null;
        }
    }

    @Test
    public void testChooseTarget() throws Exception {
        this.doTestChooseTargetNormalCase();
        this.doTestChooseTargetSpecialCase();
    }

    private void doTestChooseTargetNormalCase() throws Exception {
        String clientMachine = "client.foo.com";
        short[][] testSuite = new short[][]{{3, 2}, {3, 7}, {3, 8}, {3, 10}, {9, 1}, {10, 1}, {10, 6}, {11, 6}, {11, 9}};
        int fileCount = 0;
        for (int i = 0; i < 5; ++i) {
            for (short[] testCase : testSuite) {
                short replication = testCase[0];
                short additionalReplication = testCase[1];
                String src = "/testfile" + fileCount++;
                HdfsFileStatus fileStatus = this.namesystem.startFile(src, this.perm, clientMachine, clientMachine, EnumSet.of(CreateFlag.CREATE), true, replication, 1024L, null, null, null, false);
                LocatedBlock locatedBlock = this.nameNodeRpc.addBlock(src, clientMachine, null, null, fileStatus.getFileId(), null, null);
                this.doTestLocatedBlock(replication, locatedBlock);
                LocatedBlock additionalLocatedBlock = this.nameNodeRpc.getAdditionalDatanode(src, fileStatus.getFileId(), locatedBlock.getBlock(), (DatanodeInfo[])locatedBlock.getLocations(), locatedBlock.getStorageIDs(), DatanodeInfo.EMPTY_ARRAY, (int)additionalReplication, clientMachine);
                this.doTestLocatedBlock(replication + additionalReplication, additionalLocatedBlock);
            }
        }
    }

    private void doTestChooseTargetSpecialCase() throws Exception {
        String clientMachine = "client.foo.com";
        String src = "/testfile_1_";
        HdfsFileStatus fileStatus = this.namesystem.startFile(src, this.perm, clientMachine, clientMachine, EnumSet.of(CreateFlag.CREATE), true, (short)20, 1024L, null, null, null, false);
        LocatedBlock locatedBlock = this.nameNodeRpc.addBlock(src, clientMachine, null, null, fileStatus.getFileId(), null, null);
        this.doTestLocatedBlock(20, locatedBlock);
        DatanodeInfoWithStorage[] locs = locatedBlock.getLocations();
        String[] storageIDs = locatedBlock.getStorageIDs();
        for (int time = 0; time < 5; ++time) {
            this.shuffle((DatanodeInfo[])locs, storageIDs);
            for (int i = 1; i < locs.length; ++i) {
                DatanodeInfo[] partLocs = new DatanodeInfo[i];
                String[] partStorageIDs = new String[i];
                System.arraycopy(locs, 0, partLocs, 0, i);
                System.arraycopy(storageIDs, 0, partStorageIDs, 0, i);
                for (int j = 1; j < 20 - i; ++j) {
                    LocatedBlock additionalLocatedBlock = this.nameNodeRpc.getAdditionalDatanode(src, fileStatus.getFileId(), locatedBlock.getBlock(), partLocs, partStorageIDs, DatanodeInfo.EMPTY_ARRAY, j, clientMachine);
                    this.doTestLocatedBlock(i + j, additionalLocatedBlock);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testPlacementWithOnlyOneNodeInRackDecommission() throws Exception {
        HdfsConfiguration conf = new HdfsConfiguration();
        String[] racks = new String[]{"/RACK0", "/RACK0", "/RACK2", "/RACK3", "/RACK4", "/RACK5", "/RACK2"};
        String[] hosts = new String[]{"/host0", "/host1", "/host2", "/host3", "/host4", "/host5", "/host6"};
        conf.setClass("dfs.block.replicator.classname", BlockPlacementPolicyRackFaultTolerant.class, BlockPlacementPolicy.class);
        conf.setBoolean("dfs.use.dfs.network.topology", true);
        conf.setLong("dfs.blocksize", 1024L);
        conf.setInt("dfs.bytes-per-checksum", 512);
        if (this.cluster != null) {
            this.cluster.shutdown();
        }
        this.cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(7).racks(racks).hosts(hosts).build();
        this.cluster.waitActive();
        this.nameNodeRpc = this.cluster.getNameNodeRpc();
        this.namesystem = this.cluster.getNamesystem();
        DistributedFileSystem fs = this.cluster.getFileSystem();
        fs.enableErasureCodingPolicy("RS-3-2-1024k");
        fs.setErasureCodingPolicy(new Path("/"), "RS-3-2-1024k");
        BlockManager bm = this.cluster.getNamesystem().getBlockManager();
        DatanodeManager dm = bm.getDatanodeManager();
        Assertions.assertTrue((boolean)(dm.getNetworkTopology() instanceof DFSNetworkTopology));
        String clientMachine = "/host4";
        String clientRack = "/RACK4";
        String src = "/test";
        DatanodeManager dnm = this.namesystem.getBlockManager().getDatanodeManager();
        DatanodeDescriptor dnd4 = dnm.getDatanode(this.cluster.getDataNodes().get(4).getDatanodeId());
        Assertions.assertEquals((Object)dnd4.getNetworkLocation(), (Object)clientRack);
        dnm.getDatanodeAdminManager().startDecommission(dnd4);
        short replication = 5;
        int additionalReplication = 1;
        try {
            HdfsFileStatus fileStatus = this.namesystem.startFile(src, this.perm, clientMachine, clientMachine, EnumSet.of(CreateFlag.CREATE), true, replication, 0xA00000L, null, null, null, false);
            LocatedBlock locatedBlock = this.nameNodeRpc.addBlock(src, clientMachine, null, null, fileStatus.getFileId(), null, null);
            HashMap<String, Integer> racksCount = new HashMap<String, Integer>();
            this.doTestLocatedBlockRacks(racksCount, replication, 4, locatedBlock);
            LocatedBlock additionalLocatedBlock = this.nameNodeRpc.getAdditionalDatanode(src, fileStatus.getFileId(), locatedBlock.getBlock(), (DatanodeInfo[])locatedBlock.getLocations(), locatedBlock.getStorageIDs(), DatanodeInfo.EMPTY_ARRAY, additionalReplication, clientMachine);
            racksCount.clear();
            this.doTestLocatedBlockRacks(racksCount, additionalReplication + replication, 4, additionalLocatedBlock);
            Assertions.assertEquals((Integer)racksCount.get("/RACK0"), (Integer)2);
            Assertions.assertEquals((Integer)racksCount.get("/RACK2"), (Integer)2);
        }
        finally {
            dnm.getDatanodeAdminManager().stopDecommission(dnd4);
        }
        final DatanodeDescriptor dnd3 = dnm.getDatanode(this.cluster.getDataNodes().get(3).getDatanodeId());
        this.cluster.getNamesystem().writeLock(RwLockMode.BM);
        try {
            dm.getDatanodeAdminManager().startDecommission(dnd3);
        }
        finally {
            this.cluster.getNamesystem().writeUnlock(RwLockMode.BM, "testPlacementWithOnlyOneNodeInRackDecommission");
        }
        GenericTestUtils.waitFor((Supplier)new Supplier<Boolean>(){

            @Override
            public Boolean get() {
                return dnd3.isDecommissioned();
            }
        }, (long)1000L, (long)10000L);
        LocatedBlocks locatedBlocks = this.cluster.getFileSystem().getClient().getLocatedBlocks(src, 0L, 1024L);
        Assertions.assertEquals((int)4, (int)bm.getDatanodeManager().getNetworkTopology().getNumOfNonEmptyRacks());
        for (LocatedBlock block : locatedBlocks.getLocatedBlocks()) {
            BlockPlacementStatus status = bm.getStriptedBlockPlacementPolicy().verifyBlockPlacement((DatanodeInfo[])block.getLocations(), 5);
            Assertions.assertTrue((boolean)status.isPlacementPolicySatisfied());
        }
    }

    private void shuffle(DatanodeInfo[] locs, String[] storageIDs) {
        int i;
        int length = locs.length;
        Object[][] pairs = new Object[length][];
        for (i = 0; i < length; ++i) {
            pairs[i] = new Object[]{locs[i], storageIDs[i]};
        }
        Collections.shuffle(Arrays.asList(pairs));
        for (i = 0; i < length; ++i) {
            locs[i] = (DatanodeInfo)pairs[i][0];
            storageIDs[i] = (String)pairs[i][1];
        }
    }

    private void doTestLocatedBlock(int replication, LocatedBlock locatedBlock) {
        Assertions.assertEquals((int)replication, (int)locatedBlock.getLocations().length);
        HashMap<String, Integer> racksCount = new HashMap<String, Integer>();
        for (DatanodeInfoWithStorage node : locatedBlock.getLocations()) {
            this.addToRacksCount(node.getNetworkLocation(), racksCount);
        }
        int minCount = Integer.MAX_VALUE;
        int maxCount = Integer.MIN_VALUE;
        for (Integer rackCount : racksCount.values()) {
            minCount = Math.min(minCount, rackCount);
            maxCount = Math.max(maxCount, rackCount);
        }
        Assertions.assertTrue((maxCount - minCount <= 1 ? 1 : 0) != 0);
    }

    private void doTestLocatedBlockRacks(HashMap<String, Integer> racksCount, int replication, int validracknum, LocatedBlock locatedBlock) {
        Assertions.assertEquals((int)replication, (int)locatedBlock.getLocations().length);
        for (DatanodeInfoWithStorage node : locatedBlock.getLocations()) {
            this.addToRacksCount(node.getNetworkLocation(), racksCount);
        }
        Assertions.assertEquals((int)validracknum, (int)racksCount.size());
    }

    private void addToRacksCount(String rack, HashMap<String, Integer> racksCount) {
        Integer count = racksCount.get(rack);
        if (count == null) {
            racksCount.put(rack, 1);
        } else {
            racksCount.put(rack, count + 1);
        }
    }
}

