/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode;

import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.server.namenode.AuditLogger;
import org.apache.hadoop.security.AuthorizationContext;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestAuthorizationHeaderPropagation {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testAuthorizationHeaderPerRpc() throws Exception {
        HdfsConfiguration conf = new HdfsConfiguration();
        conf.set("dfs.namenode.audit.loggers", HeaderCapturingAuditLogger.class.getName());
        MiniDFSCluster cluster = new MiniDFSCluster.Builder((Configuration)conf).build();
        try {
            cluster.waitClusterUp();
            HeaderCapturingAuditLogger.capturedHeaders.clear();
            DistributedFileSystem fs = cluster.getFileSystem();
            byte[] header1 = "header-one".getBytes();
            AuthorizationContext.setCurrentAuthorizationHeader((byte[])header1);
            fs.mkdirs(new Path("/authz1"));
            AuthorizationContext.clear();
            byte[] header2 = "header-two".getBytes();
            AuthorizationContext.setCurrentAuthorizationHeader((byte[])header2);
            fs.mkdirs(new Path("/authz2"));
            AuthorizationContext.clear();
            fs.mkdirs(new Path("/authz3"));
            Assertions.assertArrayEquals((byte[])header1, (byte[])HeaderCapturingAuditLogger.capturedHeaders.get(0));
            Assertions.assertArrayEquals((byte[])header2, (byte[])HeaderCapturingAuditLogger.capturedHeaders.get(1));
            Assertions.assertNull((Object)HeaderCapturingAuditLogger.capturedHeaders.get(2));
        }
        finally {
            cluster.shutdown();
        }
    }

    public static class HeaderCapturingAuditLogger
    implements AuditLogger {
        public static final List<byte[]> capturedHeaders = new ArrayList<byte[]>();

        public void initialize(Configuration conf) {
        }

        public void logAuditEvent(boolean succeeded, String userName, InetAddress addr, String cmd, String src, String dst, FileStatus stat) {
            byte[] header = AuthorizationContext.getCurrentAuthorizationHeader();
            capturedHeaders.add(header == null ? null : Arrays.copyOf(header, header.length));
        }
    }
}

