/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.regex.Pattern;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.hdfs.DFSTestUtil;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.server.namenode.FSNamesystem;
import org.apache.hadoop.hdfs.web.WebHdfsFileSystem;
import org.apache.hadoop.hdfs.web.WebHdfsTestUtil;
import org.apache.hadoop.security.AccessControlException;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.test.GenericTestUtils;
import org.apache.log4j.AsyncAppender;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedClass;
import org.junit.jupiter.params.provider.MethodSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@MethodSource(value={"data"})
@ParameterizedClass
public class TestAuditLogs {
    private static final Logger LOG = LoggerFactory.getLogger(TestAuditLogs.class);
    final boolean useAsyncEdits;
    private static GenericTestUtils.LogCapturer auditLogCapture;
    private static final Pattern AUDIT_PATTERN;
    private static final Pattern SUCCESS_PATTERN;
    private static final Pattern FAILURE_PATTERN;
    private static final Pattern WEB_OPEN_PATTERN;
    static final String username = "bob";
    static final String[] groups;
    static final String fileName = "/srcdat";
    DFSTestUtil util;
    MiniDFSCluster cluster;
    FileSystem fs;
    String[] fnames;
    Configuration conf;
    UserGroupInformation userGroupInfo;

    public static Collection<Object[]> data() {
        ArrayList<Object[]> params = new ArrayList<Object[]>();
        params.add(new Object[]{Boolean.FALSE});
        params.add(new Object[]{Boolean.TRUE});
        return params;
    }

    public TestAuditLogs(boolean useAsyncEdits) {
        this.useAsyncEdits = useAsyncEdits;
    }

    @BeforeEach
    public void setupCluster() throws Exception {
        this.conf = new HdfsConfiguration();
        long precision = 1L;
        this.conf.setLong("dfs.namenode.accesstime.precision", 1L);
        this.conf.setLong("dfs.blockreport.intervalMsec", 10000L);
        this.conf.setBoolean("dfs.namenode.edits.asynclogging", this.useAsyncEdits);
        this.util = new DFSTestUtil.Builder().setName("TestAuditAllowed").setNumFiles(20).build();
        this.cluster = new MiniDFSCluster.Builder(this.conf).numDataNodes(4).build();
        this.fs = this.cluster.getFileSystem();
        this.util.createFiles(this.fs, fileName);
        org.apache.log4j.Logger logger = org.apache.log4j.Logger.getLogger((String)"org.apache.hadoop.hdfs.server.namenode.FSNamesystem.audit");
        ArrayList appenders = Collections.list(logger.getAllAppenders());
        Assertions.assertTrue((boolean)(appenders.get(0) instanceof AsyncAppender));
        this.fnames = this.util.getFileNames(fileName);
        this.util.waitReplication(this.fs, fileName, (short)3);
        this.userGroupInfo = UserGroupInformation.createUserForTesting((String)username, (String[])groups);
    }

    @AfterEach
    public void teardownCluster() throws Exception {
        this.util.cleanup(this.fs, fileName);
        if (this.fs != null) {
            this.fs.close();
            this.fs = null;
        }
        if (this.cluster != null) {
            this.cluster.shutdown();
            this.cluster = null;
        }
    }

    @BeforeAll
    public static void beforeClass() {
        auditLogCapture = GenericTestUtils.LogCapturer.captureLogs((Logger)FSNamesystem.AUDIT_LOG);
    }

    @AfterAll
    public static void afterClass() {
        auditLogCapture.stopCapturing();
    }

    @Test
    public void testAuditAllowed() throws Exception {
        Path file = new Path(this.fnames[0]);
        FileSystem userfs = DFSTestUtil.getFileSystemAs(this.userGroupInfo, this.conf);
        FSDataInputStream istream = userfs.open(file);
        int val = istream.read();
        istream.close();
        this.verifySuccessCommandsAuditLogs(2, this.fnames[0], "cmd=open");
        Assertions.assertTrue((val >= 0 ? 1 : 0) != 0, (String)"failed to read from file");
    }

    @Test
    public void testAuditAllowedStat() throws Exception {
        Path file = new Path(this.fnames[0]);
        FileSystem userfs = DFSTestUtil.getFileSystemAs(this.userGroupInfo, this.conf);
        FileStatus st = userfs.getFileStatus(file);
        this.verifySuccessCommandsAuditLogs(2, this.fnames[0], "cmd=getfileinfo");
        Assertions.assertTrue((st != null && st.isFile() ? 1 : 0) != 0, (String)"failed to stat file");
    }

    @Test
    public void testAuditDenied() throws Exception {
        Path file = new Path(this.fnames[0]);
        FileSystem userfs = DFSTestUtil.getFileSystemAs(this.userGroupInfo, this.conf);
        this.fs.setPermission(file, new FsPermission(384));
        this.fs.setOwner(file, "root", null);
        try {
            userfs.open(file);
            Assertions.fail((String)"open must not succeed");
        }
        catch (AccessControlException e) {
            System.out.println("got access denied, as expected.");
        }
        this.verifyFailedCommandsAuditLogs(1, this.fnames[0], "cmd=open");
    }

    @Test
    public void testAuditWebHdfs() throws Exception {
        Path file = new Path(this.fnames[0]);
        this.fs.setPermission(file, new FsPermission(420));
        this.fs.setOwner(file, "root", null);
        WebHdfsFileSystem webfs = WebHdfsTestUtil.getWebHdfsFileSystemAs(this.userGroupInfo, this.conf, "webhdfs");
        FSDataInputStream istream = webfs.open(file);
        int val = istream.read();
        istream.close();
        this.verifySuccessCommandsAuditLogs(3, this.fnames[0], "cmd=open");
        Assertions.assertTrue((val >= 0 ? 1 : 0) != 0, (String)"failed to read from file");
    }

    @Test
    public void testAuditWebHdfsStat() throws Exception {
        Path file = new Path(this.fnames[0]);
        this.fs.setPermission(file, new FsPermission(420));
        this.fs.setOwner(file, "root", null);
        WebHdfsFileSystem webfs = WebHdfsTestUtil.getWebHdfsFileSystemAs(this.userGroupInfo, this.conf, "webhdfs");
        FileStatus st = webfs.getFileStatus(file);
        this.verifySuccessCommandsAuditLogs(2, this.fnames[0], "cmd=getfileinfo");
        Assertions.assertTrue((st != null && st.isFile() ? 1 : 0) != 0, (String)"failed to stat file");
    }

    @Test
    public void testAuditWebHdfsDenied() throws Exception {
        Path file = new Path(this.fnames[0]);
        this.fs.setPermission(file, new FsPermission(384));
        this.fs.setOwner(file, "root", null);
        try {
            WebHdfsFileSystem webfs = WebHdfsTestUtil.getWebHdfsFileSystemAs(this.userGroupInfo, this.conf, "webhdfs");
            FSDataInputStream istream = webfs.open(file);
            int val = istream.read();
            Assertions.fail((String)("open+read must not succeed, got " + val));
        }
        catch (AccessControlException E) {
            System.out.println("got access denied, as expected.");
        }
        this.verifyFailedCommandsAuditLogs(1, this.fnames[0], "cmd=open");
    }

    @Test
    public void testAuditWebHdfsOpen() throws Exception {
        Path file = new Path(this.fnames[0]);
        this.fs.setPermission(file, new FsPermission(420));
        this.fs.setOwner(file, "root", null);
        WebHdfsFileSystem webfs = WebHdfsTestUtil.getWebHdfsFileSystemAs(this.userGroupInfo, this.conf, "webhdfs");
        webfs.open(file).read();
        this.verifySuccessCommandsAuditLogs(3, this.fnames[0], "cmd=open");
    }

    @Test
    public void testAuditCharacterEscape() throws Exception {
        Path file = new Path("foo\r\nbar");
        this.fs.create(file);
        this.verifySuccessCommandsAuditLogs(1, "foo", "cmd=create");
    }

    private void verifySuccessCommandsAuditLogs(int leastExpected, String file, String cmd) {
        String[] auditLogOutputLines = auditLogCapture.getOutput().split("\\n");
        int success = 0;
        for (String auditLogLine : auditLogOutputLines) {
            if (!auditLogLine.contains("allowed=")) continue;
            String line = "allowed=" + auditLogLine.split("allowed=")[1];
            LOG.info("Line: {}", (Object)line);
            if (!SUCCESS_PATTERN.matcher(line).matches() || !line.contains(file) || !line.contains(cmd)) continue;
            Assertions.assertTrue((boolean)AUDIT_PATTERN.matcher(line).matches(), (String)"Expected audit event not found in audit log");
            LOG.info("Successful verification. Log line: {}", (Object)line);
            ++success;
        }
        if (success < leastExpected) {
            throw new AssertionError((Object)("Least expected: " + leastExpected + ". Actual success: " + success));
        }
    }

    private void verifyFailedCommandsAuditLogs(int expected, String file, String cmd) {
        String[] auditLogOutputLines = auditLogCapture.getOutput().split("\\n");
        int success = 0;
        for (String auditLogLine : auditLogOutputLines) {
            if (!auditLogLine.contains("allowed=")) continue;
            String line = "allowed=" + auditLogLine.split("allowed=")[1];
            LOG.info("Line: {}", (Object)line);
            if (!FAILURE_PATTERN.matcher(line).matches() || !line.contains(file) || !line.contains(cmd)) continue;
            Assertions.assertTrue((boolean)AUDIT_PATTERN.matcher(line).matches(), (String)"Expected audit event not found in audit log");
            LOG.info("Failure verification. Log line: {}", (Object)line);
            ++success;
        }
        Assertions.assertEquals((int)expected, (int)success, (String)("Expected: " + expected + ". Actual failure: " + success));
    }

    static {
        AUDIT_PATTERN = Pattern.compile("allowed=.*?\\sugi=.*?\\sip=/\\d{1,3}\\.\\d{1,3}\\.\\d{1,3}\\.\\d{1,3}\\scmd=.*?\\ssrc=.*?\\sdst=null\\sperm=.*?");
        SUCCESS_PATTERN = Pattern.compile(".*allowed=true.*");
        FAILURE_PATTERN = Pattern.compile(".*allowed=false.*");
        WEB_OPEN_PATTERN = Pattern.compile(".*cmd=open.*proto=webhdfs.*");
        groups = new String[]{"group1"};
    }
}

