/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode;

import java.io.IOException;
import java.security.PrivilegedExceptionAction;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.BatchedRemoteIterator;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.hdfs.DFSTestUtil;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.protocol.CacheDirectiveInfo;
import org.apache.hadoop.hdfs.protocol.CachePoolEntry;
import org.apache.hadoop.hdfs.protocol.CachePoolInfo;
import org.apache.hadoop.hdfs.protocol.HdfsConstants;
import org.apache.hadoop.hdfs.protocol.LocatedBlock;
import org.apache.hadoop.hdfs.server.namenode.FSDirectory;
import org.apache.hadoop.hdfs.server.namenode.FSNamesystem;
import org.apache.hadoop.hdfs.server.namenode.FSPermissionChecker;
import org.apache.hadoop.hdfs.server.namenode.INodesInPath;
import org.apache.hadoop.hdfs.server.namenode.NameNodeRpcServer;
import org.apache.hadoop.hdfs.server.protocol.DatanodeStorageReport;
import org.apache.hadoop.hdfs.server.protocol.NamenodeProtocols;
import org.apache.hadoop.ipc.RPC;
import org.apache.hadoop.ipc.Server;
import org.apache.hadoop.security.AccessControlException;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.test.GenericTestUtils;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.slf4j.Logger;

public class TestAuditLoggerWithCommands {
    static final int NUM_DATA_NODES = 2;
    static final long seed = 3735928559L;
    static final int blockSize = 8192;
    private static MiniDFSCluster cluster = null;
    private static FileSystem fileSys = null;
    private static FileSystem fs2 = null;
    private static FileSystem fs = null;
    private static GenericTestUtils.LogCapturer auditlog;
    static Configuration conf;
    static UserGroupInformation user1;
    static UserGroupInformation user2;
    private static NamenodeProtocols proto;

    @BeforeEach
    public void initialize() throws Exception {
        conf = new HdfsConfiguration();
        conf.setBoolean("dfs.permissions.enabled", true);
        conf.setBoolean("dfs.namenode.acls.enabled", true);
        conf.setBoolean("dfs.namenode.delegation.token.always-use", true);
        conf.setBoolean("hadoop.security.authorization", true);
        cluster = new MiniDFSCluster.Builder(conf).numDataNodes(2).build();
        cluster.waitActive();
        user1 = UserGroupInformation.createUserForTesting((String)"theDoctor", (String[])new String[]{"tardis"});
        user2 = UserGroupInformation.createUserForTesting((String)"theEngineer", (String[])new String[]{"hadoop"});
        auditlog = GenericTestUtils.LogCapturer.captureLogs((Logger)FSNamesystem.AUDIT_LOG);
        proto = cluster.getNameNodeRpc();
        fileSys = DFSTestUtil.getFileSystemAs(user1, conf);
        fs2 = DFSTestUtil.getFileSystemAs(user2, conf);
        fs = cluster.getFileSystem();
    }

    @AfterEach
    public void tearDown() throws Exception {
        Server.getCurCall().set(null);
        fs.close();
        fs2.close();
        fileSys.close();
        cluster.shutdown();
    }

    @Test
    public void testGetContentSummary() throws IOException {
        Path dir1 = new Path("/dir1");
        Path dir2 = new Path("/dir2");
        String acePattern = ".*allowed=false.*ugi=theEngineer.*cmd=contentSummary.*";
        fs.mkdirs(dir1, new FsPermission(384));
        fs.mkdirs(dir2, new FsPermission(384));
        fs.setOwner(dir1, user1.getUserName(), user1.getPrimaryGroupName());
        fs.setOwner(dir2, user2.getUserName(), user2.getPrimaryGroupName());
        try {
            fs2.getContentSummary(new Path("/"));
            Assertions.fail((String)"The operation should have failed with AccessControlException");
        }
        catch (AccessControlException accessControlException) {
            // empty catch block
        }
        int length = this.verifyAuditLogs(acePattern);
        try {
            fs2.getContentSummary(new Path("/dir3"));
            Assertions.fail((String)"The operation should have failed with IOException");
        }
        catch (IOException iOException) {
            // empty catch block
        }
        Assertions.assertTrue((length == auditlog.getOutput().split("\n").length ? 1 : 0) != 0, (String)"Unexpected log from getContentSummary");
    }

    @Test
    public void testSetQuota() throws Exception {
        Path path = new Path("/testdir/testdir1");
        fs.mkdirs(path);
        fileSys = DFSTestUtil.getFileSystemAs(user1, conf);
        this.verifySetQuota(path, -1L, Long.MAX_VALUE);
        this.verifySetQuota(path, Long.MAX_VALUE, -1L);
        this.verifySetQuota(path, Long.MAX_VALUE, 4L);
        this.verifySetQuota(path, 4L, 4L);
        fileSys.close();
    }

    private void verifySetQuota(Path path, long nsQuota, long ssQuota) throws IOException {
        String operationName = cluster.getNamesystem().getQuotaCommand(nsQuota, ssQuota);
        String acePattern = ".*allowed=false.*ugi=theDoctor.*cmd=.*" + operationName + ".*";
        try {
            ((DistributedFileSystem)fileSys).setQuota(path, nsQuota, ssQuota);
            Assertions.fail((String)"The operation should have failed");
        }
        catch (AccessControlException accessControlException) {
            // empty catch block
        }
        this.verifyAuditLogs(acePattern);
    }

    @Test
    public void testConcat() throws Exception {
        Path file1 = new Path("/file1");
        Path file2 = new Path("/file2");
        Path targetDir = new Path("/target");
        String acePattern = ".*allowed=false.*ugi=theDoctor.*cmd=concat.*";
        fs.createNewFile(file1);
        fs.createNewFile(file2);
        fs.mkdirs(targetDir);
        fileSys = DFSTestUtil.getFileSystemAs(user1, conf);
        try {
            fileSys.concat(targetDir, new Path[]{file1, file2});
            Assertions.fail((String)"The operation should have failed with AccessControlException");
        }
        catch (AccessControlException accessControlException) {
            // empty catch block
        }
        int length = this.verifyAuditLogs(acePattern);
        fileSys.close();
        try {
            fileSys.concat(targetDir, new Path[]{file1, file2});
            Assertions.fail((String)"The operation should have failed with IOException");
        }
        catch (IOException iOException) {
            // empty catch block
        }
        Assertions.assertTrue((length == auditlog.getOutput().split("\n").length ? 1 : 0) != 0, (String)"Unexpected log from Concat");
    }

    @Test
    public void testCreateRenameSnapShot() throws Exception {
        Path srcDir = new Path("/src");
        String aceCreatePattern = ".*allowed=false.*ugi=theDoctor.*cmd=createSnapshot.*";
        String aceRenamePattern = ".*allowed=false.*ugi=theDoctor.*cmd=renameSnapshot.*";
        fs.mkdirs(srcDir);
        fileSys = DFSTestUtil.getFileSystemAs(user1, conf);
        ((DistributedFileSystem)fs).allowSnapshot(srcDir);
        try {
            fileSys.createSnapshot(srcDir);
            Assertions.fail((String)"The operation should have failed with AccessControlException");
        }
        catch (AccessControlException accessControlException) {
            // empty catch block
        }
        this.verifyAuditLogs(aceCreatePattern);
        try {
            Path s1 = fs.createSnapshot(srcDir);
            fileSys.renameSnapshot(srcDir, s1.getName(), "test");
            Assertions.fail((String)"The operation should have failed with AccessControlException");
        }
        catch (AccessControlException s1) {
            // empty catch block
        }
        int length = auditlog.getOutput().split("\n").length;
        this.verifyAuditLogs(aceRenamePattern);
        try {
            fs.createSnapshot(new Path("/test1"));
            Assertions.fail((String)"The operation should have failed with IOException");
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try {
            fs.renameSnapshot(new Path("/test1"), "abc", "test2");
            Assertions.fail((String)"The operation should have failed with IOException");
        }
        catch (IOException iOException) {
            // empty catch block
        }
        Assertions.assertTrue((length == auditlog.getOutput().split("\n").length ? 1 : 0) != 0, (String)"Unexpected log!");
    }

    @Test
    public void testDeleteSnapshot() throws Exception {
        Path s1;
        Path srcDir = new Path("/src");
        fs.mkdirs(srcDir);
        fileSys = DFSTestUtil.getFileSystemAs(user1, conf);
        ((DistributedFileSystem)fs).allowSnapshot(srcDir);
        try {
            s1 = fs.createSnapshot(srcDir);
            fileSys.deleteSnapshot(srcDir, s1.getName());
            Assertions.fail((String)"The operation should have failed with AccessControlException");
        }
        catch (AccessControlException accessControlException) {
            // empty catch block
        }
        String aceDeletePattern = ".*allowed=false.*ugi=theDoctor.*cmd=deleteSnapshot.*";
        int length = this.verifyAuditLogs(aceDeletePattern);
        fileSys.close();
        try {
            s1 = fs.createSnapshot(srcDir);
            fileSys.deleteSnapshot(srcDir, s1.getName());
            Assertions.fail((String)"The operation should have failed with IOException");
        }
        catch (IOException iOException) {
            // empty catch block
        }
        Assertions.assertTrue((length + 1 == auditlog.getOutput().split("\n").length ? 1 : 0) != 0, (String)"Unexpected log!");
    }

    @Test
    public void testAllowSnapshot() throws Exception {
        Path srcDir = new Path(System.getProperty("user.dir"), "/src");
        fs.mkdirs(srcDir);
        String pattern = ".*allowed=true.*ugi=" + System.getProperty("user.name") + ".*cmd=allowSnapshot.*";
        try {
            ((DistributedFileSystem)fs).allowSnapshot(srcDir);
            this.verifyAuditLogs(pattern);
        }
        catch (Exception e) {
            Assertions.fail((String)"The operation should not have failed with Exception");
        }
        fileSys = DFSTestUtil.getFileSystemAs(user1, conf);
        try {
            ((DistributedFileSystem)fileSys).allowSnapshot(srcDir);
            Assertions.fail((String)"The operation should have failed with AccessControlException");
        }
        catch (AccessControlException accessControlException) {
            // empty catch block
        }
        pattern = ".*allowed=false.*ugi=theDoctor.*cmd=allowSnapshot.*";
        this.verifyAuditLogs(pattern);
        fs.delete(srcDir, true);
        fileSys.close();
    }

    @Test
    public void testDisallowSnapshot() throws Exception {
        Path srcDir = new Path(System.getProperty("user.dir"), "/src");
        fs.mkdirs(srcDir);
        cluster.getNamesystem().allowSnapshot(srcDir.toString());
        String pattern = ".*allowed=true.*ugi=" + System.getProperty("user.name") + ".*cmd=disallowSnapshot.*";
        try {
            ((DistributedFileSystem)fs).disallowSnapshot(srcDir);
            this.verifyAuditLogs(pattern);
        }
        catch (Exception e) {
            Assertions.fail((String)"The operation should not have failed with Exception");
        }
        cluster.getNamesystem().allowSnapshot(srcDir.toString());
        fileSys = DFSTestUtil.getFileSystemAs(user1, conf);
        try {
            ((DistributedFileSystem)fileSys).disallowSnapshot(srcDir);
            Assertions.fail((String)"The operation should have failed with AccessControlException");
        }
        catch (AccessControlException ace) {
            pattern = ".*allowed=false.*ugi=theDoctor.*cmd=disallowSnapshot.*";
            this.verifyAuditLogs(pattern);
        }
        fileSys.close();
    }

    @Test
    public void testAddCacheDirective() throws Exception {
        this.removeExistingCachePools(null);
        proto.addCachePool(new CachePoolInfo("pool1").setMode(new FsPermission(0)));
        CacheDirectiveInfo alpha = new CacheDirectiveInfo.Builder().setPath(new Path(System.getProperty("user.dir"), "/alpha")).setPool("pool1").build();
        fileSys = DFSTestUtil.getFileSystemAs(user1, conf);
        try {
            ((DistributedFileSystem)fileSys).addCacheDirective(alpha);
            Assertions.fail((String)"The operation should have failed with AccessControlException");
        }
        catch (AccessControlException accessControlException) {
            // empty catch block
        }
        String aceAddCachePattern = ".*allowed=false.*ugi=theDoctor.*cmd=addCache.*";
        int length = this.verifyAuditLogs(aceAddCachePattern);
        try {
            fileSys.close();
            ((DistributedFileSystem)fileSys).addCacheDirective(alpha);
            Assertions.fail((String)"The operation should have failed with IOException");
        }
        catch (IOException iOException) {
            // empty catch block
        }
        Assertions.assertTrue((length == auditlog.getOutput().split("\n").length ? 1 : 0) != 0, (String)"Unexpected log!");
    }

    @Test
    public void testModifyCacheDirective() throws Exception {
        this.removeExistingCachePools(null);
        proto.addCachePool(new CachePoolInfo("pool1").setMode(new FsPermission(0)));
        CacheDirectiveInfo alpha = new CacheDirectiveInfo.Builder().setPath(new Path("/alpha")).setPool("pool1").build();
        fileSys = DFSTestUtil.getFileSystemAs(user1, conf);
        Long id = ((DistributedFileSystem)fs).addCacheDirective(alpha);
        try {
            ((DistributedFileSystem)fileSys).modifyCacheDirective(new CacheDirectiveInfo.Builder().setId(id).setReplication(Short.valueOf((short)1)).build());
            Assertions.fail((String)"The operation should have failed with AccessControlException");
        }
        catch (AccessControlException accessControlException) {
            // empty catch block
        }
        String aceModifyCachePattern = ".*allowed=false.*ugi=theDoctor.*cmd=modifyCache.*";
        this.verifyAuditLogs(aceModifyCachePattern);
        fileSys.close();
        try {
            ((DistributedFileSystem)fileSys).modifyCacheDirective(new CacheDirectiveInfo.Builder().setId(id).setReplication(Short.valueOf((short)1)).build());
            Assertions.fail((String)"The operation should have failed with IOException");
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Test
    public void testRemoveCacheDirective() throws Exception {
        this.removeExistingCachePools(null);
        proto.addCachePool(new CachePoolInfo("pool1").setMode(new FsPermission(0)));
        CacheDirectiveInfo alpha = new CacheDirectiveInfo.Builder().setPath(new Path("/alpha")).setPool("pool1").build();
        String aceRemoveCachePattern = ".*allowed=false.*ugi=theDoctor.*cmd=removeCache.*";
        int length = -1;
        Long id = ((DistributedFileSystem)fs).addCacheDirective(alpha);
        fileSys = DFSTestUtil.getFileSystemAs(user1, conf);
        try {
            ((DistributedFileSystem)fileSys).removeCacheDirective(id.longValue());
            Assertions.fail((String)"It should have failed with an AccessControlException");
        }
        catch (AccessControlException ace) {
            length = this.verifyAuditLogs(aceRemoveCachePattern);
        }
        try {
            fileSys.close();
            ((DistributedFileSystem)fileSys).removeCacheDirective(id.longValue());
            Assertions.fail((String)"The operation should have failed with IOException");
        }
        catch (IOException iOException) {
            // empty catch block
        }
        Assertions.assertTrue((length == auditlog.getOutput().split("\n").length ? 1 : 0) != 0, (String)"Unexpected log!");
    }

    @Test
    public void testGetSnapshotDiffReport() throws Exception {
        Path snapshotDirPath = new Path("/test");
        fs.mkdirs(snapshotDirPath, new FsPermission(0));
        cluster.getNamesystem().allowSnapshot(snapshotDirPath.toString());
        Path s1 = fs.createSnapshot(snapshotDirPath);
        Path s2 = fs.createSnapshot(snapshotDirPath);
        fileSys = DFSTestUtil.getFileSystemAs(user1, conf);
        try {
            ((DistributedFileSystem)fileSys).getSnapshotDiffReport(snapshotDirPath, s1.getName(), s2.getName());
            Assertions.fail((String)"The operation should have failed with AccessControlException");
        }
        catch (AccessControlException accessControlException) {
            // empty catch block
        }
        String aceSnapshotDiffPattern = ".*allowed=false.*ugi=theDoctor.*cmd=computeSnapshotDiff.*";
        int length = this.verifyAuditLogs(aceSnapshotDiffPattern);
        try {
            fileSys.close();
            ((DistributedFileSystem)fileSys).getSnapshotDiffReport(snapshotDirPath, s1.getName(), s2.getName());
            Assertions.fail((String)"The operation should have failed with IOException");
        }
        catch (IOException iOException) {
            // empty catch block
        }
        Assertions.assertTrue((length == auditlog.getOutput().split("\n").length ? 1 : 0) != 0, (String)"Unexpected log!");
    }

    @Test
    public void testGetQuotaUsage() throws Exception {
        Path path = new Path("/test");
        fs.mkdirs(path, new FsPermission(0));
        String aceGetQuotaUsagePattern = ".*allowed=false.*ugi=theDoctor.*cmd=quotaUsage.*";
        fileSys = DFSTestUtil.getFileSystemAs(user1, conf);
        try {
            fileSys.getQuotaUsage(path);
            Assertions.fail((String)"The operation should have failed with AccessControlException");
        }
        catch (AccessControlException accessControlException) {
            // empty catch block
        }
        int length = this.verifyAuditLogs(aceGetQuotaUsagePattern);
        fileSys.close();
        try {
            fileSys.getQuotaUsage(path);
            Assertions.fail((String)"The operation should have failed with IOException");
        }
        catch (IOException iOException) {
            // empty catch block
        }
        Assertions.assertTrue((length == auditlog.getOutput().split("\n").length ? 1 : 0) != 0, (String)"Unexpected log!");
    }

    @Test
    public void testAddCachePool() throws Exception {
        this.removeExistingCachePools(null);
        CachePoolInfo cacheInfo = new CachePoolInfo("pool1").setMode(new FsPermission(0));
        fileSys = DFSTestUtil.getFileSystemAs(user1, conf);
        try {
            ((DistributedFileSystem)fileSys).addCachePool(cacheInfo);
            Assertions.fail((String)"The operation should have failed with AccessControlException");
        }
        catch (AccessControlException accessControlException) {
            // empty catch block
        }
        String aceAddCachePoolPattern = ".*allowed=false.*ugi=theDoctor.*cmd=addCachePool.*";
        int length = this.verifyAuditLogs(aceAddCachePoolPattern);
        try {
            fileSys.close();
            ((DistributedFileSystem)fileSys).addCachePool(cacheInfo);
            Assertions.fail((String)"The operation should have failed with IOException");
        }
        catch (IOException iOException) {
            // empty catch block
        }
        Assertions.assertTrue((length == auditlog.getOutput().split("\n").length ? 1 : 0) != 0, (String)"Unexpected log!");
    }

    @Test
    public void testModifyCachePool() throws Exception {
        this.removeExistingCachePools(null);
        CachePoolInfo cacheInfo = new CachePoolInfo("pool1").setMode(new FsPermission(0));
        ((DistributedFileSystem)fs).addCachePool(cacheInfo);
        fileSys = DFSTestUtil.getFileSystemAs(user1, conf);
        try {
            ((DistributedFileSystem)fileSys).modifyCachePool(cacheInfo);
            Assertions.fail((String)"The operation should have failed with AccessControlException");
        }
        catch (AccessControlException accessControlException) {
            // empty catch block
        }
        String aceModifyCachePoolPattern = ".*allowed=false.*ugi=theDoctor.*cmd=modifyCachePool.*";
        int length = this.verifyAuditLogs(aceModifyCachePoolPattern);
        try {
            fileSys.close();
            ((DistributedFileSystem)fileSys).modifyCachePool(cacheInfo);
            Assertions.fail((String)"The operation should have failed with IOException");
        }
        catch (IOException iOException) {
            // empty catch block
        }
        Assertions.assertTrue((length == auditlog.getOutput().split("\n").length ? 1 : 0) != 0, (String)"Unexpected log!");
    }

    @Test
    public void testRemoveCachePool() throws Exception {
        this.removeExistingCachePools(null);
        CachePoolInfo cacheInfo = new CachePoolInfo("pool1").setMode(new FsPermission(0));
        ((DistributedFileSystem)fs).addCachePool(cacheInfo);
        fileSys = DFSTestUtil.getFileSystemAs(user1, conf);
        try {
            ((DistributedFileSystem)fileSys).removeCachePool("pool1");
            Assertions.fail((String)"The operation should have failed with AccessControlException");
        }
        catch (AccessControlException accessControlException) {
            // empty catch block
        }
        String aceRemoveCachePoolPattern = ".*allowed=false.*ugi=theDoctor.*cmd=removeCachePool.*";
        int length = this.verifyAuditLogs(aceRemoveCachePoolPattern);
        Assertions.assertTrue((length == auditlog.getOutput().split("\n").length ? 1 : 0) != 0, (String)"Unexpected log!");
        try {
            fileSys.close();
            ((DistributedFileSystem)fileSys).removeCachePool("pool1");
            Assertions.fail((String)"The operation should have failed with IOException");
        }
        catch (IOException iOException) {
            // empty catch block
        }
        Assertions.assertTrue((length == auditlog.getOutput().split("\n").length ? 1 : 0) != 0, (String)"Unexpected log!");
    }

    @Test
    public void testGetEZForPath() throws Exception {
        Path path = new Path("/test");
        fileSys = DFSTestUtil.getFileSystemAs(user1, conf);
        fs.mkdirs(path, new FsPermission(0));
        String aceGetEzForPathPattern = ".*allowed=false.*ugi=theDoctor.*cmd=getEZForPath.*";
        try {
            ((DistributedFileSystem)fileSys).getEZForPath(path);
            Assertions.fail((String)"The operation should have failed with AccessControlException");
        }
        catch (AccessControlException accessControlException) {
            // empty catch block
        }
        int length = this.verifyAuditLogs(aceGetEzForPathPattern);
        fileSys.close();
        try {
            ((DistributedFileSystem)fileSys).getEZForPath(path);
            Assertions.fail((String)"The operation should have failed with IOException");
        }
        catch (IOException iOException) {
            // empty catch block
        }
        Assertions.assertTrue((length == auditlog.getOutput().split("\n").length ? 1 : 0) != 0, (String)"Unexpected log!");
    }

    @Test
    public void testRenameTo() throws Exception {
        Path path = new Path("/test");
        fileSys = DFSTestUtil.getFileSystemAs(user1, conf);
        fs.mkdirs(path, new FsPermission(0));
        String aceRenameToPattern = ".*allowed=false.*ugi=theDoctor.*cmd=rename.*";
        try {
            fileSys.rename(path, path);
            Assertions.fail((String)"The operation should have failed with AccessControlException");
        }
        catch (AccessControlException accessControlException) {
            // empty catch block
        }
        int length = this.verifyAuditLogs(aceRenameToPattern);
        fileSys.close();
        try {
            fileSys.rename(path, path);
            Assertions.fail((String)"The operation should have failed with IOException");
        }
        catch (IOException iOException) {
            // empty catch block
        }
        Assertions.assertTrue((length == auditlog.getOutput().split("\n").length ? 1 : 0) != 0, (String)"Unexpected log!");
    }

    @Test
    public void testGetXattrs() throws Exception {
        Path path = new Path("/test");
        fileSys = DFSTestUtil.getFileSystemAs(user1, conf);
        fs.mkdirs(path, new FsPermission(0));
        String aceGetXattrsPattern = ".*allowed=false.*ugi=theDoctor.*cmd=getXAttrs.*";
        try {
            fileSys.getXAttrs(path);
            Assertions.fail((String)"The operation should have failed with AccessControlException");
        }
        catch (AccessControlException accessControlException) {
            // empty catch block
        }
        int length = this.verifyAuditLogs(aceGetXattrsPattern);
        fileSys.close();
        try {
            fileSys.getXAttrs(path);
            Assertions.fail((String)"The operation should have failed with IOException");
        }
        catch (IOException iOException) {
            // empty catch block
        }
        Assertions.assertTrue((length == auditlog.getOutput().split("\n").length ? 1 : 0) != 0, (String)"Unexpected log!");
    }

    @Test
    public void testListXattrs() throws Exception {
        Path path = new Path("/test");
        fileSys = DFSTestUtil.getFileSystemAs(user1, conf);
        fs.mkdirs(path);
        fs.setOwner(path, user1.getUserName(), user1.getPrimaryGroupName());
        String aceListXattrsPattern = ".*allowed=true.*ugi=theDoctor.*cmd=listXAttrs.*";
        fileSys.listXAttrs(path);
        this.verifyAuditLogs(aceListXattrsPattern);
    }

    @Test
    public void testGetAclStatus() throws Exception {
        Path path = new Path("/test");
        fs.mkdirs(path);
        fileSys = DFSTestUtil.getFileSystemAs(user1, conf);
        fs.setOwner(path, user1.getUserName(), user1.getPrimaryGroupName());
        FSDirectory dir = cluster.getNamesystem().getFSDirectory();
        FSDirectory mockedDir = (FSDirectory)Mockito.spy((Object)dir);
        AccessControlException ex = new AccessControlException();
        ((FSDirectory)Mockito.doThrow((Throwable[])new Throwable[]{ex}).when((Object)mockedDir)).checkTraverse((FSPermissionChecker)ArgumentMatchers.any(), (INodesInPath)ArgumentMatchers.any(), (FSDirectory.DirOp)ArgumentMatchers.any());
        cluster.getNamesystem().setFSDirectory(mockedDir);
        String aceGetAclStatus = ".*allowed=false.*ugi=theDoctor.*cmd=getAclStatus.*";
        try {
            fileSys.getAclStatus(path);
            Assertions.fail((String)"The operation should have failed with AccessControlException");
        }
        catch (AccessControlException accessControlException) {
            // empty catch block
        }
        int length = this.verifyAuditLogs(aceGetAclStatus);
        fileSys.close();
        try {
            fileSys.getAclStatus(path);
            this.verifyAuditLogs(aceGetAclStatus);
            Assertions.fail((String)"The operation should have failed with IOException");
        }
        catch (IOException iOException) {
            // empty catch block
        }
        Assertions.assertTrue((length == auditlog.getOutput().split("\n").length ? 1 : 0) != 0, (String)"Unexpected log!");
        cluster.getNamesystem().setFSDirectory(dir);
    }

    @Test
    public void testDelegationTokens() throws Exception {
        final Token dt = fs.getDelegationToken("foo");
        String getDT = ".*src=HDFS_DELEGATION_TOKEN token 1.*with renewer foo.*";
        this.verifyAuditLogs(true, ".*cmd=getDelegationToken.*src=HDFS_DELEGATION_TOKEN token 1.*with renewer foo.*");
        UserGroupInformation foo = UserGroupInformation.createUserForTesting((String)"foo", (String[])new String[0]);
        foo.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Void>(){

            @Override
            public Void run() throws Exception {
                dt.renew(conf);
                return null;
            }
        });
        this.verifyAuditLogs(true, ".*cmd=renewDelegationToken.*src=HDFS_DELEGATION_TOKEN token 1.*with renewer foo.*");
        try {
            dt.renew(conf);
            Assertions.fail((String)"Renewing a token with non-renewer should fail");
        }
        catch (AccessControlException accessControlException) {
            // empty catch block
        }
        this.verifyAuditLogs(false, ".*cmd=renewDelegationToken.*src=HDFS_DELEGATION_TOKEN token 1.*with renewer foo.*");
        UserGroupInformation bar = UserGroupInformation.createUserForTesting((String)"bar", (String[])new String[0]);
        try {
            bar.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Void>(){

                @Override
                public Void run() throws Exception {
                    dt.cancel(conf);
                    return null;
                }
            });
            Assertions.fail((String)"Canceling a token with non-renewer should fail");
        }
        catch (AccessControlException accessControlException) {
            // empty catch block
        }
        this.verifyAuditLogs(false, ".*cmd=cancelDelegationToken.*src=HDFS_DELEGATION_TOKEN token 1.*with renewer foo.*");
        dt.cancel(conf);
        this.verifyAuditLogs(true, ".*cmd=cancelDelegationToken.*src=HDFS_DELEGATION_TOKEN token 1.*with renewer foo.*");
    }

    private int verifyAuditLogs(boolean allowed, String pattern) {
        return this.verifyAuditLogs(".*allowed=" + allowed + pattern);
    }

    @Test
    public void testMetaSave() throws Exception {
        String aceMetaSave = ".*allowed=true.*cmd=metaSave.*";
        try {
            ((DistributedFileSystem)fs).metaSave("test.log");
            this.verifyAuditLogs(aceMetaSave);
        }
        catch (Exception e) {
            Assertions.fail((String)"The operation should not have failed with Exception");
        }
        try {
            ((DistributedFileSystem)fileSys).metaSave("test.log");
            Assertions.fail((String)"The operation should have failed with AccessControlException");
        }
        catch (IOException ace) {
            GenericTestUtils.assertExceptionContains((String)"Access denied", (Throwable)ace);
            aceMetaSave = ".*allowed=false.*cmd=metaSave.*";
            this.verifyAuditLogs(aceMetaSave);
        }
    }

    @Test
    public void testStartReconfiguration() throws Exception {
        String auditLogString = ".*allowed=true.*cmd=startNamenodeReconfiguration.*";
        FSNamesystem fsNamesystem = (FSNamesystem)Mockito.spy((Object)cluster.getNamesystem());
        Mockito.when((Object)fsNamesystem.isExternalInvocation()).thenReturn((Object)true);
        Server.Call call = (Server.Call)Mockito.spy((Object)new Server.Call(1, 1, null, null, RPC.RpcKind.RPC_BUILTIN, new byte[]{1, 2, 3}));
        Mockito.when((Object)call.getRemoteUser()).thenReturn((Object)UserGroupInformation.createRemoteUser((String)System.getProperty("user.name")));
        Server.getCurCall().set(call);
        try {
            ((NameNodeRpcServer)cluster.getNameNodeRpc()).startReconfiguration();
            this.verifyAuditLogs(auditLogString);
        }
        catch (Exception e) {
            Assertions.fail((String)"StartConfiguration should have passed!");
        }
        Mockito.when((Object)call.getRemoteUser()).thenReturn((Object)UserGroupInformation.createRemoteUser((String)"theDoctor"));
        try {
            ((NameNodeRpcServer)cluster.getNameNodeRpc()).startReconfiguration();
            Assertions.fail((String)"startNameNodeReconfiguration should throw AccessControlException!");
        }
        catch (AccessControlException ace) {
            auditLogString = ".*allowed=false.*cmd=startNamenodeReconfiguration.*";
            this.verifyAuditLogs(auditLogString);
        }
    }

    @Test
    public void testGetReconfigurationStatus() throws Exception {
        String auditLogString = ".*allowed=true.*cmd=getNamenodeReconfigurationStatus.*";
        FSNamesystem fsNamesystem = (FSNamesystem)Mockito.spy((Object)cluster.getNamesystem());
        Mockito.when((Object)fsNamesystem.isExternalInvocation()).thenReturn((Object)true);
        Server.Call call = (Server.Call)Mockito.spy((Object)new Server.Call(1, 1, null, null, RPC.RpcKind.RPC_BUILTIN, new byte[]{1, 2, 3}));
        Mockito.when((Object)call.getRemoteUser()).thenReturn((Object)UserGroupInformation.createRemoteUser((String)System.getProperty("user.name")));
        Server.getCurCall().set(call);
        try {
            ((NameNodeRpcServer)cluster.getNameNodeRpc()).getReconfigurationStatus();
            this.verifyAuditLogs(auditLogString);
        }
        catch (Exception e) {
            Assertions.fail((String)"getNamenodeReconfigurationStatus  threw Exception!");
        }
        Mockito.when((Object)call.getRemoteUser()).thenReturn((Object)UserGroupInformation.createRemoteUser((String)"theDoctor"));
        try {
            ((NameNodeRpcServer)cluster.getNameNodeRpc()).getReconfigurationStatus();
            Assertions.fail((String)"getNamenodeReconfigurationStatus  did not throw AccessControlException!");
        }
        catch (AccessControlException ace) {
            auditLogString = ".*allowed=false.*cmd=getNamenodeReconfigurationStatus.*";
            this.verifyAuditLogs(auditLogString);
        }
    }

    @Test
    public void testListReconfigurableProperties() throws Exception {
        String auditLogString = ".*allowed=true.*cmd=listNamenodeReconfigurableProperties.*";
        FSNamesystem fsNamesystem = (FSNamesystem)Mockito.spy((Object)cluster.getNamesystem());
        Mockito.when((Object)fsNamesystem.isExternalInvocation()).thenReturn((Object)true);
        Server.Call call = (Server.Call)Mockito.spy((Object)new Server.Call(1, 1, null, null, RPC.RpcKind.RPC_BUILTIN, new byte[]{1, 2, 3}));
        Mockito.when((Object)call.getRemoteUser()).thenReturn((Object)UserGroupInformation.createRemoteUser((String)System.getProperty("user.name")));
        Server.getCurCall().set(call);
        try {
            ((NameNodeRpcServer)cluster.getNameNodeRpc()).listReconfigurableProperties();
            this.verifyAuditLogs(auditLogString);
        }
        catch (Exception e) {
            Assertions.fail((String)"listReconfigurableProperties  threw Exception!");
        }
        Mockito.when((Object)call.getRemoteUser()).thenReturn((Object)UserGroupInformation.createRemoteUser((String)"theDoctor"));
        try {
            ((NameNodeRpcServer)cluster.getNameNodeRpc()).listReconfigurableProperties();
            Assertions.fail((String)"getNamenodeReconfigurationStatus  did not throw AccessControlException!");
        }
        catch (AccessControlException ace) {
            auditLogString = ".*allowed=false.*cmd=listNamenodeReconfigurableProperties.*";
            this.verifyAuditLogs(auditLogString);
        }
    }

    @Test
    public void testRefreshUserToGroupsMappings() throws Exception {
        String auditLogString = ".*allowed=true.*cmd=refreshUserToGroupsMappings.*";
        FSNamesystem fsNamesystem = (FSNamesystem)Mockito.spy((Object)cluster.getNamesystem());
        Mockito.when((Object)fsNamesystem.isExternalInvocation()).thenReturn((Object)true);
        Server.Call call = (Server.Call)Mockito.spy((Object)new Server.Call(1, 1, null, null, RPC.RpcKind.RPC_BUILTIN, new byte[]{1, 2, 3}));
        Mockito.when((Object)call.getRemoteUser()).thenReturn((Object)UserGroupInformation.createRemoteUser((String)System.getProperty("user.name")));
        Server.getCurCall().set(call);
        ((NameNodeRpcServer)cluster.getNameNodeRpc()).refreshUserToGroupsMappings();
        this.verifyAuditLogs(auditLogString);
    }

    @Test
    public void testRefreshSuperUserGroupsConfiguration() throws Exception {
        String auditLogString = ".*allowed=true.*cmd=refreshSuperUserGroupsConfiguration.*";
        FSNamesystem fsNamesystem = (FSNamesystem)Mockito.spy((Object)cluster.getNamesystem());
        Mockito.when((Object)fsNamesystem.isExternalInvocation()).thenReturn((Object)true);
        Server.Call call = (Server.Call)Mockito.spy((Object)new Server.Call(1, 1, null, null, RPC.RpcKind.RPC_BUILTIN, new byte[]{1, 2, 3}));
        Mockito.when((Object)call.getRemoteUser()).thenReturn((Object)UserGroupInformation.createRemoteUser((String)System.getProperty("user.name")));
        Server.getCurCall().set(call);
        try {
            ((NameNodeRpcServer)cluster.getNameNodeRpc()).refreshSuperUserGroupsConfiguration();
            this.verifyAuditLogs(auditLogString);
        }
        catch (Exception e) {
            Assertions.fail((String)" The operation threw an exception");
        }
    }

    @Test
    public void testRefreshQueue() throws Exception {
        String auditLogString = ".*allowed=true.*cmd=refreshCallQueue.*";
        FSNamesystem fsNamesystem = (FSNamesystem)Mockito.spy((Object)cluster.getNamesystem());
        Mockito.when((Object)fsNamesystem.isExternalInvocation()).thenReturn((Object)true);
        Server.Call call = (Server.Call)Mockito.spy((Object)new Server.Call(1, 1, null, null, RPC.RpcKind.RPC_BUILTIN, new byte[]{1, 2, 3}));
        Mockito.when((Object)call.getRemoteUser()).thenReturn((Object)UserGroupInformation.createRemoteUser((String)System.getProperty("user.name")));
        Server.getCurCall().set(call);
        try {
            ((NameNodeRpcServer)cluster.getNameNodeRpc()).refreshCallQueue();
            this.verifyAuditLogs(auditLogString);
        }
        catch (Exception e) {
            Assertions.fail((String)" The operation threw an exception");
        }
    }

    @Test
    public void testRefreshServiceAcl() throws Exception {
        String auditLogString = ".*allowed=true.*cmd=refreshServiceAcl.*";
        FSNamesystem fsNamesystem = (FSNamesystem)Mockito.spy((Object)cluster.getNamesystem());
        Mockito.when((Object)fsNamesystem.isExternalInvocation()).thenReturn((Object)true);
        Server.Call call = (Server.Call)Mockito.spy((Object)new Server.Call(1, 1, null, null, RPC.RpcKind.RPC_BUILTIN, new byte[]{1, 2, 3}));
        Mockito.when((Object)call.getRemoteUser()).thenReturn((Object)UserGroupInformation.createRemoteUser((String)System.getProperty("user.name")));
        Server.getCurCall().set(call);
        try {
            ((NameNodeRpcServer)cluster.getNameNodeRpc()).refreshServiceAcl();
            this.verifyAuditLogs(auditLogString);
        }
        catch (Exception e) {
            Assertions.fail((String)(" The operation threw an exception" + e));
        }
    }

    @Test
    public void testFinalizeRollingUpgrade() throws Exception {
        String auditLogString = ".*allowed=true.*cmd=finalizeRollingUpgrade.*";
        FSNamesystem fsNamesystem = (FSNamesystem)Mockito.spy((Object)cluster.getNamesystem());
        Mockito.when((Object)fsNamesystem.isExternalInvocation()).thenReturn((Object)true);
        Server.Call call = (Server.Call)Mockito.spy((Object)new Server.Call(1, 1, null, null, RPC.RpcKind.RPC_BUILTIN, new byte[]{1, 2, 3}));
        Mockito.when((Object)call.getRemoteUser()).thenReturn((Object)UserGroupInformation.createRemoteUser((String)System.getProperty("user.name")));
        Server.getCurCall().set(call);
        fsNamesystem.setRollingUpgradeInfo(false, System.currentTimeMillis());
        try {
            fsNamesystem.finalizeRollingUpgrade();
            this.verifyAuditLogs(auditLogString);
        }
        catch (Exception e) {
            Assertions.fail((String)"finalizeRollingUpgrade threw Exception");
        }
        Mockito.when((Object)call.getRemoteUser()).thenReturn((Object)UserGroupInformation.createRemoteUser((String)"theDoctor"));
        try {
            fsNamesystem.finalizeRollingUpgrade();
            Assertions.fail((String)"finalizeRollingUpgrade should throw AccessControlException!");
        }
        catch (AccessControlException ace) {
            auditLogString = ".*allowed=false.*cmd=finalizeRollingUpgrade.*";
            this.verifyAuditLogs(auditLogString);
        }
    }

    @Test
    public void testQueryRollingUpgrade() throws Exception {
        String auditLogString = ".*allowed=true.*cmd=queryRollingUpgrade.*";
        FSNamesystem fsNamesystem = (FSNamesystem)Mockito.spy((Object)cluster.getNamesystem());
        Mockito.when((Object)fsNamesystem.isExternalInvocation()).thenReturn((Object)true);
        Server.Call call = (Server.Call)Mockito.spy((Object)new Server.Call(1, 1, null, null, RPC.RpcKind.RPC_BUILTIN, new byte[]{1, 2, 3}));
        Mockito.when((Object)call.getRemoteUser()).thenReturn((Object)UserGroupInformation.createRemoteUser((String)System.getProperty("user.name")));
        Server.getCurCall().set(call);
        fsNamesystem.setRollingUpgradeInfo(false, System.currentTimeMillis());
        try {
            fsNamesystem.queryRollingUpgrade();
            this.verifyAuditLogs(auditLogString);
        }
        catch (Exception e) {
            Assertions.fail((String)"queryRollingUpgrade threw Exception");
        }
        Mockito.when((Object)call.getRemoteUser()).thenReturn((Object)UserGroupInformation.createRemoteUser((String)"theDoctor"));
        try {
            fsNamesystem.queryRollingUpgrade();
            Assertions.fail((String)"queryRollingUpgrade should have thrown an AccessControlException!");
        }
        catch (AccessControlException ace) {
            auditLogString = ".*allowed=false.*cmd=queryRollingUpgrade.*";
            this.verifyAuditLogs(auditLogString);
        }
    }

    @Test
    public void testRollEditLog() throws Exception {
        String auditLogString = ".*allowed=true.*cmd=rollEditLog.*";
        FSNamesystem fsNamesystem = (FSNamesystem)Mockito.spy((Object)cluster.getNamesystem());
        Mockito.when((Object)fsNamesystem.isExternalInvocation()).thenReturn((Object)true);
        Server.Call call = (Server.Call)Mockito.spy((Object)new Server.Call(1, 1, null, null, RPC.RpcKind.RPC_BUILTIN, new byte[]{1, 2, 3}));
        Mockito.when((Object)call.getRemoteUser()).thenReturn((Object)UserGroupInformation.createRemoteUser((String)System.getProperty("user.name")));
        Server.getCurCall().set(call);
        try {
            fsNamesystem.rollEditLog();
        }
        catch (Exception e) {
            Assertions.fail((String)"rollEditLog threw Exception");
        }
        this.verifyAuditLogs(auditLogString);
        Mockito.when((Object)call.getRemoteUser()).thenReturn((Object)UserGroupInformation.createRemoteUser((String)"theDoctor"));
        try {
            fsNamesystem.rollEditLog();
            Assertions.fail((String)"rollEditLog should have thrown an AccessControlException!");
        }
        catch (AccessControlException ace) {
            auditLogString = ".*allowed=false.*cmd=rollEditLog.*";
            this.verifyAuditLogs(auditLogString);
        }
    }

    @Test
    public void testSetSafeMode() throws Exception {
        FSNamesystem fsNamesystem = (FSNamesystem)Mockito.spy((Object)cluster.getNamesystem());
        Mockito.when((Object)fsNamesystem.isExternalInvocation()).thenReturn((Object)true);
        Server.Call call = (Server.Call)Mockito.spy((Object)new Server.Call(1, 1, null, null, RPC.RpcKind.RPC_BUILTIN, new byte[]{1, 2, 3}));
        Mockito.when((Object)call.getRemoteUser()).thenReturn((Object)UserGroupInformation.createRemoteUser((String)System.getProperty("user.name")));
        Server.getCurCall().set(call);
        this.verifySuccessfulSetSafeMode(fsNamesystem, HdfsConstants.SafeModeAction.SAFEMODE_ENTER);
        this.verifySuccessfulSetSafeMode(fsNamesystem, HdfsConstants.SafeModeAction.SAFEMODE_GET);
        this.verifySuccessfulSetSafeMode(fsNamesystem, HdfsConstants.SafeModeAction.SAFEMODE_LEAVE);
        this.verifySuccessfulSetSafeMode(fsNamesystem, HdfsConstants.SafeModeAction.SAFEMODE_FORCE_EXIT);
        String auditLogString = ".*allowed=true.*cmd=safemode_get.*";
        fsNamesystem.setSafeMode(HdfsConstants.SafeModeAction.SAFEMODE_GET);
        this.verifyAuditLogs(auditLogString);
        auditLogString = ".*allowed=true.*cmd=safemode_leave.*";
        fsNamesystem.setSafeMode(HdfsConstants.SafeModeAction.SAFEMODE_LEAVE);
        this.verifyAuditLogs(auditLogString);
        auditLogString = ".*allowed=true.*cmd=safemode_force_exit.*";
        fsNamesystem.setSafeMode(HdfsConstants.SafeModeAction.SAFEMODE_FORCE_EXIT);
        this.verifyAuditLogs(auditLogString);
        Mockito.when((Object)call.getRemoteUser()).thenReturn((Object)UserGroupInformation.createRemoteUser((String)"theDoctor"));
        this.verifySafeModeAction(fsNamesystem, HdfsConstants.SafeModeAction.SAFEMODE_ENTER);
        this.verifySafeModeAction(fsNamesystem, HdfsConstants.SafeModeAction.SAFEMODE_LEAVE);
        this.verifySafeModeAction(fsNamesystem, HdfsConstants.SafeModeAction.SAFEMODE_FORCE_EXIT);
        Mockito.when((Object)call.getRemoteUser()).thenReturn((Object)UserGroupInformation.createRemoteUser((String)System.getProperty("user.name")));
    }

    @Test
    public void testSetBalancerBandwidth() throws Exception {
        String auditLogString = ".*allowed=true.*cmd=setBalancerBandwidth.*";
        FSNamesystem fsNamesystem = (FSNamesystem)Mockito.spy((Object)cluster.getNamesystem());
        Mockito.when((Object)fsNamesystem.isExternalInvocation()).thenReturn((Object)true);
        Server.Call call = (Server.Call)Mockito.spy((Object)new Server.Call(1, 1, null, null, RPC.RpcKind.RPC_BUILTIN, new byte[]{1, 2, 3}));
        Mockito.when((Object)call.getRemoteUser()).thenReturn((Object)UserGroupInformation.createRemoteUser((String)System.getProperty("user.name")));
        Server.getCurCall().set(call);
        try {
            fsNamesystem.setBalancerBandwidth(10L);
            this.verifyAuditLogs(auditLogString);
        }
        catch (Exception e) {
            Assertions.fail((String)"setBalancerBandwidth threw exception!");
        }
        Mockito.when((Object)call.getRemoteUser()).thenReturn((Object)UserGroupInformation.createRemoteUser((String)"theDoctor"));
        try {
            fsNamesystem.setBalancerBandwidth(10L);
            Assertions.fail((String)"setBalancerBandwidth should have thrown AccessControlException!");
        }
        catch (AccessControlException ace) {
            auditLogString = ".*allowed=false.*cmd=setBalancerBandwidth.*";
            this.verifyAuditLogs(auditLogString);
        }
    }

    @Test
    public void testRefreshNodes() throws Exception {
        String auditLogString = ".*allowed=true.*cmd=refreshNodes.*";
        FSNamesystem fsNamesystem = (FSNamesystem)Mockito.spy((Object)cluster.getNamesystem());
        Mockito.when((Object)fsNamesystem.isExternalInvocation()).thenReturn((Object)true);
        Server.Call call = (Server.Call)Mockito.spy((Object)new Server.Call(1, 1, null, null, RPC.RpcKind.RPC_BUILTIN, new byte[]{1, 2, 3}));
        Mockito.when((Object)call.getRemoteUser()).thenReturn((Object)UserGroupInformation.createRemoteUser((String)System.getProperty("user.name")));
        Server.getCurCall().set(call);
        try {
            fsNamesystem.refreshNodes();
            this.verifyAuditLogs(auditLogString);
        }
        catch (Exception e) {
            Assertions.fail((String)"refreshNodes threw exception!");
        }
        Mockito.when((Object)call.getRemoteUser()).thenReturn((Object)UserGroupInformation.createRemoteUser((String)"theDoctor"));
        try {
            fsNamesystem.refreshNodes();
            Assertions.fail((String)"refreshNodes should have thrown an AccessControlException!");
        }
        catch (AccessControlException ace) {
            auditLogString = ".*allowed=false.*cmd=refreshNodes.*";
            this.verifyAuditLogs(auditLogString);
        }
    }

    @Test
    public void testFinalizeUpgrade() throws Exception {
        String auditLogString = ".*allowed=true.*cmd=finalizeUpgrade.*";
        FSNamesystem fsNamesystem = (FSNamesystem)Mockito.spy((Object)cluster.getNamesystem());
        Mockito.when((Object)fsNamesystem.isExternalInvocation()).thenReturn((Object)true);
        Server.Call call = (Server.Call)Mockito.spy((Object)new Server.Call(1, 1, null, null, RPC.RpcKind.RPC_BUILTIN, new byte[]{1, 2, 3}));
        Mockito.when((Object)call.getRemoteUser()).thenReturn((Object)UserGroupInformation.createRemoteUser((String)System.getProperty("user.name")));
        Server.getCurCall().set(call);
        try {
            fsNamesystem.finalizeUpgrade();
            this.verifyAuditLogs(auditLogString);
        }
        catch (Exception e) {
            Assertions.fail((String)"finalizeUpgrade threw Exception");
        }
        Mockito.when((Object)call.getRemoteUser()).thenReturn((Object)UserGroupInformation.createRemoteUser((String)"theDoctor"));
        try {
            fsNamesystem.finalizeUpgrade();
            Assertions.fail((String)"finalizeUpgrade should have thrown an AccessControlException!");
        }
        catch (AccessControlException ace) {
            auditLogString = ".*allowed=false.*cmd=finalizeUpgrade.*";
            this.verifyAuditLogs(auditLogString);
        }
    }

    @Test
    public void testSaveNamespace() throws Exception {
        String auditLogString = ".*allowed=true.*cmd=saveNamespace.*";
        FSNamesystem fsNamesystem = (FSNamesystem)Mockito.spy((Object)cluster.getNamesystem());
        Mockito.when((Object)fsNamesystem.isExternalInvocation()).thenReturn((Object)true);
        Server.Call call = (Server.Call)Mockito.spy((Object)new Server.Call(1, 1, null, null, RPC.RpcKind.RPC_BUILTIN, new byte[]{1, 2, 3}));
        Mockito.when((Object)call.getRemoteUser()).thenReturn((Object)UserGroupInformation.createRemoteUser((String)System.getProperty("user.name")));
        Server.getCurCall().set(call);
        fsNamesystem.setSafeMode(HdfsConstants.SafeModeAction.SAFEMODE_ENTER);
        try {
            fsNamesystem.saveNamespace(10L, 10L);
            this.verifyAuditLogs(auditLogString);
        }
        catch (Exception e) {
            Assertions.fail((String)"saveNamespace threw Exception");
        }
        Mockito.when((Object)call.getRemoteUser()).thenReturn((Object)UserGroupInformation.createRemoteUser((String)"theDoctor"));
        try {
            fsNamesystem.saveNamespace(10L, 10L);
            Assertions.fail((String)"saveNamespace should have thrown an AccessControlException!");
        }
        catch (AccessControlException ace) {
            auditLogString = ".*allowed=false.*cmd=saveNamespace.*";
            this.verifyAuditLogs(auditLogString);
        }
    }

    @Test
    public void testDatanodeReport() throws Exception {
        String auditLogString = ".*allowed=true.*cmd=datanodeReport.*";
        FSNamesystem fsNamesystem = (FSNamesystem)Mockito.spy((Object)cluster.getNamesystem());
        Mockito.when((Object)fsNamesystem.isExternalInvocation()).thenReturn((Object)true);
        Server.Call call = (Server.Call)Mockito.spy((Object)new Server.Call(1, 1, null, null, RPC.RpcKind.RPC_BUILTIN, new byte[]{1, 2, 3}));
        Mockito.when((Object)call.getRemoteUser()).thenReturn((Object)UserGroupInformation.createRemoteUser((String)System.getProperty("user.name")));
        Server.getCurCall().set(call);
        try {
            fsNamesystem.datanodeReport(HdfsConstants.DatanodeReportType.ALL);
            this.verifyAuditLogs(auditLogString);
        }
        catch (Exception e) {
            Assertions.fail((String)"datanodeReport threw Exception");
        }
        Mockito.when((Object)call.getRemoteUser()).thenReturn((Object)UserGroupInformation.createRemoteUser((String)"theDoctor"));
        try {
            fsNamesystem.datanodeReport(HdfsConstants.DatanodeReportType.ALL);
            Assertions.fail((String)"datanodeReport should have thrown an AccessControlException!");
        }
        catch (AccessControlException ace) {
            auditLogString = ".*allowed=false.*cmd=datanodeReport.*";
            this.verifyAuditLogs(auditLogString);
        }
    }

    @Test
    public void testRestoreFailedStorage() throws Exception {
        FSNamesystem fsNamesystem = (FSNamesystem)Mockito.spy((Object)cluster.getNamesystem());
        Mockito.when((Object)fsNamesystem.isExternalInvocation()).thenReturn((Object)true);
        Server.Call call = (Server.Call)Mockito.spy((Object)new Server.Call(1, 1, null, null, RPC.RpcKind.RPC_BUILTIN, new byte[]{1, 2, 3}));
        Mockito.when((Object)call.getRemoteUser()).thenReturn((Object)UserGroupInformation.createRemoteUser((String)System.getProperty("user.name")));
        Server.getCurCall().set(call);
        this.verifyAuditRestoreFailedStorage(fsNamesystem, "check");
        this.verifyAuditRestoreFailedStorage(fsNamesystem, "true");
        this.verifyAuditRestoreFailedStorage(fsNamesystem, "false");
        Mockito.when((Object)call.getRemoteUser()).thenReturn((Object)UserGroupInformation.createRemoteUser((String)"theDoctor"));
        this.verifyAuditRestoreFailedStorageACE(fsNamesystem, "check");
        this.verifyAuditRestoreFailedStorageACE(fsNamesystem, "true");
        this.verifyAuditRestoreFailedStorageACE(fsNamesystem, "false");
    }

    @Test
    public void testGetDatanodeStorageReport() throws Exception {
        FSNamesystem fsNamesystem = (FSNamesystem)Mockito.spy((Object)cluster.getNamesystem());
        Mockito.when((Object)fsNamesystem.isExternalInvocation()).thenReturn((Object)true);
        Server.Call call = (Server.Call)Mockito.spy((Object)new Server.Call(1, 1, null, null, RPC.RpcKind.RPC_BUILTIN, new byte[]{1, 2, 3}));
        Mockito.when((Object)call.getRemoteUser()).thenReturn((Object)UserGroupInformation.createRemoteUser((String)System.getProperty("user.name")));
        Server.getCurCall().set(call);
        DatanodeStorageReport[] reports = fsNamesystem.getDatanodeStorageReport(HdfsConstants.DatanodeReportType.ALL);
        String auditLogString = ".*allowed=true.*cmd=getDatanodeStorageReport.*";
        this.verifyAuditLogs(auditLogString);
        Mockito.when((Object)call.getRemoteUser()).thenReturn((Object)UserGroupInformation.createRemoteUser((String)"theDoctor"));
        auditLogString = ".*allowed=false.*cmd=getDatanodeStorageReport.*";
        try {
            fsNamesystem.getDatanodeStorageReport(HdfsConstants.DatanodeReportType.ALL);
            Assertions.fail((String)"Should have thrown an AccessControlException!");
        }
        catch (AccessControlException ace) {
            this.verifyAuditLogs(auditLogString);
        }
    }

    @Test
    public void testDeleteRoot() throws Exception {
        Path srcDir = new Path("/");
        fileSys = DFSTestUtil.getFileSystemAs(user1, conf);
        boolean result = fileSys.delete(srcDir, true);
        fileSys.close();
        Assertions.assertFalse((boolean)result);
        String aceDeletePattern = ".*allowed=false.*ugi=theDoctor.*cmd=delete.*";
        this.verifyAuditLogs(aceDeletePattern);
    }

    @Test
    public void testReportBadBlocks() throws IOException {
        String auditLogString = ".*allowed=true.*cmd=reportBadBlocks.*";
        FSNamesystem fsNamesystem = (FSNamesystem)Mockito.spy((Object)cluster.getNamesystem());
        Mockito.when((Object)fsNamesystem.isExternalInvocation()).thenReturn((Object)true);
        Server.Call call = (Server.Call)Mockito.spy((Object)new Server.Call(1, 1, null, null, RPC.RpcKind.RPC_BUILTIN, new byte[]{1, 2, 3}));
        Mockito.when((Object)call.getRemoteUser()).thenReturn((Object)UserGroupInformation.createRemoteUser((String)System.getProperty("user.name")));
        Server.getCurCall().set(call);
        try {
            cluster.getNameNodeRpc().reportBadBlocks(new LocatedBlock[0]);
            this.verifyAuditLogs(auditLogString);
        }
        catch (Exception e) {
            Assertions.fail((String)(" The operation threw an exception" + e));
        }
    }

    private void verifyAuditRestoreFailedStorageACE(FSNamesystem fsNamesystem, String arg) throws IOException {
        String operationName = fsNamesystem.getFailedStorageCommand(arg);
        try {
            fsNamesystem.restoreFailedStorage(arg);
            Assertions.fail((String)"RestoreFailedStorage should have thrown AccessControlException!");
        }
        catch (IOException ace) {
            Assertions.assertEquals(ace.getClass(), AccessControlException.class, (String)"Unexpected Exception!");
            String auditLogString = ".*allowed=false.*cmd=" + operationName + ".*";
            this.verifyAuditLogs(auditLogString);
        }
    }

    private void verifyAuditRestoreFailedStorage(FSNamesystem fsNamesystem, String arg) throws IOException {
        String operationName = fsNamesystem.getFailedStorageCommand(arg);
        String auditLogString = ".*allowed=true.*cmd=" + operationName + ".*";
        try {
            fsNamesystem.restoreFailedStorage(arg);
            this.verifyAuditLogs(auditLogString);
        }
        catch (Exception e) {
            Assertions.fail((String)"The operation should not have failed with Exception");
        }
    }

    private void verifySuccessfulSetSafeMode(FSNamesystem fsNamesystem, HdfsConstants.SafeModeAction safeModeAction) throws IOException {
        String operationName = safeModeAction.toString().toLowerCase();
        String auditLogString = ".*allowed=true.*cmd=" + operationName + ".*";
        try {
            fsNamesystem.setSafeMode(safeModeAction);
            this.verifyAuditLogs(auditLogString);
        }
        catch (Exception e) {
            Assertions.fail((String)"The operation should not have failed with Exception");
        }
    }

    private void verifySafeModeAction(FSNamesystem fsNamesystem, HdfsConstants.SafeModeAction safeModeAction) throws IOException {
        String operationName = safeModeAction.toString().toLowerCase();
        try {
            fsNamesystem.setSafeMode(safeModeAction);
            Assertions.fail((String)"setSafeMode should have thrown an AccessControlException!");
        }
        catch (AccessControlException ace) {
            String auditLogString = ".*allowed=false.*cmd=" + operationName + ".*";
            this.verifyAuditLogs(auditLogString);
        }
    }

    private int verifyAuditLogs(String pattern) {
        int length = auditlog.getOutput().split(System.lineSeparator()).length;
        String lastAudit = auditlog.getOutput().split(System.lineSeparator())[length - 1];
        Assertions.assertTrue((boolean)lastAudit.matches(pattern), (String)"Unexpected log!");
        return length;
    }

    private void removeExistingCachePools(String prevPool) throws Exception {
        BatchedRemoteIterator.BatchedEntries entries = proto.listCachePools(prevPool);
        for (int i = 0; i < entries.size(); ++i) {
            proto.removeCachePool(((CachePoolEntry)entries.get(i)).getInfo().getPoolName());
        }
    }
}

