/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.DFSTestUtil;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.StripedFileTestUtil;
import org.apache.hadoop.hdfs.protocol.Block;
import org.apache.hadoop.hdfs.protocol.DatanodeInfo;
import org.apache.hadoop.hdfs.protocol.DatanodeInfoWithStorage;
import org.apache.hadoop.hdfs.protocol.ErasureCodingPolicy;
import org.apache.hadoop.hdfs.protocol.LocatedBlocks;
import org.apache.hadoop.hdfs.protocol.LocatedStripedBlock;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockInfoStriped;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockManager;
import org.apache.hadoop.hdfs.server.datanode.DataNode;
import org.apache.hadoop.hdfs.server.datanode.SimulatedFSDataset;
import org.apache.hadoop.hdfs.util.RwLockMode;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;

@Timeout(value=300L)
public class TestAddOverReplicatedStripedBlocks {
    private MiniDFSCluster cluster;
    private DistributedFileSystem fs;
    private final Path dirPath = new Path("/striped");
    private Path filePath = new Path(this.dirPath, "file");
    private final ErasureCodingPolicy ecPolicy = StripedFileTestUtil.getDefaultECPolicy();
    private final short dataBlocks = (short)this.ecPolicy.getNumDataUnits();
    private final short parityBlocks = (short)this.ecPolicy.getNumParityUnits();
    private final short groupSize = (short)(this.dataBlocks + this.parityBlocks);
    private final int cellSize = this.ecPolicy.getCellSize();
    private final int stripesPerBlock = 4;
    private final int blockSize = 4 * this.cellSize;
    private final int numDNs = this.groupSize + 3;

    @BeforeEach
    public void setup() throws IOException {
        Configuration conf = new Configuration();
        conf.setLong("dfs.blocksize", (long)this.blockSize);
        conf.setInt("dfs.namenode.replication.max-streams", 0);
        conf.setInt("dfs.namenode.redundancy.interval.seconds", 1);
        conf.setInt("dfs.heartbeat.interval", 1);
        SimulatedFSDataset.setFactory(conf);
        this.cluster = new MiniDFSCluster.Builder(conf).numDataNodes(this.numDNs).build();
        this.cluster.waitActive();
        this.fs = this.cluster.getFileSystem();
        this.fs.enableErasureCodingPolicy(this.ecPolicy.getName());
        this.fs.mkdirs(this.dirPath);
        this.fs.getClient().setErasureCodingPolicy(this.dirPath.toString(), this.ecPolicy.getName());
    }

    @AfterEach
    public void tearDown() {
        if (this.cluster != null) {
            this.cluster.shutdown();
            this.cluster = null;
        }
    }

    @Test
    public void testProcessOverReplicatedStripedBlock() throws Exception {
        long fileLen = this.dataBlocks * this.blockSize;
        DFSTestUtil.createStripedFile(this.cluster, this.filePath, null, 1, 4, false);
        LocatedBlocks lbs = this.cluster.getNameNodeRpc().getBlockLocations(this.filePath.toString(), 0L, fileLen);
        LocatedStripedBlock bg = (LocatedStripedBlock)lbs.get(0);
        long gs = bg.getBlock().getGenerationStamp();
        String bpid = bg.getBlock().getBlockPoolId();
        long groupId = bg.getBlock().getBlockId();
        Block blk = new Block(groupId, (long)this.blockSize, gs);
        for (int i = 0; i < this.groupSize; ++i) {
            blk.setBlockId(groupId + (long)i);
            this.cluster.injectBlocks(i, Arrays.asList(blk), bpid);
        }
        this.cluster.triggerBlockReports();
        blk.setBlockId(groupId);
        this.cluster.injectBlocks(this.numDNs - 3, Arrays.asList(blk), bpid);
        this.cluster.injectBlocks(this.numDNs - 2, Arrays.asList(blk), bpid);
        blk.setBlockId(groupId + (long)this.dataBlocks);
        this.cluster.injectBlocks(this.numDNs - 1, Arrays.asList(blk), bpid);
        this.cluster.triggerBlockReports();
        this.cluster.triggerHeartbeats();
        this.cluster.triggerHeartbeats();
        this.cluster.triggerBlockReports();
        lbs = this.cluster.getNameNodeRpc().getBlockLocations(this.filePath.toString(), 0L, fileLen);
        StripedFileTestUtil.verifyLocatedStripedBlocks(lbs, this.groupSize);
    }

    @Test
    public void testProcessOverReplicatedSBSmallerThanFullBlocks() throws Exception {
        int fileLen = this.cellSize * (this.dataBlocks - 1);
        byte[] content = new byte[fileLen];
        DFSTestUtil.writeFile((FileSystem)this.fs, this.filePath, new String(content));
        LocatedBlocks lbs = this.cluster.getNameNodeRpc().getBlockLocations(this.filePath.toString(), 0L, (long)fileLen);
        LocatedStripedBlock bg = (LocatedStripedBlock)lbs.get(0);
        long gs = bg.getBlock().getGenerationStamp();
        String bpid = bg.getBlock().getBlockPoolId();
        long groupId = bg.getBlock().getBlockId();
        Block blk = new Block(groupId, (long)this.blockSize, gs);
        this.cluster.triggerBlockReports();
        List<DatanodeInfoWithStorage> infos = Arrays.asList(bg.getLocations());
        blk.setBlockId(groupId);
        ArrayList<DataNode> dataNodeList = this.cluster.getDataNodes();
        for (int i = 0; i < this.numDNs; ++i) {
            if (infos.contains(((DataNode)dataNodeList.get(i)).getDatanodeId())) continue;
            this.cluster.injectBlocks(i, Arrays.asList(blk), bpid);
            System.out.println("XXX: inject block into datanode " + i);
        }
        this.cluster.triggerBlockReports();
        this.cluster.triggerHeartbeats();
        this.cluster.triggerHeartbeats();
        this.cluster.triggerBlockReports();
        lbs = this.cluster.getNameNodeRpc().getBlockLocations(this.filePath.toString(), 0L, (long)fileLen);
        StripedFileTestUtil.verifyLocatedStripedBlocks(lbs, this.groupSize - 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testProcessOverReplicatedAndCorruptStripedBlock() throws Exception {
        long fileLen = this.dataBlocks * this.blockSize;
        DFSTestUtil.createStripedFile(this.cluster, this.filePath, null, 1, 4, false);
        LocatedBlocks lbs = this.cluster.getNameNodeRpc().getBlockLocations(this.filePath.toString(), 0L, fileLen);
        LocatedStripedBlock bg = (LocatedStripedBlock)lbs.get(0);
        long gs = bg.getBlock().getGenerationStamp();
        String bpid = bg.getBlock().getBlockPoolId();
        long groupId = bg.getBlock().getBlockId();
        Block blk = new Block(groupId, (long)this.blockSize, gs);
        BlockInfoStriped blockInfo = new BlockInfoStriped(blk, StripedFileTestUtil.getDefaultECPolicy());
        for (int i = 0; i < this.groupSize; ++i) {
            blk.setBlockId(groupId + (long)i);
            this.cluster.injectBlocks(i, Arrays.asList(blk), bpid);
        }
        this.cluster.triggerBlockReports();
        BlockManager bm = this.cluster.getNamesystem().getBlockManager();
        List<DatanodeInfoWithStorage> infos = Arrays.asList(bg.getLocations());
        this.cluster.stopDataNode(((DatanodeInfo)infos.get(0)).getXferAddr());
        List<String> storages = Arrays.asList(bg.getStorageIDs());
        this.cluster.getNamesystem().writeLock(RwLockMode.BM);
        try {
            bm.findAndMarkBlockAsCorrupt(lbs.getLastLocatedBlock().getBlock(), (DatanodeInfo)infos.get(0), storages.get(0), "TEST");
        }
        finally {
            this.cluster.getNamesystem().writeUnlock(RwLockMode.BM, "testProcessOverReplicatedAndCorruptStripedBlock");
        }
        Assertions.assertEquals((int)1, (int)bm.countNodes(bm.getStoredBlock((Block)blockInfo)).corruptReplicas());
        blk.setBlockId(groupId + 2L);
        this.cluster.injectBlocks(this.numDNs - 3, Arrays.asList(blk), bpid);
        this.cluster.injectBlocks(this.numDNs - 2, Arrays.asList(blk), bpid);
        this.cluster.triggerBlockReports();
        lbs = this.cluster.getNameNodeRpc().getBlockLocations(this.filePath.toString(), 0L, fileLen);
        bg = (LocatedStripedBlock)lbs.get(0);
        Assertions.assertEquals((int)(this.groupSize + 1), (int)bg.getBlockIndices().length);
        Assertions.assertEquals((int)(this.groupSize + 1), (int)bg.getLocations().length);
        BitSet set = new BitSet(this.groupSize);
        for (byte index : bg.getBlockIndices()) {
            set.set(index);
        }
        Assertions.assertFalse((boolean)set.get(0));
        for (int i = 1; i < this.groupSize; ++i) {
            Assertions.assertTrue((boolean)set.get(i));
        }
    }

    @Disabled
    @Test
    public void testProcessOverReplicatedAndMissingStripedBlock() throws Exception {
        long fileLen = this.cellSize * this.dataBlocks;
        DFSTestUtil.createStripedFile(this.cluster, this.filePath, null, 1, 4, false);
        LocatedBlocks lbs = this.cluster.getNameNodeRpc().getBlockLocations(this.filePath.toString(), 0L, fileLen);
        LocatedStripedBlock bg = (LocatedStripedBlock)lbs.get(0);
        long gs = bg.getBlock().getGenerationStamp();
        String bpid = bg.getBlock().getBlockPoolId();
        long groupId = bg.getBlock().getBlockId();
        Block blk = new Block(groupId, (long)this.blockSize, gs);
        for (int i = 0; i < this.groupSize - 1; ++i) {
            blk.setBlockId(groupId + (long)i);
            this.cluster.injectBlocks(i, Arrays.asList(blk), bpid);
        }
        this.cluster.triggerBlockReports();
        blk.setBlockId(groupId + 2L);
        this.cluster.injectBlocks(this.numDNs - 3, Arrays.asList(blk), bpid);
        this.cluster.injectBlocks(this.numDNs - 2, Arrays.asList(blk), bpid);
        this.cluster.triggerBlockReports();
        Thread.sleep(2000L);
        this.cluster.triggerHeartbeats();
        this.cluster.triggerHeartbeats();
        this.cluster.triggerBlockReports();
        lbs = this.cluster.getNameNodeRpc().getBlockLocations(this.filePath.toString(), 0L, fileLen);
        bg = (LocatedStripedBlock)lbs.get(0);
        Assertions.assertEquals((int)(this.groupSize + 1), (int)bg.getBlockIndices().length);
        Assertions.assertEquals((int)(this.groupSize + 1), (int)bg.getLocations().length);
        BitSet set = new BitSet(this.groupSize);
        for (byte index : bg.getBlockIndices()) {
            set.set(index);
        }
        Assertions.assertFalse((boolean)set.get(this.groupSize - 1));
        for (int i = 0; i < this.groupSize - 1; ++i) {
            Assertions.assertTrue((boolean)set.get(i));
        }
    }
}

