/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode;

import java.io.IOException;
import java.util.EnumSet;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.CreateFlag;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.protocol.LocatedBlock;
import org.apache.hadoop.hdfs.protocol.LocatedBlocks;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockManager;
import org.apache.hadoop.hdfs.server.blockmanagement.DatanodeStorageInfo;
import org.apache.hadoop.hdfs.server.namenode.FSDirWriteFileOp;
import org.apache.hadoop.hdfs.server.namenode.FSNamesystem;
import org.apache.hadoop.hdfs.server.namenode.FSPermissionChecker;
import org.apache.hadoop.hdfs.server.protocol.NamenodeProtocols;
import org.apache.hadoop.hdfs.util.RwLockMode;
import org.apache.hadoop.io.EnumSetWritable;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestAddBlockRetry {
    public static final Logger LOG = LoggerFactory.getLogger(TestAddBlockRetry.class);
    private static final short REPLICATION = 3;
    private Configuration conf;
    private MiniDFSCluster cluster;

    @BeforeEach
    public void setUp() throws Exception {
        this.conf = new Configuration();
        this.cluster = new MiniDFSCluster.Builder(this.conf).numDataNodes(3).build();
        this.cluster.waitActive();
    }

    @AfterEach
    public void tearDown() throws Exception {
        if (this.cluster != null) {
            this.cluster.shutdown();
            this.cluster = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRetryAddBlockWhileInChooseTarget() throws Exception {
        LocatedBlock newBlock;
        FSDirWriteFileOp.ValidateAddBlockResult r;
        String src = "/testRetryAddBlockWhileInChooseTarget";
        FSNamesystem ns = this.cluster.getNamesystem();
        NamenodeProtocols nn = this.cluster.getNameNodeRpc();
        nn.create("/testRetryAddBlockWhileInChooseTarget", FsPermission.getFileDefault(), "clientName", new EnumSetWritable(EnumSet.of(CreateFlag.CREATE)), true, (short)3, 1024L, null, null, null);
        LOG.info("Starting first addBlock for /testRetryAddBlockWhileInChooseTarget");
        LocatedBlock[] onRetryBlock = new LocatedBlock[1];
        ns.readLock(RwLockMode.GLOBAL);
        FSPermissionChecker pc = (FSPermissionChecker)Mockito.mock(FSPermissionChecker.class);
        try {
            r = FSDirWriteFileOp.validateAddBlock((FSNamesystem)ns, (FSPermissionChecker)pc, (String)"/testRetryAddBlockWhileInChooseTarget", (long)0L, (String)"clientName", null, (LocatedBlock[])onRetryBlock);
        }
        finally {
            ns.readUnlock(RwLockMode.GLOBAL, "validateAddBlock");
        }
        DatanodeStorageInfo[] targets = FSDirWriteFileOp.chooseTargetForNewBlock((BlockManager)ns.getBlockManager(), (String)"/testRetryAddBlockWhileInChooseTarget", null, null, null, (FSDirWriteFileOp.ValidateAddBlockResult)r);
        Assertions.assertNotNull((Object)targets, (String)"Targets must be generated");
        LOG.info("Starting second addBlock for /testRetryAddBlockWhileInChooseTarget");
        nn.addBlock("/testRetryAddBlockWhileInChooseTarget", "clientName", null, null, 0L, null, null);
        Assertions.assertTrue((boolean)this.checkFileProgress("/testRetryAddBlockWhileInChooseTarget", false), (String)"Penultimate block must be complete");
        LocatedBlocks lbs = nn.getBlockLocations("/testRetryAddBlockWhileInChooseTarget", 0L, Long.MAX_VALUE);
        Assertions.assertEquals((int)1, (int)lbs.getLocatedBlocks().size(), (String)"Must be one block");
        LocatedBlock lb2 = lbs.get(0);
        Assertions.assertEquals((int)3, (int)lb2.getLocations().length, (String)"Wrong replication");
        ns.writeLock(RwLockMode.GLOBAL);
        try {
            newBlock = FSDirWriteFileOp.storeAllocatedBlock((FSNamesystem)ns, (String)"/testRetryAddBlockWhileInChooseTarget", (long)0L, (String)"clientName", null, (DatanodeStorageInfo[])targets);
        }
        finally {
            ns.writeUnlock(RwLockMode.GLOBAL, "testRetryAddBlockWhileInChooseTarget");
        }
        Assertions.assertEquals((Object)lb2.getBlock(), (Object)newBlock.getBlock(), (String)"Blocks are not equal");
        lbs = nn.getBlockLocations("/testRetryAddBlockWhileInChooseTarget", 0L, Long.MAX_VALUE);
        Assertions.assertEquals((int)1, (int)lbs.getLocatedBlocks().size(), (String)"Must be one block");
        LocatedBlock lb1 = lbs.get(0);
        Assertions.assertEquals((int)3, (int)lb1.getLocations().length, (String)"Wrong replication");
        Assertions.assertEquals((Object)lb1.getBlock(), (Object)lb2.getBlock(), (String)"Blocks are not equal");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean checkFileProgress(String src, boolean checkall) throws IOException {
        FSNamesystem ns = this.cluster.getNamesystem();
        ns.readLock(RwLockMode.GLOBAL);
        try {
            boolean bl = ns.checkFileProgress(src, ns.dir.getINode(src).asFile(), checkall);
            return bl;
        }
        finally {
            ns.readUnlock(RwLockMode.GLOBAL, "checkFileProgress");
        }
    }

    @Test
    public void testAddBlockRetryShouldReturnBlockWithLocations() throws Exception {
        String src = "/testAddBlockRetryShouldReturnBlockWithLocations";
        NamenodeProtocols nameNodeRpc = this.cluster.getNameNodeRpc();
        nameNodeRpc.create("/testAddBlockRetryShouldReturnBlockWithLocations", FsPermission.getFileDefault(), "clientName", new EnumSetWritable(EnumSet.of(CreateFlag.CREATE)), true, (short)3, 1024L, null, null, null);
        LOG.info("Starting first addBlock for /testAddBlockRetryShouldReturnBlockWithLocations");
        LocatedBlock lb1 = nameNodeRpc.addBlock("/testAddBlockRetryShouldReturnBlockWithLocations", "clientName", null, null, 0L, null, null);
        Assertions.assertTrue((lb1.getLocations().length > 0 ? 1 : 0) != 0, (String)"Block locations should be present");
        this.cluster.restartNameNode(new String[0]);
        nameNodeRpc = this.cluster.getNameNodeRpc();
        LocatedBlock lb2 = nameNodeRpc.addBlock("/testAddBlockRetryShouldReturnBlockWithLocations", "clientName", null, null, 0L, null, null);
        Assertions.assertEquals((Object)lb1.getBlock(), (Object)lb2.getBlock(), (String)"Blocks are not equal");
        Assertions.assertTrue((lb2.getLocations().length > 0 ? 1 : 0) != 0, (String)"Wrong locations with retry");
    }
}

