/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.diskbalancer.command;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileWriter;
import java.io.PrintStream;
import java.net.URI;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.List;
import java.util.Scanner;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.HadoopIllegalArgumentException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.server.common.HdfsServerConstants;
import org.apache.hadoop.hdfs.server.datanode.DataNode;
import org.apache.hadoop.hdfs.server.diskbalancer.DiskBalancerTestUtil;
import org.apache.hadoop.hdfs.server.diskbalancer.command.ReportCommand;
import org.apache.hadoop.hdfs.server.diskbalancer.connectors.ClusterConnector;
import org.apache.hadoop.hdfs.server.diskbalancer.connectors.ConnectorFactory;
import org.apache.hadoop.hdfs.server.diskbalancer.datamodel.DiskBalancerCluster;
import org.apache.hadoop.hdfs.server.diskbalancer.datamodel.DiskBalancerDataNode;
import org.apache.hadoop.hdfs.tools.DiskBalancerCLI;
import org.apache.hadoop.ipc.RemoteException;
import org.apache.hadoop.test.GenericTestUtils;
import org.apache.hadoop.test.LambdaTestUtils;
import org.apache.hadoop.test.PathUtils;
import org.apache.hadoop.util.Lists;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;
import org.assertj.core.api.AbstractStringAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;

public class TestDiskBalancerCommand {
    private MiniDFSCluster cluster;
    private URI clusterJson;
    private Configuration conf = new HdfsConfiguration();
    private static final int DEFAULT_BLOCK_SIZE = 1024;
    private static final int FILE_LEN = 204800;
    private static final long CAPCACITY = 307200L;
    private static final long[] CAPACITIES = new long[]{307200L, 307200L};

    @BeforeEach
    public void setUp() throws Exception {
        this.conf.setBoolean("dfs.disk.balancer.enabled", true);
        this.cluster = new MiniDFSCluster.Builder(this.conf).numDataNodes(3).storagesPerDatanode(2).build();
        this.cluster.waitActive();
        this.clusterJson = this.getClass().getResource("/diskBalancer/data-cluster-64node-3disk.json").toURI();
    }

    @AfterEach
    public void tearDown() throws Exception {
        if (this.cluster != null) {
            for (int i = 0; i < this.cluster.getDataNodes().size(); ++i) {
                this.cluster.getDataNodes().get(i).shutdown();
            }
            this.cluster.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @Timeout(value=60L)
    public void testSubmitPlanInNonRegularStatus() throws Exception {
        boolean numDatanodes = true;
        MiniDFSCluster miniCluster = null;
        HdfsConfiguration hdfsConf = new HdfsConfiguration();
        try {
            miniCluster = DiskBalancerTestUtil.newImbalancedCluster((Configuration)hdfsConf, 1, CAPACITIES, 1024, 204800, HdfsServerConstants.StartupOption.ROLLBACK);
            String planFileFullName = this.runAndVerifyPlan(miniCluster, (Configuration)hdfsConf);
            try {
                String cmdLine = String.format("hdfs diskbalancer -%s %s", "execute", planFileFullName);
                this.runCommand(cmdLine, (Configuration)hdfsConf, miniCluster);
            }
            catch (RemoteException e) {
                Assertions.assertThat((String)e.getClassName()).contains(new CharSequence[]{"DiskBalancerException"});
                ((AbstractStringAssert)Assertions.assertThat((String)e.toString()).contains(new CharSequence[]{"Datanode is in special state"})).contains(new CharSequence[]{"Disk balancing not permitted."});
            }
        }
        finally {
            if (miniCluster != null) {
                miniCluster.shutdown();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @Timeout(value=120L)
    public void testRunMultipleCommandsUnderOneSetup() throws Exception {
        boolean numDatanodes = true;
        MiniDFSCluster miniCluster = null;
        HdfsConfiguration hdfsConf = new HdfsConfiguration();
        try {
            miniCluster = DiskBalancerTestUtil.newImbalancedCluster((Configuration)hdfsConf, 1, CAPACITIES, 1024, 204800);
            String planFileFullName = this.runAndVerifyPlan(miniCluster, (Configuration)hdfsConf);
            String cmdLine = String.format("hdfs diskbalancer -%s %s", "execute", planFileFullName);
            this.runCommand(cmdLine, (Configuration)hdfsConf, miniCluster);
        }
        finally {
            if (miniCluster != null) {
                miniCluster.shutdown();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @Timeout(value=600L)
    public void testDiskBalancerExecuteOptionPlanValidityWithException() throws Exception {
        boolean numDatanodes = true;
        HdfsConfiguration hdfsConf = new HdfsConfiguration();
        hdfsConf.setBoolean("dfs.disk.balancer.enabled", true);
        hdfsConf.set("dfs.disk.balancer.plan.valid.interval", "0d");
        MiniDFSCluster miniCluster = DiskBalancerTestUtil.newImbalancedCluster((Configuration)hdfsConf, 1, CAPACITIES, 1024, 204800);
        try {
            String planFileFullName = this.runAndVerifyPlan(miniCluster, (Configuration)hdfsConf);
            String cmdLine = String.format("hdfs diskbalancer -%s %s", "execute", planFileFullName);
            LambdaTestUtils.intercept(RemoteException.class, (String)"DiskBalancerException", (String)"Plan was generated more than 0d ago", () -> this.lambda$testDiskBalancerExecuteOptionPlanValidityWithException$0(cmdLine, (Configuration)hdfsConf, miniCluster));
        }
        finally {
            if (miniCluster != null) {
                miniCluster.shutdown();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @Timeout(value=600L)
    public void testDiskBalancerExecutePlanValidityWithOutUnitException() throws Exception {
        boolean numDatanodes = true;
        HdfsConfiguration hdfsConf = new HdfsConfiguration();
        hdfsConf.setBoolean("dfs.disk.balancer.enabled", true);
        hdfsConf.set("dfs.disk.balancer.plan.valid.interval", "0");
        MiniDFSCluster miniCluster = DiskBalancerTestUtil.newImbalancedCluster((Configuration)hdfsConf, 1, CAPACITIES, 1024, 204800);
        try {
            String planFileFullName = this.runAndVerifyPlan(miniCluster, (Configuration)hdfsConf);
            String cmdLine = String.format("hdfs diskbalancer -%s %s", "execute", planFileFullName);
            LambdaTestUtils.intercept(RemoteException.class, (String)"DiskBalancerException", (String)"Plan was generated more than 0ms ago", () -> this.lambda$testDiskBalancerExecutePlanValidityWithOutUnitException$1(cmdLine, (Configuration)hdfsConf, miniCluster));
        }
        finally {
            if (miniCluster != null) {
                miniCluster.shutdown();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @Timeout(value=600L)
    public void testDiskBalancerForceExecute() throws Exception {
        boolean numDatanodes = true;
        HdfsConfiguration hdfsConf = new HdfsConfiguration();
        hdfsConf.setBoolean("dfs.disk.balancer.enabled", true);
        hdfsConf.set("dfs.disk.balancer.plan.valid.interval", "0d");
        MiniDFSCluster miniCluster = DiskBalancerTestUtil.newImbalancedCluster((Configuration)hdfsConf, 1, CAPACITIES, 1024, 204800);
        try {
            String planFileFullName = this.runAndVerifyPlan(miniCluster, (Configuration)hdfsConf);
            String cmdLine = String.format("hdfs diskbalancer -%s %s -%s", "execute", planFileFullName, "skipDateCheck");
            this.runCommand(cmdLine, (Configuration)hdfsConf, miniCluster);
        }
        finally {
            if (miniCluster != null) {
                miniCluster.shutdown();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @Timeout(value=600L)
    public void testDiskBalancerExecuteOptionPlanValidity() throws Exception {
        boolean numDatanodes = true;
        HdfsConfiguration hdfsConf = new HdfsConfiguration();
        hdfsConf.setBoolean("dfs.disk.balancer.enabled", true);
        hdfsConf.set("dfs.disk.balancer.plan.valid.interval", "600s");
        MiniDFSCluster miniCluster = DiskBalancerTestUtil.newImbalancedCluster((Configuration)hdfsConf, 1, CAPACITIES, 1024, 204800);
        try {
            String planFileFullName = this.runAndVerifyPlan(miniCluster, (Configuration)hdfsConf);
            String cmdLine = String.format("hdfs diskbalancer -%s %s", "execute", planFileFullName);
            Thread.sleep(10000L);
            this.runCommand(cmdLine, (Configuration)hdfsConf, miniCluster);
        }
        finally {
            if (miniCluster != null) {
                miniCluster.shutdown();
            }
        }
    }

    private String runAndVerifyPlan(MiniDFSCluster miniCluster, Configuration hdfsConf) throws Exception {
        String cmdLine = "";
        List<String> outputs = null;
        DataNode dn = miniCluster.getDataNodes().get(0);
        cmdLine = String.format("hdfs diskbalancer -%s %s", "plan", dn.getDatanodeUuid());
        outputs = this.runCommand(cmdLine, hdfsConf, miniCluster);
        String planFileName = dn.getDatanodeUuid();
        org.junit.jupiter.api.Assertions.assertEquals((int)2, (int)outputs.size(), (String)"There must be two lines: the 1st is writing plan to..., the 2nd is actual full path of plan file.");
        Assertions.assertThat((String)outputs.get(1)).contains(new CharSequence[]{planFileName});
        String planFileFullName = outputs.get(1);
        return planFileFullName;
    }

    @Test
    @Timeout(value=60L)
    public void testExceptionOnInvalidArguments() throws Exception {
        String cmdLine = "hdfs diskbalancer random1 -report random2 random3";
        HadoopIllegalArgumentException ex = (HadoopIllegalArgumentException)org.junit.jupiter.api.Assertions.assertThrows(HadoopIllegalArgumentException.class, () -> this.runCommand("hdfs diskbalancer random1 -report random2 random3"));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)ex.getMessage().contains("Invalid or extra Arguments: [random1, random2, random3]"));
    }

    @Test
    @Timeout(value=60L)
    public void testReportSimple() throws Exception {
        String cmdLine = "hdfs diskbalancer -report";
        List<String> outputs = this.runCommand("hdfs diskbalancer -report");
        Assertions.assertThat((String)outputs.get(0)).contains(new CharSequence[]{"Processing report command"});
        ((AbstractStringAssert)((AbstractStringAssert)Assertions.assertThat((String)outputs.get(1)).contains(new CharSequence[]{"No top limit specified"})).contains(new CharSequence[]{"using default top value"})).contains(new CharSequence[]{"100"});
        ((AbstractStringAssert)((AbstractStringAssert)Assertions.assertThat((String)outputs.get(2)).contains(new CharSequence[]{"Reporting top"})).contains(new CharSequence[]{"64"})).contains(new CharSequence[]{"DataNode(s) benefiting from running DiskBalancer"});
        ((AbstractStringAssert)((AbstractStringAssert)Assertions.assertThat((String)outputs.get(32)).contains(new CharSequence[]{"30/64 null[null:0]"})).contains(new CharSequence[]{"a87654a9-54c7-4693-8dd9-c9c7021dc340"})).contains(new CharSequence[]{"9 volumes with node data density 1.97"});
    }

    @Test
    @Timeout(value=60L)
    public void testReportWithNegativeTopLimit() throws Exception {
        String cmdLine = "hdfs diskbalancer -report -top -32";
        IllegalArgumentException ex = (IllegalArgumentException)org.junit.jupiter.api.Assertions.assertThrows(IllegalArgumentException.class, () -> this.runCommand("hdfs diskbalancer -report -top -32"));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)ex.getMessage().contains("Top limit input should be a positive numeric value"));
    }

    @Test
    @Timeout(value=60L)
    public void testReportLessThanTotal() throws Exception {
        String cmdLine = "hdfs diskbalancer -report -top 32";
        List<String> outputs = this.runCommand("hdfs diskbalancer -report -top 32");
        Assertions.assertThat((String)outputs.get(0)).contains(new CharSequence[]{"Processing report command"});
        Assertions.assertThat((String)outputs.get(1)).contains(new CharSequence[]{"Reporting top", "32", "DataNode(s) benefiting from running DiskBalancer"});
        Assertions.assertThat((String)outputs.get(31)).contains(new CharSequence[]{"30/32 null[null:0]", "a87654a9-54c7-4693-8dd9-c9c7021dc340", "9 volumes with node data density 1.97"});
    }

    @Test
    @Timeout(value=60L)
    public void testReportWithGenericOptionFS() throws Exception {
        String topReportArg = "5";
        String reportArgs = String.format("-%s file:%s -%s -%s %s", "fs", this.clusterJson.getPath(), "report", "top", "5");
        String cmdLine = String.format("%s", reportArgs);
        List<String> outputs = this.runCommand(cmdLine);
        Assertions.assertThat((String)outputs.get(0)).contains(new CharSequence[]{"Processing report command"});
        Assertions.assertThat((String)outputs.get(1)).contains(new CharSequence[]{"Reporting top", "5", "DataNode(s) benefiting from running DiskBalancer"});
    }

    @Test
    @Timeout(value=60L)
    public void testReportMoreThanTotal() throws Exception {
        String cmdLine = "hdfs diskbalancer -report -top 128";
        List<String> outputs = this.runCommand("hdfs diskbalancer -report -top 128");
        Assertions.assertThat((String)outputs.get(0)).contains(new CharSequence[]{"Processing report command"});
        Assertions.assertThat((String)outputs.get(1)).contains(new CharSequence[]{"Reporting top", "64", "DataNode(s) benefiting from running DiskBalancer"});
        Assertions.assertThat((String)outputs.get(31)).contains(new CharSequence[]{"30/64 null[null:0]", "a87654a9-54c7-4693-8dd9-c9c7021dc340", "9 volumes with node data density 1.97"});
    }

    @Test
    @Timeout(value=60L)
    public void testReportInvalidTopLimit() throws Exception {
        String cmdLine = "hdfs diskbalancer -report -top xx";
        List<String> outputs = this.runCommand("hdfs diskbalancer -report -top xx");
        Assertions.assertThat((String)outputs.get(0)).contains(new CharSequence[]{"Processing report command"});
        Assertions.assertThat((String)outputs.get(1)).contains(new CharSequence[]{"Top limit input is not numeric", "using default top value", "100"});
        Assertions.assertThat((String)outputs.get(2)).contains(new CharSequence[]{"Reporting top", "64", "DataNode(s) benefiting from running DiskBalancer"});
        Assertions.assertThat((String)outputs.get(32)).contains(new CharSequence[]{"30/64 null[null:0]", "a87654a9-54c7-4693-8dd9-c9c7021dc340", "9 volumes with node data density 1.97"});
    }

    @Test
    @Timeout(value=60L)
    public void testReportNode() throws Exception {
        String cmdLine = "hdfs diskbalancer -report -node a87654a9-54c7-4693-8dd9-c9c7021dc340";
        List<String> outputs = this.runCommand("hdfs diskbalancer -report -node a87654a9-54c7-4693-8dd9-c9c7021dc340");
        Assertions.assertThat((String)outputs.get(0)).contains(new CharSequence[]{"Processing report command"});
        Assertions.assertThat((String)outputs.get(1)).contains(new CharSequence[]{"Reporting volume information for DataNode", "a87654a9-54c7-4693-8dd9-c9c7021dc340"});
        Assertions.assertThat((String)outputs.get(2)).contains(new CharSequence[]{"null[null:0]", "a87654a9-54c7-4693-8dd9-c9c7021dc340", "9 volumes with node data density 1.97"});
        Assertions.assertThat((String)outputs.get(3)).contains(new CharSequence[]{"DISK", "/tmp/disk/KmHefYNURo", "0.20 used: 39160240782/200000000000", "0.80 free: 160839759218/200000000000"});
        Assertions.assertThat((String)outputs.get(4)).contains(new CharSequence[]{"DISK", "/tmp/disk/Mxfcfmb24Y", "0.92 used: 733099315216/800000000000", "0.08 free: 66900684784/800000000000"});
        Assertions.assertThat((String)outputs.get(5)).contains(new CharSequence[]{"DISK", "/tmp/disk/xx3j3ph3zd", "0.72 used: 289544224916/400000000000", "0.28 free: 110455775084/400000000000"});
        Assertions.assertThat((String)outputs.get(6)).contains(new CharSequence[]{"RAM_DISK", "/tmp/disk/BoBlQFxhfw", "0.60 used: 477590453390/800000000000", "0.40 free: 322409546610/800000000000"});
        Assertions.assertThat((String)outputs.get(7)).contains(new CharSequence[]{"RAM_DISK", "/tmp/disk/DtmAygEU6f", "0.34 used: 134602910470/400000000000", "0.66 free: 265397089530/400000000000"});
        Assertions.assertThat((String)outputs.get(8)).contains(new CharSequence[]{"RAM_DISK", "/tmp/disk/MXRyYsCz3U", "0.55 used: 438102096853/800000000000", "0.45 free: 361897903147/800000000000"});
        Assertions.assertThat((String)outputs.get(9)).contains(new CharSequence[]{"SSD", "/tmp/disk/BGe09Y77dI", "0.89 used: 890446265501/1000000000000", "0.11 free: 109553734499/1000000000000"});
        Assertions.assertThat((String)outputs.get(10)).contains(new CharSequence[]{"SSD", "/tmp/disk/JX3H8iHggM", "0.31 used: 2782614512957/9000000000000", "0.69 free: 6217385487043/9000000000000"});
        Assertions.assertThat((String)outputs.get(11)).contains(new CharSequence[]{"SSD", "/tmp/disk/uLOYmVZfWV", "0.75 used: 1509592146007/2000000000000", "0.25 free: 490407853993/2000000000000"});
    }

    @Test
    @Timeout(value=60L)
    public void testReportNodeWithoutJson() throws Exception {
        String dataNodeUuid = this.cluster.getDataNodes().get(0).getDatanodeUuid();
        String planArg = String.format("-%s -%s %s", "report", "node", dataNodeUuid);
        String cmdLine = String.format("hdfs diskbalancer %s", planArg);
        List<String> outputs = this.runCommand(cmdLine, this.cluster);
        Assertions.assertThat((String)outputs.get(0)).contains(new CharSequence[]{"Processing report command"});
        Assertions.assertThat((String)outputs.get(1)).contains(new CharSequence[]{"Reporting volume information for DataNode", dataNodeUuid});
        Assertions.assertThat((String)outputs.get(2)).contains(new CharSequence[]{dataNodeUuid, "2 volumes with node data density 0.00"});
        Assertions.assertThat((String)outputs.get(3)).contains(new CharSequence[]{"DISK", new Path(this.cluster.getInstanceStorageDir(0, 0).getAbsolutePath()).toString(), "0.00", "1.00"});
        Assertions.assertThat((String)outputs.get(4)).contains(new CharSequence[]{"DISK", new Path(this.cluster.getInstanceStorageDir(0, 1).getAbsolutePath()).toString(), "0.00", "1.00"});
    }

    @Test
    @Timeout(value=60L)
    public void testReadClusterFromJson() throws Exception {
        ClusterConnector jsonConnector = ConnectorFactory.getCluster((URI)this.clusterJson, (Configuration)this.conf);
        DiskBalancerCluster diskBalancerCluster = new DiskBalancerCluster(jsonConnector);
        diskBalancerCluster.readClusterInfo();
        org.junit.jupiter.api.Assertions.assertEquals((int)64, (int)diskBalancerCluster.getNodes().size());
    }

    @Test
    @Timeout(value=60L)
    public void testPlanNode() throws Exception {
        String planArg = String.format("-%s %s", "plan", this.cluster.getDataNodes().get(0).getDatanodeUuid());
        String cmdLine = String.format("hdfs diskbalancer %s", planArg);
        this.runCommand(cmdLine, this.cluster);
    }

    @Test
    @Timeout(value=60L)
    public void testPlanJsonNode() throws Exception {
        String planArg = String.format("-%s %s", "plan", "a87654a9-54c7-4693-8dd9-c9c7021dc340");
        Path testPath = new Path(PathUtils.getTestPath(this.getClass()), GenericTestUtils.getMethodName());
        String cmdLine = String.format("hdfs diskbalancer -out %s %s", testPath, planArg);
        this.runCommand(cmdLine);
    }

    @Test
    @Timeout(value=60L)
    public void testIllegalArgument() throws Exception {
        String planArg = String.format("-%s %s", "plan", "a87654a9-54c7-4693-8dd9-c9c7021dc340");
        String cmdLine = String.format("hdfs diskbalancer %s -report", planArg);
        org.junit.jupiter.api.Assertions.assertThrows(IllegalArgumentException.class, () -> this.runCommand(cmdLine));
    }

    @Test
    @Timeout(value=60L)
    public void testCancelCommand() throws Exception {
        String cancelArg = String.format("-%s %s", "cancel", "nosuchplan");
        String nodeArg = String.format("-%s %s", "node", this.cluster.getDataNodes().get(0).getDatanodeUuid());
        org.junit.jupiter.api.Assertions.assertThrows(IllegalArgumentException.class, () -> {
            String cmdLine = String.format("hdfs diskbalancer  %s %s", cancelArg, nodeArg);
            this.runCommand(cmdLine);
        });
    }

    @Test
    @Timeout(value=60L)
    public void testQueryCommand() throws Exception {
        String queryArg = String.format("-%s %s", "query", this.cluster.getDataNodes().get(0).getDatanodeUuid());
        org.junit.jupiter.api.Assertions.assertThrows(UnknownHostException.class, () -> {
            String cmdLine = String.format("hdfs diskbalancer %s", queryArg);
            this.runCommand(cmdLine);
        });
    }

    @Test
    @Timeout(value=60L)
    public void testHelpCommand() throws Exception {
        String helpArg = String.format("-%s", "help");
        String cmdLine = String.format("hdfs diskbalancer %s", helpArg);
        this.runCommand(cmdLine);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testPrintFullPathOfPlan() throws Exception {
        String parent = GenericTestUtils.getRandomizedTempPath();
        MiniDFSCluster miniCluster = null;
        try {
            HdfsConfiguration hdfsConf = new HdfsConfiguration();
            List<String> outputs = null;
            miniCluster = DiskBalancerTestUtil.newImbalancedCluster((Configuration)hdfsConf, 1, CAPACITIES, 1024, 204800);
            String cmdLine = String.format("hdfs diskbalancer -%s %s -%s %s", "plan", miniCluster.getDataNodes().get(0).getDatanodeUuid(), "out", parent);
            outputs = this.runCommand(cmdLine, (Configuration)hdfsConf, miniCluster);
            String planFileFullName = new Path(parent, miniCluster.getDataNodes().get(0).getDatanodeUuid()).toString();
            org.junit.jupiter.api.Assertions.assertEquals((int)2, (int)outputs.size(), (String)"There must be two lines: the 1st is writing plan to, the 2nd is actual full path of plan file.");
            Assertions.assertThat((String)outputs.get(0)).contains(new CharSequence[]{"Writing plan to"});
            Assertions.assertThat((String)outputs.get(1)).contains(new CharSequence[]{planFileFullName});
        }
        finally {
            if (miniCluster != null) {
                miniCluster.shutdown();
            }
        }
    }

    private List<String> runCommandInternal(String cmdLine, Configuration clusterConf) throws Exception {
        String[] cmds = StringUtils.split((String)cmdLine, (char)' ');
        ByteArrayOutputStream bufOut = new ByteArrayOutputStream();
        PrintStream out = new PrintStream(bufOut);
        DiskBalancerCLI diskBalancerTool = new DiskBalancerCLI(clusterConf, out);
        ToolRunner.run((Configuration)clusterConf, (Tool)diskBalancerTool, (String[])cmds);
        Scanner scanner = new Scanner(bufOut.toString());
        ArrayList outputs = Lists.newArrayList();
        while (scanner.hasNextLine()) {
            outputs.add(scanner.nextLine());
        }
        return outputs;
    }

    private List<String> runCommandInternal(String cmdLine) throws Exception {
        return this.runCommandInternal(cmdLine, this.conf);
    }

    private List<String> runCommand(String cmdLine) throws Exception {
        FileSystem.setDefaultUri((Configuration)this.conf, (URI)this.clusterJson);
        return this.runCommandInternal(cmdLine);
    }

    private List<String> runCommand(String cmdLine, MiniDFSCluster miniCluster) throws Exception {
        FileSystem.setDefaultUri((Configuration)this.conf, (URI)miniCluster.getURI());
        return this.runCommandInternal(cmdLine);
    }

    private List<String> runCommand(String cmdLine, Configuration clusterConf, MiniDFSCluster miniCluster) throws Exception {
        FileSystem.setDefaultUri((Configuration)clusterConf, (URI)miniCluster.getURI());
        return this.runCommandInternal(cmdLine, clusterConf);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDiskBalancerQueryWithoutSubmitAndMultipleNodes() throws Exception {
        HdfsConfiguration hdfsConf = new HdfsConfiguration();
        hdfsConf.setBoolean("dfs.disk.balancer.enabled", true);
        int numDatanodes = 2;
        File basedir = new File(GenericTestUtils.getRandomizedTempPath());
        MiniDFSCluster miniDFSCluster = new MiniDFSCluster.Builder((Configuration)hdfsConf, basedir).numDataNodes(2).build();
        try {
            miniDFSCluster.waitActive();
            DataNode dataNode1 = miniDFSCluster.getDataNodes().get(0);
            DataNode dataNode2 = miniDFSCluster.getDataNodes().get(1);
            String queryArg = String.format("-query localhost:%d,localhost:%d", dataNode1.getIpcPort(), dataNode2.getIpcPort());
            String cmdLine = String.format("hdfs diskbalancer %s", queryArg);
            List<String> outputs = this.runCommand(cmdLine);
            org.junit.jupiter.api.Assertions.assertEquals((int)12, (int)outputs.size());
            org.junit.jupiter.api.Assertions.assertTrue((outputs.get(1).contains("localhost:" + dataNode1.getIpcPort()) || outputs.get(6).contains("localhost:" + dataNode1.getIpcPort()) ? 1 : 0) != 0, (String)("Expected outputs: " + outputs));
            org.junit.jupiter.api.Assertions.assertTrue((outputs.get(1).contains("localhost:" + dataNode2.getIpcPort()) || outputs.get(6).contains("localhost:" + dataNode2.getIpcPort()) ? 1 : 0) != 0, (String)("Expected outputs: " + outputs));
        }
        finally {
            miniDFSCluster.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDiskBalancerQueryWithoutSubmit() throws Exception {
        HdfsConfiguration hdfsConf = new HdfsConfiguration();
        hdfsConf.setBoolean("dfs.disk.balancer.enabled", true);
        int numDatanodes = 2;
        File basedir = new File(GenericTestUtils.getRandomizedTempPath());
        MiniDFSCluster miniDFSCluster = new MiniDFSCluster.Builder((Configuration)hdfsConf, basedir).numDataNodes(2).build();
        try {
            miniDFSCluster.waitActive();
            DataNode dataNode = miniDFSCluster.getDataNodes().get(0);
            String queryArg = String.format("-query localhost:%d", dataNode.getIpcPort());
            String cmdLine = String.format("hdfs diskbalancer %s", queryArg);
            this.runCommand(cmdLine);
        }
        finally {
            miniDFSCluster.shutdown();
        }
    }

    @Test
    @Timeout(value=60L)
    public void testGetNodeList() throws Exception {
        ClusterConnector jsonConnector = ConnectorFactory.getCluster((URI)this.clusterJson, (Configuration)this.conf);
        DiskBalancerCluster diskBalancerCluster = new DiskBalancerCluster(jsonConnector);
        diskBalancerCluster.readClusterInfo();
        int nodeNum = 5;
        StringBuilder listArg = new StringBuilder();
        for (int i = 0; i < nodeNum; ++i) {
            listArg.append(((DiskBalancerDataNode)diskBalancerCluster.getNodes().get(i)).getDataNodeUUID()).append(",");
        }
        ReportCommand command = new ReportCommand(this.conf, null);
        command.setCluster(diskBalancerCluster);
        List nodeList = command.getNodes(listArg.toString());
        org.junit.jupiter.api.Assertions.assertEquals((int)nodeNum, (int)nodeList.size());
    }

    @Test
    @Timeout(value=60L)
    public void testReportCommandWithMultipleNodes() throws Exception {
        String dataNodeUuid1 = this.cluster.getDataNodes().get(0).getDatanodeUuid();
        String dataNodeUuid2 = this.cluster.getDataNodes().get(1).getDatanodeUuid();
        String planArg = String.format("-%s -%s %s,%s", "report", "node", dataNodeUuid1, dataNodeUuid2);
        String cmdLine = String.format("hdfs diskbalancer %s", planArg);
        List<String> outputs = this.runCommand(cmdLine, this.cluster);
        this.verifyOutputsOfReportCommand(outputs, dataNodeUuid1, dataNodeUuid2, true);
    }

    private void verifyOutputsOfReportCommand(List<String> outputs, String dataNodeUuid1, String dataNodeUuid2, boolean inputNodesStr) {
        Assertions.assertThat((String)outputs.get(0)).contains(new CharSequence[]{"Processing report command"});
        if (inputNodesStr) {
            ((AbstractStringAssert)Assertions.assertThat((String)outputs.get(1)).contains(new CharSequence[]{"Reporting volume information for DataNode"})).contains(new CharSequence[]{dataNodeUuid1, dataNodeUuid2});
        }
        org.junit.jupiter.api.Assertions.assertTrue((outputs.get(2).contains(dataNodeUuid1) || outputs.get(6).contains(dataNodeUuid1) ? 1 : 0) != 0);
        org.junit.jupiter.api.Assertions.assertTrue((outputs.get(2).contains(dataNodeUuid2) || outputs.get(6).contains(dataNodeUuid2) ? 1 : 0) != 0);
    }

    @Test
    @Timeout(value=60L)
    public void testReportCommandWithInvalidNode() throws Exception {
        String dataNodeUuid1 = this.cluster.getDataNodes().get(0).getDatanodeUuid();
        String invalidNode = "invalidNode";
        String planArg = String.format("-%s -%s %s,%s", "report", "node", dataNodeUuid1, invalidNode);
        String cmdLine = String.format("hdfs diskbalancer %s", planArg);
        List<String> outputs = this.runCommand(cmdLine, this.cluster);
        Assertions.assertThat((String)outputs.get(0)).contains(new CharSequence[]{"Processing report command"});
        Assertions.assertThat((String)outputs.get(1)).contains(new CharSequence[]{"Reporting volume information for DataNode", dataNodeUuid1, invalidNode});
        String invalidNodeInfo = String.format("The node(s) '%s' not found. Please make sure that '%s' exists in the cluster.", invalidNode, invalidNode);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)outputs.get(2).contains(invalidNodeInfo));
    }

    @Test
    @Timeout(value=60L)
    public void testReportCommandWithNullNodes() throws Exception {
        String planArg = String.format("-%s -%s ,", "report", "node");
        String cmdLine = String.format("hdfs diskbalancer %s", planArg);
        List<String> outputs = this.runCommand(cmdLine, this.cluster);
        String invalidNodeInfo = "The number of input nodes is 0. Please input the valid nodes.";
        org.junit.jupiter.api.Assertions.assertTrue((boolean)outputs.get(2).contains(invalidNodeInfo));
    }

    @Test
    @Timeout(value=60L)
    public void testReportCommandWithReadingHostFile() throws Exception {
        String testDir = GenericTestUtils.getTestDir().getAbsolutePath();
        File includeFile = new File(testDir, "diskbalancer.include");
        String filePath = testDir + "/diskbalancer.include";
        String dataNodeUuid1 = this.cluster.getDataNodes().get(0).getDatanodeUuid();
        String dataNodeUuid2 = this.cluster.getDataNodes().get(1).getDatanodeUuid();
        FileWriter fw = new FileWriter(filePath);
        fw.write("#This-is-comment\n");
        fw.write(dataNodeUuid1 + "\n");
        fw.write(dataNodeUuid2 + "\n");
        fw.close();
        String planArg = String.format("-%s -%s file://%s", "report", "node", filePath);
        String cmdLine = String.format("hdfs diskbalancer %s", planArg);
        List<String> outputs = this.runCommand(cmdLine, this.cluster);
        this.verifyOutputsOfReportCommand(outputs, dataNodeUuid1, dataNodeUuid2, false);
        includeFile.delete();
    }

    @Test
    @Timeout(value=60L)
    public void testReportCommandWithInvalidHostFilePath() throws Exception {
        String testDir = GenericTestUtils.getTestDir().getAbsolutePath();
        String invalidFilePath = testDir + "/diskbalancer-invalid.include";
        String planArg = String.format("-%s -%s file://%s", "report", "node", invalidFilePath);
        String cmdLine = String.format("hdfs diskbalancer %s", planArg);
        List<String> outputs = this.runCommand(cmdLine, this.cluster);
        String invalidNodeInfo = String.format("The input host file path 'file://%s' is not a valid path.", invalidFilePath);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)outputs.get(2).contains(invalidNodeInfo));
    }

    private /* synthetic */ void lambda$testDiskBalancerExecutePlanValidityWithOutUnitException$1(String cmdLine, Configuration hdfsConf, MiniDFSCluster miniCluster) throws Exception {
        this.runCommand(cmdLine, hdfsConf, miniCluster);
    }

    private /* synthetic */ void lambda$testDiskBalancerExecuteOptionPlanValidityWithException$0(String cmdLine, Configuration hdfsConf, MiniDFSCluster miniCluster) throws Exception {
        this.runCommand(cmdLine, hdfsConf, miniCluster);
    }
}

