/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.diskbalancer;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.DFSTestUtil;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.server.datanode.DataNode;
import org.apache.hadoop.hdfs.server.datanode.DiskBalancerWorkStatus;
import org.apache.hadoop.hdfs.server.datanode.fsdataset.FsDatasetSpi;
import org.apache.hadoop.hdfs.server.datanode.fsdataset.FsVolumeSpi;
import org.apache.hadoop.hdfs.server.datanode.fsdataset.impl.FsVolumeImpl;
import org.apache.hadoop.hdfs.server.diskbalancer.DiskBalancerException;
import org.apache.hadoop.hdfs.server.diskbalancer.DiskBalancerTestUtil;
import org.apache.hadoop.hdfs.server.diskbalancer.connectors.ClusterConnector;
import org.apache.hadoop.hdfs.server.diskbalancer.connectors.ConnectorFactory;
import org.apache.hadoop.hdfs.server.diskbalancer.datamodel.DiskBalancerCluster;
import org.apache.hadoop.hdfs.server.diskbalancer.datamodel.DiskBalancerDataNode;
import org.apache.hadoop.hdfs.server.diskbalancer.datamodel.DiskBalancerVolumeSet;
import org.apache.hadoop.hdfs.server.diskbalancer.planner.GreedyPlanner;
import org.apache.hadoop.hdfs.server.diskbalancer.planner.NodePlan;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class TestDiskBalancerRPC {
    private static final String PLAN_FILE = "/system/current.plan.json";
    private MiniDFSCluster cluster;
    private Configuration conf;

    @BeforeEach
    public void setUp() throws Exception {
        this.conf = new HdfsConfiguration();
        this.conf.setBoolean("dfs.disk.balancer.enabled", true);
        this.cluster = new MiniDFSCluster.Builder(this.conf).numDataNodes(2).build();
        this.cluster.waitActive();
    }

    @AfterEach
    public void tearDown() throws Exception {
        if (this.cluster != null) {
            this.cluster.shutdown();
        }
    }

    @Test
    public void testSubmitPlan() throws Exception {
        RpcTestHelper rpcTestHelper = new RpcTestHelper().invoke();
        DataNode dataNode = rpcTestHelper.getDataNode();
        String planHash = rpcTestHelper.getPlanHash();
        int planVersion = rpcTestHelper.getPlanVersion();
        NodePlan plan = rpcTestHelper.getPlan();
        dataNode.submitDiskBalancerPlan(planHash, (long)planVersion, PLAN_FILE, plan.toJson(), false);
    }

    @Test
    public void testSubmitPlanWithInvalidHash() throws Exception {
        RpcTestHelper rpcTestHelper = new RpcTestHelper().invoke();
        DataNode dataNode = rpcTestHelper.getDataNode();
        String planHash = rpcTestHelper.getPlanHash();
        char[] hashArray = planHash.toCharArray();
        hashArray[0] = (char)(hashArray[0] + '\u0001');
        planHash = String.valueOf(hashArray);
        int planVersion = rpcTestHelper.getPlanVersion();
        NodePlan plan = rpcTestHelper.getPlan();
        String planHashVariant = planHash;
        DiskBalancerException ex = (DiskBalancerException)org.junit.jupiter.api.Assertions.assertThrows(DiskBalancerException.class, () -> dataNode.submitDiskBalancerPlan(planHashVariant, (long)planVersion, PLAN_FILE, plan.toJson(), false));
        Assertions.assertThat((Comparable)ex.getResult()).isEqualTo((Object)DiskBalancerException.Result.INVALID_PLAN_HASH);
    }

    @Test
    public void testSubmitPlanWithInvalidVersion() throws Exception {
        RpcTestHelper rpcTestHelper = new RpcTestHelper().invoke();
        DataNode dataNode = rpcTestHelper.getDataNode();
        String planHash = rpcTestHelper.getPlanHash();
        int planVersion = rpcTestHelper.getPlanVersion();
        NodePlan plan = rpcTestHelper.getPlan();
        int planVersionVariant = ++planVersion;
        DiskBalancerException ex = (DiskBalancerException)org.junit.jupiter.api.Assertions.assertThrows(DiskBalancerException.class, () -> dataNode.submitDiskBalancerPlan(planHash, (long)planVersionVariant, PLAN_FILE, plan.toJson(), false));
        Assertions.assertThat((Comparable)ex.getResult()).isEqualTo((Object)DiskBalancerException.Result.INVALID_PLAN_VERSION);
    }

    @Test
    public void testSubmitPlanWithInvalidPlan() throws Exception {
        RpcTestHelper rpcTestHelper = new RpcTestHelper().invoke();
        DataNode dataNode = rpcTestHelper.getDataNode();
        String planHash = rpcTestHelper.getPlanHash();
        int planVersion = rpcTestHelper.getPlanVersion();
        NodePlan plan = rpcTestHelper.getPlan();
        DiskBalancerException ex = (DiskBalancerException)org.junit.jupiter.api.Assertions.assertThrows(DiskBalancerException.class, () -> dataNode.submitDiskBalancerPlan(planHash, (long)planVersion, "", "", false));
        Assertions.assertThat((Comparable)ex.getResult()).isEqualTo((Object)DiskBalancerException.Result.INVALID_PLAN);
    }

    @Test
    public void testCancelPlan() throws Exception {
        RpcTestHelper rpcTestHelper = new RpcTestHelper().invoke();
        DataNode dataNode = rpcTestHelper.getDataNode();
        String planHash = rpcTestHelper.getPlanHash();
        int planVersion = rpcTestHelper.getPlanVersion();
        NodePlan plan = rpcTestHelper.getPlan();
        dataNode.submitDiskBalancerPlan(planHash, (long)planVersion, PLAN_FILE, plan.toJson(), false);
        dataNode.cancelDiskBalancePlan(planHash);
    }

    @Test
    public void testCancelNonExistentPlan() throws Exception {
        RpcTestHelper rpcTestHelper = new RpcTestHelper().invoke();
        DataNode dataNode = rpcTestHelper.getDataNode();
        String planHash = rpcTestHelper.getPlanHash();
        char[] hashArray = planHash.toCharArray();
        hashArray[0] = (char)(hashArray[0] + '\u0001');
        planHash = String.valueOf(hashArray);
        NodePlan plan = rpcTestHelper.getPlan();
        String planHashVariant = planHash;
        DiskBalancerException ex = (DiskBalancerException)org.junit.jupiter.api.Assertions.assertThrows(DiskBalancerException.class, () -> dataNode.cancelDiskBalancePlan(planHashVariant));
        Assertions.assertThat((Comparable)ex.getResult()).isEqualTo((Object)DiskBalancerException.Result.NO_SUCH_PLAN);
    }

    @Test
    public void testCancelEmptyPlan() throws Exception {
        RpcTestHelper rpcTestHelper = new RpcTestHelper().invoke();
        DataNode dataNode = rpcTestHelper.getDataNode();
        String planHash = "";
        NodePlan plan = rpcTestHelper.getPlan();
        DiskBalancerException ex = (DiskBalancerException)org.junit.jupiter.api.Assertions.assertThrows(DiskBalancerException.class, () -> dataNode.cancelDiskBalancePlan(planHash));
        Assertions.assertThat((Comparable)ex.getResult()).isEqualTo((Object)DiskBalancerException.Result.NO_SUCH_PLAN);
    }

    @Test
    public void testGetDiskBalancerVolumeMapping() throws Exception {
        boolean dnIndex = false;
        DataNode dataNode = this.cluster.getDataNodes().get(0);
        String volumeNameJson = dataNode.getDiskBalancerSetting("DiskBalancerVolumeName");
        org.junit.jupiter.api.Assertions.assertNotNull((Object)volumeNameJson);
        ObjectMapper mapper = new ObjectMapper();
        Map volumemap = (Map)mapper.readValue(volumeNameJson, HashMap.class);
        org.junit.jupiter.api.Assertions.assertEquals((int)2, (int)volumemap.size());
    }

    @Test
    public void testGetDiskBalancerInvalidSetting() throws Exception {
        boolean dnIndex = false;
        String invalidSetting = "invalidSetting";
        DataNode dataNode = this.cluster.getDataNodes().get(0);
        DiskBalancerException ex = (DiskBalancerException)org.junit.jupiter.api.Assertions.assertThrows(DiskBalancerException.class, () -> dataNode.getDiskBalancerSetting("invalidSetting"));
        Assertions.assertThat((Comparable)ex.getResult()).isEqualTo((Object)DiskBalancerException.Result.UNKNOWN_KEY);
    }

    @Test
    public void testGetDiskBalancerBandwidth() throws Exception {
        RpcTestHelper rpcTestHelper = new RpcTestHelper().invoke();
        DataNode dataNode = rpcTestHelper.getDataNode();
        String planHash = rpcTestHelper.getPlanHash();
        int planVersion = rpcTestHelper.getPlanVersion();
        NodePlan plan = rpcTestHelper.getPlan();
        dataNode.submitDiskBalancerPlan(planHash, (long)planVersion, PLAN_FILE, plan.toJson(), false);
        String bandwidthString = dataNode.getDiskBalancerSetting("DiskBalancerBandwidth");
        long value = Long.decode(bandwidthString);
        org.junit.jupiter.api.Assertions.assertEquals((long)10L, (long)value);
    }

    @Test
    public void testQueryPlan() throws Exception {
        RpcTestHelper rpcTestHelper = new RpcTestHelper().invoke();
        DataNode dataNode = rpcTestHelper.getDataNode();
        String planHash = rpcTestHelper.getPlanHash();
        int planVersion = rpcTestHelper.getPlanVersion();
        NodePlan plan = rpcTestHelper.getPlan();
        dataNode.submitDiskBalancerPlan(planHash, (long)planVersion, PLAN_FILE, plan.toJson(), false);
        DiskBalancerWorkStatus status = dataNode.queryDiskBalancerPlan();
        org.junit.jupiter.api.Assertions.assertTrue((status.getResult() == DiskBalancerWorkStatus.Result.PLAN_UNDER_PROGRESS || status.getResult() == DiskBalancerWorkStatus.Result.PLAN_DONE ? 1 : 0) != 0);
    }

    @Test
    public void testQueryPlanWithoutSubmit() throws Exception {
        RpcTestHelper rpcTestHelper = new RpcTestHelper().invoke();
        DataNode dataNode = rpcTestHelper.getDataNode();
        DiskBalancerWorkStatus status = dataNode.queryDiskBalancerPlan();
        org.junit.jupiter.api.Assertions.assertTrue((status.getResult() == DiskBalancerWorkStatus.Result.NO_PLAN ? 1 : 0) != 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMoveBlockAcrossVolume() throws Exception {
        HdfsConfiguration conf = new HdfsConfiguration();
        int defaultBlockSize = 100;
        conf.setBoolean("dfs.disk.balancer.enabled", true);
        conf.setLong("dfs.blocksize", 100L);
        conf.setInt("dfs.bytes-per-checksum", 100);
        String fileName = "/tmp.txt";
        Path filePath = new Path(fileName);
        boolean numDatanodes = true;
        boolean dnIndex = false;
        this.cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(1).build();
        FsVolumeImpl source = null;
        FsVolumeImpl dest = null;
        try {
            this.cluster.waitActive();
            Random r = new Random();
            DistributedFileSystem fs = this.cluster.getFileSystem(0);
            DFSTestUtil.createFile((FileSystem)fs, filePath, 10240L, (short)1, r.nextLong());
            DataNode dnNode = this.cluster.getDataNodes().get(0);
            try (FsDatasetSpi.FsVolumeReferences refs = dnNode.getFSDataset().getFsVolumeReferences();){
                source = (FsVolumeImpl)refs.get(0);
                dest = (FsVolumeImpl)refs.get(1);
                DiskBalancerTestUtil.moveAllDataToDestVolume(dnNode.getFSDataset(), (FsVolumeSpi)source, (FsVolumeSpi)dest);
                org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)DiskBalancerTestUtil.getBlockCount((FsVolumeSpi)source, false));
            }
        }
        finally {
            this.cluster.shutdown();
        }
    }

    private class RpcTestHelper {
        private NodePlan plan;
        private int planVersion;
        private DataNode dataNode;
        private String planHash;

        private RpcTestHelper() {
        }

        public NodePlan getPlan() {
            return this.plan;
        }

        public int getPlanVersion() {
            return this.planVersion;
        }

        public DataNode getDataNode() {
            return this.dataNode;
        }

        public String getPlanHash() {
            return this.planHash;
        }

        public RpcTestHelper invoke() throws Exception {
            boolean dnIndex = false;
            TestDiskBalancerRPC.this.cluster.restartDataNode(0);
            TestDiskBalancerRPC.this.cluster.waitActive();
            ClusterConnector nameNodeConnector = ConnectorFactory.getCluster((URI)TestDiskBalancerRPC.this.cluster.getFileSystem(0).getUri(), (Configuration)TestDiskBalancerRPC.this.conf);
            DiskBalancerCluster diskBalancerCluster = new DiskBalancerCluster(nameNodeConnector);
            diskBalancerCluster.readClusterInfo();
            org.junit.jupiter.api.Assertions.assertEquals((int)TestDiskBalancerRPC.this.cluster.getDataNodes().size(), (int)diskBalancerCluster.getNodes().size());
            diskBalancerCluster.setNodesToProcess(diskBalancerCluster.getNodes());
            this.dataNode = TestDiskBalancerRPC.this.cluster.getDataNodes().get(0);
            DiskBalancerDataNode node = diskBalancerCluster.getNodeByUUID(this.dataNode.getDatanodeUuid());
            GreedyPlanner planner = new GreedyPlanner(10.0, node);
            this.plan = new NodePlan(node.getDataNodeName(), node.getDataNodePort());
            planner.balanceVolumeSet(node, (DiskBalancerVolumeSet)node.getVolumeSets().get("DISK"), this.plan);
            this.planVersion = 1;
            this.planHash = DigestUtils.sha1Hex((String)this.plan.toJson());
            return this;
        }
    }
}

