/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.diskbalancer;

import java.io.IOException;
import java.net.URI;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.server.diskbalancer.connectors.ClusterConnector;
import org.apache.hadoop.hdfs.server.diskbalancer.connectors.ConnectorFactory;
import org.apache.hadoop.hdfs.server.diskbalancer.datamodel.DiskBalancerCluster;
import org.apache.hadoop.hdfs.server.diskbalancer.datamodel.DiskBalancerDataNode;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class TestConnectors {
    private MiniDFSCluster cluster;
    private final int numDatanodes = 3;
    private final int volumeCount = 2;
    private Configuration conf;

    @BeforeEach
    public void setup() throws IOException {
        this.conf = new HdfsConfiguration();
        this.cluster = new MiniDFSCluster.Builder(this.conf).numDataNodes(3).build();
    }

    @AfterEach
    public void teardown() {
        if (this.cluster != null) {
            this.cluster.shutdown();
        }
    }

    @Test
    public void testNameNodeConnector() throws Exception {
        this.cluster.waitActive();
        ClusterConnector nameNodeConnector = ConnectorFactory.getCluster((URI)this.cluster.getFileSystem(0).getUri(), (Configuration)this.conf);
        DiskBalancerCluster diskBalancerCluster = new DiskBalancerCluster(nameNodeConnector);
        diskBalancerCluster.readClusterInfo();
        Assertions.assertEquals((int)3, (int)diskBalancerCluster.getNodes().size(), (String)"Expected number of Datanodes not found.");
        Assertions.assertEquals((int)2, (int)((DiskBalancerDataNode)diskBalancerCluster.getNodes().get(0)).getVolumeCount(), (String)"Expected number of volumes not found.");
    }

    @Test
    public void testJsonConnector() throws Exception {
        this.cluster.waitActive();
        ClusterConnector nameNodeConnector = ConnectorFactory.getCluster((URI)this.cluster.getFileSystem(0).getUri(), (Configuration)this.conf);
        DiskBalancerCluster diskBalancerCluster = new DiskBalancerCluster(nameNodeConnector);
        diskBalancerCluster.readClusterInfo();
        String diskBalancerJson = diskBalancerCluster.toJson();
        DiskBalancerCluster serializedCluster = DiskBalancerCluster.parseJson((String)diskBalancerJson);
        Assertions.assertEquals((int)diskBalancerCluster.getNodes().size(), (int)serializedCluster.getNodes().size(), (String)"Parsed cluster is not equal to persisted info.");
    }
}

