/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.datanode.fsdataset.impl;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang.math.RandomUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.CachingGetSpaceUsed;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.DFSInputStream;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.protocol.ExtendedBlock;
import org.apache.hadoop.hdfs.protocol.LocatedBlock;
import org.apache.hadoop.hdfs.server.datanode.DataNode;
import org.apache.hadoop.hdfs.server.datanode.fsdataset.FsDatasetSpi;
import org.apache.hadoop.hdfs.server.datanode.fsdataset.impl.ReplicaCachingGetSpaceUsed;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.test.PlatformAssumptions;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;

public class TestReplicaCachingGetSpaceUsed {
    private Configuration conf = null;
    private MiniDFSCluster cluster;
    private DistributedFileSystem fs;
    private DataNode dataNode;

    @BeforeEach
    public void setUp() throws IOException, NoSuchMethodException, InterruptedException {
        this.conf = new Configuration();
        this.conf.setClass("fs.getspaceused.classname", ReplicaCachingGetSpaceUsed.class, CachingGetSpaceUsed.class);
        this.conf.setLong("fs.du.interval", 1000L);
        this.conf.setLong("fs.getspaceused.jitterMillis", 0L);
        this.cluster = new MiniDFSCluster.Builder(this.conf).build();
        this.cluster.waitActive();
        this.dataNode = this.cluster.getDataNodes().get(0);
        this.fs = this.cluster.getFileSystem();
    }

    @AfterEach
    public void tearDown() throws IOException {
        if (this.cluster != null) {
            this.cluster.shutdown();
            this.cluster = null;
        }
    }

    @Test
    public void testReplicaCachingGetSpaceUsedByFINALIZEDReplica() throws Exception {
        FSDataOutputStream os = this.fs.create(new Path("/testReplicaCachingGetSpaceUsedByFINALIZEDReplica"));
        byte[] bytes = new byte[20480];
        ByteArrayInputStream is = new ByteArrayInputStream(bytes);
        IOUtils.copyBytes((InputStream)is, (OutputStream)os, (int)bytes.length);
        os.hsync();
        os.close();
        DFSInputStream dfsInputStream = this.fs.getClient().open("/testReplicaCachingGetSpaceUsedByFINALIZEDReplica");
        long blockLength = 0L;
        long metaLength = 0L;
        List locatedBlocks = dfsInputStream.getAllBlocks();
        for (LocatedBlock locatedBlock : locatedBlocks) {
            ExtendedBlock extendedBlock = locatedBlock.getBlock();
            blockLength += extendedBlock.getLocalBlock().getNumBytes();
            metaLength += this.dataNode.getFSDataset().getMetaDataInputStream(extendedBlock).getLength();
        }
        Thread.sleep(2000L);
        Assertions.assertEquals((long)(blockLength + metaLength), (long)this.dataNode.getFSDataset().getDfsUsed());
        this.fs.delete(new Path("/testReplicaCachingGetSpaceUsedByFINALIZEDReplica"), true);
    }

    @Test
    public void testReplicaCachingGetSpaceUsedByRBWReplica() throws Exception {
        PlatformAssumptions.assumeNotWindows();
        FSDataOutputStream os = this.fs.create(new Path("/testReplicaCachingGetSpaceUsedByRBWReplica"));
        byte[] bytes = new byte[20480];
        ByteArrayInputStream is = new ByteArrayInputStream(bytes);
        IOUtils.copyBytes((InputStream)is, (OutputStream)os, (int)bytes.length);
        os.hsync();
        DFSInputStream dfsInputStream = this.fs.getClient().open("/testReplicaCachingGetSpaceUsedByRBWReplica");
        long blockLength = 0L;
        long metaLength = 0L;
        List locatedBlocks = dfsInputStream.getAllBlocks();
        for (LocatedBlock locatedBlock : locatedBlocks) {
            ExtendedBlock extendedBlock = locatedBlock.getBlock();
            blockLength += extendedBlock.getLocalBlock().getNumBytes();
            metaLength += this.dataNode.getFSDataset().getMetaDataInputStream(extendedBlock).getLength();
        }
        Thread.sleep(2000L);
        Assertions.assertEquals((long)(blockLength + metaLength), (long)this.dataNode.getFSDataset().getDfsUsed());
        os.close();
        Thread.sleep(2000L);
        Assertions.assertEquals((long)(blockLength + metaLength), (long)this.dataNode.getFSDataset().getDfsUsed());
        this.fs.delete(new Path("/testReplicaCachingGetSpaceUsedByRBWReplica"), true);
    }

    @Test
    @Timeout(value=15L)
    public void testFsDatasetImplDeepCopyReplica() {
        FsDatasetSpi fsDataset = this.dataNode.getFSDataset();
        ModifyThread modifyThread = new ModifyThread();
        modifyThread.start();
        String bpid = this.cluster.getNamesystem(0).getBlockPoolId();
        int retryTimes = 10;
        while (retryTimes > 0) {
            try {
                Set replicas = fsDataset.deepCopyReplica(bpid);
                if (replicas.size() <= 0) continue;
                --retryTimes;
            }
            catch (IOException e) {
                modifyThread.setShouldRun(false);
                Assertions.fail((String)"Encounter IOException when deep copy replica.");
            }
        }
        modifyThread.setShouldRun(false);
    }

    private class ModifyThread
    extends Thread {
        private boolean shouldRun = true;

        private ModifyThread() {
        }

        @Override
        public void run() {
            FSDataOutputStream os = null;
            while (this.shouldRun) {
                try {
                    int id = RandomUtils.nextInt();
                    os = TestReplicaCachingGetSpaceUsed.this.fs.create(new Path("/testFsDatasetImplDeepCopyReplica/" + id));
                    byte[] bytes = new byte[2048];
                    ByteArrayInputStream is = new ByteArrayInputStream(bytes);
                    IOUtils.copyBytes((InputStream)is, (OutputStream)os, (int)bytes.length);
                    os.hsync();
                    os.close();
                }
                catch (IOException iOException) {}
            }
            try {
                TestReplicaCachingGetSpaceUsed.this.fs.delete(new Path("/testFsDatasetImplDeepCopyReplica"), true);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }

        private void setShouldRun(boolean shouldRun) {
            this.shouldRun = shouldRun;
        }
    }
}

