/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.datanode.fsdataset.impl;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.Future;
import java.util.concurrent.TimeoutException;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.DF;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FileSystemTestHelper;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.StorageType;
import org.apache.hadoop.hdfs.DFSTestUtil;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.MiniDFSNNTopology;
import org.apache.hadoop.hdfs.protocol.DatanodeVolumeInfo;
import org.apache.hadoop.hdfs.server.common.Storage;
import org.apache.hadoop.hdfs.server.datanode.BlockScanner;
import org.apache.hadoop.hdfs.server.datanode.DataNode;
import org.apache.hadoop.hdfs.server.datanode.StorageLocation;
import org.apache.hadoop.hdfs.server.datanode.fsdataset.FsVolumeReference;
import org.apache.hadoop.hdfs.server.datanode.fsdataset.RoundRobinVolumeChoosingPolicy;
import org.apache.hadoop.hdfs.server.datanode.fsdataset.VolumeChoosingPolicy;
import org.apache.hadoop.hdfs.server.datanode.fsdataset.impl.BlockPoolSlice;
import org.apache.hadoop.hdfs.server.datanode.fsdataset.impl.FsDatasetImpl;
import org.apache.hadoop.hdfs.server.datanode.fsdataset.impl.FsVolumeImpl;
import org.apache.hadoop.hdfs.server.datanode.fsdataset.impl.FsVolumeImplBuilder;
import org.apache.hadoop.hdfs.server.datanode.fsdataset.impl.FsVolumeList;
import org.apache.hadoop.hdfs.server.datanode.fsdataset.impl.MountVolumeMap;
import org.apache.hadoop.hdfs.server.datanode.fsdataset.impl.RamDiskReplicaTracker;
import org.apache.hadoop.hdfs.server.datanode.fsdataset.impl.ReplicaMap;
import org.apache.hadoop.hdfs.server.datanode.fsdataset.impl.ReservedSpaceCalculator;
import org.apache.hadoop.hdfs.server.protocol.SlowDiskReports;
import org.apache.hadoop.test.GenericTestUtils;
import org.apache.hadoop.thirdparty.com.google.common.collect.ImmutableMap;
import org.apache.hadoop.util.StringUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class TestFsVolumeList {
    private Configuration conf;
    private VolumeChoosingPolicy<FsVolumeImpl> blockChooser = new RoundRobinVolumeChoosingPolicy();
    private FsDatasetImpl dataset = null;
    private String baseDir;
    private BlockScanner blockScanner;
    private static final int NUM_DATANODES = 3;
    private static final int STORAGES_PER_DATANODE = 3;
    private static final int DEFAULT_BLOCK_SIZE = 102400;
    private static final int BUFFER_LENGTH = 1024;

    @BeforeEach
    public void setUp() {
        this.dataset = (FsDatasetImpl)Mockito.mock(FsDatasetImpl.class);
        this.baseDir = new FileSystemTestHelper().getTestRootDir();
        Configuration blockScannerConf = new Configuration();
        blockScannerConf.setInt("dfs.datanode.scan.period.hours", -1);
        this.blockScanner = new BlockScanner(null, blockScannerConf);
        this.conf = new Configuration();
    }

    @Test
    @Timeout(value=30L)
    public void testGetNextVolumeWithClosedVolume() throws IOException {
        FsVolumeList volumeList = new FsVolumeList(Collections.emptyList(), this.blockScanner, this.blockChooser, this.conf, null);
        final ArrayList<FsVolumeImpl> volumes = new ArrayList<FsVolumeImpl>();
        for (int i = 0; i < 3; ++i) {
            File curDir = new File(this.baseDir, "nextvolume-" + i);
            curDir.mkdirs();
            FsVolumeImpl volume = new FsVolumeImplBuilder().setConf(this.conf).setDataset(this.dataset).setStorageID("storage-id").setStorageDirectory(new Storage.StorageDirectory(StorageLocation.parse((String)curDir.getPath()))).build();
            volume.setCapacityForTesting(0x40000000L);
            volumes.add(volume);
            volumeList.addVolume(volume.obtainReference());
        }
        ((FsVolumeImpl)volumes.get(1)).setClosed();
        try {
            GenericTestUtils.waitFor((Supplier)new Supplier<Boolean>(){

                @Override
                public Boolean get() {
                    return ((FsVolumeImpl)volumes.get(1)).checkClosed();
                }
            }, (long)100L, (long)3000L);
        }
        catch (TimeoutException e) {
            Assertions.fail((String)"timed out while waiting for volume to be removed.");
        }
        catch (InterruptedException ie) {
            Thread.currentThread().interrupt();
        }
        for (int i = 0; i < 10; ++i) {
            try (FsVolumeReference ref = volumeList.getNextVolume(StorageType.DEFAULT, null, 128L);){
                Assertions.assertNotEquals((Object)ref.getVolume(), volumes.get(1));
                continue;
            }
        }
    }

    @Test
    @Timeout(value=30L)
    public void testReleaseVolumeRefIfNoBlockScanner() throws IOException {
        FsVolumeList volumeList = new FsVolumeList(Collections.emptyList(), null, this.blockChooser, this.conf, null);
        File volDir = new File(this.baseDir, "volume-0");
        volDir.mkdirs();
        FsVolumeImpl volume = new FsVolumeImplBuilder().setConf(this.conf).setDataset(this.dataset).setStorageID("storage-id").setStorageDirectory(new Storage.StorageDirectory(StorageLocation.parse((String)volDir.getPath()))).build();
        FsVolumeReference ref = volume.obtainReference();
        volumeList.addVolume(ref);
        Assertions.assertNull((Object)ref.getVolume());
    }

    @Test
    public void testDfsReservedForDifferentStorageTypes() throws IOException {
        Configuration conf = new Configuration();
        conf.setLong("dfs.datanode.du.reserved", 100L);
        File volDir = new File(this.baseDir, "volume-0");
        volDir.mkdirs();
        FsVolumeImpl volume = new FsVolumeImplBuilder().setDataset(this.dataset).setStorageDirectory(new Storage.StorageDirectory(StorageLocation.parse((String)("[RAM_DISK]" + volDir.getPath())))).setStorageID("storage-id").setConf(conf).build();
        Assertions.assertEquals((long)100L, (long)volume.getReserved(), (String)"");
        conf.setLong("dfs.datanode.du.reserved." + StringUtils.toLowerCase((String)StorageType.RAM_DISK.toString()), 1L);
        conf.setLong("dfs.datanode.du.reserved." + StringUtils.toLowerCase((String)StorageType.SSD.toString()), 2L);
        conf.setLong("dfs.datanode.du.reserved." + StringUtils.toLowerCase((String)StorageType.NVDIMM.toString()), 3L);
        FsVolumeImpl volume1 = new FsVolumeImplBuilder().setDataset(this.dataset).setStorageDirectory(new Storage.StorageDirectory(StorageLocation.parse((String)("[RAM_DISK]" + volDir.getPath())))).setStorageID("storage-id").setConf(conf).build();
        Assertions.assertEquals((long)1L, (long)volume1.getReserved(), (String)"");
        FsVolumeImpl volume2 = new FsVolumeImplBuilder().setDataset(this.dataset).setStorageDirectory(new Storage.StorageDirectory(StorageLocation.parse((String)("[SSD]" + volDir.getPath())))).setStorageID("storage-id").setConf(conf).build();
        Assertions.assertEquals((long)2L, (long)volume2.getReserved(), (String)"");
        FsVolumeImpl volume3 = new FsVolumeImplBuilder().setDataset(this.dataset).setStorageDirectory(new Storage.StorageDirectory(StorageLocation.parse((String)("[DISK]" + volDir.getPath())))).setStorageID("storage-id").setConf(conf).build();
        Assertions.assertEquals((long)100L, (long)volume3.getReserved(), (String)"");
        FsVolumeImpl volume4 = new FsVolumeImplBuilder().setDataset(this.dataset).setStorageDirectory(new Storage.StorageDirectory(StorageLocation.parse((String)volDir.getPath()))).setStorageID("storage-id").setConf(conf).build();
        Assertions.assertEquals((long)100L, (long)volume4.getReserved(), (String)"");
        FsVolumeImpl volume5 = new FsVolumeImplBuilder().setDataset(this.dataset).setStorageDirectory(new Storage.StorageDirectory(StorageLocation.parse((String)("[NVDIMM]" + volDir.getPath())))).setStorageID("storage-id").setConf(conf).build();
        Assertions.assertEquals((long)3L, (long)volume5.getReserved());
    }

    @Test
    public void testNonDfsUsedMetricForVolume() throws Exception {
        File volDir = new File(this.baseDir, "volume-0");
        volDir.mkdirs();
        long diskCapacity = 1000L;
        long duReserved = 100L;
        long dfsUsage = 200L;
        long actualNonDfsUsage = 300L;
        long reservedForReplicas = 50L;
        this.conf.setLong("dfs.datanode.du.reserved", duReserved);
        FsVolumeImpl volume = new FsVolumeImplBuilder().setDataset(this.dataset).setStorageDirectory(new Storage.StorageDirectory(StorageLocation.parse((String)volDir.getPath()))).setStorageID("storage-id").setConf(this.conf).build();
        FsVolumeImpl spyVolume = (FsVolumeImpl)Mockito.spy((Object)volume);
        long testCapacity = diskCapacity - duReserved;
        spyVolume.setCapacityForTesting(testCapacity);
        long dfAvailable = diskCapacity - dfsUsage - actualNonDfsUsage;
        ((FsVolumeImpl)Mockito.doReturn((Object)dfAvailable).when((Object)spyVolume)).getDfAvailable();
        ((FsVolumeImpl)Mockito.doReturn((Object)dfsUsage).when((Object)spyVolume)).getDfsUsed();
        ((FsVolumeImpl)Mockito.doReturn((Object)reservedForReplicas).when((Object)spyVolume)).getReservedForReplicas();
        ((FsVolumeImpl)Mockito.doReturn((Object)actualNonDfsUsage).when((Object)spyVolume)).getActualNonDfsUsed();
        long expectedNonDfsUsage = actualNonDfsUsage - duReserved;
        Assertions.assertEquals((long)expectedNonDfsUsage, (long)spyVolume.getNonDfsUsed());
    }

    @Test
    public void testDfsReservedPercentageForDifferentStorageTypes() throws IOException {
        this.conf.setClass("dfs.datanode.du.reserved.calculator", ReservedSpaceCalculator.ReservedSpaceCalculatorPercentage.class, ReservedSpaceCalculator.class);
        this.conf.setLong("dfs.datanode.du.reserved.pct", 15L);
        File volDir = new File(this.baseDir, "volume-0");
        volDir.mkdirs();
        DF usage = (DF)Mockito.mock(DF.class);
        Mockito.when((Object)usage.getCapacity()).thenReturn((Object)4000L);
        Mockito.when((Object)usage.getAvailable()).thenReturn((Object)1000L);
        FsVolumeImpl volume = new FsVolumeImplBuilder().setConf(this.conf).setDataset(this.dataset).setStorageID("storage-id").setStorageDirectory(new Storage.StorageDirectory(StorageLocation.parse((String)("[RAM_DISK]" + volDir.getPath())))).setUsage(usage).build();
        Assertions.assertEquals((long)600L, (long)volume.getReserved());
        Assertions.assertEquals((long)3400L, (long)volume.getCapacity());
        Assertions.assertEquals((long)400L, (long)volume.getAvailable());
        this.conf.setLong("dfs.datanode.du.reserved.pct." + StringUtils.toLowerCase((String)StorageType.RAM_DISK.toString()), 10L);
        this.conf.setLong("dfs.datanode.du.reserved.pct." + StringUtils.toLowerCase((String)StorageType.SSD.toString()), 50L);
        this.conf.setLong("dfs.datanode.du.reserved.pct." + StringUtils.toLowerCase((String)StorageType.NVDIMM.toString()), 20L);
        FsVolumeImpl volume1 = new FsVolumeImplBuilder().setConf(this.conf).setDataset(this.dataset).setStorageID("storage-id").setStorageDirectory(new Storage.StorageDirectory(StorageLocation.parse((String)("[RAM_DISK]" + volDir.getPath())))).setUsage(usage).build();
        Assertions.assertEquals((long)400L, (long)volume1.getReserved());
        Assertions.assertEquals((long)3600L, (long)volume1.getCapacity());
        Assertions.assertEquals((long)600L, (long)volume1.getAvailable());
        FsVolumeImpl volume2 = new FsVolumeImplBuilder().setConf(this.conf).setDataset(this.dataset).setStorageID("storage-id").setStorageDirectory(new Storage.StorageDirectory(StorageLocation.parse((String)("[SSD]" + volDir.getPath())))).setUsage(usage).build();
        Assertions.assertEquals((long)2000L, (long)volume2.getReserved());
        Assertions.assertEquals((long)2000L, (long)volume2.getCapacity());
        Assertions.assertEquals((long)0L, (long)volume2.getAvailable());
        FsVolumeImpl volume3 = new FsVolumeImplBuilder().setConf(this.conf).setDataset(this.dataset).setStorageID("storage-id").setStorageDirectory(new Storage.StorageDirectory(StorageLocation.parse((String)("[DISK]" + volDir.getPath())))).setUsage(usage).build();
        Assertions.assertEquals((long)600L, (long)volume3.getReserved());
        FsVolumeImpl volume4 = new FsVolumeImplBuilder().setConf(this.conf).setDataset(this.dataset).setStorageID("storage-id").setStorageDirectory(new Storage.StorageDirectory(StorageLocation.parse((String)volDir.getPath()))).setUsage(usage).build();
        Assertions.assertEquals((long)600L, (long)volume4.getReserved());
        FsVolumeImpl volume5 = new FsVolumeImplBuilder().setConf(this.conf).setDataset(this.dataset).setStorageID("storage-id").setStorageDirectory(new Storage.StorageDirectory(StorageLocation.parse((String)("[NVDIMM]" + volDir.getPath())))).setUsage(usage).build();
        Assertions.assertEquals((long)800L, (long)volume5.getReserved());
        Assertions.assertEquals((long)3200L, (long)volume5.getCapacity());
        Assertions.assertEquals((long)200L, (long)volume5.getAvailable());
    }

    @Test
    @Timeout(value=300L)
    public void testAddRplicaProcessorForAddingReplicaInMap() throws Exception {
        BlockPoolSlice.reInitializeAddReplicaThreadPool();
        Configuration cnf = new Configuration();
        int poolSize = 5;
        cnf.setInt("dfs.replication", 1);
        cnf.setInt("dfs.datanode.volumes.replica-add.threadpool.size", poolSize);
        MiniDFSCluster cluster = new MiniDFSCluster.Builder(cnf).numDataNodes(1).storagesPerDatanode(1).build();
        final DistributedFileSystem fs = cluster.getFileSystem();
        ExecutorService pool = Executors.newFixedThreadPool(10);
        ArrayList futureList = new ArrayList();
        for (int i = 0; i < 100; ++i) {
            Thread thread = new Thread(){

                @Override
                public void run() {
                    for (int j = 0; j < 10; ++j) {
                        try {
                            DFSTestUtil.createFile((FileSystem)fs, new Path("File_" + this.getName() + j), 10L, (short)1, 0L);
                            continue;
                        }
                        catch (IOException | IllegalArgumentException e) {
                            e.printStackTrace();
                        }
                    }
                }
            };
            thread.setName("FileWriter" + i);
            futureList.add(pool.submit(thread));
        }
        for (Future future : futureList) {
            future.get();
        }
        fs.close();
        FsDatasetImpl fsDataset = (FsDatasetImpl)cluster.getDataNodes().get(0).getFSDataset();
        ReplicaMap replicaMap = new ReplicaMap(fsDataset.acquireDatasetLockManager());
        RamDiskReplicaTracker ramDiskReplicaMap = RamDiskReplicaTracker.getInstance((Configuration)this.conf, (FsDatasetImpl)fsDataset);
        FsVolumeImpl vol = (FsVolumeImpl)fsDataset.getFsVolumeReferences().get(0);
        String bpid = cluster.getNamesystem().getBlockPoolId();
        vol.getVolumeMap(bpid, replicaMap, ramDiskReplicaMap);
        Assertions.assertTrue((replicaMap.replicas(bpid).size() == 1000 ? 1 : 0) != 0, (String)"Failed to add all the replica to map");
        Assertions.assertEquals((int)poolSize, (int)BlockPoolSlice.getAddReplicaForkPoolSize(), (String)"Fork pool should be initialize with configured pool size");
    }

    @Test
    @Timeout(value=60L)
    public void testInstanceOfAddReplicaThreadPool() throws Exception {
        try (MiniDFSCluster cluster = new MiniDFSCluster.Builder((Configuration)new HdfsConfiguration()).nnTopology(MiniDFSNNTopology.simpleFederatedTopology(2)).numDataNodes(1).build();){
            cluster.waitActive();
            FsDatasetImpl fsDataset = (FsDatasetImpl)cluster.getDataNodes().get(0).getFSDataset();
            FsVolumeImpl vol = (FsVolumeImpl)fsDataset.getFsVolumeReferences().get(0);
            ForkJoinPool threadPool1 = vol.getBlockPoolSlice(cluster.getNamesystem(0).getBlockPoolId()).getAddReplicaThreadPool();
            ForkJoinPool threadPool2 = vol.getBlockPoolSlice(cluster.getNamesystem(1).getBlockPoolId()).getAddReplicaThreadPool();
            Assertions.assertEquals((Object)threadPool1, (Object)threadPool2, (String)"Thread pool instance should be same in all the BlockPoolSlice");
        }
    }

    @Test
    public void testGetCachedVolumeCapacity() throws IOException {
        this.conf.setBoolean("dfs.datanode.fixed.volume.size", false);
        long capacity = 4000L;
        DF usage = (DF)Mockito.mock(DF.class);
        Mockito.when((Object)usage.getCapacity()).thenReturn((Object)capacity);
        FsVolumeImpl volumeChanged = new FsVolumeImplBuilder().setConf(this.conf).setDataset(this.dataset).setStorageID("storage-id").setStorageDirectory(new Storage.StorageDirectory(StorageLocation.parse((String)"[RAM_DISK]volume-changed"))).setUsage(usage).build();
        int callTimes = 5;
        for (int i = 0; i < callTimes; ++i) {
            Assertions.assertEquals((long)capacity, (long)volumeChanged.getCapacity());
        }
        ((DF)Mockito.verify((Object)usage, (VerificationMode)Mockito.times((int)callTimes))).getCapacity();
        this.conf.setBoolean("dfs.datanode.fixed.volume.size", true);
        FsVolumeImpl volumeFixed = new FsVolumeImplBuilder().setConf(this.conf).setDataset(this.dataset).setStorageID("storage-id").setStorageDirectory(new Storage.StorageDirectory(StorageLocation.parse((String)"[RAM_DISK]volume-fixed"))).setUsage(usage).build();
        for (int i = 0; i < callTimes; ++i) {
            Assertions.assertEquals((long)capacity, (long)volumeFixed.getCapacity());
        }
        ((DF)Mockito.verify((Object)usage, (VerificationMode)Mockito.times((int)(callTimes + 1)))).getCapacity();
        this.conf.setBoolean("dfs.datanode.fixed.volume.size", false);
    }

    @Test
    public void testGetVolumeWithSameDiskArchival() throws Exception {
        File diskVolDir = new File(this.baseDir, "volume-disk");
        File archivalVolDir = new File(this.baseDir, "volume-archival");
        diskVolDir.mkdirs();
        archivalVolDir.mkdirs();
        double reservedForArchival = 0.75;
        this.conf.setBoolean("dfs.datanode.same-disk-tiering.enabled", true);
        this.conf.setDouble("dfs.datanode.reserve-for-archive.default.percentage", reservedForArchival);
        FsVolumeImpl diskVolume = new FsVolumeImplBuilder().setConf(this.conf).setDataset(this.dataset).setStorageID("storage-id").setStorageDirectory(new Storage.StorageDirectory(StorageLocation.parse((String)diskVolDir.getPath()))).build();
        FsVolumeImpl archivalVolume = new FsVolumeImplBuilder().setConf(this.conf).setDataset(this.dataset).setStorageID("storage-id").setStorageDirectory(new Storage.StorageDirectory(StorageLocation.parse((String)("[ARCHIVE]" + archivalVolDir.getPath())))).build();
        FsVolumeList volumeList = new FsVolumeList(Collections.emptyList(), this.blockScanner, this.blockChooser, this.conf, null);
        volumeList.addVolume(archivalVolume.obtainReference());
        volumeList.addVolume(diskVolume.obtainReference());
        Assertions.assertEquals((Object)diskVolume.getMount(), (Object)archivalVolume.getMount());
        String device = diskVolume.getMount();
        Assertions.assertEquals((Object)diskVolume, (Object)volumeList.getMountVolumeMap().getVolumeRefByMountAndStorageType(device, StorageType.DISK).getVolume());
        Assertions.assertEquals((Object)archivalVolume, (Object)volumeList.getMountVolumeMap().getVolumeRefByMountAndStorageType(device, StorageType.ARCHIVE).getVolume());
        volumeList.removeVolume(diskVolume.getStorageLocation(), true);
        Assertions.assertNull((Object)volumeList.getMountVolumeMap().getVolumeRefByMountAndStorageType(device, StorageType.DISK));
        Assertions.assertEquals((Object)archivalVolume, (Object)volumeList.getMountVolumeMap().getVolumeRefByMountAndStorageType(device, StorageType.ARCHIVE).getVolume());
    }

    @Test
    public void testDfsUsageStatWithSameDiskArchival() throws Exception {
        File diskVolDir = new File(this.baseDir, "volume-disk");
        File archivalVolDir = new File(this.baseDir, "volume-archival");
        diskVolDir.mkdirs();
        archivalVolDir.mkdirs();
        long dfCapacity = 1100L;
        double reservedForArchival = 0.75;
        long duReserved = 100L;
        long diskDfsUsage = 100L;
        long archivalDfsUsage = 200L;
        long dfUsage = 700L;
        long dfAvailable = 300L;
        this.conf.setLong("dfs.datanode.du.reserved", duReserved);
        this.conf.setBoolean("dfs.datanode.same-disk-tiering.enabled", true);
        this.conf.setDouble("dfs.datanode.reserve-for-archive.default.percentage", reservedForArchival);
        FsVolumeImpl diskVolume = new FsVolumeImplBuilder().setConf(this.conf).setDataset(this.dataset).setStorageID("storage-id").setStorageDirectory(new Storage.StorageDirectory(StorageLocation.parse((String)diskVolDir.getPath()))).build();
        FsVolumeImpl archivalVolume = new FsVolumeImplBuilder().setConf(this.conf).setDataset(this.dataset).setStorageID("storage-id").setStorageDirectory(new Storage.StorageDirectory(StorageLocation.parse((String)("[ARCHIVE]" + archivalVolDir.getPath())))).build();
        FsVolumeImpl spyDiskVolume = (FsVolumeImpl)Mockito.spy((Object)diskVolume);
        FsVolumeImpl spyArchivalVolume = (FsVolumeImpl)Mockito.spy((Object)archivalVolume);
        long testDfCapacity = dfCapacity - duReserved;
        spyDiskVolume.setCapacityForTesting(testDfCapacity);
        spyArchivalVolume.setCapacityForTesting(testDfCapacity);
        ((FsVolumeImpl)Mockito.doReturn((Object)dfAvailable).when((Object)spyDiskVolume)).getDfAvailable();
        ((FsVolumeImpl)Mockito.doReturn((Object)dfAvailable).when((Object)spyArchivalVolume)).getDfAvailable();
        MountVolumeMap mountVolumeMap = new MountVolumeMap(this.conf);
        mountVolumeMap.addVolume(spyDiskVolume);
        mountVolumeMap.addVolume(spyArchivalVolume);
        ((FsDatasetImpl)Mockito.doReturn((Object)mountVolumeMap).when((Object)this.dataset)).getMountVolumeMap();
        long diskStorageTypeCapacity = (long)((double)(dfCapacity - duReserved) * (1.0 - reservedForArchival));
        Assertions.assertEquals((long)diskStorageTypeCapacity, (long)spyDiskVolume.getCapacity());
        long archiveStorageTypeCapacity = (long)((double)(dfCapacity - duReserved) * reservedForArchival);
        Assertions.assertEquals((long)archiveStorageTypeCapacity, (long)spyArchivalVolume.getCapacity());
        long expectedActualNonDfsUsage = 400L;
        ((FsVolumeImpl)Mockito.doReturn((Object)diskDfsUsage).when((Object)spyDiskVolume)).getDfsUsed();
        ((FsVolumeImpl)Mockito.doReturn((Object)archivalDfsUsage).when((Object)spyArchivalVolume)).getDfsUsed();
        ((FsVolumeImpl)Mockito.doReturn((Object)dfUsage).when((Object)spyDiskVolume)).getDfUsed();
        ((FsVolumeImpl)Mockito.doReturn((Object)dfUsage).when((Object)spyArchivalVolume)).getDfUsed();
        Assertions.assertEquals((long)expectedActualNonDfsUsage, (long)spyDiskVolume.getActualNonDfsUsed());
        Assertions.assertEquals((long)expectedActualNonDfsUsage, (long)spyArchivalVolume.getActualNonDfsUsed());
        mountVolumeMap.removeVolume(spyArchivalVolume);
        Assertions.assertEquals((long)(dfCapacity - duReserved), (long)spyDiskVolume.getCapacity());
    }

    @Test
    public void testExcludeSlowDiskWhenChoosingVolume() throws Exception {
        this.conf = new HdfsConfiguration();
        this.conf.setLong("dfs.blocksize", 102400L);
        this.conf.setStrings("dfs.datanode.outliers.report.interval", new String[]{"1s"});
        this.conf.setInt("dfs.datanode.fileio.profiling.sampling.percentage", 30);
        this.conf.setInt("dfs.datanode.max.slowdisks.to.exclude", 1);
        long capacity = 1024000L;
        long[][] capacities = new long[3][3];
        String[] hostnames = new String[3];
        for (int i = 0; i < 3; ++i) {
            hostnames[i] = i + "." + i + "." + i + "." + i;
            for (int j = 0; j < 3; ++j) {
                capacities[i][j] = capacity;
            }
        }
        MiniDFSCluster cluster = new MiniDFSCluster.Builder(this.conf).hosts(hostnames).numDataNodes(3).storagesPerDatanode(3).storageCapacities(capacities).build();
        cluster.waitActive();
        DistributedFileSystem fs = cluster.getFileSystem();
        ArrayList<DataNode> dataNodes = cluster.getDataNodes();
        final DataNode dn0 = dataNodes.get(0);
        final DataNode dn1 = dataNodes.get(1);
        final DataNode dn2 = dataNodes.get(2);
        String slowDisk0OnDn0 = dn0.getFSDataset().getFsVolumeReferences().getReference(0).getVolume().getBaseURI().getPath();
        String slowDisk0OnDn1 = dn1.getFSDataset().getFsVolumeReferences().getReference(0).getVolume().getBaseURI().getPath();
        String slowDisk0OnDn2 = dn2.getFSDataset().getFsVolumeReferences().getReference(0).getVolume().getBaseURI().getPath();
        String slowDisk1OnDn0 = dn0.getFSDataset().getFsVolumeReferences().getReference(1).getVolume().getBaseURI().getPath();
        String slowDisk1OnDn1 = dn1.getFSDataset().getFsVolumeReferences().getReference(1).getVolume().getBaseURI().getPath();
        String slowDisk1OnDn2 = dn2.getFSDataset().getFsVolumeReferences().getReference(1).getVolume().getBaseURI().getPath();
        dn0.getDiskMetrics().addSlowDiskForTesting(slowDisk0OnDn0, (Map)ImmutableMap.of((Object)SlowDiskReports.DiskOp.READ, (Object)1.0, (Object)SlowDiskReports.DiskOp.WRITE, (Object)1.5, (Object)SlowDiskReports.DiskOp.METADATA, (Object)2.0));
        dn1.getDiskMetrics().addSlowDiskForTesting(slowDisk0OnDn1, (Map)ImmutableMap.of((Object)SlowDiskReports.DiskOp.READ, (Object)1.0, (Object)SlowDiskReports.DiskOp.WRITE, (Object)1.5, (Object)SlowDiskReports.DiskOp.METADATA, (Object)2.0));
        dn2.getDiskMetrics().addSlowDiskForTesting(slowDisk0OnDn2, (Map)ImmutableMap.of((Object)SlowDiskReports.DiskOp.READ, (Object)1.0, (Object)SlowDiskReports.DiskOp.WRITE, (Object)1.5, (Object)SlowDiskReports.DiskOp.METADATA, (Object)2.0));
        dn0.getDiskMetrics().addSlowDiskForTesting(slowDisk1OnDn0, (Map)ImmutableMap.of((Object)SlowDiskReports.DiskOp.READ, (Object)1.0, (Object)SlowDiskReports.DiskOp.WRITE, (Object)1.0, (Object)SlowDiskReports.DiskOp.METADATA, (Object)1.0));
        dn1.getDiskMetrics().addSlowDiskForTesting(slowDisk1OnDn1, (Map)ImmutableMap.of((Object)SlowDiskReports.DiskOp.READ, (Object)1.0, (Object)SlowDiskReports.DiskOp.WRITE, (Object)1.0, (Object)SlowDiskReports.DiskOp.METADATA, (Object)1.0));
        dn2.getDiskMetrics().addSlowDiskForTesting(slowDisk1OnDn2, (Map)ImmutableMap.of((Object)SlowDiskReports.DiskOp.READ, (Object)1.0, (Object)SlowDiskReports.DiskOp.WRITE, (Object)1.0, (Object)SlowDiskReports.DiskOp.METADATA, (Object)1.0));
        GenericTestUtils.waitFor((Supplier)new Supplier<Boolean>(){

            @Override
            public Boolean get() {
                return dn0.getDiskMetrics().getSlowDisksToExclude().size() == 1 && dn1.getDiskMetrics().getSlowDisksToExclude().size() == 1 && dn2.getDiskMetrics().getSlowDisksToExclude().size() == 1;
            }
        }, (long)1000L, (long)5000L);
        DFSTestUtil.createFile((FileSystem)fs, new Path("/file0"), false, 1024, 1000L, 102400L, (short)3, 0L, false, null);
        Assertions.assertEquals((long)0L, (long)((DatanodeVolumeInfo)dn0.getVolumeReport().stream().filter(v -> (v.getPath() + "/").equals(slowDisk0OnDn0)).collect(Collectors.toList()).get(0)).getNumBlocks());
        Assertions.assertEquals((long)0L, (long)((DatanodeVolumeInfo)dn1.getVolumeReport().stream().filter(v -> (v.getPath() + "/").equals(slowDisk0OnDn1)).collect(Collectors.toList()).get(0)).getNumBlocks());
        Assertions.assertEquals((long)0L, (long)((DatanodeVolumeInfo)dn2.getVolumeReport().stream().filter(v -> (v.getPath() + "/").equals(slowDisk0OnDn2)).collect(Collectors.toList()).get(0)).getNumBlocks());
    }
}

