/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.datanode.fsdataset.impl;

import java.io.IOException;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.hadoop.hdfs.server.datanode.fsdataset.impl.AddBlockPoolException;
import org.apache.hadoop.hdfs.server.datanode.fsdataset.impl.FsVolumeImpl;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;

public class TestAddBlockPoolException {
    @Test
    public void testHasExceptionsReturnsCorrectValue() {
        AddBlockPoolException e = new AddBlockPoolException();
        Assertions.assertFalse((boolean)e.hasExceptions());
        FsVolumeImpl fakeVol = (FsVolumeImpl)Mockito.mock(FsVolumeImpl.class);
        ConcurrentHashMap<FsVolumeImpl, IOException> vols = new ConcurrentHashMap<FsVolumeImpl, IOException>();
        vols.put(fakeVol, new IOException("Error 1"));
        e = new AddBlockPoolException(vols);
        Assertions.assertTrue((boolean)e.hasExceptions());
    }

    @Test
    public void testExceptionsCanBeMerged() {
        FsVolumeImpl vol1 = (FsVolumeImpl)Mockito.mock(FsVolumeImpl.class);
        FsVolumeImpl vol2 = (FsVolumeImpl)Mockito.mock(FsVolumeImpl.class);
        ConcurrentHashMap<FsVolumeImpl, IOException> first = new ConcurrentHashMap<FsVolumeImpl, IOException>();
        ConcurrentHashMap<FsVolumeImpl, IOException> second = new ConcurrentHashMap<FsVolumeImpl, IOException>();
        first.put(vol1, new IOException("First Error"));
        second.put(vol1, new IOException("Second Error"));
        second.put(vol2, new IOException("V2 Error"));
        AddBlockPoolException e = new AddBlockPoolException(first);
        e.mergeException(new AddBlockPoolException(second));
        Assertions.assertEquals((int)e.getFailingVolumes().size(), (int)2);
        Assertions.assertEquals((Object)((IOException)e.getFailingVolumes().get(vol1)).getMessage(), (Object)"First Error");
        Assertions.assertEquals((Object)((IOException)e.getFailingVolumes().get(vol2)).getMessage(), (Object)"V2 Error");
    }

    @Test
    public void testEmptyExceptionsCanBeMerged() {
        AddBlockPoolException e = new AddBlockPoolException();
        e.mergeException(new AddBlockPoolException());
        Assertions.assertFalse((boolean)e.hasExceptions());
    }
}

