/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.datanode.checker;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.hadoop.HadoopIllegalArgumentException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.server.datanode.StorageLocation;
import org.apache.hadoop.hdfs.server.datanode.checker.StorageLocationChecker;
import org.apache.hadoop.hdfs.server.datanode.checker.VolumeCheckResult;
import org.apache.hadoop.test.LambdaTestUtils;
import org.apache.hadoop.util.FakeTimer;
import org.apache.hadoop.util.Timer;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestStorageLocationChecker {
    public static final Logger LOG = LoggerFactory.getLogger(TestStorageLocationChecker.class);

    @Test
    @Timeout(value=30L)
    public void testAllLocationsHealthy() throws Exception {
        List<StorageLocation> locations = this.makeMockLocations(VolumeCheckResult.HEALTHY, VolumeCheckResult.HEALTHY, VolumeCheckResult.HEALTHY);
        HdfsConfiguration conf = new HdfsConfiguration();
        conf.setInt("dfs.datanode.failed.volumes.tolerated", 0);
        StorageLocationChecker checker = new StorageLocationChecker((Configuration)conf, (Timer)new FakeTimer());
        List filteredLocations = checker.check((Configuration)conf, locations);
        Assertions.assertThat((int)filteredLocations.size()).isEqualTo(3);
        for (StorageLocation location : locations) {
            ((StorageLocation)Mockito.verify((Object)location)).check((StorageLocation.CheckContext)Mockito.any(StorageLocation.CheckContext.class));
        }
    }

    @Test
    @Timeout(value=30L)
    public void testFailedLocationsBelowThreshold() throws Exception {
        List<StorageLocation> locations = this.makeMockLocations(VolumeCheckResult.HEALTHY, VolumeCheckResult.HEALTHY, VolumeCheckResult.FAILED);
        HdfsConfiguration conf = new HdfsConfiguration();
        conf.setInt("dfs.datanode.failed.volumes.tolerated", 1);
        StorageLocationChecker checker = new StorageLocationChecker((Configuration)conf, (Timer)new FakeTimer());
        List filteredLocations = checker.check((Configuration)conf, locations);
        Assertions.assertThat((int)filteredLocations.size()).isEqualTo(2);
    }

    @Test
    @Timeout(value=30L)
    public void testFailedLocationsAboveThreshold() throws Exception {
        List<StorageLocation> locations = this.makeMockLocations(VolumeCheckResult.HEALTHY, VolumeCheckResult.FAILED, VolumeCheckResult.FAILED);
        HdfsConfiguration conf = new HdfsConfiguration();
        conf.setInt("dfs.datanode.failed.volumes.tolerated", 1);
        IOException ex = (IOException)org.junit.jupiter.api.Assertions.assertThrows(IOException.class, () -> TestStorageLocationChecker.lambda$testFailedLocationsAboveThreshold$0((Configuration)conf, locations));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)ex.getMessage().contains("Too many failed volumes - current valid volumes: 1, volumes configured: 3, volumes failed: 2, volume failures tolerated: 1"));
    }

    @Test
    @Timeout(value=30L)
    public void testBadConfiguration() throws Exception {
        List<StorageLocation> locations = this.makeMockLocations(VolumeCheckResult.HEALTHY, VolumeCheckResult.HEALTHY, VolumeCheckResult.HEALTHY);
        HdfsConfiguration conf = new HdfsConfiguration();
        conf.setInt("dfs.datanode.failed.volumes.tolerated", 3);
        HadoopIllegalArgumentException ex = (HadoopIllegalArgumentException)org.junit.jupiter.api.Assertions.assertThrows(HadoopIllegalArgumentException.class, () -> TestStorageLocationChecker.lambda$testBadConfiguration$1((Configuration)conf, locations));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)ex.getMessage().contains("Invalid value configured"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @Timeout(value=300L)
    public void testTimeoutInCheck() throws Exception {
        HdfsConfiguration conf = new HdfsConfiguration();
        conf.setTimeDuration("dfs.datanode.disk.check.timeout", 1L, TimeUnit.SECONDS);
        conf.setInt("dfs.datanode.failed.volumes.tolerated", 1);
        FakeTimer timer = new FakeTimer();
        List<StorageLocation> locations = this.makeSlowLocations(2000L, 1L);
        StorageLocationChecker checker = new StorageLocationChecker((Configuration)conf, (Timer)timer);
        try {
            List filteredList = checker.check((Configuration)conf, locations);
            Assertions.assertThat((int)filteredList.size()).isEqualTo(1);
        }
        finally {
            checker.shutdownAndWait(10, TimeUnit.SECONDS);
        }
    }

    private List<StorageLocation> makeMockLocations(VolumeCheckResult ... args) throws IOException {
        ArrayList<StorageLocation> locations = new ArrayList<StorageLocation>(args.length);
        AtomicInteger index = new AtomicInteger(0);
        for (VolumeCheckResult result : args) {
            StorageLocation location = (StorageLocation)Mockito.mock(StorageLocation.class);
            Mockito.when((Object)location.toString()).thenReturn((Object)("/" + index.incrementAndGet()));
            Mockito.when((Object)location.check((StorageLocation.CheckContext)Mockito.any(StorageLocation.CheckContext.class))).thenReturn((Object)result);
            locations.add(location);
        }
        return locations;
    }

    private List<StorageLocation> makeSlowLocations(long ... args) throws IOException {
        ArrayList<StorageLocation> locations = new ArrayList<StorageLocation>(args.length);
        AtomicInteger index = new AtomicInteger(0);
        for (final long checkDelayMs : args) {
            StorageLocation location = (StorageLocation)Mockito.mock(StorageLocation.class);
            Mockito.when((Object)location.toString()).thenReturn((Object)("/" + index.incrementAndGet()));
            Mockito.when((Object)location.check((StorageLocation.CheckContext)Mockito.any(StorageLocation.CheckContext.class))).thenAnswer((Answer)new Answer<VolumeCheckResult>(){

                public VolumeCheckResult answer(InvocationOnMock invocation) throws Throwable {
                    Thread.sleep(checkDelayMs);
                    return VolumeCheckResult.HEALTHY;
                }
            });
            locations.add(location);
        }
        return locations;
    }

    @Test
    public void testInvalidConfigurationValues() throws Exception {
        List<StorageLocation> locations = this.makeMockLocations(VolumeCheckResult.HEALTHY, VolumeCheckResult.HEALTHY, VolumeCheckResult.HEALTHY);
        HdfsConfiguration conf = new HdfsConfiguration();
        conf.setInt("dfs.datanode.failed.volumes.tolerated", 4);
        LambdaTestUtils.intercept(HadoopIllegalArgumentException.class, (String)"Invalid value configured for dfs.datanode.failed.volumes.tolerated - 4. Value configured is >= to the number of configured volumes (3).", () -> TestStorageLocationChecker.lambda$testInvalidConfigurationValues$2((Configuration)conf, locations));
        conf.unset("dfs.datanode.failed.volumes.tolerated");
        conf.setInt("dfs.datanode.disk.check.timeout", 0);
        LambdaTestUtils.intercept(HadoopIllegalArgumentException.class, (String)"Invalid value configured for dfs.datanode.disk.check.timeout - 0 (should be > 0)", () -> TestStorageLocationChecker.lambda$testInvalidConfigurationValues$3((Configuration)conf));
        conf.unset("dfs.datanode.disk.check.timeout");
        conf.setInt("dfs.datanode.failed.volumes.tolerated", -2);
        LambdaTestUtils.intercept(HadoopIllegalArgumentException.class, (String)"Invalid value configured for dfs.datanode.failed.volumes.tolerated - -2 should be greater than or equal to -1", () -> TestStorageLocationChecker.lambda$testInvalidConfigurationValues$4((Configuration)conf));
    }

    private static /* synthetic */ StorageLocationChecker lambda$testInvalidConfigurationValues$4(Configuration conf) throws Exception {
        return new StorageLocationChecker(conf, (Timer)new FakeTimer());
    }

    private static /* synthetic */ StorageLocationChecker lambda$testInvalidConfigurationValues$3(Configuration conf) throws Exception {
        return new StorageLocationChecker(conf, (Timer)new FakeTimer());
    }

    private static /* synthetic */ List lambda$testInvalidConfigurationValues$2(Configuration conf, List locations) throws Exception {
        return new StorageLocationChecker(conf, (Timer)new FakeTimer()).check(conf, (Collection)locations);
    }

    private static /* synthetic */ void lambda$testBadConfiguration$1(Configuration conf, List locations) throws Throwable {
        StorageLocationChecker checker = new StorageLocationChecker(conf, (Timer)new FakeTimer());
        checker.check(conf, (Collection)locations);
    }

    private static /* synthetic */ void lambda$testFailedLocationsAboveThreshold$0(Configuration conf, List locations) throws Throwable {
        StorageLocationChecker checker = new StorageLocationChecker(conf, (Timer)new FakeTimer());
        checker.check(conf, (Collection)locations);
    }
}

