/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.datanode.checker;

import java.nio.channels.ClosedChannelException;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.server.datanode.StorageLocation;
import org.apache.hadoop.hdfs.server.datanode.checker.DatasetVolumeChecker;
import org.apache.hadoop.hdfs.server.datanode.checker.TestDatasetVolumeChecker;
import org.apache.hadoop.hdfs.server.datanode.checker.VolumeCheckResult;
import org.apache.hadoop.hdfs.server.datanode.fsdataset.FsDatasetSpi;
import org.apache.hadoop.hdfs.server.datanode.fsdataset.FsVolumeReference;
import org.apache.hadoop.hdfs.server.datanode.fsdataset.FsVolumeSpi;
import org.apache.hadoop.util.FakeTimer;
import org.apache.hadoop.util.Timer;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestDatasetVolumeCheckerFailures {
    public static final Logger LOG = LoggerFactory.getLogger(TestDatasetVolumeCheckerFailures.class);
    private FakeTimer timer;
    private Configuration conf;
    private static final long MIN_DISK_CHECK_GAP_MS = 1000L;

    @BeforeEach
    public void commonInit() {
        this.timer = new FakeTimer();
        this.conf = new HdfsConfiguration();
        this.conf.setTimeDuration("dfs.datanode.disk.check.min.gap", 1000L, TimeUnit.MILLISECONDS);
    }

    @Test
    @Timeout(value=60L)
    public void testTimeout() throws Exception {
        List<FsVolumeSpi> volumes = Collections.singletonList(TestDatasetVolumeCheckerFailures.makeHungVolume());
        FsDatasetSpi<FsVolumeSpi> dataset = TestDatasetVolumeChecker.makeDataset(volumes);
        this.conf.setTimeDuration("dfs.datanode.disk.check.timeout", 1L, TimeUnit.SECONDS);
        DatasetVolumeChecker checker = new DatasetVolumeChecker(this.conf, (Timer)new FakeTimer());
        Set failedVolumes = checker.checkAllVolumes(dataset);
        Assertions.assertThat((int)failedVolumes.size()).isEqualTo(1);
    }

    @Test
    @Timeout(value=60L)
    public void testCheckingClosedVolume() throws Exception {
        List<FsVolumeSpi> volumes = Collections.singletonList(TestDatasetVolumeCheckerFailures.makeClosedVolume());
        FsDatasetSpi<FsVolumeSpi> dataset = TestDatasetVolumeChecker.makeDataset(volumes);
        DatasetVolumeChecker checker = new DatasetVolumeChecker(this.conf, (Timer)this.timer);
        Set failedVolumes = checker.checkAllVolumes(dataset);
        Assertions.assertThat((int)failedVolumes.size()).isEqualTo(0);
        Assertions.assertThat((long)checker.getNumSyncDatasetChecks()).isEqualTo(0L);
        ((FsVolumeSpi)Mockito.verify((Object)volumes.get(0), (VerificationMode)Mockito.times((int)0))).check(ArgumentMatchers.any());
    }

    @Test
    @Timeout(value=60L)
    public void testMinGapIsEnforcedForSyncChecks() throws Exception {
        List<FsVolumeSpi> volumes = TestDatasetVolumeChecker.makeVolumes(1, VolumeCheckResult.HEALTHY);
        FsDatasetSpi<FsVolumeSpi> dataset = TestDatasetVolumeChecker.makeDataset(volumes);
        DatasetVolumeChecker checker = new DatasetVolumeChecker(this.conf, (Timer)this.timer);
        checker.checkAllVolumes(dataset);
        Assertions.assertThat((long)checker.getNumSyncDatasetChecks()).isEqualTo(1L);
        checker.checkAllVolumes(dataset);
        Assertions.assertThat((long)checker.getNumSyncDatasetChecks()).isEqualTo(1L);
        Assertions.assertThat((long)checker.getNumSkippedChecks()).isEqualTo(1L);
        this.timer.advance(1000L);
        checker.checkAllVolumes(dataset);
        Assertions.assertThat((long)checker.getNumSyncDatasetChecks()).isEqualTo(2L);
        Assertions.assertThat((long)checker.getNumSkippedChecks()).isEqualTo(1L);
    }

    private static FsVolumeSpi makeHungVolume() throws Exception {
        FsVolumeSpi volume = (FsVolumeSpi)Mockito.mock(FsVolumeSpi.class);
        FsVolumeReference reference = (FsVolumeReference)Mockito.mock(FsVolumeReference.class);
        StorageLocation location = (StorageLocation)Mockito.mock(StorageLocation.class);
        Mockito.when((Object)reference.getVolume()).thenReturn((Object)volume);
        Mockito.when((Object)volume.obtainReference()).thenReturn((Object)reference);
        Mockito.when((Object)volume.getStorageLocation()).thenReturn((Object)location);
        Mockito.when((Object)volume.check(ArgumentMatchers.any())).thenAnswer(invocation -> {
            Thread.sleep(Long.MAX_VALUE);
            return VolumeCheckResult.HEALTHY;
        });
        return volume;
    }

    private static FsVolumeSpi makeClosedVolume() throws Exception {
        FsVolumeSpi volume = (FsVolumeSpi)Mockito.mock(FsVolumeSpi.class);
        StorageLocation location = (StorageLocation)Mockito.mock(StorageLocation.class);
        Mockito.when((Object)volume.obtainReference()).thenThrow(new Throwable[]{new ClosedChannelException()});
        Mockito.when((Object)volume.getStorageLocation()).thenReturn((Object)location);
        return volume;
    }
}

