/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.datanode.checker;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.hadoop.HadoopIllegalArgumentException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.server.datanode.StorageLocation;
import org.apache.hadoop.hdfs.server.datanode.checker.AsyncChecker;
import org.apache.hadoop.hdfs.server.datanode.checker.Checkable;
import org.apache.hadoop.hdfs.server.datanode.checker.DatasetVolumeChecker;
import org.apache.hadoop.hdfs.server.datanode.checker.VolumeCheckResult;
import org.apache.hadoop.hdfs.server.datanode.fsdataset.FsDatasetSpi;
import org.apache.hadoop.hdfs.server.datanode.fsdataset.FsVolumeReference;
import org.apache.hadoop.hdfs.server.datanode.fsdataset.FsVolumeSpi;
import org.apache.hadoop.test.GenericTestUtils;
import org.apache.hadoop.test.LambdaTestUtils;
import org.apache.hadoop.test.TestName;
import org.apache.hadoop.thirdparty.com.google.common.util.concurrent.Futures;
import org.apache.hadoop.thirdparty.com.google.common.util.concurrent.ListenableFuture;
import org.apache.hadoop.util.DiskChecker;
import org.apache.hadoop.util.FakeTimer;
import org.apache.hadoop.util.Timer;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Timeout;
import org.junit.jupiter.api.extension.RegisterExtension;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestDatasetVolumeChecker {
    public static final Logger LOG = LoggerFactory.getLogger(TestDatasetVolumeChecker.class);
    @RegisterExtension
    public TestName testName = new TestName();
    private VolumeCheckResult expectedVolumeHealth;
    private static final int NUM_VOLUMES = 2;

    public static Collection<Object[]> data() {
        ArrayList<Object[]> values = new ArrayList<Object[]>();
        for (VolumeCheckResult result : VolumeCheckResult.values()) {
            values.add(new Object[]{result});
        }
        values.add(new Object[]{null});
        return values;
    }

    public void initTestDatasetVolumeChecker(VolumeCheckResult pExpectedVolumeHealth) {
        this.expectedVolumeHealth = pExpectedVolumeHealth;
    }

    @ParameterizedTest(name="{0}")
    @MethodSource(value={"data"})
    @Timeout(value=10L)
    public void testCheckOneVolume(VolumeCheckResult pExpectedVolumeHealth) throws Exception {
        this.initTestDatasetVolumeChecker(pExpectedVolumeHealth);
        LOG.info("Executing {}", (Object)this.testName.getMethodName());
        FsVolumeSpi volume = TestDatasetVolumeChecker.makeVolumes(1, this.expectedVolumeHealth).get(0);
        DatasetVolumeChecker checker = new DatasetVolumeChecker((Configuration)new HdfsConfiguration(), (Timer)new FakeTimer());
        checker.setDelegateChecker((AsyncChecker)new DummyChecker());
        final AtomicLong numCallbackInvocations = new AtomicLong(0L);
        boolean result = checker.checkVolume(volume, new DatasetVolumeChecker.Callback(){

            public void call(Set<FsVolumeSpi> healthyVolumes, Set<FsVolumeSpi> failedVolumes) {
                numCallbackInvocations.incrementAndGet();
                if (TestDatasetVolumeChecker.this.expectedVolumeHealth != null && TestDatasetVolumeChecker.this.expectedVolumeHealth != VolumeCheckResult.FAILED) {
                    Assertions.assertThat((int)healthyVolumes.size()).isEqualTo(1);
                    Assertions.assertThat((int)failedVolumes.size()).isEqualTo(0);
                } else {
                    Assertions.assertThat((int)healthyVolumes.size()).isEqualTo(0);
                    Assertions.assertThat((int)failedVolumes.size()).isEqualTo(1);
                }
            }
        });
        GenericTestUtils.waitFor(() -> numCallbackInvocations.get() > 0L, (long)5L, (long)10000L);
        ((FsVolumeSpi)Mockito.verify((Object)volume, (VerificationMode)Mockito.times((int)1))).check(Mockito.any());
        if (result) {
            Assertions.assertThat((long)numCallbackInvocations.get()).isEqualTo(1L);
        }
    }

    @ParameterizedTest(name="{0}")
    @MethodSource(value={"data"})
    @Timeout(value=10L)
    public void testCheckAllVolumes(VolumeCheckResult pExpectedVolumeHealth) throws Exception {
        this.initTestDatasetVolumeChecker(pExpectedVolumeHealth);
        LOG.info("Executing {}", (Object)this.testName.getMethodName());
        List<FsVolumeSpi> volumes = TestDatasetVolumeChecker.makeVolumes(2, this.expectedVolumeHealth);
        FsDatasetSpi<FsVolumeSpi> dataset = TestDatasetVolumeChecker.makeDataset(volumes);
        DatasetVolumeChecker checker = new DatasetVolumeChecker((Configuration)new HdfsConfiguration(), (Timer)new FakeTimer());
        checker.setDelegateChecker((AsyncChecker)new DummyChecker());
        Set failedVolumes = checker.checkAllVolumes(dataset);
        LOG.info("Got back {} failed volumes", (Object)failedVolumes.size());
        if (this.expectedVolumeHealth == null || this.expectedVolumeHealth == VolumeCheckResult.FAILED) {
            Assertions.assertThat((int)failedVolumes.size()).isEqualTo(2);
        } else {
            org.junit.jupiter.api.Assertions.assertTrue((boolean)failedVolumes.isEmpty());
        }
        for (FsVolumeSpi volume : volumes) {
            ((FsVolumeSpi)Mockito.verify((Object)volume, (VerificationMode)Mockito.times((int)1))).check(Mockito.any());
        }
    }

    static FsDatasetSpi<FsVolumeSpi> makeDataset(List<FsVolumeSpi> volumes) throws Exception {
        FsDatasetSpi dataset = (FsDatasetSpi)Mockito.mock(FsDatasetSpi.class);
        FsDatasetSpi.FsVolumeReferences references = new FsDatasetSpi.FsVolumeReferences(volumes);
        Mockito.when((Object)dataset.getFsVolumeReferences()).thenReturn((Object)references);
        return dataset;
    }

    static List<FsVolumeSpi> makeVolumes(int numVolumes, VolumeCheckResult health) throws Exception {
        ArrayList<FsVolumeSpi> volumes = new ArrayList<FsVolumeSpi>(numVolumes);
        for (int i = 0; i < numVolumes; ++i) {
            FsVolumeSpi volume = (FsVolumeSpi)Mockito.mock(FsVolumeSpi.class);
            FsVolumeReference reference = (FsVolumeReference)Mockito.mock(FsVolumeReference.class);
            StorageLocation location = (StorageLocation)Mockito.mock(StorageLocation.class);
            Mockito.when((Object)reference.getVolume()).thenReturn((Object)volume);
            Mockito.when((Object)volume.obtainReference()).thenReturn((Object)reference);
            Mockito.when((Object)volume.getStorageLocation()).thenReturn((Object)location);
            if (health != null) {
                Mockito.when((Object)volume.check(Mockito.any())).thenReturn((Object)health);
            } else {
                DiskChecker.DiskErrorException de = new DiskChecker.DiskErrorException("Fake Exception");
                Mockito.when((Object)volume.check(Mockito.any())).thenThrow(new Throwable[]{de});
            }
            volumes.add(volume);
        }
        return volumes;
    }

    @ParameterizedTest(name="{0}")
    @MethodSource(value={"data"})
    public void testInvalidConfigurationValues(VolumeCheckResult pExpectedVolumeHealth) throws Exception {
        this.initTestDatasetVolumeChecker(pExpectedVolumeHealth);
        HdfsConfiguration conf = new HdfsConfiguration();
        conf.setInt("dfs.datanode.disk.check.timeout", 0);
        LambdaTestUtils.intercept(HadoopIllegalArgumentException.class, (String)"Invalid value configured for dfs.datanode.disk.check.timeout - 0 (should be > 0)", () -> new DatasetVolumeChecker((Configuration)conf, (Timer)new FakeTimer()));
        conf.unset("dfs.datanode.disk.check.timeout");
        conf.setInt("dfs.datanode.disk.check.min.gap", -1);
        LambdaTestUtils.intercept(HadoopIllegalArgumentException.class, (String)"Invalid value configured for dfs.datanode.disk.check.min.gap - -1 (should be >= 0)", () -> new DatasetVolumeChecker((Configuration)conf, (Timer)new FakeTimer()));
        conf.unset("dfs.datanode.disk.check.min.gap");
        conf.setInt("dfs.datanode.disk.check.timeout", -1);
        LambdaTestUtils.intercept(HadoopIllegalArgumentException.class, (String)"Invalid value configured for dfs.datanode.disk.check.timeout - -1 (should be > 0)", () -> new DatasetVolumeChecker((Configuration)conf, (Timer)new FakeTimer()));
        conf.unset("dfs.datanode.disk.check.timeout");
        conf.setInt("dfs.datanode.failed.volumes.tolerated", -2);
        LambdaTestUtils.intercept(HadoopIllegalArgumentException.class, (String)"Invalid value configured for dfs.datanode.failed.volumes.tolerated - -2 should be greater than or equal to -1", () -> new DatasetVolumeChecker((Configuration)conf, (Timer)new FakeTimer()));
    }

    static class DummyChecker
    implements AsyncChecker<FsVolumeSpi.VolumeCheckContext, VolumeCheckResult> {
        DummyChecker() {
        }

        public Optional<ListenableFuture<VolumeCheckResult>> schedule(Checkable<FsVolumeSpi.VolumeCheckContext, VolumeCheckResult> target, FsVolumeSpi.VolumeCheckContext context) {
            try {
                return Optional.of(Futures.immediateFuture((Object)target.check((Object)context)));
            }
            catch (Exception e) {
                LOG.info("check routine threw exception " + e);
                return Optional.of(Futures.immediateFailedFuture((Throwable)e));
            }
        }

        public void shutdownAndWait(long timeout, TimeUnit timeUnit) throws InterruptedException {
        }
    }
}

