/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.datanode;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.StorageType;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.protocolPB.DatanodeProtocolClientSideTranslatorPB;
import org.apache.hadoop.hdfs.server.datanode.DataNode;
import org.apache.hadoop.hdfs.server.datanode.DataNodeTestUtils;
import org.apache.hadoop.hdfs.server.datanode.InternalDataNodeTestUtils;
import org.apache.hadoop.hdfs.server.namenode.NameNode;
import org.apache.hadoop.hdfs.server.protocol.DatanodeRegistration;
import org.apache.hadoop.hdfs.server.protocol.DatanodeStorage;
import org.apache.hadoop.hdfs.server.protocol.SlowDiskReports;
import org.apache.hadoop.hdfs.server.protocol.SlowPeerReports;
import org.apache.hadoop.hdfs.server.protocol.StorageReport;
import org.apache.hadoop.hdfs.server.protocol.VolumeFailureSummary;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentCaptor;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestStorageReport {
    public static final Logger LOG = LoggerFactory.getLogger(TestStorageReport.class);
    private static final short REPL_FACTOR = 1;
    private static final StorageType storageType = StorageType.SSD;
    private static Configuration conf;
    private MiniDFSCluster cluster;
    private DistributedFileSystem fs;
    static String bpid;

    @BeforeEach
    public void startUpCluster() throws IOException {
        conf = new HdfsConfiguration();
        this.cluster = new MiniDFSCluster.Builder(conf).numDataNodes(1).storageTypes(new StorageType[]{storageType, storageType}).build();
        this.fs = this.cluster.getFileSystem();
        bpid = this.cluster.getNamesystem().getBlockPoolId();
    }

    @AfterEach
    public void shutDownCluster() throws IOException {
        if (this.cluster != null) {
            this.fs.close();
            this.cluster.shutdown();
            this.cluster = null;
        }
    }

    @Test
    public void testStorageReportHasStorageTypeAndState() throws IOException {
        StorageReport[] reports;
        org.junit.jupiter.api.Assertions.assertNotSame((Object)storageType, (Object)StorageType.DEFAULT);
        NameNode nn = this.cluster.getNameNode();
        DataNode dn = this.cluster.getDataNodes().get(0);
        DatanodeProtocolClientSideTranslatorPB nnSpy = InternalDataNodeTestUtils.spyOnBposToNN(dn, nn);
        DataNodeTestUtils.triggerHeartbeat(dn);
        ArgumentCaptor captor = ArgumentCaptor.forClass(StorageReport[].class);
        ((DatanodeProtocolClientSideTranslatorPB)Mockito.verify((Object)nnSpy)).sendHeartbeat((DatanodeRegistration)ArgumentMatchers.any(DatanodeRegistration.class), (StorageReport[])captor.capture(), ArgumentMatchers.anyLong(), ArgumentMatchers.anyLong(), ArgumentMatchers.anyInt(), ArgumentMatchers.anyInt(), ArgumentMatchers.anyInt(), (VolumeFailureSummary)ArgumentMatchers.any(), Mockito.anyBoolean(), (SlowPeerReports)Mockito.any(SlowPeerReports.class), (SlowDiskReports)Mockito.any(SlowDiskReports.class));
        for (StorageReport report : reports = (StorageReport[])captor.getValue()) {
            Assertions.assertThat((Comparable)report.getStorage().getStorageType()).isEqualTo((Object)storageType);
            Assertions.assertThat((Comparable)report.getStorage().getState()).isEqualTo((Object)DatanodeStorage.State.NORMAL);
        }
    }
}

