/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.datanode;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.HashSet;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.MiniDFSNNTopology;
import org.apache.hadoop.hdfs.server.datanode.BPOfferService;
import org.apache.hadoop.hdfs.server.datanode.BPServiceActor;
import org.apache.hadoop.hdfs.server.datanode.DataNode;
import org.apache.hadoop.hdfs.server.datanode.DataNodeFaultInjector;
import org.apache.hadoop.thirdparty.com.google.common.base.Joiner;
import org.apache.hadoop.util.Sets;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;

public class TestRefreshNamenodes {
    private final int nnPort1 = 2221;
    private final int nnPort2 = 2224;
    private final int nnPort3 = 2227;
    private final int nnPort4 = 2230;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRefreshNamenodes() throws IOException {
        Configuration conf = new Configuration();
        MiniDFSCluster cluster = null;
        try {
            MiniDFSNNTopology topology = new MiniDFSNNTopology().addNameservice(new MiniDFSNNTopology.NSConf("ns1").addNN(new MiniDFSNNTopology.NNConf(null).setIpcPort(2221))).setFederation(true);
            cluster = new MiniDFSCluster.Builder(conf).nnTopology(topology).build();
            DataNode dn = cluster.getDataNodes().get(0);
            Assertions.assertEquals((int)1, (int)dn.getAllBpOs().size());
            cluster.addNameNode(conf, 2224);
            Assertions.assertEquals((int)2, (int)dn.getAllBpOs().size());
            cluster.addNameNode(conf, 2227);
            Assertions.assertEquals((int)3, (int)dn.getAllBpOs().size());
            cluster.addNameNode(conf, 2230);
            HashSet<InetSocketAddress> nnAddrsFromCluster = new HashSet<InetSocketAddress>();
            for (int i = 0; i < 4; ++i) {
                Assertions.assertTrue((boolean)nnAddrsFromCluster.add(cluster.getNameNode(i).getNameNodeAddress()));
            }
            HashSet<InetSocketAddress> nnAddrsFromDN = new HashSet<InetSocketAddress>();
            for (BPOfferService bpos : dn.getAllBpOs()) {
                for (BPServiceActor bpsa : bpos.getBPServiceActors()) {
                    Assertions.assertTrue((boolean)nnAddrsFromDN.add(bpsa.getNNSocketAddress()));
                }
            }
            Assertions.assertEquals((Object)"", (Object)Joiner.on((String)",").join((Iterable)Sets.symmetricDifference(nnAddrsFromCluster, nnAddrsFromDN)));
        }
        finally {
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @Timeout(value=10L)
    public void testRefreshNameNodeDeadLock() throws Exception {
        HdfsConfiguration conf = new HdfsConfiguration();
        MiniDFSCluster cluster = null;
        try {
            cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(3).build();
            cluster.waitActive();
            DataNodeFaultInjector.set((DataNodeFaultInjector)new DataNodeFaultInjector(){

                public void delayWhenOfferServiceHoldLock() {
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
            });
            DataNode dn = cluster.getDataNodes().get(0);
            Configuration dnConf = dn.getConf();
            dnConf.set("dfs.nameservices", "ns1");
            dnConf.set("dfs.namenode.lifeline.rpc-address.ns1", "mock:8022");
            dn.refreshNamenodes(dnConf);
        }
        finally {
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }
}

