/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.datanode;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.io.input.BoundedInputStream;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystemTestHelper;
import org.apache.hadoop.hdfs.server.datanode.FinalizedProvidedReplica;
import org.apache.hadoop.hdfs.server.datanode.ProvidedReplica;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestProvidedReplicaImpl {
    private static final Logger LOG = LoggerFactory.getLogger(TestProvidedReplicaImpl.class);
    private static final String BASE_DIR = new FileSystemTestHelper().getTestRootDir();
    private static final String FILE_NAME = "provided-test";
    private static final long FILE_LEN = 0x150000L;
    private static final long BLK_LEN = 131072L;
    private static List<ProvidedReplica> replicas;

    private static void createFileIfNotExists(String baseDir) throws IOException {
        File newFile = new File(baseDir, FILE_NAME);
        newFile.getParentFile().mkdirs();
        if (!newFile.exists()) {
            newFile.createNewFile();
            FileOutputStream writer = new FileOutputStream(newFile.getAbsolutePath());
            byte[] bytes = new byte[]{0};
            int i = 0;
            while ((long)i < 0x150000L) {
                ((OutputStream)writer).write(bytes);
                ++i;
            }
            writer.flush();
            ((OutputStream)writer).close();
            LOG.info("Created provided file " + newFile + " of length " + newFile.length());
        }
    }

    private static void createProvidedReplicas(Configuration conf) {
        long numReplicas = (long)Math.ceil(10.5);
        File providedFile = new File(BASE_DIR, FILE_NAME);
        replicas = new ArrayList<ProvidedReplica>();
        LOG.info("Creating " + numReplicas + " provided replicas");
        int i = 0;
        while ((long)i < numReplicas) {
            long currentReplicaLength = 0x150000L >= (long)(i + 1) * 131072L ? 131072L : 0x150000L - (long)i * 131072L;
            replicas.add((ProvidedReplica)new FinalizedProvidedReplica((long)i, providedFile.toURI(), (long)i * 131072L, currentReplicaLength, 0L, null, null, conf, null));
            ++i;
        }
    }

    @BeforeEach
    public void setUp() throws IOException {
        TestProvidedReplicaImpl.createFileIfNotExists(new File(BASE_DIR).getAbsolutePath());
        TestProvidedReplicaImpl.createProvidedReplicas(new Configuration());
    }

    public static void verifyReplicaContents(File file, InputStream ins, long fileOffset, long dataLength) throws IOException {
        FileInputStream fileIns = new FileInputStream(file);
        ((InputStream)fileIns).skip(fileOffset);
        try (ReadableByteChannel i = Channels.newChannel((InputStream)new BoundedInputStream((InputStream)fileIns, dataLength));
             ReadableByteChannel j = Channels.newChannel(ins);){
            ByteBuffer ib = ByteBuffer.allocate(4096);
            ByteBuffer jb = ByteBuffer.allocate(4096);
            while (true) {
                int il = i.read(ib);
                int jl = j.read(jb);
                if (il < 0 || jl < 0) {
                    Assertions.assertEquals((int)il, (int)jl);
                    break;
                }
                ib.flip();
                jb.flip();
                int cmp = Math.min(ib.remaining(), jb.remaining());
                for (int k = 0; k < cmp; ++k) {
                    Assertions.assertEquals((byte)ib.get(), (byte)jb.get());
                }
                ib.compact();
                jb.compact();
            }
        }
    }

    @Test
    public void testProvidedReplicaRead() throws IOException {
        ProvidedReplica replica;
        int i;
        File providedFile = new File(BASE_DIR, FILE_NAME);
        for (i = 0; i < replicas.size(); ++i) {
            replica = replicas.get(i);
            Assertions.assertTrue((boolean)replica.blockDataExists());
            Assertions.assertEquals((Object)providedFile.toURI(), (Object)replica.getBlockURI());
            TestProvidedReplicaImpl.verifyReplicaContents(providedFile, replica.getDataInputStream(0L), 131072L * (long)i, replica.getBlockDataLength());
        }
        LOG.info("All replica contents verified");
        providedFile.delete();
        for (i = 0; i < replicas.size(); ++i) {
            replica = replicas.get(i);
            Assertions.assertTrue((!replica.blockDataExists() ? 1 : 0) != 0);
        }
    }
}

