/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.datanode;

import java.util.ArrayList;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdfs.DFSTestUtil;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.protocol.BlockListAsLongs;
import org.apache.hadoop.hdfs.protocolPB.DatanodeProtocolClientSideTranslatorPB;
import org.apache.hadoop.hdfs.server.datanode.BPOfferService;
import org.apache.hadoop.hdfs.server.datanode.DataNode;
import org.apache.hadoop.hdfs.server.datanode.fsdataset.impl.FsDatasetImplTestUtils;
import org.apache.hadoop.hdfs.server.protocol.BlockReportContext;
import org.apache.hadoop.hdfs.server.protocol.DatanodeRegistration;
import org.apache.hadoop.hdfs.server.protocol.DatanodeStorage;
import org.apache.hadoop.hdfs.server.protocol.StorageBlockReport;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.slf4j.event.Level;

public class TestLargeBlockReport {
    private final HdfsConfiguration conf = new HdfsConfiguration();
    private MiniDFSCluster cluster;
    private DataNode dn;
    private BPOfferService bpos;
    private DatanodeProtocolClientSideTranslatorPB nnProxy;
    private DatanodeRegistration bpRegistration;
    private String bpId;
    private DatanodeStorage dnStorage;
    private final long reportId = 1L;
    private final long fullBrLeaseId = 0L;

    @BeforeAll
    public static void init() {
        DFSTestUtil.setNameNodeLogLevel(Level.WARN);
        FsDatasetImplTestUtils.setFsDatasetImplLogLevel(Level.WARN);
    }

    @AfterEach
    public void tearDown() {
        if (this.cluster != null) {
            this.cluster.shutdown();
        }
    }

    @Test
    public void testBlockReportExceedsLengthLimit() throws Exception {
        this.conf.setInt("ipc.maximum.data.length", 0x4000000);
        this.initCluster();
        StorageBlockReport[] reports = this.createReports(6000000);
        try {
            this.nnProxy.blockReport(this.bpRegistration, this.bpId, reports, new BlockReportContext(1, 0, 1L, 0L));
            Assertions.fail((String)"Should have failed because of the too long RPC data length");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Test
    public void testBlockReportSucceedsWithLargerLengthLimit() throws Exception {
        this.conf.setInt("ipc.maximum.data.length", 0x10000000);
        this.initCluster();
        StorageBlockReport[] reports = this.createReports(6000000);
        this.nnProxy.blockReport(this.bpRegistration, this.bpId, reports, new BlockReportContext(1, 0, 1L, 0L));
    }

    private StorageBlockReport[] createReports(int numBlocks) {
        int longsPerBlock = 3;
        int blockListSize = 2 + numBlocks * longsPerBlock;
        ArrayList<Long> longs = new ArrayList<Long>(blockListSize);
        longs.add(Long.valueOf(numBlocks));
        longs.add(0L);
        for (int i = 0; i < blockListSize; ++i) {
            longs.add(Long.valueOf(i));
        }
        BlockListAsLongs blockList = BlockListAsLongs.decodeLongs(longs);
        StorageBlockReport[] reports = new StorageBlockReport[]{new StorageBlockReport(this.dnStorage, blockList)};
        return reports;
    }

    private void initCluster() throws Exception {
        this.cluster = new MiniDFSCluster.Builder((Configuration)this.conf).numDataNodes(1).build();
        this.cluster.waitActive();
        this.dn = this.cluster.getDataNodes().get(0);
        this.bpos = (BPOfferService)this.dn.getAllBpOs().get(0);
        this.nnProxy = this.bpos.getActiveNN();
        this.bpRegistration = this.bpos.bpRegistration;
        this.bpId = this.bpos.getBlockPoolId();
        this.dnStorage = (DatanodeStorage)this.dn.getFSDataset().getBlockReports(this.bpId).keySet().iterator().next();
    }
}

