/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.datanode;

import org.apache.hadoop.hdfs.server.common.HdfsServerConstants;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestHdfsServerConstants {
    private static void verifyStartupOptionResult(String value, HdfsServerConstants.StartupOption expectedOption, HdfsServerConstants.RollingUpgradeStartupOption expectedRollupOption) {
        HdfsServerConstants.StartupOption option = HdfsServerConstants.StartupOption.getEnum((String)value);
        Assertions.assertEquals((Object)expectedOption, (Object)option);
        if (expectedRollupOption != null) {
            Assertions.assertEquals((Object)expectedRollupOption, (Object)option.getRollingUpgradeStartupOption());
        }
    }

    @Test
    public void testStartupOptionParsing() {
        TestHdfsServerConstants.verifyStartupOptionResult("FORMAT", HdfsServerConstants.StartupOption.FORMAT, null);
        TestHdfsServerConstants.verifyStartupOptionResult("REGULAR", HdfsServerConstants.StartupOption.REGULAR, null);
        TestHdfsServerConstants.verifyStartupOptionResult("CHECKPOINT", HdfsServerConstants.StartupOption.CHECKPOINT, null);
        TestHdfsServerConstants.verifyStartupOptionResult("UPGRADE", HdfsServerConstants.StartupOption.UPGRADE, null);
        TestHdfsServerConstants.verifyStartupOptionResult("ROLLBACK", HdfsServerConstants.StartupOption.ROLLBACK, null);
        TestHdfsServerConstants.verifyStartupOptionResult("ROLLINGUPGRADE", HdfsServerConstants.StartupOption.ROLLINGUPGRADE, null);
        TestHdfsServerConstants.verifyStartupOptionResult("IMPORT", HdfsServerConstants.StartupOption.IMPORT, null);
        TestHdfsServerConstants.verifyStartupOptionResult("INITIALIZESHAREDEDITS", HdfsServerConstants.StartupOption.INITIALIZESHAREDEDITS, null);
        try {
            TestHdfsServerConstants.verifyStartupOptionResult("UNKNOWN(UNKNOWNOPTION)", HdfsServerConstants.StartupOption.FORMAT, null);
            Assertions.fail((String)"Failed to get expected IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testRollingUpgradeStartupOptionParsing() {
        TestHdfsServerConstants.verifyStartupOptionResult("ROLLINGUPGRADE(ROLLBACK)", HdfsServerConstants.StartupOption.ROLLINGUPGRADE, HdfsServerConstants.RollingUpgradeStartupOption.ROLLBACK);
        TestHdfsServerConstants.verifyStartupOptionResult("ROLLINGUPGRADE(STARTED)", HdfsServerConstants.StartupOption.ROLLINGUPGRADE, HdfsServerConstants.RollingUpgradeStartupOption.STARTED);
        try {
            TestHdfsServerConstants.verifyStartupOptionResult("ROLLINGUPGRADE(UNKNOWNOPTION)", HdfsServerConstants.StartupOption.ROLLINGUPGRADE, null);
            Assertions.fail((String)"Failed to get expected IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }
}

