/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.datanode;

import java.io.IOException;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.DFSTestUtil;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.protocol.BlockListAsLongs;
import org.apache.hadoop.hdfs.protocolPB.DatanodeProtocolClientSideTranslatorPB;
import org.apache.hadoop.hdfs.server.datanode.DataNode;
import org.apache.hadoop.hdfs.server.datanode.DataNodeTestUtils;
import org.apache.hadoop.hdfs.server.datanode.InternalDataNodeTestUtils;
import org.apache.hadoop.hdfs.server.datanode.TestStorageReport;
import org.apache.hadoop.hdfs.server.namenode.NameNode;
import org.apache.hadoop.hdfs.server.protocol.BlockReportContext;
import org.apache.hadoop.hdfs.server.protocol.DatanodeRegistration;
import org.apache.hadoop.hdfs.server.protocol.StorageBlockReport;
import org.apache.hadoop.test.GenericTestUtils;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;
import org.mockito.ArgumentCaptor;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestDnRespectsBlockReportSplitThreshold {
    public static final Logger LOG = LoggerFactory.getLogger(TestStorageReport.class);
    private static final int BLOCK_SIZE = 1024;
    private static final short REPL_FACTOR = 1;
    private static final long seed = -17958194L;
    private static final int BLOCKS_IN_FILE = 5;
    private static Configuration conf;
    private MiniDFSCluster cluster;
    private DistributedFileSystem fs;
    static String bpid;

    public void startUpCluster(long splitThreshold) throws IOException {
        conf = new HdfsConfiguration();
        conf.setLong("dfs.blockreport.split.threshold", splitThreshold);
        this.cluster = new MiniDFSCluster.Builder(conf).numDataNodes(1).build();
        this.fs = this.cluster.getFileSystem();
        bpid = this.cluster.getNamesystem().getBlockPoolId();
    }

    @AfterEach
    public void shutDownCluster() throws IOException {
        if (this.cluster != null) {
            this.fs.close();
            this.cluster.shutdown();
            this.cluster = null;
        }
    }

    private void createFile(String filenamePrefix, int blockCount) throws IOException {
        Path path = new Path("/" + filenamePrefix + ".dat");
        DFSTestUtil.createFile((FileSystem)this.fs, path, 1024, blockCount * 1024, 1024L, (short)1, -17958194L);
    }

    private void verifyCapturedArguments(ArgumentCaptor<StorageBlockReport[]> captor, int expectedReportsPerCall, int expectedTotalBlockCount) {
        List listOfReports = captor.getAllValues();
        int numBlocksReported = 0;
        for (StorageBlockReport[] reports : listOfReports) {
            Assertions.assertThat((int)reports.length).isEqualTo(expectedReportsPerCall);
            for (StorageBlockReport report : reports) {
                BlockListAsLongs blockList = report.getBlocks();
                numBlocksReported += blockList.getNumberOfBlocks();
            }
        }
        assert (numBlocksReported >= expectedTotalBlockCount);
    }

    @Test
    @Timeout(value=300L)
    public void testAlwaysSplit() throws IOException, InterruptedException {
        this.startUpCluster(0L);
        NameNode nn = this.cluster.getNameNode();
        DataNode dn = this.cluster.getDataNodes().get(0);
        this.createFile(GenericTestUtils.getMethodName(), 5);
        DatanodeProtocolClientSideTranslatorPB nnSpy = InternalDataNodeTestUtils.spyOnBposToNN(dn, nn);
        DataNodeTestUtils.triggerBlockReport(dn);
        ArgumentCaptor captor = ArgumentCaptor.forClass(StorageBlockReport[].class);
        ((DatanodeProtocolClientSideTranslatorPB)Mockito.verify((Object)nnSpy, (VerificationMode)Mockito.times((int)this.cluster.getStoragesPerDatanode()))).blockReport((DatanodeRegistration)ArgumentMatchers.any(DatanodeRegistration.class), ArgumentMatchers.anyString(), (StorageBlockReport[])captor.capture(), (BlockReportContext)ArgumentMatchers.any());
        this.verifyCapturedArguments((ArgumentCaptor<StorageBlockReport[]>)captor, 1, 5);
    }

    @Test
    @Timeout(value=300L)
    public void testCornerCaseUnderThreshold() throws IOException, InterruptedException {
        this.startUpCluster(6L);
        NameNode nn = this.cluster.getNameNode();
        DataNode dn = this.cluster.getDataNodes().get(0);
        this.createFile(GenericTestUtils.getMethodName(), 5);
        DatanodeProtocolClientSideTranslatorPB nnSpy = InternalDataNodeTestUtils.spyOnBposToNN(dn, nn);
        DataNodeTestUtils.triggerBlockReport(dn);
        ArgumentCaptor captor = ArgumentCaptor.forClass(StorageBlockReport[].class);
        ((DatanodeProtocolClientSideTranslatorPB)Mockito.verify((Object)nnSpy, (VerificationMode)Mockito.times((int)1))).blockReport((DatanodeRegistration)ArgumentMatchers.any(DatanodeRegistration.class), ArgumentMatchers.anyString(), (StorageBlockReport[])captor.capture(), (BlockReportContext)ArgumentMatchers.any());
        this.verifyCapturedArguments((ArgumentCaptor<StorageBlockReport[]>)captor, this.cluster.getStoragesPerDatanode(), 5);
    }

    @Test
    @Timeout(value=300L)
    public void testCornerCaseAtThreshold() throws IOException, InterruptedException {
        this.startUpCluster(5L);
        NameNode nn = this.cluster.getNameNode();
        DataNode dn = this.cluster.getDataNodes().get(0);
        this.createFile(GenericTestUtils.getMethodName(), 5);
        DatanodeProtocolClientSideTranslatorPB nnSpy = InternalDataNodeTestUtils.spyOnBposToNN(dn, nn);
        DataNodeTestUtils.triggerBlockReport(dn);
        ArgumentCaptor captor = ArgumentCaptor.forClass(StorageBlockReport[].class);
        ((DatanodeProtocolClientSideTranslatorPB)Mockito.verify((Object)nnSpy, (VerificationMode)Mockito.times((int)this.cluster.getStoragesPerDatanode()))).blockReport((DatanodeRegistration)ArgumentMatchers.any(DatanodeRegistration.class), ArgumentMatchers.anyString(), (StorageBlockReport[])captor.capture(), (BlockReportContext)ArgumentMatchers.any());
        this.verifyCapturedArguments((ArgumentCaptor<StorageBlockReport[]>)captor, 1, 5);
    }
}

