/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.datanode;

import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.server.common.HdfsServerConstants;
import org.apache.hadoop.hdfs.server.datanode.DataNode;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;

public class TestDatanodeStartupOptions {
    private Configuration conf = null;

    private static void checkExpected(boolean expectSuccess, HdfsServerConstants.StartupOption expectedOption, Configuration conf, String ... arg) {
        String[] args = new String[arg.length];
        int i = 0;
        for (String currentArg : arg) {
            args[i++] = currentArg;
        }
        boolean returnValue = DataNode.parseArguments((String[])args, (Configuration)conf);
        HdfsServerConstants.StartupOption option = DataNode.getStartupOption((Configuration)conf);
        Assertions.assertThat((boolean)returnValue).isEqualTo(expectSuccess);
        if (expectSuccess) {
            Assertions.assertThat((Comparable)option).isEqualTo((Object)expectedOption);
        }
    }

    @BeforeEach
    public void initConfiguration() {
        this.conf = new HdfsConfiguration();
    }

    @Test
    @Timeout(value=60L)
    public void testStartupSuccess() {
        TestDatanodeStartupOptions.checkExpected(true, HdfsServerConstants.StartupOption.REGULAR, this.conf, new String[0]);
        TestDatanodeStartupOptions.checkExpected(true, HdfsServerConstants.StartupOption.REGULAR, this.conf, "-regular");
        TestDatanodeStartupOptions.checkExpected(true, HdfsServerConstants.StartupOption.REGULAR, this.conf, "-REGULAR");
        TestDatanodeStartupOptions.checkExpected(true, HdfsServerConstants.StartupOption.ROLLBACK, this.conf, "-rollback");
    }

    @Test
    @Timeout(value=60L)
    public void testStartupFailure() {
        TestDatanodeStartupOptions.checkExpected(false, HdfsServerConstants.StartupOption.REGULAR, this.conf, "unknownoption");
        TestDatanodeStartupOptions.checkExpected(false, HdfsServerConstants.StartupOption.REGULAR, this.conf, "-regular -rollback");
    }
}

