/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.datanode;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.StorageType;
import org.apache.hadoop.hdfs.DFSOutputStream;
import org.apache.hadoop.hdfs.DFSTestUtil;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.protocol.ExtendedBlock;
import org.apache.hadoop.hdfs.server.datanode.DataNode;
import org.apache.hadoop.hdfs.server.datanode.DataNodeTestUtils;
import org.apache.hadoop.hdfs.server.datanode.SimulatedFSDataset;
import org.apache.hadoop.hdfs.server.datanode.fsdataset.DataNodeVolumeMetrics;
import org.apache.hadoop.hdfs.server.datanode.fsdataset.FsVolumeSpi;
import org.apache.hadoop.metrics2.MetricsRecordBuilder;
import org.apache.hadoop.test.MetricsAsserts;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Timeout(value=300L)
public class TestDataNodeVolumeMetrics {
    private static final Logger LOG = LoggerFactory.getLogger(TestDataNodeVolumeMetrics.class);
    private static final int BLOCK_SIZE = 1024;
    private static final short REPL = 1;
    private static final int NUM_DATANODES = 1;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testVolumeMetrics() throws Exception {
        MiniDFSCluster cluster = this.setupClusterForVolumeMetrics();
        try {
            DistributedFileSystem fs = cluster.getFileSystem();
            Path fileName = new Path("/test.dat");
            long fileLen = 0x80000000L;
            DFSTestUtil.createFile((FileSystem)fs, fileName, false, 1024, 0x80000000L, fs.getDefaultBlockSize(fileName), (short)1, 1L, true);
            try (FSDataOutputStream out = fs.append(fileName);){
                out.writeBytes("hello world");
                ((DFSOutputStream)out.getWrappedStream()).hsync();
            }
            this.verifyDataNodeVolumeMetrics((FileSystem)fs, cluster, fileName);
        }
        finally {
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testVolumeMetricsWithVolumeDepartureArrival() throws Exception {
        MiniDFSCluster cluster = this.setupClusterForVolumeMetrics();
        try {
            DistributedFileSystem fs = cluster.getFileSystem();
            Path fileName = new Path("/test.dat");
            long fileLen = 0x80000000L;
            DFSTestUtil.createFile((FileSystem)fs, fileName, false, 1024, 0x80000000L, fs.getDefaultBlockSize(fileName), (short)1, 1L, true);
            try (FSDataOutputStream out = fs.append(fileName);){
                out.writeBytes("hello world");
                ((DFSOutputStream)out.getWrappedStream()).hsync();
            }
            ArrayList<DataNode> dns = cluster.getDataNodes();
            Assertions.assertTrue((boolean)dns.get(0).isDatanodeUp(), (String)"DN1 should be up");
            File dn1Vol2 = cluster.getInstanceStorageDir(0, 1);
            DataNodeTestUtils.injectDataDirFailure(dn1Vol2);
            this.verifyDataNodeVolumeMetrics((FileSystem)fs, cluster, fileName);
            DataNodeTestUtils.restoreDataDirFromFailure(dn1Vol2);
            DataNodeTestUtils.reconfigureDataNode(dns.get(0), dn1Vol2);
            this.verifyDataNodeVolumeMetrics((FileSystem)fs, cluster, fileName);
        }
        finally {
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }

    private MiniDFSCluster setupClusterForVolumeMetrics() throws IOException {
        HdfsConfiguration conf = new HdfsConfiguration();
        conf.setInt("dfs.datanode.fileio.profiling.sampling.percentage", 100);
        SimulatedFSDataset.setFactory((Configuration)conf);
        return new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(1).storageTypes(new StorageType[]{StorageType.RAM_DISK, StorageType.DISK}).storagesPerDatanode(2).build();
    }

    private void verifyDataNodeVolumeMetrics(FileSystem fs, MiniDFSCluster cluster, Path fileName) throws IOException {
        ArrayList<DataNode> datanodes = cluster.getDataNodes();
        DataNode datanode = (DataNode)datanodes.get(0);
        ExtendedBlock block = DFSTestUtil.getFirstBlock(fs, fileName);
        FsVolumeSpi volume = datanode.getFSDataset().getVolume(block);
        DataNodeVolumeMetrics metrics = volume.getMetrics();
        MetricsRecordBuilder rb = MetricsAsserts.getMetrics((String)volume.getMetrics().name());
        MetricsAsserts.assertCounter((String)"TotalDataFileIos", (long)metrics.getTotalDataFileIos(), (MetricsRecordBuilder)rb);
        LOG.info("TotalMetadataOperations : " + metrics.getTotalMetadataOperations());
        LOG.info("TotalDataFileIos : " + metrics.getTotalDataFileIos());
        LOG.info("TotalFileIoErrors : " + metrics.getTotalFileIoErrors());
        LOG.info("MetadataOperationSampleCount : " + metrics.getMetadataOperationSampleCount());
        LOG.info("MetadataOperationMean : " + metrics.getMetadataOperationMean());
        LOG.info("MetadataOperationStdDev : " + metrics.getMetadataOperationStdDev());
        LOG.info("DataFileIoSampleCount : " + metrics.getDataFileIoSampleCount());
        LOG.info("DataFileIoMean : " + metrics.getDataFileIoMean());
        LOG.info("DataFileIoStdDev : " + metrics.getDataFileIoStdDev());
        LOG.info("flushIoSampleCount : " + metrics.getFlushIoSampleCount());
        LOG.info("flushIoMean : " + metrics.getFlushIoMean());
        LOG.info("flushIoStdDev : " + metrics.getFlushIoStdDev());
        LOG.info("syncIoSampleCount : " + metrics.getSyncIoSampleCount());
        LOG.info("syncIoMean : " + metrics.getSyncIoMean());
        LOG.info("syncIoStdDev : " + metrics.getSyncIoStdDev());
        LOG.info("readIoSampleCount : " + metrics.getReadIoSampleCount());
        LOG.info("readIoMean : " + metrics.getReadIoMean());
        LOG.info("readIoStdDev : " + metrics.getReadIoStdDev());
        LOG.info("writeIoSampleCount : " + metrics.getWriteIoSampleCount());
        LOG.info("writeIoMean : " + metrics.getWriteIoMean());
        LOG.info("writeIoStdDev : " + metrics.getWriteIoStdDev());
        LOG.info("transferIoSampleCount : " + metrics.getTransferIoSampleCount());
        LOG.info("transferIoMean : " + metrics.getTransferIoMean());
        LOG.info("transferIoStdDev : " + metrics.getTransferIoStdDev());
        LOG.info("nativeCopyIoSampleCount : " + metrics.getNativeCopyIoSampleCount());
        LOG.info("nativeCopyIoMean : " + metrics.getNativeCopyIoMean());
        LOG.info("nativeCopyIoStdDev : " + metrics.getNativeCopyIoStdDev());
        LOG.info("fileIoErrorSampleCount : " + metrics.getFileIoErrorSampleCount());
        LOG.info("fileIoErrorMean : " + metrics.getFileIoErrorMean());
        LOG.info("fileIoErrorStdDev : " + metrics.getFileIoErrorStdDev());
        MetricsAsserts.assertTag((String)"VolumeName", (String)metrics.getVolumeName(), (MetricsRecordBuilder)rb);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testWriteIoVolumeMetrics() throws IOException {
        HdfsConfiguration conf = new HdfsConfiguration();
        conf.setInt("dfs.datanode.fileio.profiling.sampling.percentage", 100);
        MiniDFSCluster cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(1).storageTypes(new StorageType[]{StorageType.RAM_DISK, StorageType.DISK}).storagesPerDatanode(2).build();
        try {
            DistributedFileSystem fs = cluster.getFileSystem();
            Path fileName = new Path("/test.dat");
            long fileLen = 0x80000000L;
            DFSTestUtil.createFile((FileSystem)fs, fileName, false, 1024, 0x80000000L, fs.getDefaultBlockSize(fileName), (short)1, 1L, true);
            ArrayList<DataNode> datanodes = cluster.getDataNodes();
            DataNode datanode = (DataNode)datanodes.get(0);
            ExtendedBlock block = DFSTestUtil.getFirstBlock((FileSystem)fs, fileName);
            FsVolumeSpi volume = datanode.getFSDataset().getVolume(block);
            DataNodeVolumeMetrics metrics = volume.getMetrics();
            Assertions.assertEquals((long)0L, (long)metrics.getSyncIoSampleCount());
            Assertions.assertNotEquals((long)0L, (long)metrics.getWriteIoSampleCount());
            Assertions.assertTrue((metrics.getFlushIoSampleCount() > metrics.getSyncIoSampleCount() ? 1 : 0) != 0);
            Assertions.assertTrue((metrics.getWriteIoSampleCount() > metrics.getFlushIoSampleCount() ? 1 : 0) != 0);
            long lastWriteIoSampleCount = metrics.getWriteIoSampleCount();
            try (FSDataOutputStream out = fs.append(fileName);){
                out.writeBytes("hello world");
                out.hflush();
            }
            Assertions.assertEquals((long)0L, (long)metrics.getSyncIoSampleCount());
            Assertions.assertTrue((metrics.getWriteIoSampleCount() > lastWriteIoSampleCount ? 1 : 0) != 0);
        }
        finally {
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }
}

